/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.sdb.internal.util;

import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.models.internal.sdb.SDBDirective;
import org.eclipse.hyades.models.internal.sdb.SDBMatchPattern;
import org.eclipse.hyades.models.internal.sdb.SDBRuntime;
import org.eclipse.hyades.models.internal.sdb.SDBSolution;
import org.eclipse.hyades.models.internal.sdb.SDBSymptom;

public class SymptomDBTextSearch {
    private SDBRuntime root;
    private Object[] start = null;
    private int[] startIndex = null;
    private int[] index = null;

    public void initialize(SDBRuntime sDBRuntime, Object[] objectArray) {
        this.root = sDBRuntime;
        this.start = objectArray;
        this.startIndex = new int[]{-1, -1, -1, -1};
        this.index = new int[]{-1, -1, -1, -1};
        this.startIndex = this.lookForStartNode(objectArray);
    }

    public Object[] search(String string, int n, boolean bl) {
        if (this.startIndex == null) {
            this.setStartIndex(-1, -1, -1, -1);
            this.startIndex = this.lookForStartNode(this.start);
        }
        if (this.startIndex[1] == -1 && n > 0) {
            this.setIndex(0, 0, 0, 0);
            return this.searchDown(string, bl);
        }
        if (this.startIndex[1] == -1 && n < 0) {
            this.startIndex[0] = -1;
            this.setIndex(this.startIndex[0], this.startIndex[1], this.startIndex[2], this.startIndex[3]);
            return this.searchUp(string, bl);
        }
        if (this.startIndex[2] == -1 && n > 0) {
            this.setIndex(0, this.startIndex[1], 0, 0);
            return this.searchDown(string, bl);
        }
        if (this.startIndex[2] == -1 && n < 0) {
            if (this.startIndex[1] - 1 >= 0) {
                this.setIndex(0, this.startIndex[1] - 1, -11, -11);
                return this.searchUp(string, bl);
            }
            this.setIndex(0, -1, -1, -1);
            return this.searchUp(string, bl);
        }
        if (this.startIndex[3] == -1 && n > 0) {
            this.setIndex(0, this.startIndex[1], this.startIndex[2], 0);
            return this.searchDown(string, bl);
        }
        if (this.startIndex[3] == -1 && n < 0) {
            if (this.startIndex[2] - 1 >= 0) {
                this.setIndex(0, this.startIndex[1], this.startIndex[2] - 1, -11);
                return this.searchUp(string, bl);
            }
            this.setIndex(0, this.startIndex[1], this.startIndex[2] - 1, -1);
            return this.searchUp(string, bl);
        }
        if (n > 0) {
            this.setIndex(0, this.startIndex[1], this.startIndex[2], this.startIndex[3]);
            return this.searchDown(string, bl);
        }
        this.setIndex(0, this.startIndex[1], this.startIndex[2], this.startIndex[3] - 1);
        return this.searchUp(string, bl);
    }

    private int[] lookForStartNode(Object[] objectArray) {
        if (objectArray[0] == null) {
            this.startIndex[0] = -1;
            return this.startIndex;
        }
        this.startIndex[0] = 0;
        if (objectArray[1] == null) {
            return this.startIndex;
        }
        EList eList = this.root.getSymptoms();
        this.startIndex[1] = eList.indexOf((Object)((SDBSymptom)objectArray[1]));
        if (objectArray[2] == null) {
            this.startIndex[2] = -1;
            return this.startIndex;
        }
        SDBSymptom sDBSymptom = (SDBSymptom)objectArray[1];
        EList eList2 = sDBSymptom.getSolutions();
        this.startIndex[2] = eList2.indexOf((Object)((SDBSolution)objectArray[2]));
        if (objectArray[3] == null) {
            this.startIndex[3] = -1;
            return this.startIndex;
        }
        SDBSolution sDBSolution = (SDBSolution)objectArray[2];
        EList eList3 = sDBSolution.getDirectives();
        this.startIndex[3] = eList3.indexOf((Object)((SDBDirective)objectArray[3]));
        return this.startIndex;
    }

    private boolean searchPatternIn(String string, String string2, boolean bl) {
        return !(bl ? string2.indexOf(string) < 0 : (string2 = string2.toLowerCase()).indexOf(string = string.toLowerCase()) < 0);
    }

    private Object[] searchDown(String string, boolean bl) {
        if (this.startIndex[0] < 0 && this.searchPatternIn(string, this.root.getDescription() + this.root.getLocalExternalFileLocation() + this.root.getName() + this.root.getSymptomUrl(), bl)) {
            this.setStartIndex(0, -1, -1, -1);
            this.setStartObject(this.root, null, null, null);
            return this.start;
        }
        EList eList = this.root.getSymptoms();
        int n = this.index[2];
        int n2 = this.index[3];
        int n3 = this.index[1];
        while (n3 >= 0 && n3 < eList.size()) {
            SDBMatchPattern sDBMatchPattern;
            EList eList2;
            SDBSymptom sDBSymptom = (SDBSymptom)eList.get(n3);
            if (n3 != this.startIndex[1]) {
                if (this.searchPatternIn(string, sDBSymptom.getDescription(), bl)) {
                    this.setStartIndex(0, n3, -1, -1);
                    this.setStartObject(this.root, sDBSymptom, null, null);
                    return this.start;
                }
                eList2 = sDBSymptom.getPatterns();
                int n4 = 0;
                while (n4 < eList2.size()) {
                    sDBMatchPattern = (SDBMatchPattern)eList2.get(n4);
                    if (this.searchPatternIn(string, sDBMatchPattern.getValue(), bl)) {
                        this.setStartIndex(0, n3, -1, -1);
                        this.setStartObject(this.root, sDBSymptom, null, null);
                        return this.start;
                    }
                    ++n4;
                }
            }
            eList2 = sDBSymptom.getSolutions();
            while (n >= 0 && n < eList2.size()) {
                SDBSolution sDBSolution = (SDBSolution)eList2.get(n);
                if ((n3 != this.startIndex[1] || n != this.startIndex[2]) && this.searchPatternIn(string, sDBSolution.getDescription(), bl)) {
                    this.setStartIndex(0, n3, n, -1);
                    this.setStartObject(this.root, sDBSymptom, sDBSolution, null);
                    return this.start;
                }
                sDBMatchPattern = sDBSolution.getDirectives();
                while (n2 >= 0 && n2 < sDBMatchPattern.size()) {
                    SDBDirective sDBDirective = (SDBDirective)sDBMatchPattern.get(n2);
                    if ((n3 != this.startIndex[1] || n != this.startIndex[2] || n2 != this.startIndex[3]) && (this.searchPatternIn(string, sDBDirective.getDescription(), bl) || this.searchPatternIn(string, sDBDirective.getDirectiveString(), bl))) {
                        this.setStartIndex(0, n3, n, n2);
                        this.setStartObject(this.root, sDBSymptom, sDBSolution, sDBDirective);
                        return this.start;
                    }
                    ++n2;
                }
                n2 = 0;
                ++n;
            }
            n = 0;
            ++n3;
        }
        this.setStartObject(null, null, null, null);
        return this.start;
    }

    private Object[] searchUp(String string, boolean bl) {
        EList eList = this.root.getSymptoms();
        int n = this.index[1];
        while (n >= 0 && n < eList.size()) {
            SDBSolution sDBSolution;
            SDBSymptom sDBSymptom = (SDBSymptom)eList.get(n);
            EList eList2 = sDBSymptom.getSolutions();
            int n2 = eList2.size() - 1;
            if (n == this.index[1] && this.index[2] >= -1) {
                n2 = this.index[2];
            }
            while (n2 >= 0 && n2 < eList2.size()) {
                sDBSolution = (SDBSolution)eList2.get(n2);
                EList eList3 = sDBSolution.getDirectives();
                int n3 = eList3.size() - 1;
                if (n == this.index[1] && n2 == this.index[2] && this.index[3] >= -1) {
                    n3 = this.index[3];
                }
                while (n3 >= 0 && n3 < eList3.size()) {
                    SDBDirective sDBDirective = (SDBDirective)eList3.get(n3);
                    if ((n != this.startIndex[1] || n2 != this.startIndex[2] || n3 != this.startIndex[3]) && (this.searchPatternIn(string, sDBDirective.getDescription(), bl) || this.searchPatternIn(string, sDBDirective.getDirectiveString(), bl))) {
                        this.setStartIndex(0, n, n2, n3);
                        this.setStartObject(this.root, sDBSymptom, sDBSolution, sDBDirective);
                        return this.start;
                    }
                    --n3;
                }
                if (this.searchPatternIn(string, sDBSolution.getDescription(), bl)) {
                    this.setStartIndex(0, n, n2, -1);
                    this.setStartObject(this.root, sDBSymptom, sDBSolution, null);
                    return this.start;
                }
                --n2;
            }
            if (this.searchPatternIn(string, sDBSymptom.getDescription(), bl)) {
                this.setStartIndex(0, n, -1, -1);
                this.setStartObject(this.root, sDBSymptom, null, null);
                return this.start;
            }
            sDBSolution = sDBSymptom.getPatterns();
            int n4 = 0;
            while (n4 < sDBSolution.size()) {
                SDBMatchPattern sDBMatchPattern = (SDBMatchPattern)sDBSolution.get(n4);
                if (this.searchPatternIn(string, sDBMatchPattern.getValue(), bl)) {
                    this.setStartIndex(0, n, -1, -1);
                    this.setStartObject(this.root, sDBSymptom, null, null);
                    return this.start;
                }
                ++n4;
            }
            --n;
        }
        if (this.startIndex[0] > -1 && this.searchPatternIn(string, this.root.getDescription() + this.root.getLocalExternalFileLocation() + this.root.getName() + this.root.getSymptomUrl(), bl)) {
            this.setStartIndex(0, -1, -1, -1);
            this.setStartObject(this.root, null, null, null);
            return this.start;
        }
        this.setStartObject(null, null, null, null);
        return this.start;
    }

    private void setStartIndex(int n, int n2, int n3, int n4) {
        this.startIndex[0] = n;
        this.startIndex[1] = n2;
        this.startIndex[2] = n3;
        this.startIndex[3] = n4;
    }

    private void setIndex(int n, int n2, int n3, int n4) {
        this.index[0] = n;
        this.index[1] = n2;
        this.index[2] = n3;
        this.index[3] = n4;
    }

    private void setStartObject(Object object, Object object2, Object object3, Object object4) {
        this.start[0] = object;
        this.start[1] = object2;
        this.start[2] = object3;
        this.start[3] = object4;
    }
}

