/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.sdb.internal.util;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.sdb.internal.SDbPlugin;
import org.eclipse.hyades.sdb.internal.util.IValidateEditListener;
import org.eclipse.hyades.sdb.internal.util.ResourceStateValidator;
import org.eclipse.hyades.sdb.internal.util.TString;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;

public class ValidateEditListener
extends ShellAdapter
implements IValidateEditListener {
    private ResourceStateValidator fValidator;
    private boolean fNeedsStateValidation = true;
    private Shell fShell;
    private IWorkbenchPart fPart;
    private boolean fHasReadOnlyFiles = false;
    private boolean firstReadOnlyFileAttempt = true;
    private boolean fMessageUp = false;
    private boolean fIsActivating = false;
    private boolean fIsDeactivating = false;

    public ValidateEditListener(IWorkbenchPart iWorkbenchPart, ResourceStateValidator resourceStateValidator) {
        this.fPart = iWorkbenchPart;
        this.fValidator = resourceStateValidator;
        if (iWorkbenchPart != null) {
            iWorkbenchPart.getSite().getPage().addPartListener((IPartListener)this);
        }
        if (this.getShell() != null) {
            this.getShell().addShellListener((ShellListener)this);
        }
    }

    protected Shell getShell() {
        if (this.fShell == null && this.fPart != null && this.fPart.getSite() != null) {
            this.fShell = this.fPart.getSite().getShell();
        }
        return this.fShell;
    }

    public ResourceStateValidator getValidator() {
        return this.fValidator;
    }

    public boolean getNeedsStateValidation() {
        return this.fNeedsStateValidation;
    }

    public void setNeedsStateValidation(boolean bl) {
        this.fNeedsStateValidation = bl;
    }

    public boolean promptForInconsistentFileRefresh(List list) {
        if (list == null || list.size() == 0) {
            return false;
        }
        String string = null;
        String string2 = SDbPlugin.getResourceString("SYMPTOMDB_MESSAGE");
        if (list.size() == 1) {
            Object e = list.get(0);
            String string3 = null;
            string3 = e instanceof Resource ? ((Resource)e).getURI().devicePath() : e.toString();
            string = SDbPlugin.getResourceString("STR_INCONS_FILE_EDITOR_INFO_");
            string = TString.change(string, "%1", string3);
        } else {
            string = SDbPlugin.getResourceString("STR_INCONS_FILES_EDITOR_INFO_");
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                string = string + "    ";
                Object e = iterator.next();
                string = e instanceof Resource ? string + ((Resource)e).getURI().devicePath() : string + e.toString();
                if (iterator.hasNext()) {
                    string = string + ",";
                }
                string = string + "\n";
            }
        }
        string = string + SDbPlugin.getResourceString("STR_UPDATE_EDITOR_INFO_");
        return MessageDialog.openQuestion((Shell)this.getShell(), (String)string2, (String)string);
    }

    public Object getValidateEditContext() {
        return this.getShell();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleActivation() {
        if (this.fIsActivating) {
            return;
        }
        this.fIsActivating = true;
        try {
            try {
                this.fValidator.checkActivation(this);
                this.updatePartReadOnly();
            }
            catch (CoreException coreException) {
                Object var3_2 = null;
                this.fIsActivating = false;
            }
            Object var3_1 = null;
            this.fIsActivating = false;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.fIsActivating = false;
            throw throwable;
        }
    }

    public void shellActivated(ShellEvent shellEvent) {
        this.handleActivation();
    }

    public void partActivated(IWorkbenchPart iWorkbenchPart) {
        if (iWorkbenchPart == this.fPart) {
            this.handleActivation();
        }
    }

    public void partBroughtToTop(IWorkbenchPart iWorkbenchPart) {
    }

    public void partClosed(IWorkbenchPart iWorkbenchPart) {
        if (iWorkbenchPart == this.fPart) {
            iWorkbenchPart.getSite().getPage().removePartListener((IPartListener)this);
        }
        if (this.getShell() != null) {
            this.getShell().removeShellListener((ShellListener)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void partDeactivated(IWorkbenchPart iWorkbenchPart) {
        if (iWorkbenchPart == this.fPart) {
            if (this.fIsDeactivating) {
                return;
            }
            this.fIsDeactivating = true;
            try {
                try {
                    this.fValidator.lostActivation(this);
                    this.updatePartReadOnly();
                }
                catch (CoreException coreException) {
                    Object var4_3 = null;
                    this.fIsDeactivating = true;
                }
                Object var4_2 = null;
                this.fIsDeactivating = true;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.fIsDeactivating = true;
                throw throwable;
            }
        }
    }

    public void partOpened(IWorkbenchPart iWorkbenchPart) {
    }

    public IStatus validateState() {
        if (this.fNeedsStateValidation) {
            this.setNeedsStateValidation(false);
            IStatus iStatus = null;
            try {
                iStatus = this.fValidator.validateState(this);
                if (iStatus.getSeverity() == 4) {
                    ErrorDialog.openError((Shell)this.getShell(), (String)SDbPlugin.getResourceString("SYMPTOMDB_MESSAGE"), (String)SDbPlugin.getResourceString("STR_CHECKOUT_ERR_INFO_"), (IStatus)iStatus);
                    this.setNeedsStateValidation(true);
                }
                this.fValidator.checkActivation(this);
                this.updatePartReadOnly();
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            return iStatus;
        }
        return ResourceStateValidator.OK_STATUS;
    }

    public boolean promptForInconsistentFileOverwrite(List list) {
        if (list == null || list.size() == 0) {
            return false;
        }
        String string = "";
        String string2 = SDbPlugin.getResourceString("SYMPTOMDB_MESSAGE");
        if (list.size() == 1) {
            Object e = list.get(0);
            String string3 = null;
            string3 = e instanceof Resource ? ((Resource)e).getURI().devicePath() : e.toString();
            string = SDbPlugin.getResourceString("STR_INCONSISTENT_FILE_INFO_");
            string = TString.change(string, "%1", string3);
        } else {
            string = SDbPlugin.getResourceString("STR_INCONSISTENT_FILES_INFO_");
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                string = string + "    ";
                Object e = iterator.next();
                string = e instanceof Resource ? string + ((Resource)e).getURI().devicePath() : string + e.toString();
                if (iterator.hasNext()) {
                    string = string + ",";
                }
                string = string + "\n";
            }
        }
        string = string + SDbPlugin.getResourceString("STR_FILEOVERWRITE_INFO_");
        return MessageDialog.openQuestion((Shell)this.getShell(), (String)string2, (String)string);
    }

    protected boolean checkReadOnly() {
        this.fHasReadOnlyFiles = this.fValidator.checkReadOnly();
        return this.fHasReadOnlyFiles;
    }

    public boolean hasReadOnlyFiles() {
        if (this.firstReadOnlyFileAttempt) {
            this.checkReadOnly();
            this.firstReadOnlyFileAttempt = false;
        }
        return this.fHasReadOnlyFiles;
    }

    protected void updatePartReadOnly() {
        if (!this.getNeedsStateValidation()) {
            this.checkReadOnly();
            this.setNeedsStateValidation(true);
        }
    }

    public boolean checkSave() throws CoreException {
        if (!this.validateState().isOK()) {
            return false;
        }
        return this.getValidator().checkSave(this);
    }

    public void setShell(Shell shell) {
        this.fShell = shell;
    }

    protected IWorkbenchPart getWorkbenchPart() {
        return this.fPart;
    }
}

