/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.http.internal.junit.editor;

import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.hyades.models.common.facades.behavioral.ITestCase;
import org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage;
import org.eclipse.hyades.test.common.internal.editor.TestCasesForm;
import org.eclipse.hyades.test.common.internal.editor.action.AddTestCase;
import org.eclipse.hyades.test.common.internal.util.IITestSuiteProvider;
import org.eclipse.hyades.test.http.TestHttpImages;
import org.eclipse.hyades.test.http.TestHttpPlugin;
import org.eclipse.hyades.test.http.internal.junit.editor.HttpEditorExtension;
import org.eclipse.hyades.test.http.internal.junit.editor.HttpTestCaseDetailPage;
import org.eclipse.hyades.test.http.internal.junit.editor.HttpTestCasesForm;
import org.eclipse.hyades.test.http.internal.preferences.HttpPreferenceUtil;
import org.eclipse.hyades.test.http.internal.util.HttpConstants;
import org.eclipse.hyades.test.http.internal.util.RequestHelper;
import org.eclipse.hyades.test.http.runner.HttpExecutor;
import org.eclipse.hyades.test.http.runner.HttpRequest;
import org.eclipse.hyades.test.ui.editor.extension.BaseEditorExtension;
import org.eclipse.hyades.test.ui.editor.form.util.EditorForm;
import org.eclipse.hyades.test.ui.editor.form.util.WidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.form.util.DetailSection;
import org.eclipse.hyades.test.ui.internal.editor.form.util.EObjectTreeSection;
import org.eclipse.hyades.ui.internal.util.CoreUtil;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.hyades.ui.util.IDisposable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class HttpTestCasesForm
extends TestCasesForm {
    protected DetailSection detailSection;
    static /* synthetic */ Class class$org$eclipse$hyades$models$common$facades$behavioral$ITestCase;

    public HttpTestCasesForm(HttpEditorExtension httpEditorExtension, WidgetFactory widgetFactory) {
        super((BaseEditorExtension)httpEditorExtension, widgetFactory);
        this.setHeadingText(TestHttpPlugin.getString("EDT_GENERAL_INFO"));
    }

    protected void createLeftColumn(Composite composite) {
        this.createTestCaseSection(composite);
        this.createNamedElementSection(composite);
    }

    protected void createRightColumn(Composite composite) {
        this.createDetailSection(composite);
    }

    protected IAction getAddTestCaseAction() {
        return new AddTestCase((IITestSuiteProvider)this, "org.eclipse.hyades.test.http.junit.testCase", TestHttpPlugin.getString("W_HTTP_REQUEST").toLowerCase()){

            protected void adjusTestCase(ITestCase iTestCase) {
                RequestHelper requestHelper = new RequestHelper();
                requestHelper.setTestCase(iTestCase);
                requestHelper.setAttribute(1, HttpPreferenceUtil.getInstance().getDefaultHostName());
                requestHelper.setAttribute(2, HttpPreferenceUtil.getInstance().getDefaultHostPort());
                requestHelper.setAttribute(3, HttpPreferenceUtil.getInstance().getDefaultAbsolutePath());
                requestHelper.setAttribute(5, HttpConstants.SUPPORTED_REQUEST_METHODS[0]);
                requestHelper.setAttribute(6, "1.1");
                requestHelper.setAttribute(7, HttpPreferenceUtil.getInstance().getDefaultThinkTime());
                HttpTestCasesForm.this.detailSection.setInput((Object)iTestCase);
            }
        };
    }

    protected String getTestCasesSectionHeaderText() {
        return TestHttpPlugin.getString("W_REQUESTS");
    }

    protected void registerHelp(int n, Object object) {
        switch (n) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
        }
    }

    protected void addDetails(DetailSection detailSection) {
        this.detailSection = detailSection;
        detailSection.add(class$org$eclipse$hyades$models$common$facades$behavioral$ITestCase == null ? (class$org$eclipse$hyades$models$common$facades$behavioral$ITestCase = HttpTestCasesForm.class$("org.eclipse.hyades.models.common.facades.behavioral.ITestCase")) : class$org$eclipse$hyades$models$common$facades$behavioral$ITestCase, (DetailSection.DetailPage)new HttpTestCaseDetailPage());
    }

    protected EObjectTreeSection createTestCasesSection() {
        return new EObjectTreeSection((EditorForm)this, (EStructuralFeature)Common_TestprofilePackage.eINSTANCE.getTPFTestSuite_TestCases(), this.getAddTestCaseAction()){
            private CheckTestCaseAction checkTestCaseAction;

            protected void createActions() {
                super.createActions();
                this.checkTestCaseAction = new CheckTestCaseAction();
            }

            protected void fillContextMenu(IMenuManager iMenuManager) {
                super.fillContextMenu(iMenuManager);
                iMenuManager.add((IContributionItem)new Separator());
                iMenuManager.add((IAction)this.checkTestCaseAction);
                this.checkTestCaseAction.setStructuredSelection(this.getStructuredSelection());
            }
        };
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected static class CheckTestCaseAction
    extends Action
    implements IDisposable {
        private RequestHelper requestHelper;

        public CheckTestCaseAction() {
            super(TestHttpPlugin.getString("W_TEST"), TestHttpImages.INSTANCE.getImageDescriptor("check.gif"));
        }

        public void dispose() {
            if (this.requestHelper != null) {
                this.requestHelper.dispose();
                this.requestHelper = null;
            }
        }

        public boolean isAvailable() {
            return this.requestHelper != null && this.requestHelper.getTestCase() != null;
        }

        public void setStructuredSelection(IStructuredSelection iStructuredSelection) {
            Object object;
            if (this.requestHelper != null) {
                this.requestHelper.dispose();
            }
            if (iStructuredSelection != null && !iStructuredSelection.isEmpty() && (object = iStructuredSelection.getFirstElement()) instanceof ITestCase) {
                this.setTestCase((ITestCase)object);
            }
            this.setEnabled(this.isAvailable());
        }

        public void setTestCase(ITestCase iTestCase) {
            if (this.requestHelper == null) {
                this.requestHelper = new RequestHelper();
            } else {
                this.requestHelper.dispose();
            }
            this.requestHelper.setTestCase(iTestCase);
        }

        public ITestCase getTestCase() {
            if (this.requestHelper == null) {
                return null;
            }
            return this.requestHelper.getTestCase();
        }

        public void run() {
            if (this.requestHelper == null) {
                return;
            }
            String string = this.requestHelper.getAttribute(1);
            if (string == null) {
                this.openErrorMessage(TestHttpPlugin.getString("Host_Is_Blank"), null);
                return;
            }
            string = this.requestHelper.getAttribute(3);
            if (string == null || !string.startsWith("/")) {
                this.openErrorMessage(TestHttpPlugin.getString("Path_Needs_Slash"), null);
                return;
            }
            HttpRequest httpRequest = this.requestHelper.createHttpRequest();
            if (httpRequest == null) {
                this.openErrorMessage(TestHttpPlugin.getString("TEST_ERR_MSG"), null);
                return;
            }
            CheckTestCaseDialog checkTestCaseDialog = new CheckTestCaseDialog(httpRequest);
            checkTestCaseDialog.open();
        }

        protected void openErrorMessage(String string, String string2) {
            if (string2 != null) {
                string = string + " \n\n" + string2;
            }
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)TestHttpPlugin.getString("W_ERROR"), (String)string);
        }
    }

    protected static class CheckTestCaseDialog
    extends Dialog
    implements Listener {
        protected HttpRequest request;
        private Text resultText;
        private Cursor cursor;
        private boolean started;

        public CheckTestCaseDialog(HttpRequest httpRequest) {
            super(Display.getCurrent().getActiveShell());
            this.request = httpRequest;
            this.started = false;
        }

        protected Control createDialogArea(Composite composite) {
            this.getShell().setText(TestHttpPlugin.getString("W_TEST"));
            Composite composite2 = new Composite(composite, 0);
            GridData gridData = GridDataUtil.createFill();
            gridData.heightHint = 250;
            gridData.widthHint = 400;
            composite2.setLayoutData((Object)gridData);
            composite2.setLayout((Layout)new GridLayout());
            this.resultText = new Text(composite2, 2818);
            this.resultText.setLayoutData((Object)GridDataUtil.createFill());
            this.resultText.setEditable(false);
            this.getShell().addListener(26, (Listener)this);
            return composite2;
        }

        protected void createButtonsForButtonBar(Composite composite) {
            this.createButton(composite, 1, IDialogConstants.CANCEL_LABEL, true);
        }

        public void handleEvent(Event event) {
            this.execute();
        }

        protected void execute() {
            if (this.started) {
                return;
            }
            this.started = true;
            this.cursor = new Cursor((Device)Display.getDefault(), 1);
            this.getShell().setCursor(this.cursor);
            this.resultText.setText(TestHttpPlugin.getString("test.WaitMessage"));
            Thread thread = new Thread(this, "HyadesHttpRequestTester"){
                private final /* synthetic */ CheckTestCaseDialog this$0;
                {
                    this.this$0 = checkTestCaseDialog;
                }

                public void run() {
                    Object object;
                    String string = null;
                    try {
                        object = new HttpExecutor().execute(this.this$0.request);
                        string = TestHttpPlugin.getString("test.Response", new String[]{object.getCode() + "", object.getContentType(), "" + object.getContentLength()});
                        if (object.getDetail() != null) {
                            string = string + "\n\n" + object.getDetail();
                        }
                        if (object.getBody() != null) {
                            string = string + "\n\n" + object.getBody();
                        }
                    }
                    catch (Throwable throwable) {
                        string = TestHttpPlugin.getString("test.Exception") + "\n" + CoreUtil.getStackTrace((Throwable)throwable);
                    }
                    object = string;
                    Display.getDefault().asyncExec(new Runnable(this, (String)object){
                        private final /* synthetic */ String val$cr;
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = var1_1;
                            this.val$cr = string;
                        }

                        public void run() {
                            1.access$000(this.this$1).testFinished(this.val$cr);
                        }
                    });
                }

                static /* synthetic */ CheckTestCaseDialog access$000(1 var0) {
                    return var0.this$0;
                }
            };
            thread.start();
        }

        protected void testFinished(String string) {
            if (this.getShell() == null || this.resultText.isDisposed()) {
                return;
            }
            this.resultText.setText(string);
            this.getButton(1).setText(IDialogConstants.OK_LABEL);
            this.getShell().setCursor(null);
            this.cursor.dispose();
        }
    }
}

