/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.common.common.impl;

import java.io.File;
import java.io.IOException;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.hyades.models.common.common.CMNAnnotation;
import org.eclipse.hyades.models.common.common.CMNNamedElement;
import org.eclipse.hyades.models.common.common.CommonPackage;
import org.eclipse.hyades.models.common.common.impl.CMNNamedElementImpl;
import org.eclipse.hyades.models.common.facades.behavioral.impl.FacadeResourceImpl;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionEvent;
import org.eclipse.hyades.models.common.util.FileUtil;

public class CMNAnnotationImpl
extends CMNNamedElementImpl
implements CMNAnnotation {
    public static final String copyright = "";
    protected static final String URI_EDEFAULT = null;
    protected String uri = URI_EDEFAULT;
    protected static final String TYPE_EDEFAULT = null;
    protected String type = TYPE_EDEFAULT;
    public static final String ANNOTATION_QUERY = "annotationID=/";

    protected CMNAnnotationImpl() {
    }

    protected EClass eStaticClass() {
        return CommonPackage.eINSTANCE.getCMNAnnotation();
    }

    public String getURI() {
        return this.uri;
    }

    public void setURI(String string) {
        String string2 = this.uri;
        this.uri = string;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)string2, (Object)this.uri));
        }
    }

    public String getType() {
        return this.type;
    }

    public void setType(String string) {
        String string2 = this.type;
        this.type = string;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, (Object)string2, (Object)this.type));
        }
    }

    public Object eGet(EStructuralFeature eStructuralFeature, boolean bl) {
        switch (this.eDerivedStructuralFeatureID(eStructuralFeature)) {
            case 0: {
                return this.getId();
            }
            case 1: {
                return this.getDescription();
            }
            case 2: {
                return this.getName();
            }
            case 3: {
                return this.getURI();
            }
            case 4: {
                return this.getType();
            }
        }
        return this.eDynamicGet(eStructuralFeature, bl);
    }

    public void eSet(EStructuralFeature eStructuralFeature, Object object) {
        switch (this.eDerivedStructuralFeatureID(eStructuralFeature)) {
            case 0: {
                this.setId((String)object);
                return;
            }
            case 1: {
                this.setDescription((String)object);
                return;
            }
            case 2: {
                this.setName((String)object);
                return;
            }
            case 3: {
                this.setURI((String)object);
                return;
            }
            case 4: {
                this.setType((String)object);
                return;
            }
        }
        this.eDynamicSet(eStructuralFeature, object);
    }

    public void eUnset(EStructuralFeature eStructuralFeature) {
        switch (this.eDerivedStructuralFeatureID(eStructuralFeature)) {
            case 0: {
                this.setId(CMNNamedElementImpl.ID_EDEFAULT);
                return;
            }
            case 1: {
                this.setDescription(CMNNamedElementImpl.DESCRIPTION_EDEFAULT);
                return;
            }
            case 2: {
                this.setName(CMNNamedElementImpl.NAME_EDEFAULT);
                return;
            }
            case 3: {
                this.setURI(URI_EDEFAULT);
                return;
            }
            case 4: {
                this.setType(TYPE_EDEFAULT);
                return;
            }
        }
        this.eDynamicUnset(eStructuralFeature);
    }

    public boolean eIsSet(EStructuralFeature eStructuralFeature) {
        switch (this.eDerivedStructuralFeatureID(eStructuralFeature)) {
            case 0: {
                return CMNNamedElementImpl.ID_EDEFAULT == null ? this.id != null : !CMNNamedElementImpl.ID_EDEFAULT.equals(this.id);
            }
            case 1: {
                return CMNNamedElementImpl.DESCRIPTION_EDEFAULT == null ? this.description != null : !CMNNamedElementImpl.DESCRIPTION_EDEFAULT.equals(this.description);
            }
            case 2: {
                return CMNNamedElementImpl.NAME_EDEFAULT == null ? this.name != null : !CMNNamedElementImpl.NAME_EDEFAULT.equals(this.name);
            }
            case 3: {
                return URI_EDEFAULT == null ? this.uri != null : !URI_EDEFAULT.equals(this.uri);
            }
            case 4: {
                return TYPE_EDEFAULT == null ? this.type != null : !TYPE_EDEFAULT.equals(this.type);
            }
        }
        return this.eDynamicIsSet(eStructuralFeature);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append(" (URI: ");
        stringBuffer.append(this.uri);
        stringBuffer.append(", type: ");
        stringBuffer.append(this.type);
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public URI getFileAnnotation() throws UnsupportedOperationException, IOException {
        if (!this.isFileAnnotation()) {
            throw new UnsupportedOperationException("Annotation is not a File Annotation " + this.toString());
        }
        String string = this.getURI();
        if (!(this.eResource() instanceof FacadeResourceImpl)) {
            throw new UnsupportedOperationException("Resource is not supported by FacadeResourceImpl");
        }
        FacadeResourceImpl facadeResourceImpl = (FacadeResourceImpl)this.eResource();
        File file = facadeResourceImpl.getAnnotationDir();
        URI uRI = URI.createFileURI((String)file.getAbsolutePath());
        URI uRI2 = URI.createURI((String)string);
        uRI2 = this.queryURItoRelativeURI(uRI2);
        URI uRI3 = uRI2.resolve(uRI);
        return uRI3;
    }

    public boolean isFileAnnotation() {
        if (this.eResource() instanceof FacadeResourceImpl) {
            String string = this.getURI();
            if (string == null || string.length() == 0) {
                return false;
            }
            URI uRI = URI.createURI((String)string);
            if ((uRI = this.queryURItoRelativeURI(uRI)).isFile()) {
                return true;
            }
        }
        return false;
    }

    private URI queryURItoRelativeURI(URI uRI) {
        if (uRI.hasQuery()) {
            String string = uRI.query();
            String string2 = string.replaceFirst(ANNOTATION_QUERY, copyright);
            uRI = URI.createURI((String)string2);
        }
        return uRI;
    }

    private URI relativeURItoQueryURI(URI uRI) {
        if (!uRI.hasQuery()) {
            String string = ANNOTATION_QUERY + uRI.toString();
            uRI = URI.createHierarchicalURI(null, null, null, (String)string, null);
        }
        return uRI;
    }

    public void putFileAnnotation(URI uRI) throws UnsupportedOperationException, IOException {
        File file;
        if (!(this.eResource() instanceof FacadeResourceImpl)) {
            throw new UnsupportedOperationException("Resource is not supported by FacadeResourceImpl");
        }
        String string = this.getContainerID();
        FacadeResourceImpl facadeResourceImpl = (FacadeResourceImpl)this.eResource();
        File file2 = facadeResourceImpl.getAnnotationDir();
        File file3 = new File(file2, string);
        if (!file3.exists()) {
            if (!file3.mkdir()) {
                throw new IOException("Collision making dirctory " + file3.getAbsolutePath());
            }
        } else if (!file3.isDirectory()) {
            throw new IOException("Object annotation dir name exists as file " + file3.getAbsolutePath());
        }
        if (!(file = new File(uRI.toFileString())).exists()) {
            throw new IOException("Specified file does not exist " + uRI.toFileString());
        }
        File file4 = new File(file3, file.getName());
        if (file4.exists()) {
            throw new IOException("FileAnnotation of same name (" + file.getName() + ") already exists on object " + this.eContainer().toString());
        }
        FileUtil.copyFile(file.getAbsolutePath(), file4.getAbsolutePath());
        URI uRI2 = URI.createFileURI((String)file2.getAbsolutePath());
        URI uRI3 = URI.createFileURI((String)file4.getAbsolutePath());
        URI uRI4 = uRI3.deresolve(uRI2);
        this.setURI(this.relativeURItoQueryURI(uRI4).toString());
    }

    private String getContainerID() throws UnsupportedOperationException {
        String string;
        EObject eObject = this.eContainer();
        if (eObject == null) {
            throw new UnsupportedOperationException("FileAnnotation must be contained in a model element");
        }
        if (eObject instanceof CMNNamedElement) {
            CMNNamedElement cMNNamedElement = (CMNNamedElement)eObject;
            string = cMNNamedElement.getId();
        } else if (eObject instanceof TPFExecutionEvent) {
            TPFExecutionEvent tPFExecutionEvent = (TPFExecutionEvent)eObject;
            string = tPFExecutionEvent.getId();
        } else {
            throw new UnsupportedOperationException("Annotations not supported for container of type " + eObject);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFileAnnotation() throws UnsupportedOperationException, IOException {
        URI uRI = this.getFileAnnotation();
        File file = new File(uRI.toFileString());
        try {
            if (file.exists()) {
                File[] fileArray;
                file.delete();
                File file2 = file.getParentFile();
                if (file2.exists() && (fileArray = file2.listFiles()).length == 0) {
                    file2.delete();
                }
            }
            Object var6_5 = null;
            this.setURI(URI_EDEFAULT);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.setURI(URI_EDEFAULT);
            throw throwable;
        }
    }
}

