/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.common.configuration.util;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.models.common.configuration.Common_ConfigurationFactory;
import org.eclipse.hyades.models.common.configuration.util.ICategory;
import org.eclipse.hyades.models.common.configuration.util.ICategoryEnumeration;

public class Common_ConfigurationCategoryUtil {
    public static final String DB_VER = "DB_VER";
    public static final String DB = "DB";
    public static final String DISP_DEPTH = "DISP_DEPTH";
    public static final String DISP_HEIGHT = "DISP_HEIGHT";
    public static final String DISP_WIDTH = "DISP_WIDTH";
    public static final String DISP_NUM = "DISP_NUM";
    public static final String SVC_PAC = "SVC_PAC";
    public static final String WBR_TYPE = "WBR_TYPE";
    public static final String WBR_VER = "WBR_VER";
    public static final String HNAME = "HNAME";
    public static final String WIN_DOM = "WIN_DOM";
    public static final String USR_NAME = "USR_NAME";
    public static final String MIN_VER = "MIN_VER";
    public static final String MAJ_VER = "MAJ_VER";
    public static final String OS = "OS";
    public static final String MEM_SZ = "MEM_SZ";
    public static final String PROC_TYPE = "PROC_TYPE";
    public static final String PROC_SPD = "PROC_SPD";
    public static final String PROC_NUM = "PROC_NUM";
    public static final String PASSWD = "PASSWD";
    public static final String CLSPATH = "CLASSPATH";
    public static final String ROOTDIR = "ROOTDIR";
    private ArrayList categories = new ArrayList(100);
    private ArrayList categoryNames = null;
    private ArrayList categoryDisplayNames = null;
    private ArrayList enumerations = null;
    private HashMap nameCategoryMap = null;
    private HashMap categoryEnumerationMap = null;
    private static final Common_ConfigurationCategoryUtil instance = new Common_ConfigurationCategoryUtil();

    public static Common_ConfigurationCategoryUtil getInstance() {
        return instance;
    }

    protected Common_ConfigurationCategoryUtil() {
        Object object;
        Object object2;
        this.categories.add(Common_ConfigurationFactory.eINSTANCE.createHyadesBrowserTypeCategory());
        this.categories.add(Common_ConfigurationFactory.eINSTANCE.createHyadesBrowserVersionCategory());
        this.categories.add(Common_ConfigurationFactory.eINSTANCE.createHyadesDatabaseCategory());
        this.categories.add(Common_ConfigurationFactory.eINSTANCE.createHyadesDatabaseVersionCategory());
        this.categories.add(Common_ConfigurationFactory.eINSTANCE.createHyadesDisplayColorDepthCategory());
        this.categories.add(Common_ConfigurationFactory.eINSTANCE.createHyadesDisplayHeightCategory());
        this.categories.add(Common_ConfigurationFactory.eINSTANCE.createHyadesDisplayNumberCategory());
        this.categories.add(Common_ConfigurationFactory.eINSTANCE.createHyadesDisplayWidthCategory());
        this.categories.add(Common_ConfigurationFactory.eINSTANCE.createHyadesHostnameCategory());
        this.categories.add(Common_ConfigurationFactory.eINSTANCE.createHyadesMajorVersionCategory());
        this.categories.add(Common_ConfigurationFactory.eINSTANCE.createHyadesMemorySizeCategory());
        this.categories.add(Common_ConfigurationFactory.eINSTANCE.createHyadesMinorVersionCategory());
        this.categories.add(Common_ConfigurationFactory.eINSTANCE.createHyadesOperatingSystemCategory());
        this.categories.add(Common_ConfigurationFactory.eINSTANCE.createHyadesProcessorNumberCategory());
        this.categories.add(Common_ConfigurationFactory.eINSTANCE.createHyadesProcessorSpeedCategory());
        this.categories.add(Common_ConfigurationFactory.eINSTANCE.createHyadesProcessorTypeCategory());
        this.categories.add(Common_ConfigurationFactory.eINSTANCE.createHyadesServicePackCategory());
        this.categories.add(Common_ConfigurationFactory.eINSTANCE.createHyadesUsernameCategory());
        this.categories.add(Common_ConfigurationFactory.eINSTANCE.createHyadesWindowsDomainCategory());
        this.categories.add(Common_ConfigurationFactory.eINSTANCE.createHyadesPasswordCategory());
        this.categories.add(Common_ConfigurationFactory.eINSTANCE.createHyadesClasspathCategory());
        this.categories.add(Common_ConfigurationFactory.eINSTANCE.createHyadesRootDirectroyCategory());
        this.enumerations = new ArrayList(100);
        this.enumerations.add(Common_ConfigurationFactory.eINSTANCE.createHyadesBrowserEnumeration());
        this.enumerations.add(Common_ConfigurationFactory.eINSTANCE.createHyadesDatabaseEnumeration());
        this.enumerations.add(Common_ConfigurationFactory.eINSTANCE.createHyadesDisplayColorDepthEnumeration());
        this.enumerations.add(Common_ConfigurationFactory.eINSTANCE.createHyadesDisplayHeightEnumeration());
        this.enumerations.add(Common_ConfigurationFactory.eINSTANCE.createHyadesDisplayWidthEnumeration());
        this.enumerations.add(Common_ConfigurationFactory.eINSTANCE.createHyadesOperatingSystemEnumeration());
        this.enumerations.add(Common_ConfigurationFactory.eINSTANCE.createHyadesProcessorTypeEnumeration());
        this.enumerations.add(Common_ConfigurationFactory.eINSTANCE.createHyadesServicePackEnumeration());
        this.nameCategoryMap = new HashMap(100);
        this.categoryDisplayNames = new ArrayList(100);
        this.categoryNames = new ArrayList(100);
        int n = 0;
        while (n < this.categories.size()) {
            ICategory iCategory = (ICategory)this.categories.get(n);
            object2 = iCategory.getName();
            object = iCategory.getDisplayName();
            this.nameCategoryMap.put(object2, iCategory);
            this.categoryNames.add(object2);
            this.categoryDisplayNames.add(object);
            ++n;
        }
        this.categoryEnumerationMap = new HashMap(100);
        int n2 = 0;
        while (n2 < this.enumerations.size()) {
            object2 = (ICategoryEnumeration)this.enumerations.get(n2);
            object = object2.getICategory();
            ArrayList<Object> arrayList = new ArrayList<Object>(5);
            arrayList.add(object2);
            if (object != null) {
                this.categoryEnumerationMap.put(object.getName(), arrayList);
            }
            ++n2;
        }
        this.addCategoriesFromExtensionPoint();
        this.addCategoryEnumerationsFromExtensionPoint();
    }

    private void addCategoriesFromExtensionPoint() {
        block4: {
            IExtensionPoint iExtensionPoint = Platform.getPluginRegistry().getExtensionPoint("org.eclipse.hyades.models.common.categoryExtensions");
            if (iExtensionPoint == null) break block4;
            try {
                IConfigurationElement[] iConfigurationElementArray = iExtensionPoint.getConfigurationElements();
                int n = 0;
                while (n < iConfigurationElementArray.length) {
                    ICategory iCategory = (ICategory)iConfigurationElementArray[n].createExecutableExtension("categoryClass");
                    if (!this.nameCategoryMap.containsKey(iCategory.getName()) && iCategory != null && iCategory.getName() != null && iCategory.getDisplayName() != null && !this.nameCategoryMap.containsKey(iCategory.getName())) {
                        this.categories.add(iCategory);
                        this.categoryNames.add(iCategory.getName());
                        this.categoryDisplayNames.add(iCategory.getDisplayName());
                        this.nameCategoryMap.put(iCategory.getName(), iCategory);
                    }
                    ++n;
                }
            }
            catch (Exception exception) {}
        }
    }

    private void addCategoryEnumerationsFromExtensionPoint() {
        block6: {
            IExtensionPoint iExtensionPoint = Platform.getPluginRegistry().getExtensionPoint("org.eclipse.hyades.models.common.categoryEnumerationExtensions");
            if (iExtensionPoint == null) break block6;
            try {
                IConfigurationElement[] iConfigurationElementArray = iExtensionPoint.getConfigurationElements();
                int n = 0;
                while (n < iConfigurationElementArray.length) {
                    ICategory iCategory;
                    ICategoryEnumeration iCategoryEnumeration = (ICategoryEnumeration)iConfigurationElementArray[n].createExecutableExtension("enumeration");
                    if (iCategoryEnumeration != null && iCategoryEnumeration.getIEnumerationValues() != null && (iCategory = iCategoryEnumeration.getICategory()) != null && this.nameCategoryMap.containsKey(iCategory.getName())) {
                        ArrayList arrayList;
                        this.enumerations.add(iCategoryEnumeration);
                        if (this.categoryEnumerationMap.containsKey(iCategory.getName())) {
                            arrayList = (ArrayList)this.categoryEnumerationMap.get(iCategory.getName());
                            arrayList.add(iCategoryEnumeration);
                        } else {
                            arrayList = new ArrayList(5);
                            arrayList.add(iCategoryEnumeration);
                            this.categoryEnumerationMap.put(iCategory.getName(), arrayList);
                        }
                    }
                    ++n;
                }
            }
            catch (Exception exception) {}
        }
    }

    public ICategory[] getCategories() {
        ICategory[] iCategoryArray = new ICategory[this.categories.size()];
        int n = 0;
        while (n < this.categories.size()) {
            iCategoryArray[n] = (ICategory)this.categories.get(n);
            ++n;
        }
        return iCategoryArray;
    }

    public ICategoryEnumeration[] getEnumerations() {
        ICategoryEnumeration[] iCategoryEnumerationArray = new ICategoryEnumeration[this.enumerations.size()];
        int n = 0;
        while (n < this.enumerations.size()) {
            iCategoryEnumerationArray[n] = (ICategoryEnumeration)this.enumerations.get(n);
            ++n;
        }
        return iCategoryEnumerationArray;
    }

    public String[] getCategoryNames() {
        String[] stringArray = new String[this.categoryNames.size()];
        int n = 0;
        while (n < this.categoryNames.size()) {
            stringArray[n] = (String)this.categoryNames.get(n);
            ++n;
        }
        return stringArray;
    }

    public String[] getCategoryDisplayNames() {
        String[] stringArray = new String[this.categoryDisplayNames.size()];
        int n = 0;
        while (n < this.categoryDisplayNames.size()) {
            stringArray[n] = (String)this.categoryDisplayNames.get(n);
            ++n;
        }
        return stringArray;
    }

    public ICategory getCategory(String string) {
        return (ICategory)this.nameCategoryMap.get(string);
    }

    public ICategoryEnumeration[] getCategoryEnumeration(ICategory iCategory) {
        if (iCategory == null) {
            return null;
        }
        ArrayList arrayList = (ArrayList)this.categoryEnumerationMap.get(iCategory.getName());
        if (arrayList == null) {
            return null;
        }
        ICategoryEnumeration[] iCategoryEnumerationArray = new ICategoryEnumeration[arrayList.size()];
        int n = 0;
        while (n < arrayList.size()) {
            iCategoryEnumerationArray[n] = (ICategoryEnumeration)arrayList.get(n);
            ++n;
        }
        return iCategoryEnumerationArray;
    }

    public ICategoryEnumeration[] getCategoryEnumeration(String string) {
        ICategory iCategory = null;
        if (this.nameCategoryMap != null) {
            iCategory = (ICategory)this.nameCategoryMap.get(string);
        }
        return this.getCategoryEnumeration(iCategory);
    }
}

