/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.common.configuration.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.hyades.models.common.common.CMNNamedElement;
import org.eclipse.hyades.models.common.configuration.CFGArtifact;
import org.eclipse.hyades.models.common.configuration.CFGArtifactLocationPair;
import org.eclipse.hyades.models.common.configuration.CFGClass;
import org.eclipse.hyades.models.common.configuration.CFGLocation;
import org.eclipse.hyades.models.common.configuration.CFGMachineConstraint;
import org.eclipse.hyades.models.common.configuration.CFGPropertyGroup;
import org.eclipse.hyades.models.common.configuration.Common_ConfigurationFactory;
import org.eclipse.hyades.models.common.interactions.BVRProperty;
import org.eclipse.hyades.models.common.testprofile.Common_TestprofileFactory;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;

public class ConfigurationUtil {
    public static final String CLASSPATH = "CLASSPATH";
    public static final String ROOTDIR = "ROOTDIR";
    public static final String ATTRS_PROP_GROUP_ID_ARTIFACT = "org.eclipse.hyades.test.configuration.artifact.attributes";
    public static final String ATTRS_PROP_GROUP_ID_LOCATION = "org.eclipse.hyades.test.configuration.location.attributes";

    public static TPFDeployment createDeployment(String string, String string2) {
        TPFDeployment tPFDeployment = Common_TestprofileFactory.eINSTANCE.createTPFDeployment();
        if (string != null) {
            tPFDeployment.setName(string);
        }
        if (string2 != null && string2.trim().length() > 0) {
            tPFDeployment.setDescription(string2);
        }
        return tPFDeployment;
    }

    public static TPFDeployment createDeploymentWithPair(String string, String string2, CFGClass cFGClass, String string3) {
        TPFDeployment tPFDeployment = ConfigurationUtil.createDeployment(string, string2);
        CFGArtifact cFGArtifact = ConfigurationUtil.createArtifact(null, null);
        cFGArtifact.getDeployableInstances().add((Object)cFGClass);
        CFGLocation cFGLocation = ConfigurationUtil.createLocation(null, null, string3);
        CFGArtifactLocationPair cFGArtifactLocationPair = ConfigurationUtil.createArtifactLocationPair(cFGArtifact, cFGLocation);
        tPFDeployment.getArtifactLocations().add((Object)cFGArtifactLocationPair);
        return tPFDeployment;
    }

    public static CFGArtifact createArtifact(String string, String string2) {
        CFGArtifact cFGArtifact = Common_ConfigurationFactory.eINSTANCE.createCFGArtifact();
        if (string != null) {
            cFGArtifact.setName(string);
        }
        if (string2 != null && string2.trim().length() > 0) {
            cFGArtifact.setDescription(string2);
        }
        return cFGArtifact;
    }

    public static CFGLocation createLocation(String string, String string2, String string3) {
        CFGLocation cFGLocation = ConfigurationUtil.createLocation();
        if (string != null) {
            cFGLocation.setName(string);
        }
        if (string2 != null && string2.trim().length() > 0) {
            cFGLocation.setDescription(string2);
        }
        if (string3 != null && cFGLocation instanceof CFGMachineConstraint) {
            ((CFGMachineConstraint)cFGLocation).setHostname(string3);
        }
        return cFGLocation;
    }

    public static CFGLocation createLocation() {
        CFGMachineConstraint cFGMachineConstraint = Common_ConfigurationFactory.eINSTANCE.createCFGMachineConstraint();
        String string = "localhost";
        cFGMachineConstraint.setHostname(string);
        return cFGMachineConstraint;
    }

    public static CFGArtifactLocationPair searchPairWithTestAsset(CFGClass cFGClass, TPFDeployment tPFDeployment) {
        CFGArtifactLocationPair cFGArtifactLocationPair = null;
        CFGArtifact cFGArtifact = null;
        Iterator iterator = tPFDeployment.getArtifactLocations().iterator();
        while (iterator.hasNext()) {
            cFGArtifactLocationPair = (CFGArtifactLocationPair)iterator.next();
            cFGArtifact = cFGArtifactLocationPair.getArtifact();
            if (!ConfigurationUtil.containsById((List)cFGArtifact.getDeployableInstances(), cFGClass)) continue;
            return cFGArtifactLocationPair;
        }
        return null;
    }

    public static CFGArtifact searchArtifactWithTestAsset(CFGClass cFGClass, TPFDeployment tPFDeployment) {
        CFGArtifact cFGArtifact = null;
        Iterator iterator = tPFDeployment.getArtifacts().iterator();
        while (iterator.hasNext()) {
            cFGArtifact = (CFGArtifact)iterator.next();
            if (!ConfigurationUtil.containsById((List)cFGArtifact.getDeployableInstances(), cFGClass)) continue;
            return cFGArtifact;
        }
        return null;
    }

    public static CFGArtifactLocationPair createArtifactLocationPair(CFGArtifact cFGArtifact, CFGLocation cFGLocation) {
        CFGArtifactLocationPair cFGArtifactLocationPair = Common_ConfigurationFactory.eINSTANCE.createCFGArtifactLocationPair();
        cFGArtifactLocationPair.setArtifact(cFGArtifact);
        cFGArtifactLocationPair.setLocation(cFGLocation);
        return cFGArtifactLocationPair;
    }

    public static BVRProperty[] searchPropertiesByName(List list, String string, boolean bl) {
        if (list != null && !list.isEmpty() && string != null) {
            ArrayList<BVRProperty> arrayList = new ArrayList<BVRProperty>();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                BVRProperty bVRProperty = (BVRProperty)iterator.next();
                if (bl) {
                    if (!string.equals(bVRProperty.getName())) continue;
                    arrayList.add(bVRProperty);
                    continue;
                }
                if (!string.equalsIgnoreCase(bVRProperty.getName())) continue;
                arrayList.add(bVRProperty);
            }
            return arrayList.toArray(new BVRProperty[arrayList.size()]);
        }
        return new BVRProperty[0];
    }

    public static CFGPropertyGroup searchPropertyGroupById(List list, String string) {
        if (list == null || list.isEmpty() || string == null) {
            return null;
        }
        CFGPropertyGroup cFGPropertyGroup = null;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof CFGPropertyGroup) || ((CFGPropertyGroup)e).getPropertyGroupID() == null || !((CFGPropertyGroup)e).getPropertyGroupID().equals(string)) continue;
            cFGPropertyGroup = (CFGPropertyGroup)e;
            break;
        }
        return cFGPropertyGroup;
    }

    public static boolean containsById(List list, CMNNamedElement cMNNamedElement) {
        if (list.isEmpty()) {
            return false;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof CMNNamedElement) || !((CMNNamedElement)e).getId().equals(cMNNamedElement.getId())) continue;
            return true;
        }
        return false;
    }

    public static String getHostNameForTestAsset(CFGClass cFGClass, TPFDeployment tPFDeployment) {
        CFGArtifactLocationPair cFGArtifactLocationPair;
        String string = null;
        if (!tPFDeployment.getArtifactLocations().isEmpty() && (cFGArtifactLocationPair = ConfigurationUtil.searchPairWithTestAsset(cFGClass, tPFDeployment)) != null) {
            CFGLocation cFGLocation = cFGArtifactLocationPair.getLocation();
            if (cFGLocation instanceof CFGMachineConstraint) {
                string = ((CFGMachineConstraint)cFGLocation).getHostname();
            } else if (cFGLocation != null) {
                string = cFGLocation.getName();
            }
        }
        return string;
    }
}

