/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.common.datapool.impl;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.hyades.edit.datapool.IDatapool;
import org.eclipse.hyades.edit.datapool.IDatapoolSuggestedType;
import org.eclipse.hyades.execution.runtime.datapool.DatapoolException;
import org.eclipse.hyades.execution.runtime.datapool.IDatapoolIterator;
import org.eclipse.hyades.models.common.datapool.Common_DatapoolFactory;
import org.eclipse.hyades.models.common.datapool.Common_DatapoolPackage;
import org.eclipse.hyades.models.common.datapool.DPLCell;
import org.eclipse.hyades.models.common.datapool.DPLDatapool;
import org.eclipse.hyades.models.common.datapool.DPLDatapoolSpec;
import org.eclipse.hyades.models.common.datapool.DPLEquivalenceClass;
import org.eclipse.hyades.models.common.datapool.DPLRecord;
import org.eclipse.hyades.models.common.datapool.DPLRole;
import org.eclipse.hyades.models.common.datapool.DPLVariable;
import org.eclipse.hyades.models.common.datapool.impl.DPLCellImpl;
import org.eclipse.hyades.models.common.datapool.impl.DPLDatapoolImpl;
import org.eclipse.hyades.models.common.datapool.impl.DPLDatapoolSpecImpl;
import org.eclipse.hyades.models.common.datapool.impl.DPLEquivalenceClassImpl;
import org.eclipse.hyades.models.common.datapool.impl.DPLLogImpl;
import org.eclipse.hyades.models.common.datapool.impl.DPLRecordImpl;
import org.eclipse.hyades.models.common.datapool.impl.DPLVariableImpl;
import org.eclipse.hyades.models.common.datapool.impl.DatapoolSuggestedTypeImpl;

public class Common_DatapoolFactoryImpl
extends EFactoryImpl
implements Common_DatapoolFactory {
    public static final String copyright = "";
    private static HashMap datapoolsOpen = new HashMap();
    private static HashMap datapoolRefCounts = new HashMap();

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createDPLDatapoolSpec();
            }
            case 1: {
                return this.createDPLEquivalenceClass();
            }
            case 2: {
                return this.createDPLRecord();
            }
            case 3: {
                return this.createDPLCell();
            }
            case 4: {
                return this.createDPLVariable();
            }
            case 5: {
                return this.createDPLDatapool();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String string) {
        switch (eDataType.getClassifierID()) {
            case 6: {
                return DPLRole.get(string);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object object) {
        switch (eDataType.getClassifierID()) {
            case 6: {
                return object == null ? null : object.toString();
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public DPLDatapoolSpec createDPLDatapoolSpec() {
        DPLDatapoolSpecImpl dPLDatapoolSpecImpl = new DPLDatapoolSpecImpl();
        return dPLDatapoolSpecImpl;
    }

    public DPLDatapool createDPLDatapool() {
        DPLDatapoolImpl dPLDatapoolImpl = new DPLDatapoolImpl();
        return dPLDatapoolImpl;
    }

    public DPLEquivalenceClass createDPLEquivalenceClass() {
        DPLEquivalenceClassImpl dPLEquivalenceClassImpl = new DPLEquivalenceClassImpl();
        return dPLEquivalenceClassImpl;
    }

    public DPLRecord createDPLRecord() {
        DPLRecordImpl dPLRecordImpl = new DPLRecordImpl();
        return dPLRecordImpl;
    }

    public DPLCell createDPLCell() {
        DPLCellImpl dPLCellImpl = new DPLCellImpl();
        return dPLCellImpl;
    }

    public DPLVariable createDPLVariable() {
        DPLVariableImpl dPLVariableImpl = new DPLVariableImpl();
        return dPLVariableImpl;
    }

    public Common_DatapoolPackage getCommon_DatapoolPackage() {
        return (Common_DatapoolPackage)this.getEPackage();
    }

    public static Common_DatapoolPackage getPackage() {
        return Common_DatapoolPackage.eINSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IDatapool loadForEdit(File file, boolean bl) {
        Common_DatapoolFactoryImpl common_DatapoolFactoryImpl = this;
        synchronized (common_DatapoolFactoryImpl) {
            String string = file.getAbsolutePath();
            IDatapool iDatapool = (IDatapool)datapoolsOpen.get(string);
            if (!bl || bl && iDatapool == null) {
                try {
                    ResourceSetImpl resourceSetImpl = new ResourceSetImpl();
                    DPLLogImpl.log("Load file: " + string);
                    Resource resource = resourceSetImpl.getResource(URI.createFileURI((String)string), true);
                    resource.load(null);
                    IDatapool iDatapool2 = (IDatapool)resource.getContents().get(0);
                    if (bl) {
                        datapoolsOpen.put(string, iDatapool2);
                        DPLLogImpl.log("datapool cached, refCount =1");
                        datapoolRefCounts.put(string, new Integer(1));
                    }
                    ((DPLDatapoolImpl)iDatapool2).setAbsoluteFilePathname(string);
                    return iDatapool2;
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    throw new DatapoolException("Datapool could not be loaded from file: " + string);
                }
            }
            Integer n = (Integer)datapoolRefCounts.remove(string);
            Integer n2 = new Integer(n + 1);
            DPLLogImpl.log("Refcount: " + n2);
            datapoolRefCounts.put(string, n2);
            return iDatapool;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unload(IDatapool iDatapool) {
        String string = ((DPLDatapoolImpl)iDatapool).getAbsoluteFilePathname();
        Common_DatapoolFactoryImpl common_DatapoolFactoryImpl = this;
        synchronized (common_DatapoolFactoryImpl) {
            Integer n = (Integer)datapoolRefCounts.remove(string);
            if (n != null && n > 1) {
                Integer n2 = new Integer(n - 1);
                DPLLogImpl.log("Refcount: " + n2);
                datapoolRefCounts.put(string, n2);
            } else if (n != null && n == 1) {
                DPLLogImpl.log("datapool uncached");
                datapoolsOpen.remove(string);
            }
        }
    }

    public void save(IDatapool iDatapool) {
        this.saveAs(iDatapool, new File(((DPLDatapoolImpl)iDatapool).getAbsoluteFilePathname()));
    }

    public void saveAs(IDatapool iDatapool, File file) {
        try {
            String string = file.getAbsolutePath();
            ResourceSetImpl resourceSetImpl = new ResourceSetImpl();
            URI uRI = URI.createFileURI((String)string);
            Resource.Factory.Registry registry = Resource.Factory.Registry.INSTANCE;
            Map map = registry.getExtensionToFactoryMap();
            map.put("xmi", new XMIResourceFactoryImpl());
            resourceSetImpl.getResourceFactoryRegistry();
            Resource resource = resourceSetImpl.createResource(uRI);
            DPLLogImpl.log("Save file: " + string);
            resource.getContents().add((Object)iDatapool);
            resource.save(Collections.EMPTY_MAP);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public org.eclipse.hyades.execution.runtime.datapool.IDatapool load(File file, boolean bl) {
        return this.loadForEdit(file, bl);
    }

    public void unload(org.eclipse.hyades.execution.runtime.datapool.IDatapool iDatapool) {
        this.unload((IDatapool)iDatapool);
    }

    public IDatapoolIterator open(org.eclipse.hyades.execution.runtime.datapool.IDatapool iDatapool, String string) {
        Object object;
        Object object2;
        IDatapoolIterator iDatapoolIterator = null;
        Class<?> clazz = null;
        try {
            object2 = Platform.getPluginRegistry().getExtensionPoint("org.eclipse.hyades.models.common.datapool_iterator");
            DPLLogImpl.log("iterator ext point found!!!");
            object = object2.getExtensions();
            DPLLogImpl.log("extensions.length: " + ((IExtension[])object).length);
            int n = 0;
            boolean bl = false;
            while (!bl && n < ((Object)object).length) {
                Object object3 = object[n];
                DPLLogImpl.log("   extension:" + object3.getUniqueIdentifier());
                if (string.equals(object3.getUniqueIdentifier())) {
                    IConfigurationElement[] iConfigurationElementArray = object3.getConfigurationElements();
                    DPLLogImpl.log("configElements.length : " + iConfigurationElementArray.length);
                    IConfigurationElement iConfigurationElement = iConfigurationElementArray[0];
                    iDatapoolIterator = (IDatapoolIterator)iConfigurationElement.createExecutableExtension("class");
                    DPLLogImpl.log("iterator: " + iDatapoolIterator.toString());
                    clazz = iDatapoolIterator.getClass();
                    bl = true;
                    continue;
                }
                ++n;
            }
            if (!bl) {
                throw new DatapoolException("Datapool Iterator extension not found: " + string);
            }
        }
        catch (Throwable throwable) {
            try {
                clazz = Class.forName(string);
            }
            catch (Throwable throwable2) {
                throwable2.printStackTrace();
                throw new DatapoolException("Error while accessing iterator: " + string);
            }
        }
        try {
            object2 = clazz.getMethod("getInstance", new Class[0]);
            return (IDatapoolIterator)((Method)object2).invoke(null, new Object[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                object = clazz.getConstructor(new Class[0]);
                return (IDatapoolIterator)((Constructor)object).newInstance(new Object[0]);
            }
            catch (Throwable throwable) {
                throw new DatapoolException("Datapool Iterator " + string + " could not be opened: " + throwable.getMessage());
            }
        }
        catch (Throwable throwable) {
            throw new DatapoolException("Datapool Iterator " + string + " could not be opened: " + throwable.getMessage());
        }
    }

    public void close(IDatapoolIterator iDatapoolIterator) {
        try {
            Method method = iDatapoolIterator.getClass().getMethod("close", new Class[0]);
            method.invoke(null, new Object[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public IDatapoolSuggestedType createDatapoolSuggestedType() {
        return new DatapoolSuggestedTypeImpl();
    }

    public IDatapool constructDatapool() {
        DPLDatapoolImpl dPLDatapoolImpl = new DPLDatapoolImpl();
        DPLDatapoolSpecImpl dPLDatapoolSpecImpl = new DPLDatapoolSpecImpl();
        dPLDatapoolImpl.setDatapoolSpec(dPLDatapoolSpecImpl);
        return dPLDatapoolImpl;
    }
}

