/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.common.datapool.test;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.hyades.edit.datapool.IDatapool;
import org.eclipse.hyades.edit.datapool.IDatapoolEquivalenceClass;
import org.eclipse.hyades.edit.datapool.IDatapoolListener;
import org.eclipse.hyades.edit.datapool.IDatapoolRecord;
import org.eclipse.hyades.execution.runtime.datapool.IDatapoolCell;
import org.eclipse.hyades.execution.runtime.datapool.IDatapoolFactory;
import org.eclipse.hyades.execution.runtime.datapool.IDatapoolIterator;
import org.eclipse.hyades.execution.runtime.datapool.IDatapoolVariable;
import org.eclipse.hyades.models.common.datapool.impl.Common_DatapoolFactoryImpl;
import org.eclipse.hyades.models.common.datapool.impl.DPLDatapoolImpl;
import org.eclipse.hyades.models.common.datapool.impl.DPLLogImpl;

public class DatapoolAPITest
extends TestCase {
    IDatapoolListener lis = null;
    org.eclipse.hyades.edit.datapool.IDatapoolFactory editFactory = null;
    IDatapoolFactory runtimeFactory = null;
    IDatapool edp = null;
    org.eclipse.hyades.execution.runtime.datapool.IDatapool rdp = null;
    File testDpXmiFile;
    File testDpResFile;

    public DatapoolAPITest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite("Datapool API Test");
        testSuite.addTest((Test)new DatapoolAPITest("testDatapoolSetup"));
        testSuite.addTest((Test)new DatapoolAPITest("testIDatapoolFactoryEdit"));
        testSuite.addTest((Test)new DatapoolAPITest("testIDatapoolEdit"));
        testSuite.addTest((Test)new DatapoolAPITest("testIDatapoolEquivalenceClassEdit"));
        testSuite.addTest((Test)new DatapoolAPITest("testIDatapoolFactoryRuntime"));
        testSuite.addTest((Test)new DatapoolAPITest("testRuntimeAPIs"));
        return testSuite;
    }

    public void setUp() {
        this.lis = new IDatapoolListener(){

            public void variableAdded(IDatapool iDatapool, int n) {
                DPLLogImpl.log("***Listener: variableAdded: " + n);
            }

            public void variableRemoved(IDatapool iDatapool, int n) {
                DPLLogImpl.log("***Listener: variableRemoved: " + n);
            }

            public void variableMoved(IDatapool iDatapool, int n, int n2) {
                DPLLogImpl.log("***Listener: variableMoved: " + n + " " + n2);
            }

            public void variableChanged(IDatapool iDatapool, int n) {
                DPLLogImpl.log("***Listener: variableChanged: " + n);
            }

            public void variableChanged(IDatapool iDatapool, int n, String string) {
                DPLLogImpl.log("***Listener: variableChanged: " + n + " " + string);
            }

            public void recordAdded(IDatapool iDatapool, int n, int n2) {
                DPLLogImpl.log("***Listener: recordAdded: " + n + " " + n2);
            }

            public void recordRemoved(IDatapool iDatapool, int n, int n2) {
                DPLLogImpl.log("***Listener: recordRemoved: " + n + " " + n2);
            }

            public void recordMoved(IDatapool iDatapool, int n, int n2, int n3) {
                DPLLogImpl.log("***Listener: recordMoved: " + n + " " + n2 + " " + n3);
            }

            public void recordChanged(IDatapool iDatapool, int n, int n2) {
                DPLLogImpl.log("***Listener: recordMoved: " + n + " " + n2);
            }

            public void cellChanged(IDatapool iDatapool, int n, int n2, int n3) {
                DPLLogImpl.log("***Listener: cellChanged: " + n + " " + n2 + " " + n3);
            }

            public void equivalenceClassReordered(IDatapool iDatapool, int n) {
                DPLLogImpl.log("***Listener: equivalenceClassReordered");
            }

            public void equivalenceClassAdded(IDatapool iDatapool, int n) {
                DPLLogImpl.log("***Listener: equivalenceClassAdded: " + n);
            }

            public void equivalenceClassRemoved(IDatapool iDatapool, int n) {
                DPLLogImpl.log("***Listener: equivalenceClassRemoved: " + n);
            }

            public void equivalenceClassMoved(IDatapool iDatapool, int n, int n2) {
                DPLLogImpl.log("***Listener: equivalenceClassMoved: " + n + " " + n2);
            }

            public void equivalenceClassChanged(IDatapool iDatapool, int n) {
                DPLLogImpl.log("***Listener: equivalenceClassChanged: " + n);
            }

            public void equivalenceClassChanged(IDatapool iDatapool, int n, String string) {
                DPLLogImpl.log("***Listener: equivalenceClassChanged: " + n + " " + string);
            }

            public void save(IDatapool iDatapool) {
                DPLLogImpl.log("***Listener: datapoolSaved");
            }
        };
        this.editFactory = new Common_DatapoolFactoryImpl();
        this.runtimeFactory = new Common_DatapoolFactoryImpl();
        try {
            this.testDpXmiFile = File.createTempFile("testDatapool", ".xmi");
            this.testDpXmiFile.deleteOnExit();
            this.testDpResFile = File.createTempFile("testDatapool", ".datapool");
            this.testDpResFile.deleteOnExit();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void tearDown() {
    }

    public void testDatapoolSetup() {
        DPLLogImpl.log("\n########## Hello to Datapool Setup (edit) Test!");
        this.edp = this.editFactory.constructDatapool();
        this.edp.setName("DP1");
        this.edp.addDatapoolListener(this.lis);
        org.eclipse.hyades.edit.datapool.IDatapoolVariable iDatapoolVariable = this.edp.constructVariable();
        iDatapoolVariable.setName("LoginId");
        this.edp.appendVariable(iDatapoolVariable);
        org.eclipse.hyades.edit.datapool.IDatapoolVariable iDatapoolVariable2 = this.edp.constructVariable();
        iDatapoolVariable2.setName("Password");
        this.edp.appendVariable(iDatapoolVariable2);
        IDatapoolEquivalenceClass iDatapoolEquivalenceClass = this.edp.constructEquivalenceClass();
        iDatapoolEquivalenceClass.setName("EC1");
        this.edp.appendEquivalenceClass(iDatapoolEquivalenceClass);
        IDatapoolRecord iDatapoolRecord = iDatapoolEquivalenceClass.constructRecord(new Object[]{"<Literal>myLoginId</Literal>", "<Literal>myPassword</Literal>"});
        IDatapoolRecord iDatapoolRecord2 = iDatapoolEquivalenceClass.constructRecord(new Object[]{"<Literal>yourLoginId</Literal>", "<Literal>yourPassword</Literal>"});
        IDatapoolRecord iDatapoolRecord3 = iDatapoolEquivalenceClass.constructRecord(new Object[]{"<Literal>hisLoginId</Literal>", "<Literal>hisPassword</Literal>"});
        iDatapoolEquivalenceClass.appendRecord(iDatapoolRecord);
        iDatapoolEquivalenceClass.appendRecord(iDatapoolRecord2);
        iDatapoolEquivalenceClass.appendRecord(iDatapoolRecord3);
        ((DPLDatapoolImpl)this.edp).logDatapoolAsStrings();
        Assert.assertTrue((this.edp.getEquivalenceClassCount() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((this.edp.getEquivalenceClass(0).getRecordCount() == 3 ? 1 : 0) != 0);
        this.rdp = this.edp;
        DPLLogImpl.log("########## Bye from Datapool Setup (edit) Test!");
    }

    public void testIDatapoolFactoryEdit() {
        DPLLogImpl.log("\n########## Hello to IDatapoolFactory (edit) Test!");
        DPLLogImpl.setLoggingStatus(false);
        this.testDatapoolSetup();
        DPLLogImpl.setLoggingStatus(true);
        ((DPLDatapoolImpl)this.edp).logDatapoolAsStrings();
        this.editFactory.saveAs(this.edp, this.testDpXmiFile);
        try {
            int n;
            FileInputStream fileInputStream = new FileInputStream(this.testDpXmiFile);
            FileOutputStream fileOutputStream = new FileOutputStream(this.testDpResFile);
            ZipOutputStream zipOutputStream = new ZipOutputStream(fileOutputStream);
            ZipEntry zipEntry = new ZipEntry("ResourceContents");
            zipOutputStream.putNextEntry(zipEntry);
            byte[] byArray = new byte[10];
            while ((n = fileInputStream.read(byArray, 0, 10)) != -1) {
                zipOutputStream.write(byArray, 0, n);
            }
            zipOutputStream.close();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        this.edp = this.editFactory.loadForEdit(this.testDpResFile, false);
        ((DPLDatapoolImpl)this.edp).logDatapoolAsStrings();
        DPLLogImpl.log("########## bye from IDatapool (edit) Test!");
    }

    public void testIDatapoolEdit() {
        DPLLogImpl.log("\n########## Hello to IDatapool (edit) Test!");
        DPLLogImpl.setLoggingStatus(false);
        this.testDatapoolSetup();
        DPLLogImpl.setLoggingStatus(true);
        ((DPLDatapoolImpl)this.edp).logDatapoolAsStrings();
        org.eclipse.hyades.edit.datapool.IDatapoolVariable iDatapoolVariable = this.edp.constructVariable();
        iDatapoolVariable.setName("MachineName");
        this.edp.appendVariable(iDatapoolVariable);
        Assert.assertTrue((this.edp.getVariableCount() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.edp.getVariable(2).getName().equals("MachineName"));
        this.edp.moveVariable(1, 0);
        Assert.assertTrue((boolean)this.edp.getVariable(0).getName().equals("Password"));
        Assert.assertTrue((boolean)this.edp.getVariable(1).getName().equals("LoginId"));
        this.edp.removeVariable(2);
        Assert.assertTrue((this.edp.getVariableCount() == 2 ? 1 : 0) != 0);
        this.edp.updateVariable(iDatapoolVariable, 0);
        ((DPLDatapoolImpl)this.edp).logDatapoolAsStrings();
        Assert.assertTrue((boolean)this.edp.getVariable(0).getName().equals("MachineName"));
        DPLLogImpl.log("########## Bye from IDatapool (edit) Test!");
    }

    public void testIDatapoolEquivalenceClassEdit() {
        DPLLogImpl.log("\n########## Hello to IDatapoolEquivalenceClass (edit) Test!");
        DPLLogImpl.setLoggingStatus(false);
        this.testDatapoolSetup();
        DPLLogImpl.setLoggingStatus(true);
        IDatapoolEquivalenceClass iDatapoolEquivalenceClass = this.edp.constructEquivalenceClass();
        iDatapoolEquivalenceClass.setName("EC2");
        this.edp.appendEquivalenceClass(iDatapoolEquivalenceClass);
        IDatapoolRecord iDatapoolRecord = iDatapoolEquivalenceClass.constructRecord(new Object[]{"<ExcelData>LoginId1</ExcelData>", "<ExcelData>Password1</ExcelData>"});
        IDatapoolRecord iDatapoolRecord2 = iDatapoolEquivalenceClass.constructRecord(new Object[]{"<Literal>LoginId2</Literal>", "<Literal>Password2</Literal>"});
        IDatapoolRecord iDatapoolRecord3 = iDatapoolEquivalenceClass.constructRecord(new Object[]{"<Literal>LoginId3</Literal>", "<Literal>Password3</Literal>"});
        iDatapoolEquivalenceClass.appendRecord(iDatapoolRecord);
        iDatapoolEquivalenceClass.appendRecord(iDatapoolRecord2);
        iDatapoolEquivalenceClass.appendRecord(iDatapoolRecord3);
        ((DPLDatapoolImpl)this.edp).logDatapoolAsStrings();
        Assert.assertTrue((this.edp.getEquivalenceClassCount() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((this.edp.getEquivalenceClass(1).getRecordCount() == 3 ? 1 : 0) != 0);
        IDatapoolCell iDatapoolCell = this.rdp.getEquivalenceClass(1).getRecord(0).getCell("LoginId");
        Assert.assertTrue((boolean)iDatapoolCell.getCellVariable().getName().equals("LoginId"));
        Assert.assertTrue((boolean)iDatapoolCell.getStringValue().equals("LoginId1 (Excel)"));
        this.edp.moveEquivalenceClass(0, 1);
        Assert.assertTrue((boolean)this.edp.getEquivalenceClass(0).getName().equals("EC2"));
        Assert.assertTrue((boolean)this.edp.getEquivalenceClass(1).getName().equals("EC1"));
        this.edp.removeEquivalenceClass(1);
        Assert.assertTrue((this.edp.getEquivalenceClassCount() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.edp.getEquivalenceClass(0).getName().equals("EC2"));
        ((IDatapoolEquivalenceClass)this.edp.getEquivalenceClass(0)).reorder(new int[]{1, 0, 2});
        Assert.assertTrue((boolean)this.edp.getEquivalenceClass(0).getRecord(0).getCell("LoginId").getStringValue().equals("LoginId2"));
        DPLLogImpl.log("########## bye from IDatapoolEquivalenceClass (edit) Test!");
    }

    public void testIDatapoolFactoryRuntime() {
        DPLLogImpl.log("\n########## Hello to IDatapool (runtime) Test!");
        DPLLogImpl.setLoggingStatus(false);
        this.testIDatapoolFactoryEdit();
        DPLLogImpl.setLoggingStatus(true);
        this.rdp = this.runtimeFactory.load(this.testDpResFile, true);
        this.rdp = this.runtimeFactory.load(this.testDpResFile, true);
        this.rdp = this.runtimeFactory.load(this.testDpResFile, true);
        this.runtimeFactory.unload(this.rdp);
        this.runtimeFactory.unload(this.rdp);
        this.runtimeFactory.unload(this.rdp);
        this.rdp = this.runtimeFactory.load(this.testDpResFile, true);
        ((DPLDatapoolImpl)this.rdp).logDatapoolAsStrings();
        IDatapoolIterator iDatapoolIterator = this.runtimeFactory.open(this.rdp, "org.eclipse.hyades.datapool.iterator.DatapoolIteratorSequentialShared");
        iDatapoolIterator.dpInitialize(this.rdp, -1);
        DPLLogImpl.log("");
        while (!iDatapoolIterator.dpDone()) {
            DPLLogImpl.log("Iterator: " + iDatapoolIterator.dpString("LoginId"));
            iDatapoolIterator.dpNext();
        }
        this.runtimeFactory.close(iDatapoolIterator);
        DPLLogImpl.log("########## Bye from IDatapool (runtime) Test!");
    }

    public void testRuntimeAPIs() {
        DPLLogImpl.log("\n########## Hello to Runtime APIs Test!");
        DPLLogImpl.setLoggingStatus(false);
        this.testDatapoolSetup();
        DPLLogImpl.setLoggingStatus(true);
        IDatapoolCell iDatapoolCell = this.rdp.getEquivalenceClass(0).getRecord(0).getCell("LoginId");
        Assert.assertTrue((boolean)iDatapoolCell.getCellVariable().getName().equals("LoginId"));
        Assert.assertTrue((boolean)iDatapoolCell.getStringValue().equals("myLoginId"));
        int n = this.rdp.getVariableIndex("LoginId");
        IDatapoolVariable iDatapoolVariable = this.rdp.getVariable(n);
        Assert.assertTrue((n == 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)iDatapoolVariable.getName().equals("LoginId"));
        DPLLogImpl.log("########## Bye from Runtime APIs Test!");
    }
}

