/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.common.facades.behavioral.impl;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.hyades.models.common.facades.behavioral.impl.HyadesCommon_Behavior_FragmentsAdapterFactory;
import org.eclipse.hyades.models.common.facades.behavioral.impl.HyadesCommon_TestprofileAdapterFactory;
import org.eclipse.hyades.models.common.fragments.Common_Behavior_FragmentsPackage;
import org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage;
import org.eclipse.hyades.models.common.util.FileUtil;

public class FacadeResourceImpl
extends XMIResourceImpl {
    private File annotationDir = null;

    public FacadeResourceImpl() {
    }

    public FacadeResourceImpl(URI uRI) {
        super(uRI);
    }

    public void attached(EObject eObject) {
        AdapterFactoryImpl adapterFactoryImpl;
        super.attached(eObject);
        if (eObject.eClass().equals(Common_TestprofilePackage.eINSTANCE.getTPFTestSuite())) {
            adapterFactoryImpl = new HyadesCommon_TestprofileAdapterFactory();
            adapterFactoryImpl.adapt((Notifier)eObject, (Object)Common_TestprofilePackage.eINSTANCE.getTPFTestSuite());
        }
        if (eObject.eClass().equals(Common_Behavior_FragmentsPackage.eINSTANCE.getBVRInteraction())) {
            adapterFactoryImpl = new HyadesCommon_Behavior_FragmentsAdapterFactory();
            adapterFactoryImpl.adapt((Notifier)eObject, (Object)Common_Behavior_FragmentsPackage.eINSTANCE.getBVRInteraction());
        }
        if (eObject.eClass().equals(Common_Behavior_FragmentsPackage.eINSTANCE.getBVRInteractionOperand())) {
            adapterFactoryImpl = new HyadesCommon_Behavior_FragmentsAdapterFactory();
            adapterFactoryImpl.adapt((Notifier)eObject, (Object)Common_Behavior_FragmentsPackage.eINSTANCE.getBVRInteractionOperand());
        }
    }

    public void detached(EObject eObject) {
        super.detached(eObject);
        eObject.eAdapters().clear();
    }

    public void doLoad(InputStream inputStream, Map map) throws IOException {
        if (inputStream instanceof ZipInputStream) {
            Object object;
            Object object2;
            int n;
            ZipInputStream zipInputStream = (ZipInputStream)inputStream;
            File file = File.createTempFile("tempResouce", "");
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            int n2 = 65536;
            byte[] byArray = new byte[n2];
            while ((n = zipInputStream.read(byArray, 0, n2)) != -1) {
                bufferedOutputStream.write(byArray, 0, n);
            }
            bufferedOutputStream.close();
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            if (zipEntry != null) {
                object2 = URI.createFileURI((String)this.getAnnotationDir().getAbsolutePath());
                while (zipEntry != null) {
                    object = zipEntry.getName();
                    URI uRI = URI.createURI((String)object);
                    URI uRI2 = uRI.resolve(object2);
                    File file2 = new File(uRI2.toFileString());
                    if (!file2.getParentFile().exists()) {
                        file2.getParentFile().mkdirs();
                    }
                    fileOutputStream = new FileOutputStream(uRI2.toFileString());
                    bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
                    while ((n = zipInputStream.read(byArray, 0, n2)) != -1) {
                        bufferedOutputStream.write(byArray, 0, n);
                    }
                    bufferedOutputStream.close();
                    zipEntry = zipInputStream.getNextEntry();
                }
            }
            object2 = new FileInputStream(file);
            object = new BufferedInputStream((InputStream)object2);
            super.doLoad((InputStream)object, map);
            ((BufferedInputStream)object).close();
            file.delete();
        } else {
            super.doLoad(inputStream, map);
        }
    }

    public void doSave(OutputStream outputStream, Map map) throws IOException {
        super.doSave(outputStream, map);
        if (this.hasAnnotations() && outputStream instanceof ZipOutputStream) {
            ZipOutputStream zipOutputStream = (ZipOutputStream)outputStream;
            File file = this.getAnnotationDir();
            URI uRI = URI.createFileURI((String)file.getAbsolutePath());
            File[] fileArray = FileUtil.listAllFiles(file);
            if (fileArray == null) {
                return;
            }
            int n = 0;
            while (n < fileArray.length) {
                int n2;
                URI uRI2 = URI.createFileURI((String)fileArray[n].getAbsolutePath());
                URI uRI3 = uRI2.deresolve(uRI);
                FileInputStream fileInputStream = new FileInputStream(fileArray[n]);
                ZipEntry zipEntry = new ZipEntry(uRI3.toString());
                zipEntry.setMethod(0);
                zipEntry.setSize(fileArray[n].length());
                CRC32 cRC32 = new CRC32();
                BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
                int n3 = 65536;
                byte[] byArray = new byte[n3];
                while ((n2 = bufferedInputStream.read(byArray, 0, n3)) != -1) {
                    cRC32.update(byArray, 0, n2);
                }
                bufferedInputStream.close();
                zipEntry.setCrc(cRC32.getValue());
                zipOutputStream.putNextEntry(zipEntry);
                fileInputStream = new FileInputStream(fileArray[n]);
                bufferedInputStream = new BufferedInputStream(fileInputStream);
                while ((n2 = bufferedInputStream.read(byArray, 0, n3)) != -1) {
                    zipOutputStream.write(byArray, 0, n2);
                }
                zipOutputStream.closeEntry();
                bufferedInputStream.close();
                ++n;
            }
        }
    }

    public boolean hasAnnotations() {
        return this.annotationDir != null;
    }

    public synchronized File getAnnotationDir() throws IOException {
        if (this.annotationDir != null) {
            return this.annotationDir;
        }
        File file = FileUtil.getTempDir();
        File file2 = File.createTempFile("Hyades.TestModel.AnnotationDir", "", file);
        if (file2.delete() && file2.mkdir()) {
            this.annotationDir = new File(file2, "annotations");
            if (!this.annotationDir.mkdir()) {
                throw new IOException("Unable to create new annotation Dir " + this.annotationDir.getAbsolutePath());
            }
        } else {
            throw new IOException("Unable to create new annotation Dir " + file2.getAbsolutePath());
        }
        return this.annotationDir;
    }

    protected void finalize() throws Throwable {
        this.cleanupAnnotationDir();
        super.finalize();
    }

    private void cleanupAnnotationDir() {
        if (this.hasAnnotations()) {
            FileUtil.deltree(this.annotationDir.getParentFile());
        }
    }

    protected void doUnload() {
        super.doUnload();
        this.cleanupAnnotationDir();
    }
}

