/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.actions;

import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.internal.execution.local.common.CustomCommand;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCCollectionMode;
import org.eclipse.hyades.models.hierarchy.TRCConfiguration;
import org.eclipse.hyades.models.hierarchy.TRCOption;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.actions.AbstractListenerActionDelegate;
import org.eclipse.hyades.trace.ui.internal.util.PDCoreUtil;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class CollectObjRefActionDelegate
extends AbstractListenerActionDelegate {
    public void run(TRCAgentProxy tRCAgentProxy, INavigator iNavigator) {
        block6: {
            if (tRCAgentProxy == null) {
                return;
            }
            if (!tRCAgentProxy.isMonitored()) {
                MessageDialog.openInformation((Shell)UIPlugin.getActiveWorkbenchShell(), (String)UIPlugin.getResourceString("TRACE_MSG"), (String)UIPlugin.getResourceString("COLLECT_OBJ_REF_INFO_"));
                return;
            }
            if (!tRCAgentProxy.getType().equals("Profiler")) break block6;
            TRCProcessProxy tRCProcessProxy = tRCAgentProxy.getProcessProxy();
            String string = tRCProcessProxy.getNode().getName();
            try {
                Node node = PDCoreUtil.profileConnect(string, String.valueOf(tRCProcessProxy.getNode().getPort()));
                if (node == null) {
                    return;
                }
                Object object = LoadersUtils.locateAgentInstance((TRCAgentProxy)tRCAgentProxy);
                if (object != null && object instanceof Agent) {
                    Agent agent = (Agent)object;
                    CustomCommand customCommand = new CustomCommand();
                    customCommand.setData("ANALYSEHEAP");
                    agent.invokeCustomCommand(customCommand);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    protected boolean isEnabledFor(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof TRCAgentProxy) {
            TRCAgentProxy tRCAgentProxy = (TRCAgentProxy)object;
            return tRCAgentProxy.getType().equals("Profiler") && tRCAgentProxy.isMonitored() && this.collectInstanceInformation(tRCAgentProxy);
        }
        if (object instanceof TRCProcessProxy) {
            EList eList = ((TRCProcessProxy)object).getAgentProxies();
            int n = 0;
            while (n < eList.size()) {
                TRCAgentProxy tRCAgentProxy = (TRCAgentProxy)eList.get(n);
                if (!tRCAgentProxy.eIsProxy() && tRCAgentProxy.getType().equals("Profiler") && tRCAgentProxy.isMonitored() && this.collectInstanceInformation(tRCAgentProxy)) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    public void doAction(Object object) throws Exception {
        if (object == null || !(object instanceof TRCAgentProxy) && !(object instanceof TRCProcessProxy)) {
            return;
        }
        INavigator iNavigator = (INavigator)this.getView();
        if (iNavigator == null) {
            MessageDialog.openInformation((Shell)UIPlugin.getActiveWorkbenchShell(), (String)"title", (String)"Action not available in current context");
            return;
        }
        TRCAgentProxy tRCAgentProxy = null;
        if (object instanceof TRCAgentProxy) {
            tRCAgentProxy = (TRCAgentProxy)object;
        } else if (object instanceof TRCProcessProxy) {
            EList eList = ((TRCProcessProxy)object).getAgentProxies();
            int n = 0;
            while (n < eList.size()) {
                TRCAgentProxy tRCAgentProxy2 = (TRCAgentProxy)eList.get(n);
                if (!tRCAgentProxy2.eIsProxy() && tRCAgentProxy2.getType().equals("Profiler")) {
                    tRCAgentProxy = tRCAgentProxy2;
                }
                ++n;
            }
        }
        this.run(tRCAgentProxy, iNavigator);
    }

    private boolean collectInstanceInformation(TRCAgentProxy tRCAgentProxy) {
        TRCConfiguration tRCConfiguration;
        EList eList;
        TRCCollectionMode tRCCollectionMode = tRCAgentProxy.getCollectionMode();
        if (tRCCollectionMode == TRCCollectionMode.EXECUTION_STATISTICS_ONLY_LITERAL) {
            return false;
        }
        Iterator iterator = tRCAgentProxy.getConfigurations().iterator();
        if (iterator.hasNext() && (eList = (tRCConfiguration = (TRCConfiguration)iterator.next()).getOptions()) != null) {
            Iterator iterator2 = eList.iterator();
            while (iterator2.hasNext()) {
                TRCOption tRCOption = (TRCOption)iterator2.next();
                if (!tRCOption.getKey().equals("TRACE_MODE") || !tRCOption.getValue().equals("noObjectCorrelation")) continue;
                return false;
            }
        }
        return true;
    }

    public void dispose() {
        super.dispose();
    }
}

