/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.core;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.internal.ui.PDPluginImages;
import org.eclipse.hyades.trace.internal.ui.TraceConstants;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.AbstractChangeable;
import org.eclipse.hyades.trace.ui.internal.util.FilterElementModifier;
import org.eclipse.hyades.trace.ui.internal.util.FilterList;
import org.eclipse.hyades.trace.ui.internal.util.FilterListContentProvider;
import org.eclipse.hyades.trace.ui.internal.util.FilterListLabelProvider;
import org.eclipse.hyades.trace.ui.internal.util.FilterSetElement;
import org.eclipse.hyades.trace.ui.internal.util.FilterTableElement;
import org.eclipse.hyades.ui.internal.util.XMLUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IBasicPropertyConstants;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.WorkbenchHelp;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TraceProfileFiltersUI
extends AbstractChangeable
implements SelectionListener,
ICheckStateListener {
    private Composite _result;
    protected FilterList _filterList;
    protected FilterSetList _filterSetList;
    private Button _upBtn;
    private Button _downBtn;
    private Button _addBtn;
    private Button _editBtn;
    private Button _removeBtn;
    protected Table _table;
    protected CheckboxTableViewer _tableViewer;
    private static String[] tableColumnProperties = new String[]{"string", "method", "combo"};
    private Table _filterSetTable;
    private CheckboxTableViewer _filterSetTableViewer;
    private Button _addSetBtn;
    private Button _editSetBtn;
    private Button _removeSetBtn;
    private Label _contentLabel;
    private FilterSetElement _oldSelection;
    private String activeFS;
    private boolean agentTerminated = false;
    private static final String OPEN_FILTERS_TAG = "<filters>";
    private static final String CLOSE_FILTERS_TAG = "</filters>";
    private static final String OPEN_FILTER_TAG = "<filter";
    private static final String CLOSE_FILTER_TAG = "</filter>";
    private static final String FILTER_NAME_ATTRIBUTE = "name";
    private static final String FILTER_ENABLED_ATTRIBUTE = "enabled";
    private static final String OPEN_CONTENTS_TAG = "<contents>";
    private static final String CLOSE_CONTENTS_TAG = "</contents>";
    private static final String OPEN_CONTENT_TAG = "<content";
    private static final String CLOSE_CONTENT_TAG = "/>";
    private static final String CONTENT_TEXT_ATTRIBUTE = "text";
    private static final String CONTENT_METHOD_ATTRIBUTE = "method";
    private static final String CONTENT_VISIBILITY_ATTRIBUTE = "visibility";

    private void createColumns() {
        TableLayout tableLayout = new TableLayout();
        this._table.setLayout((Layout)tableLayout);
        this._table.setHeaderVisible(true);
        String[] stringArray = new String[]{UIPlugin.getResourceString("HEADER_FILTER"), UIPlugin.getResourceString("HEADER_METHOD"), UIPlugin.getResourceString("HEADER_VISIBILITY")};
        ColumnLayoutData[] columnLayoutDataArray = new ColumnLayoutData[]{new ColumnPixelData(120, true), new ColumnPixelData(110, true), new ColumnPixelData(70, true)};
        TableColumn[] tableColumnArray = new TableColumn[stringArray.length];
        boolean bl = false;
        int n = 0;
        while (n < stringArray.length) {
            tableLayout.addColumnData(columnLayoutDataArray[n]);
            TableColumn tableColumn = new TableColumn(this._table, 0, n);
            tableColumn.setResizable(columnLayoutDataArray[n].resizable);
            tableColumn.setText(stringArray[n]);
            tableColumnArray[n] = tableColumn;
            ++n;
        }
    }

    public Composite createControl(Composite composite) {
        this._result = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.verticalSpacing = 0;
        this._result.setLayout((Layout)gridLayout);
        GridData gridData = GridUtil.createFill();
        this._result.setLayoutData((Object)gridData);
        this.createFilterSet(this._result);
        this.createFilterContents(this._result);
        Label label = new Label(this._result, 0);
        label.setText(UIPlugin.getResourceString("STR_FILTER_NOTE"));
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        return this._result;
    }

    private void createFilterContents(Composite composite) {
        Label label = new Label(composite, 0);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        this._contentLabel = new Label(composite, 0);
        this._contentLabel.setText(UIPlugin.getResourceString("STR_FILTER_CONTENTS"));
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        this._contentLabel.setLayoutData((Object)gridData);
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        composite2.setLayout((Layout)gridLayout);
        gridData = GridUtil.createFill();
        gridData.heightHint = 180;
        composite2.setLayoutData((Object)gridData);
        this.initializeTable(composite2);
        Composite composite3 = new Composite(composite, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        composite3.setLayout((Layout)gridLayout);
        composite3.setLayoutData((Object)GridUtil.createVerticalFill());
        Composite composite4 = new Composite(composite3, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.makeColumnsEqualWidth = true;
        composite4.setLayout((Layout)gridLayout);
        composite4.setLayoutData((Object)GridUtil.createVerticalFill());
        this._addBtn = new Button(composite4, 8);
        this._addBtn.setText(UIPlugin.getResourceString("ADD_FILTER_TEXT1"));
        this._addBtn.setToolTipText(UIPlugin.getResourceString("ADD_FILTER_TOOLTIP_TEXT"));
        this._addBtn.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._editBtn = new Button(composite4, 8);
        this._editBtn.setText(UIPlugin.getResourceString("STR_EDIT_FILTER_BTN1"));
        this._editBtn.setToolTipText(UIPlugin.getResourceString("EDIT_FILTER_TOOLTIP_TEXT"));
        this._editBtn.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._removeBtn = new Button(composite4, 8);
        this._removeBtn.setText(UIPlugin.getResourceString("REMOVE_TEXT1"));
        this._removeBtn.setToolTipText(UIPlugin.getResourceString("REMOVE_TOOLTIP_TEXT"));
        this._removeBtn.setLayoutData((Object)GridUtil.createHorizontalFill());
        Composite composite5 = new Composite(composite3, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.makeColumnsEqualWidth = true;
        composite5.setLayout((Layout)gridLayout);
        composite5.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._upBtn = new Button(composite5, 8);
        this._upBtn.setText(UIPlugin.getResourceString("MOVEUP_TEXT"));
        this._upBtn.setToolTipText(UIPlugin.getResourceString("MOVEUP_TOOLTIP_TEXT"));
        this._upBtn.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._downBtn = new Button(composite5, 8);
        this._downBtn.setText(UIPlugin.getResourceString("MOVEDOWN_TEXT"));
        this._downBtn.setToolTipText(UIPlugin.getResourceString("MOVEDOWN_TOOLTIP_TEXT"));
        this._downBtn.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._editBtn.setEnabled(false);
        this._removeBtn.setEnabled(false);
        this._upBtn.setEnabled(false);
        this._downBtn.setEnabled(false);
        this._removeBtn.addSelectionListener((SelectionListener)this);
        this._upBtn.addSelectionListener((SelectionListener)this);
        this._downBtn.addSelectionListener((SelectionListener)this);
        this._addBtn.addSelectionListener((SelectionListener)this);
        this._editBtn.addSelectionListener((SelectionListener)this);
        this._table.addSelectionListener((SelectionListener)this);
        WorkbenchHelp.setHelp((Control)this._table, (String)(UIPlugin.getPluginId() + ".pfpp0002"));
    }

    private void createFilterSet(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText(UIPlugin.getResourceString("STR_SELECT_FILTER_SET"));
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        composite2.setLayout((Layout)gridLayout);
        gridData = GridUtil.createFill();
        gridData.heightHint = 100;
        composite2.setLayoutData((Object)gridData);
        this._filterSetTable = new Table(composite2, 68132);
        this._filterSetTable.setLinesVisible(false);
        this._filterSetTable.setLayoutData((Object)GridUtil.createFill());
        this._filterSetTableViewer = new CheckboxTableViewer(this._filterSetTable);
        this._filterSetTableViewer.setContentProvider((IContentProvider)new FilterSetContentProvider(this._filterSetTableViewer));
        this._filterSetTableViewer.setLabelProvider((IBaseLabelProvider)new FilterSetLabelProvider());
        this._filterSetList = new FilterSetList((TableViewer)this._filterSetTableViewer);
        this._filterSetTableViewer.setInput((Object)this._filterSetList);
        this._filterSetTableViewer.addCheckStateListener((ICheckStateListener)this);
        TableLayout tableLayout = new TableLayout();
        this._filterSetTable.setLayout((Layout)tableLayout);
        ColumnPixelData columnPixelData = new ColumnPixelData(420, true);
        tableLayout.addColumnData((ColumnLayoutData)columnPixelData);
        TableColumn tableColumn = new TableColumn(this._filterSetTable, 0, 0);
        tableColumn.setResizable(columnPixelData.resizable);
        Composite composite3 = new Composite(composite, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        composite3.setLayout((Layout)gridLayout);
        composite3.setLayoutData((Object)GridUtil.createVerticalFill());
        Composite composite4 = new Composite(composite3, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.makeColumnsEqualWidth = true;
        composite4.setLayout((Layout)gridLayout);
        composite4.setLayoutData((Object)GridUtil.createVerticalFill());
        this._addSetBtn = new Button(composite4, 8);
        this._addSetBtn.setText(UIPlugin.getResourceString("ADD_FILTER_TEXT"));
        this._addSetBtn.setToolTipText(UIPlugin.getResourceString("ADD_FILTER_TOOLTIP_TEXT"));
        this._addSetBtn.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._editSetBtn = new Button(composite4, 8);
        this._editSetBtn.setText(UIPlugin.getResourceString("STR_EDIT_SET_BTN"));
        this._editSetBtn.setToolTipText(UIPlugin.getResourceString("EDIT_SET_TOOLTIP_TEXT"));
        this._editSetBtn.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._removeSetBtn = new Button(composite4, 8);
        this._removeSetBtn.setText(UIPlugin.getResourceString("REMOVE_TEXT"));
        this._removeSetBtn.setToolTipText(UIPlugin.getResourceString("REMOVE_TOOLTIP_TEXT"));
        this._removeSetBtn.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._editSetBtn.setEnabled(false);
        this._removeSetBtn.setEnabled(false);
        this._removeSetBtn.addSelectionListener((SelectionListener)this);
        this._addSetBtn.addSelectionListener((SelectionListener)this);
        this._editSetBtn.addSelectionListener((SelectionListener)this);
        this._filterSetTable.addSelectionListener((SelectionListener)this);
        WorkbenchHelp.setHelp((Control)this._filterSetTable, (String)(UIPlugin.getPluginId() + ".pfps0001"));
    }

    private void createTable(Composite composite) {
        this._table = new Table(composite, 68354);
        this._table.setLinesVisible(true);
        this._table.setLayoutData((Object)GridUtil.createFill());
    }

    public void enable(boolean bl) {
        this._addSetBtn.setEnabled(bl);
        this._removeSetBtn.setEnabled(bl);
        this._editSetBtn.setEnabled(bl);
        this._filterSetTable.setEnabled(bl);
        this._filterSetTableViewer.getTable().setEnabled(bl);
        this._addBtn.setEnabled(bl);
        this._removeBtn.setEnabled(bl);
        this._editBtn.setEnabled(bl);
        this._upBtn.setEnabled(bl);
        this._downBtn.setEnabled(bl);
        if (!bl) {
            this._tableViewer.setCellEditors(null);
            this._tableViewer.setCellModifier(null);
        }
    }

    protected void enableButtons() {
        if (this.isAgentTerminated()) {
            this.enable(false);
            return;
        }
        int n = this._table.getSelectionIndex();
        int n2 = this._table.getSelectionCount();
        this._removeBtn.setEnabled(this._filterList.getSize() > 0 && n != -1);
        this._editBtn.setEnabled(this._filterList.getSize() > 0 && n != -1);
        this._upBtn.setEnabled(n > 0 && n2 == 1);
        this._downBtn.setEnabled(n >= 0 && n < this._table.getItemCount() - 1 && n2 == 1);
        n = this._filterSetTable.getSelectionIndex();
        this._removeSetBtn.setEnabled(this._filterSetList.getSize() > 1 && n != -1);
        this._editSetBtn.setEnabled(this._filterSetList.getSize() > 0 && n != -1);
    }

    public ArrayList getFilterSet() {
        if (this._oldSelection != null) {
            this._oldSelection.setChildren((ArrayList)this._filterList.getFilters().clone());
        }
        this.validateFilterSet(this._filterSetList);
        return this._filterSetList.getFilters();
    }

    public static String getFilterSet(ArrayList arrayList) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < arrayList.size()) {
            stringBuffer.append(OPEN_FILTER_TAG);
            FilterSetElement filterSetElement = (FilterSetElement)arrayList.get(n);
            stringBuffer.append(" name = '" + filterSetElement.getName() + "'>");
            ArrayList arrayList2 = filterSetElement.getChildren();
            stringBuffer.append(OPEN_CONTENTS_TAG);
            int n2 = 0;
            while (n2 < arrayList2.size()) {
                stringBuffer.append(OPEN_CONTENT_TAG);
                FilterTableElement filterTableElement = (FilterTableElement)arrayList2.get(n2);
                stringBuffer.append(" text = '" + filterTableElement.getText() + "'");
                stringBuffer.append(" method = '" + filterTableElement.getMethod() + "'");
                stringBuffer.append(" visibility = '" + filterTableElement.getVisibility() + "'");
                stringBuffer.append(CLOSE_CONTENT_TAG);
                ++n2;
            }
            stringBuffer.append(CLOSE_CONTENTS_TAG);
            stringBuffer.append(CLOSE_FILTER_TAG);
            ++n;
        }
        return stringBuffer.toString();
    }

    private void validateFilterSet(FilterSetList filterSetList) {
        boolean bl = true;
        ArrayList arrayList = filterSetList.getFilters();
        int n = 0;
        while (n < arrayList.size()) {
            FilterSetElement filterSetElement = (FilterSetElement)arrayList.get(n);
            ArrayList arrayList2 = filterSetElement.getChildren();
            boolean bl2 = true;
            int n2 = 0;
            while (n2 < arrayList2.size()) {
                FilterTableElement filterTableElement = (FilterTableElement)arrayList2.get(n2);
                if (filterTableElement.getVisibility().equals(UIPlugin.getResourceString("STR_EXCLUDE"))) {
                    bl2 = false;
                    break;
                }
                if (filterTableElement.getText().equals("*")) {
                    bl2 = false;
                    break;
                }
                ++n2;
            }
            if (arrayList2.size() > 0 && bl2) {
                arrayList2.add(new FilterTableElement("*", "*", UIPlugin.getResourceString("STR_EXCLUDE")));
                filterSetElement.setChildren(arrayList2);
            }
            ++n;
        }
    }

    protected void initializeTable(Composite composite) {
        this.createTable(composite);
        this._tableViewer = new CheckboxTableViewer(this._table);
        this.createColumns();
        this._tableViewer.setContentProvider((IContentProvider)new FilterListContentProvider(this._tableViewer));
        this._tableViewer.setLabelProvider((IBaseLabelProvider)new FilterListLabelProvider());
        this._filterList = new FilterList((TableViewer)this._tableViewer);
        this._tableViewer.setInput((Object)this._filterList);
        CellEditor[] cellEditorArray = new CellEditor[this._table.getColumnCount()];
        cellEditorArray[0] = new TextCellEditor((Composite)this._table);
        cellEditorArray[1] = new TextCellEditor((Composite)this._table);
        cellEditorArray[2] = new ComboBoxCellEditor((Composite)this._table, FilterTableElement.getVisibilityStates());
        this._tableViewer.setCellEditors(cellEditorArray);
        FilterElementModifier filterElementModifier = new FilterElementModifier(this._tableViewer);
        this._tableViewer.setCellModifier((ICellModifier)filterElementModifier);
        this._tableViewer.setColumnProperties(tableColumnProperties);
    }

    public static ArrayList getFiltersSet(String string) {
        Element element = XMLUtil.loadDom((String)string, (String)"filters");
        return TraceProfileFiltersUI.getFiltersSet(element);
    }

    public static ArrayList getFiltersSet(Element element) {
        ArrayList<FilterSetElement> arrayList = new ArrayList<FilterSetElement>();
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Element element2 = (Element)nodeList.item(n);
            FilterSetElement filterSetElement = new FilterSetElement(element2.getAttribute(FILTER_NAME_ATTRIBUTE));
            ArrayList arrayList2 = TraceProfileFiltersUI.getFilter(element2);
            filterSetElement.setChildren(arrayList2);
            arrayList.add(filterSetElement);
            ++n;
        }
        return arrayList;
    }

    private void setXMLFilterSet(Element element) {
        ArrayList arrayList = TraceProfileFiltersUI.getFiltersSet(element);
        int n = 0;
        while (n < arrayList.size()) {
            this.addFilterSet((FilterSetElement)arrayList.get(n));
            ++n;
        }
        this.selectTableItem(this._filterSetTable, 0);
    }

    public void setFilterSet(String string) {
        Element element = XMLUtil.loadDom((String)string, (String)"filters");
        this.setXMLFilterSet(element);
    }

    public void setFilterSet(Element element) {
        this.setXMLFilterSet(element);
    }

    private void addFilterSet(String string, ArrayList arrayList) {
        FilterSetElement filterSetElement = new FilterSetElement(string);
        this.addFilterSet(filterSetElement);
    }

    public void addFilterSet(FilterSetElement filterSetElement) {
        this._filterSetList.add(filterSetElement);
        this._filterSetTableViewer.refresh();
        this._filterSetTableViewer.setChecked((Object)filterSetElement, false);
    }

    public void reset() {
        this.activeFS = null;
        this._oldSelection = null;
        this._table.removeAll();
        this._filterList.removeAll();
        this._filterSetList.removeAll();
        this._filterSetTableViewer.refresh();
    }

    protected void selectTableItem(Table table, int n) {
        table.setFocus();
        table.setSelection(n);
        table.showSelection();
        if (table == this._filterSetTable) {
            this.showFiltersForSelection((FilterSetElement)this._filterSetList.getElementAt(n));
        }
    }

    private void showFiltersForSelection(FilterSetElement filterSetElement) {
        if (this._oldSelection != null) {
            this._oldSelection.setChildren((ArrayList)this._filterList.getFilters().clone());
        }
        this._table.setRedraw(false);
        this._filterList.removeAll();
        ArrayList arrayList = filterSetElement.getChildren();
        int n = 0;
        while (n < arrayList.size()) {
            FilterTableElement filterTableElement = (FilterTableElement)arrayList.get(n);
            filterTableElement.setParent(this._filterList);
            this._filterList.add(filterTableElement, this._filterList.getSize());
            this._tableViewer.refresh();
            ++n;
        }
        this._tableViewer.refresh();
        this._oldSelection = filterSetElement;
        this._table.setRedraw(true);
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        if (selectionEvent.widget == this._addSetBtn) {
            this.showWSetDialog(UIPlugin.getResourceString("STR_ADD_SET_DLG"), null);
            this.enableButtons();
            return;
        }
        if (selectionEvent.widget == this._editSetBtn) {
            int n = this._filterSetTable.getSelectionIndex();
            if (n != -1) {
                this.showWSetDialog(UIPlugin.getResourceString("STR_EDIT_SET_DLG"), this._filterSetTable.getItem(n).getText());
            }
            return;
        }
        if (selectionEvent.widget == this._removeSetBtn) {
            int n = this._filterSetTable.getSelectionIndex();
            if (n != -1) {
                boolean bl = false;
                if (this._filterSetTable.getItem(n).getChecked()) {
                    bl = true;
                }
                this._filterSetList.removeElementAt(n);
                if (bl) {
                    FilterSetElement filterSetElement = (FilterSetElement)this._filterSetList.getElementAt(0);
                    this.activeFS = filterSetElement.getName();
                    this._filterSetTableViewer.setChecked((Object)filterSetElement, true);
                }
                this._filterSetTableViewer.refresh();
                this.selectTableItem(this._filterSetTable, 0);
            }
            this.enableButtons();
            return;
        }
        if (selectionEvent.widget == this._addBtn) {
            this.showEditDialog(UIPlugin.getResourceString("STR_ADD_FILTER_DLG"), null, "*", null);
            this.enableButtons();
        } else if (selectionEvent.widget == this._editBtn) {
            int n = this._table.getSelectionIndex();
            if (n != -1) {
                FilterTableElement filterTableElement = (FilterTableElement)this._filterList.getElementAt(n);
                String string = filterTableElement.getText();
                String string2 = filterTableElement.getMethod();
                String string3 = filterTableElement.getVisibility();
                this.showEditDialog(UIPlugin.getResourceString("STR_EDIT_FILTER_DLG"), string, string2, string3);
            }
        } else {
            if (selectionEvent.widget == this._table) {
                this.enableButtons();
                return;
            }
            if (selectionEvent.widget == this._filterSetTable) {
                int n = this._filterSetTable.getSelectionIndex();
                if (n != -1) {
                    FilterSetElement filterSetElement = (FilterSetElement)this._filterSetList.getElementAt(n);
                    this.showFiltersForSelection(filterSetElement);
                    this._filterSetTableViewer.setChecked((Object)filterSetElement, true);
                    this.activeFS = filterSetElement.getName();
                    int n2 = 0;
                    while (n2 < this._filterSetList.getSize()) {
                        if (n2 != n) {
                            FilterSetElement filterSetElement2 = (FilterSetElement)this._filterSetList.getElementAt(n2);
                            this._filterSetTableViewer.setChecked((Object)filterSetElement2, false);
                        }
                        ++n2;
                    }
                    this._filterSetTableViewer.refresh();
                }
                this.enableButtons();
                return;
            }
            if (selectionEvent.widget == this._removeBtn) {
                int n = this._table.getSelectionIndex();
                this._filterList.removeElements(this._table.getSelectionIndices());
                this._tableViewer.refresh();
                int n3 = this._filterList.getSize();
                if (n3 > 0) {
                    if (n > 0 && n < n3) {
                        this.selectTableItem(this._table, n - 1);
                    } else {
                        this.selectTableItem(this._table, 0);
                    }
                }
                this.enableButtons();
            } else if (selectionEvent.widget == this._upBtn) {
                this._tableViewer.refresh();
                int n = this._table.getSelectionIndex();
                if (n > 0) {
                    FilterTableElement filterTableElement = (FilterTableElement)this._filterList.getElementAt(n);
                    FilterTableElement filterTableElement2 = (FilterTableElement)this._filterList.getElementAt(n - 1);
                    String string = filterTableElement.getText();
                    String string4 = filterTableElement.getMethod();
                    String string5 = filterTableElement.getVisibility();
                    filterTableElement.setText(filterTableElement2.getText());
                    filterTableElement.setMethod(filterTableElement2.getMethod());
                    filterTableElement2.setText(string);
                    filterTableElement2.setMethod(string4);
                    filterTableElement.setVisibility(filterTableElement2.getVisibility());
                    filterTableElement2.setVisibility(string5);
                    this.selectTableItem(this._table, n - 1);
                }
                this._tableViewer.refresh();
                this.enableButtons();
            } else if (selectionEvent.widget == this._downBtn) {
                this._tableViewer.refresh();
                int n = this._table.getSelectionIndex();
                if (n < this._table.getItemCount() - 1) {
                    FilterTableElement filterTableElement = (FilterTableElement)this._filterList.getElementAt(n);
                    FilterTableElement filterTableElement3 = (FilterTableElement)this._filterList.getElementAt(n + 1);
                    String string = filterTableElement.getText();
                    String string6 = filterTableElement.getMethod();
                    String string7 = filterTableElement.getVisibility();
                    filterTableElement.setText(filterTableElement3.getText());
                    filterTableElement.setMethod(filterTableElement3.getMethod());
                    filterTableElement3.setText(string);
                    filterTableElement3.setMethod(string6);
                    filterTableElement.setVisibility(filterTableElement3.getVisibility());
                    filterTableElement3.setVisibility(string7);
                    this.selectTableItem(this._table, n + 1);
                }
                this._tableViewer.refresh();
                this.enableButtons();
            }
        }
    }

    private void showEditDialog(String string, String string2, String string3, String string4) {
        EditDialog editDialog = new EditDialog(this._result.getShell(), string, string2, string3, string4);
        editDialog.open();
        if (editDialog.getReturnCode() == 0) {
            if (string2 == null) {
                FilterTableElement filterTableElement = new FilterTableElement(editDialog.clas(), editDialog.method(), editDialog.rule());
                if (editDialog.rule().equals(UIPlugin.getResourceString("STR_EXCLUDE"))) {
                    this._filterList.add(filterTableElement, this._filterList.getSize());
                } else {
                    this._filterList.add(filterTableElement, 0);
                }
                filterTableElement.setParent(this._filterList);
                this._tableViewer.refresh();
                if (editDialog.rule().equals(UIPlugin.getResourceString("STR_EXCLUDE"))) {
                    this.selectTableItem(this._table, this._filterList.getSize() - 1);
                } else {
                    this.selectTableItem(this._table, 0);
                }
            } else {
                int n = this._table.getSelectionIndex();
                if (n != -1) {
                    FilterTableElement filterTableElement = (FilterTableElement)this._filterList.getElementAt(n);
                    filterTableElement.setText(editDialog.clas());
                    filterTableElement.setMethod(editDialog.method());
                    filterTableElement.setVisibility(editDialog.rule());
                    this._tableViewer.refresh();
                }
            }
        }
    }

    private void showWSetDialog(String string, String string2) {
        EditWSetDialog editWSetDialog = new EditWSetDialog(this._result.getShell(), string, string2);
        editWSetDialog.open();
        if (editWSetDialog.getReturnCode() == 0) {
            if (string2 == null) {
                FilterSetElement filterSetElement;
                int n = 0;
                while (n < this._filterSetList.getSize()) {
                    filterSetElement = (FilterSetElement)this._filterSetList.getElementAt(n);
                    if (filterSetElement.getName().equals(editWSetDialog._name)) {
                        this.selectTableItem(this._filterSetTable, n);
                        return;
                    }
                    ++n;
                }
                filterSetElement = new FilterSetElement(editWSetDialog._name);
                String string3 = TraceConstants.DEFAULT_FILTER_SET;
                Element element = XMLUtil.loadDom((String)string3, (String)"filters");
                ArrayList arrayList = TraceProfileFiltersUI.getFiltersSet(element);
                if (arrayList.size() > 0) {
                    FilterSetElement filterSetElement2 = (FilterSetElement)arrayList.get(0);
                    filterSetElement.setChildren((ArrayList)filterSetElement2.getChildren().clone());
                }
                this.addFilterSet(filterSetElement);
                this.selectTableItem(this._filterSetTable, 0);
            } else {
                int n = this._filterSetTable.getSelectionIndex();
                if (n != -1) {
                    ((FilterSetElement)this._filterSetList.getElementAt(n)).setName(editWSetDialog._name);
                }
                this._filterSetTableViewer.refresh((Object)((FilterSetElement)this._filterSetList.getElementAt(n)));
            }
        }
    }

    private static ArrayList getFilter(Element element) {
        ArrayList<FilterTableElement> arrayList = new ArrayList<FilterTableElement>();
        Element element2 = (Element)element.getFirstChild();
        NodeList nodeList = element2.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Element element3 = (Element)nodeList.item(n);
            FilterTableElement filterTableElement = element3.getAttribute(CONTENT_VISIBILITY_ATTRIBUTE).equals("0") || element3.getAttribute(CONTENT_VISIBILITY_ATTRIBUTE).equals("EXCLUDE") ? new FilterTableElement(element3.getAttribute(CONTENT_TEXT_ATTRIBUTE), element3.getAttribute(CONTENT_METHOD_ATTRIBUTE), "EXCLUDE") : new FilterTableElement(element3.getAttribute(CONTENT_TEXT_ATTRIBUTE), element3.getAttribute(CONTENT_METHOD_ATTRIBUTE), "INCLUDE");
            arrayList.add(filterTableElement);
            ++n;
        }
        return arrayList;
    }

    private static void getFilter(FilterSetElement filterSetElement, String string) {
        Object object;
        String string2;
        String string3;
        String string4;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = string.indexOf("#");
        while (n != -1) {
            string4 = string.substring(0, n);
            string = string.substring(n + 1);
            n = string4.indexOf("!");
            string3 = string4.substring(0, n);
            string4 = string4.substring(n + 1);
            n = string4.indexOf("!");
            string2 = string4.substring(0, n);
            object = (string4 = string4.substring(n + 1)).equals("0") ? UIPlugin.getResourceString("STR_EXCLUDE") : UIPlugin.getResourceString("STR_INCLUDE");
            FilterTableElement filterTableElement = new FilterTableElement(string3, string2, (String)object);
            arrayList.add(filterTableElement);
            n = string.indexOf("#");
        }
        if (!string.equals("")) {
            n = string.indexOf("!");
            string4 = string.substring(0, n);
            string = string.substring(n + 1);
            n = string.indexOf("!");
            string3 = string.substring(0, n);
            string2 = (string = string.substring(n + 1)).equals("0") ? UIPlugin.getResourceString("STR_EXCLUDE") : UIPlugin.getResourceString("STR_INCLUDE");
            object = new FilterTableElement(string4, string3, string2);
            arrayList.add(object);
        }
        filterSetElement.setChildren(arrayList);
    }

    public void checkStateChanged(CheckStateChangedEvent checkStateChangedEvent) {
        FilterSetElement filterSetElement = (FilterSetElement)checkStateChangedEvent.getElement();
        int n = 0;
        while (n < this._filterSetList.getSize()) {
            FilterSetElement filterSetElement2 = (FilterSetElement)this._filterSetList.getElementAt(n);
            if (filterSetElement2 == filterSetElement && this._filterSetTableViewer.getChecked((Object)filterSetElement2)) {
                this._filterSetTable.setSelection(n);
            }
            ++n;
        }
        this._filterSetTableViewer.refresh();
    }

    public static void storeValues(ArrayList arrayList) {
        String string = "";
        IPreferenceStore iPreferenceStore = UIPlugin.getDefault().getPreferenceStore();
        iPreferenceStore.setValue("set_filters", OPEN_FILTERS_TAG + TraceProfileFiltersUI.getFilterSet(arrayList) + CLOSE_FILTERS_TAG);
    }

    public boolean isAgentTerminated() {
        return this.agentTerminated;
    }

    public void setAgentTerminated(boolean bl) {
        this.agentTerminated = bl;
    }

    public void removeFilterSet(int n) {
        if (n < 0 || n > this._filterSetList.getSize()) {
            return;
        }
        this._filterSetList.removeElementAt(n);
    }

    public void alterFilterSetChildren(FilterSetElement filterSetElement, ArrayList arrayList) {
        filterSetElement.setChildren(arrayList);
    }

    public String getActiveFilterSet() {
        return this.activeFS;
    }

    public void setActiveFilterSet(FilterSetElement filterSetElement) {
        this.activeFS = filterSetElement.getName();
        this._filterSetTableViewer.setChecked((Object)filterSetElement, true);
        this._filterSetTableViewer.setSelection((ISelection)new StructuredSelection((Object)filterSetElement));
        this.showFiltersForSelection(filterSetElement);
        this._filterSetTableViewer.refresh();
    }

    public void addFilterSets(FilterSetElement[] filterSetElementArray) {
        int n = 0;
        while (n < filterSetElementArray.length) {
            this.addFilterSet(filterSetElementArray[n]);
            ++n;
        }
    }

    class EditWSetDialog
    extends Dialog
    implements ModifyListener {
        private String _name;
        private Text _nameText;
        private String _title;

        public EditWSetDialog(Shell shell, String string, String string2) {
            super(shell);
            this._name = string2;
            this._title = string;
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            shell.setText(this._title);
        }

        protected Control createDialogArea(Composite composite) {
            Composite composite2 = (Composite)super.createDialogArea(composite);
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 2;
            composite2.setLayout((Layout)gridLayout);
            GridData gridData = GridUtil.createFill();
            gridData.widthHint = 400;
            composite2.setLayoutData((Object)gridData);
            Label label = new Label(composite2, 0);
            label.setText(UIPlugin.getResourceString("STR_FILTER_SET_NAME"));
            this._nameText = new Text(composite2, 2048);
            this._nameText.setLayoutData((Object)GridUtil.createHorizontalFill());
            this._nameText.addModifyListener((ModifyListener)this);
            if (this._name != null) {
                this._nameText.setText(this._name);
            }
            return composite2;
        }

        public void modifyText(ModifyEvent modifyEvent) {
            if (modifyEvent.widget == this._nameText && this.getButton(0) != null) {
                this.getButton(0).setEnabled(this._nameText.getText().trim() != "");
            }
        }

        protected void okPressed() {
            this._name = this._nameText.getText().trim();
            super.okPressed();
        }
    }

    class EditDialog
    extends Dialog
    implements ModifyListener {
        private String _class = "mypackage.*";
        private String _method;
        private String _rule;
        private Text _classText;
        private Text _methodText;
        private Combo _ruleText;
        private String _title;

        public EditDialog(Shell shell, String string, String string2, String string3, String string4) {
            super(shell);
            if (string2 != null) {
                this._class = string2;
            }
            this._method = string3;
            this._rule = string4;
            this._title = string;
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            shell.setText(this._title);
        }

        public void clas(String string) {
            this._class = string;
        }

        public String clas() {
            return this._class;
        }

        public void method(String string) {
            this._method = string;
        }

        public String method() {
            return this._method;
        }

        public void rule(String string) {
            this._rule = string;
        }

        public String rule() {
            return this._rule;
        }

        protected Control createDialogArea(Composite composite) {
            Composite composite2 = (Composite)super.createDialogArea(composite);
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 2;
            composite2.setLayout((Layout)gridLayout);
            GridData gridData = GridUtil.createFill();
            gridData.widthHint = 400;
            composite2.setLayoutData((Object)gridData);
            Label label = new Label(composite2, 0);
            label.setText(UIPlugin.getResourceString("HEADER_FILTER"));
            this._classText = new Text(composite2, 2048);
            this._classText.setLayoutData((Object)GridUtil.createHorizontalFill());
            label = new Label(composite2, 0);
            label.setText(UIPlugin.getResourceString("HEADER_METHOD"));
            this._methodText = new Text(composite2, 2048);
            this._methodText.setLayoutData((Object)GridUtil.createHorizontalFill());
            label = new Label(composite2, 0);
            label.setText(UIPlugin.getResourceString("HEADER_VISIBILITY"));
            this._ruleText = new Combo(composite2, 2056);
            this._ruleText.setLayoutData((Object)GridUtil.createHorizontalFill());
            this._ruleText.add(UIPlugin.getResourceString("STR_EXCLUDE"));
            this._ruleText.add(UIPlugin.getResourceString("STR_INCLUDE"));
            this._classText.addModifyListener((ModifyListener)this);
            this._methodText.addModifyListener((ModifyListener)this);
            this._ruleText.select(1);
            if (this._class != null) {
                this._classText.setText(this._class);
            }
            if (this._method != null) {
                this._methodText.setText(this._method);
            }
            if (this._rule != null) {
                this._ruleText.setText(this._rule);
            }
            this._classText.setFocus();
            this._classText.selectAll();
            return composite2;
        }

        public void modifyText(ModifyEvent modifyEvent) {
            if ((modifyEvent.widget == this._classText || modifyEvent.widget == this._methodText) && this.getButton(0) != null) {
                this.getButton(0).setEnabled(this._classText.getText().trim() != "" || this._methodText.getText().trim() != "");
            }
        }

        protected void okPressed() {
            this._class = this._classText.getText().trim();
            this._method = this._methodText.getText().trim();
            this._rule = this._ruleText.getText();
            super.okPressed();
        }
    }

    public class FilterSetList
    implements IBasicPropertyConstants {
        ArrayList filters = new ArrayList();
        TableViewer fViewer;
        private ArrayList listeners;

        public FilterSetList(TableViewer tableViewer) {
            this.fViewer = tableViewer;
        }

        public void add(FilterSetElement filterSetElement) {
            this.add(filterSetElement, -1);
        }

        public void add(FilterSetElement filterSetElement, int n) {
            if (n < 0) {
                this.filters.add(filterSetElement);
            } else {
                this.filters.add(n, filterSetElement);
            }
        }

        public void addElementChangedListener(FilterSetContentProvider filterSetContentProvider) {
            if (filterSetContentProvider == null) {
                return;
            }
            if (this.listeners == null) {
                this.listeners = new ArrayList();
            }
            if (!this.listeners.contains(filterSetContentProvider)) {
                this.listeners.add(filterSetContentProvider);
            }
        }

        public Object[] elements() {
            return this.filters.toArray();
        }

        public void fireElementChanged(FilterSetElement filterSetElement, String string) {
            if (this.listeners != null) {
                Iterator iterator = this.listeners.iterator();
                while (iterator.hasNext()) {
                    FilterSetContentProvider filterSetContentProvider = (FilterSetContentProvider)iterator.next();
                    filterSetContentProvider.elementChanged(filterSetElement, string);
                }
            }
        }

        public Object getElementAt(int n) {
            return this.filters.get(n);
        }

        public ArrayList getFilters() {
            return (ArrayList)this.filters.clone();
        }

        public int getSize() {
            return this.filters.size();
        }

        public void removeAll() {
            this.filters.clear();
        }

        public Object removeElementAt(int n) {
            Object e = this.filters.get(n);
            if (e == null) {
                return null;
            }
            this.filters.remove(e);
            return e;
        }

        public void removeElementChangedListener(FilterSetContentProvider filterSetContentProvider) {
            if (this.listeners != null) {
                this.listeners.remove(filterSetContentProvider);
            }
        }

        public Object[] uiElements() {
            return this.filters.toArray();
        }
    }

    class FilterSetContentProvider
    implements IStructuredContentProvider {
        private CheckboxTableViewer fViewer;
        protected FilterSetElement fChangedElement;

        public FilterSetContentProvider(CheckboxTableViewer checkboxTableViewer) {
            this.fViewer = checkboxTableViewer;
        }

        public void dispose() {
        }

        public void elementChanged(FilterSetElement filterSetElement, String string) {
            this.fChangedElement = filterSetElement;
            this.fViewer.getControl().getDisplay().asyncExec(new Runnable(this){
                private final /* synthetic */ FilterSetContentProvider this$1;
                {
                    this.this$1 = filterSetContentProvider;
                }

                public void run() {
                    FilterSetContentProvider.access$000(this.this$1).refresh((Object)this.this$1.fChangedElement);
                }
            });
        }

        public Object[] getElements(Object object) {
            return ((FilterSetList)object).elements();
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
            this.fViewer = (CheckboxTableViewer)viewer;
            if (object != null && object instanceof FilterList) {
                ((FilterSetList)object).removeElementChangedListener(this);
            }
            if (object2 != null && object2 instanceof FilterList) {
                ((FilterSetList)object2).addElementChangedListener(this);
            }
        }

        public boolean isDeleted(Object object) {
            return false;
        }

        static /* synthetic */ CheckboxTableViewer access$000(FilterSetContentProvider filterSetContentProvider) {
            return filterSetContentProvider.fViewer;
        }
    }

    public class FilterSetLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        public Image getColumnImage(Object object, int n) {
            return PDPluginImages.getImage("filter_obj.gif");
        }

        public Image getColumnImage(Viewer viewer, Object object, int n) {
            return PDPluginImages.getImage("filter_obj.gif");
        }

        public String getColumnText(Object object, int n) {
            return ((FilterSetElement)object).getName();
        }

        public String getColumnText(Viewer viewer, Object object, int n) {
            return ((FilterSetElement)object).getName();
        }
    }
}

