/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.internal.ui.PDPluginImages;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.TraceProfileTypeGroupUI;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfileFiltersTab;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfileTab;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfilingSet;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfilingSetType;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfilingSetsManager;
import org.eclipse.hyades.trace.ui.internal.util.AbstractChangeable;
import org.eclipse.hyades.trace.ui.internal.util.FilterSetElement;
import org.eclipse.hyades.trace.ui.internal.util.ProfilingList;
import org.eclipse.hyades.trace.ui.launcher.IProfilingSet;
import org.eclipse.hyades.trace.ui.launcher.IProfilingSetType;
import org.eclipse.hyades.trace.ui.launcher.IProfilingSetTypeGroup;
import org.eclipse.hyades.trace.ui.launcher.ProfilingAttribute;
import org.eclipse.hyades.trace.ui.launcher.ProfilingSetsManagerCopy;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IBasicPropertyConstants;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.WorkbenchHelp;

public class TraceProfileOverviewUI
extends AbstractChangeable
implements SelectionListener,
ICheckStateListener {
    private Composite _result;
    protected ArrayList _profilingList;
    protected ProfilingSetList _profilingSetList;
    private Button _editBtn;
    protected Table _table;
    protected CheckboxTableViewer _tableViewer;
    private Table _profilingSetTable;
    private CheckboxTableViewer _profilingSetTableViewer;
    private Button _addSetBtn;
    private Button _renameSetBtn;
    private Button _removeSetBtn;
    private Label _contentLabel;
    private Label profilingSetLabel;
    private ProfileTab parentTab;
    private ProfilingSetsManagerCopy managerCopy;
    private Listener _listener = new Listener(){

        public void handleEvent(Event event) {
            TraceProfileOverviewUI.this.changed();
        }
    };

    public TraceProfileOverviewUI(ProfileTab profileTab) {
        this.parentTab = profileTab;
    }

    private void createColumns() {
        TableLayout tableLayout = new TableLayout();
        this._table.setLayout((Layout)tableLayout);
        this._table.setHeaderVisible(true);
        String[] stringArray = new String[]{UIPlugin.getResourceString("HEADER_PROFILING_TYPE")};
        ColumnLayoutData[] columnLayoutDataArray = new ColumnLayoutData[]{new ColumnPixelData(300, true)};
        TableColumn[] tableColumnArray = new TableColumn[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            tableLayout.addColumnData(columnLayoutDataArray[n]);
            TableColumn tableColumn = new TableColumn(this._table, 0, n);
            tableColumn.setResizable(columnLayoutDataArray[n].resizable);
            tableColumn.setText(stringArray[n]);
            tableColumnArray[n] = tableColumn;
            ++n;
        }
    }

    public Composite createControl(Composite composite) {
        this._result = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.verticalSpacing = 0;
        this._result.setLayout((Layout)gridLayout);
        GridData gridData = GridUtil.createFill();
        this._result.setLayoutData((Object)gridData);
        this.createProfilingSetGroup(this._result);
        this.createprofilingContents(this._result);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        return this._result;
    }

    private void createprofilingContents(Composite composite) {
        Label label = new Label(composite, 0);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        this._contentLabel = new Label(composite, 0);
        this._contentLabel.setText(UIPlugin.getResourceString("STR_MODIFY_PROFILINGSET_CONTENTS"));
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        this._contentLabel.setLayoutData((Object)gridData);
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        composite2.setLayout((Layout)gridLayout);
        gridData = GridUtil.createFill();
        gridData.heightHint = 180;
        composite2.setLayoutData((Object)gridData);
        this.initializeTypesTable(composite2);
        Composite composite3 = new Composite(composite, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        composite3.setLayout((Layout)gridLayout);
        composite3.setLayoutData((Object)GridUtil.createVerticalFill());
        Composite composite4 = new Composite(composite3, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.makeColumnsEqualWidth = true;
        composite4.setLayout((Layout)gridLayout);
        composite4.setLayoutData((Object)GridUtil.createVerticalFill());
        this._editBtn = new Button(composite4, 8);
        this._editBtn.setText(UIPlugin.getResourceString("EDIT_PROFILINGSETCONTENTS_TEXT"));
        this._editBtn.setToolTipText(UIPlugin.getResourceString("EDIT_FILTER_TOOLTIP_TEXT"));
        this._editBtn.setLayoutData((Object)GridUtil.createHorizontalFill());
        Composite composite5 = new Composite(composite3, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.makeColumnsEqualWidth = true;
        composite5.setLayout((Layout)gridLayout);
        composite5.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._editBtn.setEnabled(false);
        label = new Label(composite, 0);
        label.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._editBtn.addSelectionListener((SelectionListener)this);
        this._table.addSelectionListener((SelectionListener)this);
        WorkbenchHelp.setHelp((Control)this._table, (String)(UIPlugin.getPluginId() + ".pfpp0002"));
    }

    private void createProfilingSetGroup(Composite composite) {
        IProfilingSet iProfilingSet;
        Label label = new Label(composite, 0);
        label.setText(UIPlugin.getResourceString("STR_SELECT_PROFILING_SET"));
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        composite2.setLayout((Layout)gridLayout);
        gridData = GridUtil.createFill();
        gridData.heightHint = 100;
        composite2.setLayoutData((Object)gridData);
        this._profilingSetTable = new Table(composite2, 68132);
        this._profilingSetTable.setLinesVisible(false);
        this._profilingSetTable.setLayoutData((Object)GridUtil.createFill());
        this._profilingSetTableViewer = new CheckboxTableViewer(this._profilingSetTable);
        this._profilingSetTableViewer.setContentProvider((IContentProvider)new ProfilingSetContentProvider(this._profilingSetTableViewer));
        this._profilingSetTableViewer.setLabelProvider((IBaseLabelProvider)new ProfilingSetLabelProvider());
        this._profilingSetList = new ProfilingSetList((TableViewer)this._profilingSetTableViewer);
        Object[] objectArray = this.order(this.getManagerCopy().getProfilingSets().values().toArray());
        int n = 0;
        while (n < objectArray.length) {
            iProfilingSet = (IProfilingSet)objectArray[n];
            this._profilingSetList.add(iProfilingSet);
            ++n;
        }
        this._profilingSetTableViewer.setInput((Object)this._profilingSetList);
        this._profilingSetTableViewer.addCheckStateListener((ICheckStateListener)this);
        iProfilingSet = new TableLayout();
        this._profilingSetTable.setLayout((Layout)iProfilingSet);
        ColumnPixelData columnPixelData = new ColumnPixelData(420, true);
        iProfilingSet.addColumnData((ColumnLayoutData)columnPixelData);
        TableColumn tableColumn = new TableColumn(this._profilingSetTable, 0, 0);
        tableColumn.setResizable(columnPixelData.resizable);
        Composite composite3 = new Composite(composite, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        composite3.setLayout((Layout)gridLayout);
        composite3.setLayoutData((Object)GridUtil.createVerticalFill());
        Composite composite4 = new Composite(composite3, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.makeColumnsEqualWidth = true;
        composite4.setLayout((Layout)gridLayout);
        composite4.setLayoutData((Object)GridUtil.createVerticalFill());
        this._addSetBtn = new Button(composite4, 8);
        this._addSetBtn.setText(UIPlugin.getResourceString("ADD_PROFILINGSET_TEXT"));
        this._addSetBtn.setToolTipText(UIPlugin.getResourceString("ADD_FILTER_TOOLTIP_TEXT"));
        this._addSetBtn.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._renameSetBtn = new Button(composite4, 8);
        this._renameSetBtn.setText(UIPlugin.getResourceString("RENAME_PROFILINGSET_TEXT"));
        this._renameSetBtn.setToolTipText(UIPlugin.getResourceString("EDIT_SET_TOOLTIP_TEXT"));
        this._renameSetBtn.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._removeSetBtn = new Button(composite4, 8);
        this._removeSetBtn.setText(UIPlugin.getResourceString("REMOVE_PROFILINGSET_TEXT"));
        this._removeSetBtn.setToolTipText(UIPlugin.getResourceString("REMOVE_TOOLTIP_TEXT"));
        this._removeSetBtn.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._renameSetBtn.setEnabled(false);
        this._removeSetBtn.setEnabled(false);
        this._removeSetBtn.addSelectionListener((SelectionListener)this);
        this._addSetBtn.addSelectionListener((SelectionListener)this);
        this._renameSetBtn.addSelectionListener((SelectionListener)this);
        this._profilingSetTable.addSelectionListener((SelectionListener)this);
        WorkbenchHelp.setHelp((Control)this._profilingSetTable, (String)(UIPlugin.getPluginId() + ".pfps0001"));
        this.profilingSetLabel = new Label(composite, 64);
        gridData = new GridData();
        gridData.widthHint = 375;
        this.profilingSetLabel.setLayoutData((Object)gridData);
    }

    private Object[] order(Object[] objectArray) {
        int n = 0;
        IProfilingSet iProfilingSet = null;
        Object[] objectArray2 = new Object[objectArray.length];
        IProfilingSet iProfilingSet2 = this.getManagerCopy().getDefaultSet();
        iProfilingSet = (IProfilingSet)objectArray[0];
        if (iProfilingSet.getName().equals(iProfilingSet2.getName())) {
            return objectArray;
        }
        objectArray2[n] = iProfilingSet2;
        int n2 = 0;
        while (n2 < objectArray.length) {
            iProfilingSet = (IProfilingSet)objectArray[n2];
            if (iProfilingSet.getId() != iProfilingSet2.getId()) {
                objectArray2[++n] = iProfilingSet;
            }
            ++n2;
        }
        return objectArray2;
    }

    private void createTable(Composite composite) {
        this._table = new Table(composite, 68354);
        this._table.setLinesVisible(false);
        this._table.setLayoutData((Object)GridUtil.createFill());
    }

    public void enable(boolean bl) {
        this._addSetBtn.setEnabled(bl);
        this._removeSetBtn.setEnabled(bl);
        this._renameSetBtn.setEnabled(bl);
        this._profilingSetTable.setEnabled(bl);
        this._profilingSetTableViewer.getTable().setEnabled(bl);
        this._editBtn.setEnabled(bl);
        if (!bl) {
            this._tableViewer.setCellEditors(null);
            this._tableViewer.setCellModifier(null);
        }
    }

    protected void enableButtons() {
        int n = this._table.getSelectionIndex();
        int n2 = this._table.getSelectionCount();
        n = this._profilingSetTable.getSelectionIndex();
        this._removeSetBtn.setEnabled(this._profilingSetList.getSize() > 1 && n != -1);
        this._renameSetBtn.setEnabled(this._profilingSetList.getSize() > 0 && n != -1);
        this._editBtn.setEnabled(this._profilingSetList.getSize() > 0 && n != -1);
        if (n != -1) {
            IProfilingSet iProfilingSet = (IProfilingSet)this._profilingSetList.getElementAt(n);
            this.profilingSetLabel.setText(iProfilingSet.getDescription());
        } else {
            this.profilingSetLabel.setText("");
        }
    }

    protected void initializeTypesTable(Composite composite) {
        this.createTable(composite);
        this._tableViewer = new CheckboxTableViewer(this._table);
        this.createColumns();
        this._tableViewer.setContentProvider((IContentProvider)new ListContentProvider());
        this._tableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this._profilingList = new ArrayList();
        this._tableViewer.setInput((Object)this._profilingList);
    }

    public void reset() {
        this._table.removeAll();
        this._profilingList.clear();
        this._profilingSetList.removeAll();
        this._profilingSetTableViewer.refresh();
    }

    protected void selectTableItem(Table table, int n) {
        table.setFocus();
        int n2 = 0;
        while (n2 < table.getItemCount()) {
            table.getItem(n2).setChecked(n2 == n);
            ++n2;
        }
        table.setSelection(n);
        table.showSelection();
        if (table == this._profilingSetTable) {
            this.showProfilingTypeDetails((IProfilingSet)this._profilingSetList.getElementAt(n));
        }
        this.enableButtons();
    }

    private void showProfilingTypeDetails(IProfilingSet iProfilingSet) {
        this._profilingList.clear();
        List list = iProfilingSet.getProfilingTypes();
        int n = 0;
        while (n < list.size()) {
            String string = list.get(n).toString();
            IProfilingSetType iProfilingSetType = (IProfilingSetType)this.managerCopy.getProfilingTypes().get(string);
            if (iProfilingSetType != null) {
                boolean bl;
                iProfilingSetType.setDescription(iProfilingSetType.getProfilingType().getDescription(this.managerCopy));
                boolean bl2 = bl = iProfilingSetType.getDescription() != null && iProfilingSetType.getDescription().length() > 0;
                if (bl) {
                    if (n != 0) {
                        this._profilingList.add("");
                    }
                    this._profilingList.add(iProfilingSetType.getName());
                    this.addDescription(this._profilingList, iProfilingSetType.getDescription());
                    this._profilingList.add("");
                } else {
                    this._profilingList.add(iProfilingSetType.getName());
                }
            }
            ++n;
        }
        this._tableViewer.refresh();
    }

    private void addDescription(ArrayList arrayList, String string) {
        String string2 = "\n";
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2, false);
        while (stringTokenizer.hasMoreElements()) {
            String string3 = stringTokenizer.nextToken();
            arrayList.add(string3);
        }
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        if (selectionEvent.widget == this._addSetBtn) {
            this.showWSetDialog(UIPlugin.getResourceString("STR_ADD_PROFILINGSET_DLG"), null, null, null);
            this.enableButtons();
            return;
        }
        if (selectionEvent.widget == this._renameSetBtn) {
            this.renameProfilingSet();
        } else if (selectionEvent.widget == this._removeSetBtn) {
            int n = this._profilingSetTable.getSelectionIndex();
            if (n != -1) {
                this.removeProfilingSet(n);
            }
        } else if (selectionEvent.widget == this._editBtn) {
            int n = this._profilingSetTable.getSelectionIndex();
            if (n != -1) {
                IProfilingSet iProfilingSet = (IProfilingSet)this._profilingSetList.getElementAt(n);
                String string = iProfilingSet.getName();
                this.showEditDialog(UIPlugin.getResourceString("STR_EDIT_PROFILINGSET_DLG"), string, " ");
                this.showProfilingTypeDetails(iProfilingSet);
            }
        } else if (selectionEvent.widget == this._table) {
            this.enableButtons();
        } else if (selectionEvent.widget == this._profilingSetTable) {
            int n = this._profilingSetTable.getSelectionIndex();
            if (n != -1) {
                IProfilingSet iProfilingSet = (IProfilingSet)this._profilingSetList.getElementAt(n);
                this.managerCopy.setDefaultSet(iProfilingSet);
                this.showProfilingTypeDetails(iProfilingSet);
                this._profilingSetTableViewer.setChecked((Object)iProfilingSet, true);
                int n2 = 0;
                while (n2 < this._profilingSetList.getSize()) {
                    if (n2 != n) {
                        IProfilingSet iProfilingSet2 = (IProfilingSet)this._profilingSetList.getElementAt(n2);
                        this._profilingSetTableViewer.setChecked((Object)iProfilingSet2, false);
                    }
                    ++n2;
                }
                this._profilingSetTableViewer.refresh();
            }
            this.enableButtons();
            this.changed();
            return;
        }
    }

    private void showEditDialog(String string, String string2, String string3) {
        EditWizard editWizard = new EditWizard(string2, this.getManagerCopy());
        EditWizardDialog editWizardDialog = new EditWizardDialog(new Shell(Display.getDefault()), (IWizard)editWizard);
        editWizard.init(PlatformUI.getWorkbench(), null);
        editWizard.setParent(string2);
        editWizard.setWindowTitle(string);
        editWizardDialog.create();
        editWizardDialog.open();
    }

    private void showWSetDialog(String string, String string2, String string3, String string4) {
        EditWSetDialog editWSetDialog = new EditWSetDialog(this._result.getShell(), string, string2, string3, string4);
        editWSetDialog.open();
        if (editWSetDialog.getReturnCode() == 0) {
            this._profilingSetTableViewer.refresh();
            int n = 0;
            while (n < this._profilingSetList.getSize()) {
                IProfilingSet iProfilingSet = (IProfilingSet)this._profilingSetList.getElementAt(n);
                if (iProfilingSet.getName().equals(editWSetDialog._name)) {
                    this.selectTableItem(this._profilingSetTable, n);
                    this.showProfilingTypeDetails(iProfilingSet);
                    ProfilingSetsManager profilingSetsManager = ProfilingSetsManager.instance();
                    IProfilingSet iProfilingSet2 = (IProfilingSet)profilingSetsManager.getProfilingSets().get(iProfilingSet.getId());
                    if (iProfilingSet2 == null) {
                        profilingSetsManager.getProfilingSets().put(iProfilingSet.getId(), iProfilingSet);
                    } else {
                        iProfilingSet2.setName(iProfilingSet.getName());
                    }
                    profilingSetsManager.writeSetsToPreferences();
                    this.changed();
                    break;
                }
                ++n;
            }
        }
    }

    public void checkStateChanged(CheckStateChangedEvent checkStateChangedEvent) {
        IProfilingSet iProfilingSet = (IProfilingSet)checkStateChangedEvent.getElement();
        boolean bl = true;
        int n = 0;
        while (n < this._profilingSetList.getSize()) {
            IProfilingSet iProfilingSet2 = (IProfilingSet)this._profilingSetList.getElementAt(n);
            if (iProfilingSet2 == iProfilingSet) {
                if (this._profilingSetTableViewer.getChecked((Object)iProfilingSet2)) {
                    this._profilingSetTable.setSelection(n);
                }
            } else {
                this._profilingSetTableViewer.setChecked((Object)iProfilingSet2, bl);
            }
            ++n;
        }
        this._profilingSetTableViewer.refresh();
        this.managerCopy.setDefaultSet(iProfilingSet);
    }

    protected void renameProfilingSet() {
        int n = this._profilingSetTable.getSelectionIndex();
        if (n != -1) {
            IProfilingSet iProfilingSet = (IProfilingSet)this._profilingSetList.getElementAt(n);
            this.showWSetDialog(UIPlugin.getResourceString("STR_EDIT_PROFILINGSET_DLG"), iProfilingSet.getName(), iProfilingSet.getDescription(), iProfilingSet.getId());
            this._profilingSetTable.getItem(n).setText(iProfilingSet.getName());
            this.profilingSetLabel.setText(iProfilingSet.getDescription());
            this.showProfilingTypeDetails(iProfilingSet);
            this.changed();
        }
    }

    protected void removeProfilingSet(int n) {
        boolean bl = false;
        if (this._profilingSetTable.getItem(n).getChecked()) {
            bl = true;
        }
        IProfilingSet iProfilingSet = (IProfilingSet)this._profilingSetList.getElementAt(n);
        this._profilingSetList.removeElementAt(n);
        if (bl) {
            this.setDefaultProfilingSet(true);
        } else {
            this.refreshProfilingSetTable(0);
        }
        ProfilingSetsManager profilingSetsManager = ProfilingSetsManager.instance();
        profilingSetsManager.getProfilingSets().remove(iProfilingSet.getId());
    }

    private void setDefaultProfilingSet(boolean bl) {
        int n = -1;
        n = 0;
        while (n < this._profilingSetList.getprofilings().size()) {
            IProfilingSet iProfilingSet = (IProfilingSet)this._profilingSetList.getElementAt(n);
            if (iProfilingSet.getId().equals(this.managerCopy.getDefaultProfilingSet()) || n == this._profilingSetList.getprofilings().size() - 1) {
                this._profilingSetTableViewer.setChecked((Object)iProfilingSet, true);
                if (!bl) break;
                if (iProfilingSet.getId().equals(this.managerCopy.getDefaultProfilingSet())) {
                    this.refreshProfilingSetTable(n);
                    break;
                }
                this.refreshProfilingSetTable(0);
                break;
            }
            ++n;
        }
    }

    private void refreshProfilingSetTable(int n) {
        this._profilingSetTableViewer.refresh();
        this.selectTableItem(this._profilingSetTable, n);
        this.showProfilingTypeDetails((IProfilingSet)this._profilingSetList.getElementAt(n));
        this.enableButtons();
        this.managerCopy.setDefaultSet((IProfilingSet)this._profilingSetList.getElementAt(this._profilingSetTable.getSelectionIndex()));
        this.changed();
        this._profilingSetTableViewer.refresh();
    }

    public void initializeFrom(ILaunchConfiguration iLaunchConfiguration) {
        this.getManagerCopy().initializeFrom(iLaunchConfiguration);
        int n = -1;
        IProfilingSet iProfilingSet = this.getManagerCopy().getDefaultSet();
        if (iProfilingSet != null) {
            int n2 = 0;
            while (n2 < this._profilingSetList.getSize()) {
                if (((IProfilingSet)this._profilingSetList.getElementAt(n2)).getId().equals(iProfilingSet.getId())) {
                    n = n2;
                    break;
                }
                ++n2;
            }
        }
        if (n != -1) {
            this.selectTableItem(this._profilingSetTable, n);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        this.managerCopy.performApply(iLaunchConfigurationWorkingCopy);
    }

    public boolean isValid(ILaunchConfiguration iLaunchConfiguration) {
        return true;
    }

    public ProfilingSetsManagerCopy getManagerCopy() {
        if (this.managerCopy == null) {
            this.managerCopy = new ProfilingSetsManagerCopy();
        }
        return this.managerCopy;
    }

    class EditWSetDialog
    extends Dialog
    implements ModifyListener {
        private String _name;
        private Text _nameText;
        private String _title;
        private String _description;
        private String _id;
        private Text _descText;

        public EditWSetDialog(Shell shell, String string, String string2, String string3, String string4) {
            super(shell);
            this._name = string2;
            this._title = string;
            this._description = string3;
            this._id = string4;
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            shell.setText(this._title);
        }

        protected Control createDialogArea(Composite composite) {
            Composite composite2 = (Composite)super.createDialogArea(composite);
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 2;
            composite2.setLayout((Layout)gridLayout);
            GridData gridData = GridUtil.createFill();
            gridData.widthHint = 400;
            composite2.setLayoutData((Object)gridData);
            Label label = new Label(composite2, 0);
            label.setText(UIPlugin.getResourceString("STR_PROFILING_SET_NAME"));
            this._nameText = new Text(composite2, 2048);
            this._nameText.setLayoutData((Object)GridUtil.createHorizontalFill());
            Label label2 = new Label(composite2, 0);
            label2.setText(UIPlugin.getResourceString("STR_PROFILING_SET_DESCRIPTION"));
            label2.setLayoutData((Object)new GridData(2));
            gridData = GridUtil.createHorizontalFill();
            gridData.heightHint = 80;
            this._descText = new Text(composite2, 2624);
            this._descText.setLayoutData((Object)gridData);
            this._nameText.addModifyListener((ModifyListener)this);
            this._descText.addModifyListener((ModifyListener)this);
            if (this._name == null) {
                this._name = UIPlugin.getResourceString("FILTER_SET_DEFAULT_NAME");
            }
            this._nameText.setText(this._name);
            if (this._description == null) {
                this._description = UIPlugin.getResourceString("FILTER_SET_DEFAULT_DESCRIPTION");
            }
            this._descText.setText(this._description);
            return composite2;
        }

        public void modifyText(ModifyEvent modifyEvent) {
            Button button = this.getButton(0);
            if (button != null) {
                button.setEnabled(this._nameText.getText().trim().length() != 0 && this._descText.getText().trim().length() != 0);
            }
        }

        protected void okPressed() {
            this._name = this._nameText.getText().trim();
            this._description = this._descText.getText().trim();
            if (this._id == null) {
                ProfilingSet profilingSet = new ProfilingSet(this._name, this._name, this._description);
                TraceProfileOverviewUI.this.managerCopy.setDefaultSet(profilingSet);
                TraceProfileOverviewUI.this.managerCopy.getProfilingSets().put(this._name, profilingSet);
                TraceProfileOverviewUI.this._profilingSetList.add(profilingSet);
            } else {
                IProfilingSet iProfilingSet = (IProfilingSet)TraceProfileOverviewUI.this.managerCopy.getProfilingSets().get(this._id);
                if (iProfilingSet == null) {
                    iProfilingSet = new ProfilingSet(this._id, this._name, this._description);
                    TraceProfileOverviewUI.this.managerCopy.setDefaultSet(iProfilingSet);
                    TraceProfileOverviewUI.this.managerCopy.getProfilingSets().put(this._id, iProfilingSet);
                    TraceProfileOverviewUI.this._profilingSetList.add(iProfilingSet);
                } else {
                    iProfilingSet.setName(this._name);
                    iProfilingSet.setDescription(this._description);
                }
            }
            super.okPressed();
        }
    }

    public class TreeContentProvider
    implements ITreeContentProvider {
        public Object[] getChildren(Object object) {
            if (object instanceof IProfilingSetTypeGroup) {
                return TraceProfileOverviewUI.this.getManagerCopy().getProfilingTypesForGroup(((IProfilingSetTypeGroup)object).getId());
            }
            return new Object[0];
        }

        public Object[] getElements(Object object) {
            return TraceProfileOverviewUI.this.getManagerCopy().getProfilingTypesGroups().values().toArray();
        }

        public boolean hasChildren(Object object) {
            return this.getChildren(object).length > 0;
        }

        public Object getParent(Object object) {
            String string;
            if (object instanceof IProfilingSetType && (string = ((IProfilingSetType)object).getGroup()) != null) {
                return TraceProfileOverviewUI.this.getManagerCopy().getProfilingTypesGroups().get(string);
            }
            return "";
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }
    }

    public class TreeLabelProvider
    extends LabelProvider {
        private Hashtable iconList = new Hashtable();
        private ImageDescriptor memoryDescriptor;
        private ImageDescriptor coverageDescriptor;
        private ImageDescriptor probesDescriptor;

        public TreeLabelProvider(ImageDescriptor[] imageDescriptorArray) {
            int n = 0;
            while (n < imageDescriptorArray.length) {
                if (!this.iconList.containsKey(imageDescriptorArray[n])) {
                    this.iconList.put(imageDescriptorArray[n], imageDescriptorArray[n].createImage());
                }
                ++n;
            }
        }

        public String getText(Object object) {
            if (object instanceof IProfilingSetType) {
                return ((IProfilingSetType)object).getName();
            }
            if (object instanceof IProfilingSetTypeGroup) {
                return ((IProfilingSetTypeGroup)object).getName();
            }
            return object.toString();
        }

        public Image getImage(Object object) {
            ImageDescriptor imageDescriptor = null;
            if (object instanceof IProfilingSetType) {
                imageDescriptor = ((IProfilingSetType)object).getImage();
            } else if (object instanceof IProfilingSetTypeGroup) {
                imageDescriptor = ((IProfilingSetTypeGroup)object).getIcon();
            }
            if (imageDescriptor == null) {
                return null;
            }
            return (Image)this.iconList.get(imageDescriptor);
        }

        public void dispose() {
            Iterator iterator = this.iconList.keySet().iterator();
            while (iterator.hasNext()) {
                ((Image)this.iconList.get(iterator.next())).dispose();
            }
            this.iconList.clear();
            this.iconList = null;
        }
    }

    static class PageContent
    extends Composite {
        private StackLayout detailsLayout;
        private Control[] controls;
        private IProfilingSetType[] profilingTypes;
        private Control currentControl = null;
        private TraceProfileTypeGroupUI _traceProfileTypeGroupUI;
        private Map groupControls = new HashMap();

        public PageContent(Composite composite, int n) {
            super(composite, n);
        }

        public Composite createContent(IProfilingSetType[] iProfilingSetTypeArray, ProfilingSetsManagerCopy profilingSetsManagerCopy) {
            this.detailsLayout = new StackLayout();
            this.setLayout((Layout)this.detailsLayout);
            this.setLayoutData(new GridData(1808));
            this.controls = new Control[iProfilingSetTypeArray.length + 1];
            this.profilingTypes = iProfilingSetTypeArray;
            int n = 0;
            while (n < iProfilingSetTypeArray.length) {
                this.controls[n] = iProfilingSetTypeArray[n].getProfilingType().createControl(this, profilingSetsManagerCopy);
                this.controls[n].setVisible(false);
                ++n;
            }
            this.controls[this.controls.length - 1] = new Composite((Composite)this, 0);
            this.controls[this.controls.length - 1].setVisible(false);
            Map map = profilingSetsManagerCopy.getProfilingTypesGroups();
            Object[] objectArray = map.keySet().toArray();
            this._traceProfileTypeGroupUI = new TraceProfileTypeGroupUI();
            int n2 = 0;
            while (n2 < objectArray.length) {
                IProfilingSetTypeGroup iProfilingSetTypeGroup = (IProfilingSetTypeGroup)map.get(objectArray[n2]);
                this.groupControls.put(iProfilingSetTypeGroup.getId(), this._traceProfileTypeGroupUI.createControl(this, iProfilingSetTypeGroup.getName(), iProfilingSetTypeGroup.getDescription()));
                ++n2;
            }
            return null;
        }

        public boolean performApply(ProfilingSetsManagerCopy profilingSetsManagerCopy) {
            Object object;
            Object object2;
            IProfilingSet iProfilingSet = profilingSetsManagerCopy.getDefaultSet();
            if (iProfilingSet == null) {
                return true;
            }
            StringBuffer stringBuffer = new StringBuffer();
            List list = iProfilingSet.getProfilingTypes();
            int n = 0;
            while (n < this.profilingTypes.length) {
                String string;
                if (list.contains(this.profilingTypes[n].getId()) && (string = (object2 = this.profilingTypes[n].getProfilingType()).validateConfiguration(profilingSetsManagerCopy)) != null) {
                    stringBuffer.append(string).append("\n");
                }
                ++n;
            }
            if (stringBuffer.length() > 0) {
                object2 = UIPlugin.getResourceString("ERROR_DLG_CONFLICTS_MSG");
                if (!MessageDialog.openQuestion((Shell)this.getShell(), (String)UIPlugin.getResourceString("ERROR_DLG_CONFLICTS_TITLE"), (String)((String)object2 + stringBuffer.toString()))) {
                    return false;
                }
            }
            object2 = ProfilingSetsManager.getDefaultProfilingOptions();
            int n2 = 0;
            while (n2 < this.profilingTypes.length) {
                if (list.contains(this.profilingTypes[n2].getId())) {
                    object = this.profilingTypes[n2].getProfilingType();
                    ProfilingAttribute[] profilingAttributeArray = object.getAttributes();
                    int n3 = 0;
                    while (n3 < profilingAttributeArray.length) {
                        object2.add(profilingAttributeArray[n3]);
                        ++n3;
                    }
                }
                ++n2;
            }
            object2 = ProfilingSetsManager.filterDuplicateOptions((List)object2);
            iProfilingSet.getAttributes().clear();
            object = iProfilingSet.getAttributes();
            int n4 = 0;
            while (n4 < object2.size()) {
                ProfilingAttribute profilingAttribute = (ProfilingAttribute)object2.get(n4);
                object.put(profilingAttribute.getName(), profilingAttribute);
                ++n4;
            }
            return true;
        }

        public void showDetailsFor(Control control) {
            this.detailsLayout.topControl = control;
            this.currentControl = control;
            control.setVisible(true);
            this.layout();
        }

        public void showGroupDetails(IProfilingSetTypeGroup iProfilingSetTypeGroup) {
            Control control;
            Control control2 = (Control)this.groupControls.get(iProfilingSetTypeGroup.getId());
            if (!control2.equals(control = this.getCurrentlyDisplayingControl())) {
                this.showDetailsFor(control2);
            }
            this.layout();
        }

        public void showEmptyDetails() {
            this.detailsLayout.topControl = this.controls[this.controls.length - 1];
            this.currentControl = this.controls[this.controls.length - 1];
            this.controls[this.controls.length - 1].setVisible(true);
            this.layout();
        }

        public void dispose() {
            this.currentControl = null;
            this.profilingTypes = null;
            int n = 0;
            while (n < this.controls.length) {
                if (this.controls[n] != null) {
                    this.controls[n].dispose();
                }
                ++n;
            }
            Object[] objectArray = this.groupControls.values().toArray();
            int n2 = 0;
            while (n2 < objectArray.length) {
                if ((Control)objectArray[n2] != null) {
                    ((Control)objectArray[n2]).dispose();
                }
                ++n2;
            }
            this.groupControls.clear();
            this.groupControls = null;
            this.controls = null;
        }

        public Control getCurrentlyDisplayingControl() {
            return this.currentControl;
        }

        public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        }
    }

    public class EditWizardPage1
    extends WizardPage
    implements ICheckStateListener,
    ISelectionChangedListener {
        private boolean canFlipToNext;
        private PageContent dc;
        private String profilingSetName;
        private CheckboxTreeViewer treeViewer;
        private TreeContentProvider provider;
        private ProfilingSetsManagerCopy copy;

        public EditWizardPage1(String string, String string2, ProfilingSetsManagerCopy profilingSetsManagerCopy) {
            super(string);
            this.profilingSetName = string2;
            this.copy = profilingSetsManagerCopy;
        }

        public boolean isPageComplete() {
            return true;
        }

        public boolean canFlipToNextPage() {
            return this.canFlipToNext;
        }

        public void dispose() {
            this.dc.dispose();
            super.dispose();
        }

        public void createControl(Composite composite) {
            ProfilingSetType[] profilingSetTypeArray;
            Composite composite2 = new Composite(composite, 0);
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 2;
            composite2.setLayout((Layout)gridLayout);
            GridData gridData = GridUtil.createFill();
            composite2.setLayoutData((Object)gridData);
            gridData = GridUtil.createFill();
            GridLayout gridLayout2 = new GridLayout();
            gridLayout2.numColumns = 1;
            this.provider = new TreeContentProvider();
            this.treeViewer = new CheckboxTreeViewer(composite2);
            this.treeViewer.setContentProvider((IContentProvider)this.provider);
            Object[] objectArray = TraceProfileOverviewUI.this.getManagerCopy().getProfilingTypesGroups().values().toArray();
            Object[] objectArray2 = TraceProfileOverviewUI.this.getManagerCopy().getProfilingTypes().values().toArray();
            ImageDescriptor[] imageDescriptorArray = new ImageDescriptor[objectArray.length + objectArray2.length];
            int n = 0;
            while (n < objectArray.length) {
                imageDescriptorArray[n] = ((IProfilingSetTypeGroup)objectArray[n]).getIcon();
                ++n;
            }
            int n2 = 0;
            while (n2 < objectArray2.length) {
                profilingSetTypeArray = (ProfilingSetType[])objectArray2[n2];
                imageDescriptorArray[n2 + objectArray.length] = profilingSetTypeArray.getImage();
                ++n2;
            }
            this.treeViewer.setLabelProvider((IBaseLabelProvider)new TreeLabelProvider(imageDescriptorArray));
            this.treeViewer.setInput((Object)"");
            this.treeViewer.getTree().setLayout((Layout)gridLayout2);
            this.treeViewer.getTree().setLayoutData((Object)GridUtil.createVerticalFill());
            profilingSetTypeArray = new ProfilingSetType[TraceProfileOverviewUI.this.getManagerCopy().getProfilingTypes().size()];
            this.dc = new PageContent(composite2, 0);
            this.dc.createContent(TraceProfileOverviewUI.this.getManagerCopy().getProfilingTypes().values().toArray(profilingSetTypeArray), this.copy);
            this.dc.setVisible(true);
            this.treeViewer.addCheckStateListener((ICheckStateListener)this);
            this.treeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
            this.setControl((Control)composite2);
            this.setPageComplete(this.isPageComplete());
        }

        private void setChecked(IProfilingSetType iProfilingSetType) {
            if (iProfilingSetType == null) {
                return;
            }
            this.treeViewer.expandToLevel((Object)iProfilingSetType, 0);
            this.treeViewer.setChecked((Object)iProfilingSetType, true);
            Object object = this.provider.getParent(iProfilingSetType);
            Object[] objectArray = this.provider.getChildren(object);
            boolean bl = false;
            int n = 0;
            while (n < objectArray.length) {
                if (!this.treeViewer.getChecked(objectArray[n])) {
                    bl = true;
                }
                ++n;
            }
            if (!bl) {
                this.treeViewer.setChecked(object, true);
            }
        }

        public void checkStateChanged(CheckStateChangedEvent checkStateChangedEvent) {
            Object object = checkStateChangedEvent.getElement();
            if (object instanceof IProfilingSetType) {
                Object object2 = this.provider.getParent(object);
                Object[] objectArray = this.provider.getChildren(object2);
                boolean bl = false;
                int n = 0;
                while (n < objectArray.length) {
                    if (this.treeViewer.getChecked(objectArray[n])) {
                        bl = true;
                    }
                    ++n;
                }
                this.treeViewer.setChecked(object2, bl);
            } else if (object instanceof IProfilingSetTypeGroup) {
                Object[] objectArray = this.provider.getChildren(object);
                int n = 0;
                while (n < objectArray.length) {
                    this.treeViewer.setChecked(objectArray[n], checkStateChangedEvent.getChecked());
                    ++n;
                }
            }
            this.updateWizardButtons();
        }

        public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
            this.updateWizardButtons();
            IStructuredSelection iStructuredSelection = (IStructuredSelection)selectionChangedEvent.getSelection();
            if (iStructuredSelection.getFirstElement() instanceof IProfilingSetType) {
                this.updateGui((IProfilingSetType)iStructuredSelection.getFirstElement());
            } else if (iStructuredSelection.getFirstElement() instanceof IProfilingSetTypeGroup) {
                this.dc.showGroupDetails((IProfilingSetTypeGroup)iStructuredSelection.getFirstElement());
            } else {
                this.dc.showEmptyDetails();
            }
        }

        private void updateGui(IProfilingSetType iProfilingSetType) {
            Control control;
            Control control2 = iProfilingSetType.getProfilingType().getControl(this.profilingSetName);
            if (!control2.equals(control = this.dc.getCurrentlyDisplayingControl())) {
                this.dc.showDetailsFor(control2);
            }
        }

        private void updateWizardButtons() {
            Object[] objectArray = this.treeViewer.getCheckedElements();
            int n = 0;
            while (n < objectArray.length) {
                IProfilingSetType iProfilingSetType;
                if (objectArray[n] instanceof IProfilingSetType && (iProfilingSetType = (IProfilingSetType)objectArray[n]).isUseFilters()) {
                    this.canFlipToNext = iProfilingSetType.isUseFilters();
                    this.getWizard().getContainer().updateButtons();
                    return;
                }
                ++n;
            }
            this.canFlipToNext = false;
            this.getWizard().getContainer().updateButtons();
        }

        public void initializeFrom(ProfilingSetsManagerCopy profilingSetsManagerCopy) {
            IProfilingSet iProfilingSet = profilingSetsManagerCopy.getDefaultSet();
            if (iProfilingSet == null) {
                return;
            }
            List list = iProfilingSet.getProfilingTypes();
            int n = 0;
            while (n < list.size()) {
                String string = list.get(n).toString();
                Object v = profilingSetsManagerCopy.getProfilingTypes().get(string);
                if (string != null) {
                    this.setChecked((IProfilingSetType)v);
                }
                ++n;
            }
        }

        public boolean performApply(ProfilingSetsManagerCopy profilingSetsManagerCopy) {
            IProfilingSet iProfilingSet = profilingSetsManagerCopy.getDefaultSet();
            iProfilingSet.getProfilingTypes().clear();
            Object[] objectArray = this.treeViewer.getCheckedElements();
            int n = 0;
            while (n < objectArray.length) {
                Object object = objectArray[n];
                if (object != null && object instanceof IProfilingSetType) {
                    iProfilingSet.getProfilingTypes().add(((IProfilingSetType)object).getId());
                }
                ++n;
            }
            return this.dc.performApply(profilingSetsManagerCopy);
        }
    }

    public class EditWizardPage2
    extends WizardPage {
        private ProfileFiltersTab _filterTab = new ProfileFiltersTab("name");

        public EditWizardPage2(String string) {
            super(string);
        }

        public void createControl(Composite composite) {
            Composite composite2 = this._filterTab.createControl(composite);
            this._filterTab.addListener(TraceProfileOverviewUI.this._listener);
            this.setControl((Control)composite2);
        }

        public void initializeFrom(ProfilingSetsManagerCopy profilingSetsManagerCopy) {
            Collection collection = profilingSetsManagerCopy.getFilterSets().values();
            FilterSetElement[] filterSetElementArray = new FilterSetElement[collection.size()];
            this._filterTab.activateFilters(collection.toArray(filterSetElementArray), profilingSetsManagerCopy.getDefaultFilterSet());
        }

        public boolean performApply(ProfilingSetsManagerCopy profilingSetsManagerCopy) {
            Object object;
            Map map = profilingSetsManagerCopy.getFilterSets();
            map.clear();
            ArrayList arrayList = this._filterTab.getFilterSet();
            int n = 0;
            while (n < arrayList.size()) {
                object = (FilterSetElement)arrayList.get(n);
                map.put(((FilterSetElement)object).getName(), object);
                ++n;
            }
            object = this._filterTab.getActiveFilterSet();
            profilingSetsManagerCopy.setDefaultFilterSet((FilterSetElement)profilingSetsManagerCopy.getFilterSets().get(object));
            return true;
        }
    }

    public class EditWizard
    extends Wizard {
        private EditWizardPage1 wizPage1;
        private EditWizardPage2 wizPage2;
        protected IStructuredSelection selection;
        protected IWorkbench workbench;
        private String parentName;
        private ProfilingSetsManagerCopy original;
        private ProfilingSetsManagerCopy copy;

        public EditWizard(String string, ProfilingSetsManagerCopy profilingSetsManagerCopy) {
            this.parentName = string;
            this.original = profilingSetsManagerCopy;
            this.copy = this.original.createCopy();
        }

        public void setParent(String string) {
            this.parentName = string;
        }

        public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
            this.workbench = iWorkbench;
            this.selection = iStructuredSelection;
        }

        public void addPages() {
            super.addPages();
            this.wizPage1 = new EditWizardPage1("profilingTypes", this.parentName, this.copy);
            this.wizPage1.setTitle(this.getWindowTitle());
            this.wizPage1.setDescription(this.getWindowTitle());
            this.addPage((IWizardPage)this.wizPage1);
            this.wizPage2 = new EditWizardPage2("filters");
            this.wizPage2.setTitle(this.getWindowTitle());
            this.wizPage2.setDescription(this.getWindowTitle());
            this.addPage((IWizardPage)this.wizPage2);
        }

        public ProfilingSetsManagerCopy getProfilingSetsManagerCopy() {
            return this.copy;
        }

        public boolean performFinish() {
            this.original.resetFrom(this.copy);
            this.original.applyChanges();
            TraceProfileOverviewUI.this.parentTab.update();
            return true;
        }
    }

    private static class EditWizardDialog
    extends WizardDialog {
        private ProfilingSetsManagerCopy _copy = ((EditWizard)this.getWizard()).getProfilingSetsManagerCopy();

        public EditWizardDialog(Shell shell, IWizard iWizard) {
            super(shell, iWizard);
        }

        protected Control createContents(Composite composite) {
            Control control = super.createContents(composite);
            EditWizardPage1 editWizardPage1 = (EditWizardPage1)this.getWizard().getPages()[0];
            EditWizardPage2 editWizardPage2 = (EditWizardPage2)this.getWizard().getPages()[1];
            editWizardPage1.initializeFrom(this._copy);
            editWizardPage2.initializeFrom(this._copy);
            return control;
        }

        protected void backPressed() {
            EditWizardPage2 editWizardPage2 = (EditWizardPage2)this.getCurrentPage();
            if (editWizardPage2.performApply(this._copy)) {
                EditWizardPage1 editWizardPage1 = (EditWizardPage1)editWizardPage2.getPreviousPage();
                editWizardPage1.initializeFrom(this._copy);
                super.backPressed();
            }
        }

        protected void nextPressed() {
            EditWizardPage1 editWizardPage1 = (EditWizardPage1)this.getCurrentPage();
            if (editWizardPage1.performApply(this._copy)) {
                EditWizardPage2 editWizardPage2 = (EditWizardPage2)editWizardPage1.getNextPage();
                editWizardPage2.initializeFrom(this._copy);
                super.nextPressed();
            }
        }

        protected void finishPressed() {
            EditWizardPage1 editWizardPage1 = (EditWizardPage1)this.getWizard().getPages()[0];
            EditWizardPage2 editWizardPage2 = (EditWizardPage2)this.getWizard().getPages()[1];
            boolean bl = editWizardPage1.performApply(this._copy);
            boolean bl2 = editWizardPage2.performApply(this._copy);
            if (bl || bl2) {
                super.finishPressed();
            }
        }
    }

    class ListContentProvider
    implements IStructuredContentProvider {
        ArrayList contents;

        public Object[] getElements(Object object) {
            if (this.contents != null && this.contents == object) {
                return this.contents.toArray();
            }
            return new Object[0];
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
            this.contents = object2 instanceof ArrayList ? (ArrayList)object2 : null;
        }

        public void dispose() {
        }
    }

    public class ProfilingSetList
    implements IBasicPropertyConstants {
        ArrayList profilings = new ArrayList();
        TableViewer fViewer;
        private ArrayList listeners;

        public ProfilingSetList(TableViewer tableViewer) {
            this.fViewer = tableViewer;
        }

        public void add(IProfilingSet iProfilingSet) {
            this.add(iProfilingSet, -1);
        }

        public void add(IProfilingSet iProfilingSet, int n) {
            if (n < 0) {
                this.profilings.add(iProfilingSet);
            } else {
                this.profilings.add(n, iProfilingSet);
            }
        }

        public void addElementChangedListener(ProfilingSetContentProvider profilingSetContentProvider) {
            if (profilingSetContentProvider == null) {
                return;
            }
            if (this.listeners == null) {
                this.listeners = new ArrayList();
            }
            if (!this.listeners.contains(profilingSetContentProvider)) {
                this.listeners.add(profilingSetContentProvider);
            }
        }

        public Object[] elements() {
            return this.profilings.toArray();
        }

        public void fireElementChanged(IProfilingSet iProfilingSet, String string) {
            if (this.listeners != null) {
                Iterator iterator = this.listeners.iterator();
                while (iterator.hasNext()) {
                    ProfilingSetContentProvider profilingSetContentProvider = (ProfilingSetContentProvider)iterator.next();
                    profilingSetContentProvider.elementChanged(iProfilingSet, string);
                }
            }
        }

        public Object getElementAt(int n) {
            return this.profilings.get(n);
        }

        public ArrayList getprofilings() {
            return (ArrayList)this.profilings.clone();
        }

        public int getSize() {
            return this.profilings.size();
        }

        public void removeAll() {
            this.profilings.clear();
        }

        public Object removeElementAt(int n) {
            Object e = this.profilings.get(n);
            if (e == null) {
                return null;
            }
            this.profilings.remove(e);
            return e;
        }

        public void removeElementChangedListener(ProfilingSetContentProvider profilingSetContentProvider) {
            if (this.listeners != null) {
                this.listeners.remove(profilingSetContentProvider);
            }
        }

        public Object[] uiElements() {
            return this.profilings.toArray();
        }
    }

    class ProfilingSetContentProvider
    implements IStructuredContentProvider {
        private CheckboxTableViewer fViewer;
        protected IProfilingSet fChangedElement;

        public ProfilingSetContentProvider(CheckboxTableViewer checkboxTableViewer) {
            this.fViewer = checkboxTableViewer;
        }

        public void dispose() {
        }

        public void elementChanged(IProfilingSet iProfilingSet, String string) {
            this.fChangedElement = iProfilingSet;
            this.fViewer.getControl().getDisplay().asyncExec(new Runnable(this){
                private final /* synthetic */ ProfilingSetContentProvider this$1;
                {
                    this.this$1 = profilingSetContentProvider;
                }

                public void run() {
                    ProfilingSetContentProvider.access$100(this.this$1).refresh((Object)this.this$1.fChangedElement);
                }
            });
        }

        public Object[] getElements(Object object) {
            return ((ProfilingSetList)object).elements();
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
            this.fViewer = (CheckboxTableViewer)viewer;
            if (object != null && object instanceof ProfilingList) {
                ((ProfilingSetList)object).removeElementChangedListener(this);
            }
            if (object2 != null && object2 instanceof ProfilingList) {
                ((ProfilingSetList)object2).addElementChangedListener(this);
            }
        }

        public boolean isDeleted(Object object) {
            return false;
        }

        static /* synthetic */ CheckboxTableViewer access$100(ProfilingSetContentProvider profilingSetContentProvider) {
            return profilingSetContentProvider.fViewer;
        }
    }

    public class ProfilingSetLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        public Image getColumnImage(Object object, int n) {
            return PDPluginImages.getImage("filter_obj.gif");
        }

        public Image getColumnImage(Viewer viewer, Object object, int n) {
            return PDPluginImages.getImage("filter_obj.gif");
        }

        public String getColumnText(Object object, int n) {
            return ((IProfilingSet)object).getName();
        }

        public String getColumnText(Viewer viewer, Object object, int n) {
            return ((IProfilingSet)object).getName();
        }
    }
}

