/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.launcher;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.junit.launcher.JUnitLaunchShortcut;
import org.eclipse.jdt.internal.junit.ui.JUnitMessages;
import org.eclipse.jdt.internal.junit.ui.JUnitPlugin;
import org.eclipse.jdt.internal.junit.util.TestSearchEngine;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class ProfileJUnitShortcut
extends JUnitLaunchShortcut {
    protected void launchType(Object[] objectArray, String string) {
        IType[] iTypeArray = null;
        try {
            iTypeArray = TestSearchEngine.findTests((Object[])objectArray);
        }
        catch (InterruptedException interruptedException) {
            JUnitPlugin.log((Throwable)interruptedException);
            return;
        }
        catch (InvocationTargetException invocationTargetException) {
            JUnitPlugin.log((Throwable)invocationTargetException);
            return;
        }
        IType iType = null;
        if (iTypeArray.length == 0) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)JUnitMessages.getString((String)"LaunchTestAction.dialog.title"), (String)JUnitMessages.getString((String)"LaunchTestAction.message.notests"));
        } else {
            iType = iTypeArray.length > 1 ? this.chooseType(iTypeArray, string) : iTypeArray[0];
        }
        if (iType != null) {
            this.launch(iType, string);
        }
    }

    private void launch(IType iType, final String string) {
        String string2 = iType.getFullyQualifiedName();
        ILaunchConfiguration iLaunchConfiguration = this.findLaunchConfiguration(string, (IJavaElement)iType, "", string2, "");
        if (iLaunchConfiguration == null) {
            iLaunchConfiguration = this.createConfiguration(iType.getJavaProject(), iType.getElementName(), string2, "", "");
        }
        final ILaunchConfiguration iLaunchConfiguration2 = iLaunchConfiguration;
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                Shell shell = UIPlugin.getActiveWorkbenchShell();
                int n = DebugUITools.openLaunchConfigurationPropertiesDialog((Shell)shell, (ILaunchConfiguration)iLaunchConfiguration2, (String)IDebugUIConstants.ID_PROFILE_LAUNCH_GROUP);
                if (n == 0) {
                    DebugUITools.launch((ILaunchConfiguration)iLaunchConfiguration2, (String)string);
                }
            }
        });
    }

    private ILaunchConfiguration findLaunchConfiguration(String string, IJavaElement iJavaElement, String string2, String string3, String string4) {
        ILaunchConfigurationType iLaunchConfigurationType = this.getJUnitLaunchConfigType();
        ArrayList<ILaunchConfiguration> arrayList = Collections.EMPTY_LIST;
        try {
            ILaunchConfiguration[] iLaunchConfigurationArray = this.getLaunchManager().getLaunchConfigurations(iLaunchConfigurationType);
            arrayList = new ArrayList<ILaunchConfiguration>(iLaunchConfigurationArray.length);
            int n = 0;
            while (n < iLaunchConfigurationArray.length) {
                ILaunchConfiguration iLaunchConfiguration = iLaunchConfigurationArray[n];
                if (iLaunchConfiguration.getAttribute("org.eclipse.jdt.junit.CONTAINER", "").equals(string2) && iLaunchConfiguration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, "").equals(string3) && iLaunchConfiguration.getAttribute("org.eclipse.jdt.junit.TESTNAME", "").equals(string4) && iLaunchConfiguration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "").equals(iJavaElement.getJavaProject().getElementName())) {
                    arrayList.add(iLaunchConfiguration);
                }
                ++n;
            }
        }
        catch (CoreException coreException) {
            JUnitPlugin.log((Throwable)coreException);
        }
        int n = arrayList.size();
        if (n < 1) {
            return null;
        }
        if (n == 1) {
            return (ILaunchConfiguration)arrayList.get(0);
        }
        ILaunchConfiguration iLaunchConfiguration = this.chooseConfiguration(arrayList, string);
        if (iLaunchConfiguration != null) {
            return iLaunchConfiguration;
        }
        return null;
    }

    protected IType chooseType(IType[] iTypeArray, String string) {
        if (string.equals("profile")) {
            ElementListSelectionDialog elementListSelectionDialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)new JavaElementLabelProvider(2048));
            elementListSelectionDialog.setElements((Object[])iTypeArray);
            elementListSelectionDialog.setTitle(UIPlugin.getResourceString("LAUNCH_SHORTCUT_SELECT_TEST_TITLE"));
            elementListSelectionDialog.setMessage(UIPlugin.getResourceString("LAUNCH_SHORTCUT_SELECT_TEST_MSG"));
            elementListSelectionDialog.setMultipleSelection(false);
            if (elementListSelectionDialog.open() == 0) {
                return (IType)elementListSelectionDialog.getFirstResult();
            }
            return null;
        }
        return super.chooseType(iTypeArray, string);
    }

    protected ILaunchConfiguration chooseConfiguration(List list, String string) {
        if (string.equals("profile")) {
            IDebugModelPresentation iDebugModelPresentation = DebugUITools.newDebugModelPresentation();
            ElementListSelectionDialog elementListSelectionDialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)iDebugModelPresentation);
            elementListSelectionDialog.setElements(list.toArray());
            elementListSelectionDialog.setTitle(UIPlugin.getResourceString("LAUNCH_SHORTCUT_SELECT_CONF_TITLE"));
            elementListSelectionDialog.setMessage(UIPlugin.getResourceString("LAUNCH_SHORTCUT_SELECT_CONF_MSG"));
            elementListSelectionDialog.setMultipleSelection(false);
            int n = elementListSelectionDialog.open();
            iDebugModelPresentation.dispose();
            if (n == 0) {
                return (ILaunchConfiguration)elementListSelectionDialog.getFirstResult();
            }
            return null;
        }
        return this.chooseConfiguration(list, string);
    }
}

