/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.launcher;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.launcher.IProfileLaunchConfigurationConstants;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfilingSetsManager;
import org.eclipse.hyades.trace.ui.internal.launcher.TraceArguments;
import org.eclipse.hyades.trace.ui.internal.util.PDCoreUtil;
import org.eclipse.jdt.internal.launching.LaunchingMessages;
import org.eclipse.jdt.internal.launching.LaunchingPlugin;
import org.eclipse.jdt.launching.AbstractJavaLaunchConfigurationDelegate;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.framework.msg.MessageFormat;

public class ProfileJavaAppletDelegate
extends AbstractJavaLaunchConfigurationDelegate
implements IDebugEventSetListener {
    private static Map fgLaunchToFileMap = new HashMap();

    public void launch(ILaunchConfiguration iLaunchConfiguration, String string, ILaunch iLaunch, IProgressMonitor iProgressMonitor) throws CoreException {
        ProfilingSetsManager profilingSetsManager = ProfilingSetsManager.instance();
        IPreferenceStore iPreferenceStore = UIPlugin.getDefault().getPreferenceStore();
        this.verifyMainTypeName(iLaunchConfiguration);
        File file = this.verifyWorkingDirectory(iLaunchConfiguration);
        String string2 = file.getAbsolutePath();
        TraceArguments traceArguments = new TraceArguments(iLaunchConfiguration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_APPLET_APPLETVIEWER_CLASS, "sun.applet.AppletViewer"));
        traceArguments.setClassPath(this.getClasspathString(iLaunchConfiguration));
        traceArguments.setVMArguments(this.getJavaPolicyFile(file) + ' ' + this.getVMArguments(iLaunchConfiguration));
        File file2 = this.buildHTMLFile(iLaunchConfiguration, file);
        traceArguments.setParameters(file2.getName());
        traceArguments.setLocation(string2);
        if (fgLaunchToFileMap.isEmpty()) {
            DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
        }
        fgLaunchToFileMap.put(iLaunch, file2);
        this.setDefaultSourceLocator(iLaunch, iLaunchConfiguration);
        String string3 = iLaunchConfiguration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_PROJECT, iPreferenceStore.getString("prj_name"));
        String string4 = iLaunchConfiguration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_MONITOR, iPreferenceStore.getString("mon_name"));
        traceArguments.setHostName("localhost");
        traceArguments.setPortNumber(iPreferenceStore.getInt("localhost_port"));
        traceArguments.setAutoMonitoring(profilingSetsManager.getAutoMonitoring(iLaunchConfiguration));
        traceArguments.setEnvironmentVariable(new ArrayList());
        if (iLaunchConfiguration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILE_TO_FILE, false)) {
            traceArguments.setProfileFile(iLaunchConfiguration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_FILE, (String)null));
        }
        ArrayList arrayList = profilingSetsManager.getFilters(iLaunchConfiguration);
        Vector vector = profilingSetsManager.getOptions(iLaunchConfiguration);
        PDCoreUtil.launchTrace(traceArguments, arrayList, vector, string3, string4, iLaunch);
    }

    public String getJavaPolicyFile(File file) {
        File file2 = new File(file, "java.policy.applet");
        if (!file2.exists()) {
            File file3 = LaunchingPlugin.getFileInPlugin((IPath)new Path("java.policy.applet"));
            try {
                byte[] byArray = ProfileJavaAppletDelegate.getFileByteContent(file3);
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
                bufferedOutputStream.write(byArray);
                bufferedOutputStream.close();
            }
            catch (IOException iOException) {
                return "";
            }
        }
        return "-Djava.security.policy=java.policy.applet";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private File buildHTMLFile(ILaunchConfiguration var1_1, File var2_2) {
        block18: {
            var3_3 = null;
            var4_4 = null;
            try {
                var5_5 = this.getMainTypeName(var1_1);
                var4_4 = new File(var2_2, var5_5 + System.currentTimeMillis() + ".html");
                var3_3 = new FileWriter(var4_4);
                var3_3.write("<html>\n");
                var3_3.write("<body>\n");
                var3_3.write("<applet code=");
                var3_3.write(var5_5);
                var3_3.write(".class ");
                var6_7 = var1_1.getAttribute(IJavaLaunchConfigurationConstants.ATTR_APPLET_NAME, "");
                if (var6_7.length() != 0) {
                    var3_3.write("NAME =\"" + var6_7 + "\" ");
                }
                var3_3.write("width=\"");
                var3_3.write(Integer.toString(var1_1.getAttribute(IJavaLaunchConfigurationConstants.ATTR_APPLET_WIDTH, 200)));
                var3_3.write("\" height=\"");
                var3_3.write(Integer.toString(var1_1.getAttribute(IJavaLaunchConfigurationConstants.ATTR_APPLET_HEIGHT, 200)));
                var3_3.write("\" >\n");
                var7_9 = var1_1.getAttribute(IJavaLaunchConfigurationConstants.ATTR_APPLET_PARAMETERS, new HashMap<K, V>());
                if (var7_9.size() != 0) {
                    var8_10 = var7_9.entrySet().iterator();
                    while (var8_10.hasNext()) {
                        var9_11 = var8_10.next();
                        var3_3.write("<param name=");
                        var3_3.write(this.getQuotedString((String)var9_11.getKey()));
                        var3_3.write(" value=");
                        var3_3.write(this.getQuotedString((String)var9_11.getValue()));
                        var3_3.write(">\n");
                    }
                }
                var3_3.write("</applet>\n");
                var3_3.write("</body>\n");
                var3_3.write("</html>\n");
                var11_12 = null;
                ** if (var3_3 == null) goto lbl-1000
            }
            catch (Throwable var10_20) {
                var11_15 = null;
                if (var3_3 != null) {
                    try {
                        var3_3.close();
                    }
                    catch (IOException var12_19) {
                        // empty catch block
                    }
                }
                throw var10_20;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    var3_3.close();
                }
                catch (IOException var12_16) {}
            }
lbl-1000:
            // 2 sources

            {
                break block18;
                catch (IOException var5_6) {
                    var11_13 = null;
                    if (var3_3 != null) {
                        try {
                            var3_3.close();
                        }
                        catch (IOException var12_17) {}
                    }
                    break block18;
                }
                catch (CoreException var6_8) {
                    var11_14 = null;
                    if (var3_3 != null) {
                        try {
                            var3_3.close();
                        }
                        catch (IOException var12_18) {}
                    }
                }
            }
        }
        if (var4_4 == null) {
            return null;
        }
        return var4_4;
    }

    private String getQuotedString(String string) {
        if (string.indexOf(34) == -1) {
            return '\"' + string + '\"';
        }
        return '\'' + string + '\'';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleDebugEvents(DebugEvent[] debugEventArray) {
        int n = 0;
        while (n < debugEventArray.length) {
            DebugEvent debugEvent = debugEventArray[n];
            Object object = debugEvent.getSource();
            switch (debugEvent.getKind()) {
                case 8: {
                    Object var8_7;
                    Object object2;
                    if (object == null) break;
                    ILaunch iLaunch = null;
                    if (object instanceof IProcess) {
                        object2 = (IProcess)object;
                        iLaunch = object2.getLaunch();
                    } else if (object instanceof IDebugTarget) {
                        object2 = (IDebugTarget)object;
                        iLaunch = object2.getLaunch();
                    }
                    object2 = (File)fgLaunchToFileMap.get(iLaunch);
                    if (object2 == null) break;
                    try {
                        fgLaunchToFileMap.remove(iLaunch);
                        ((File)object2).delete();
                        var8_7 = null;
                        if (!fgLaunchToFileMap.isEmpty()) break;
                    }
                    catch (Throwable throwable) {
                        var8_7 = null;
                        if (fgLaunchToFileMap.isEmpty()) {
                            DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
                        }
                        throw throwable;
                    }
                    DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
                    break;
                }
            }
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static byte[] getFileByteContent(File file) throws IOException {
        byte[] byArray;
        block5: {
            BufferedInputStream bufferedInputStream = null;
            try {
                bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                byArray = ProfileJavaAppletDelegate.getInputStreamAsByteArray(bufferedInputStream, (int)file.length());
                Object var4_3 = null;
                if (bufferedInputStream == null) break block5;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var4_4 = null;
                    if (bufferedInputStream == null) break block6;
                    try {
                        ((InputStream)bufferedInputStream).close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                ((InputStream)bufferedInputStream).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return byArray;
    }

    protected static byte[] getInputStreamAsByteArray(InputStream inputStream, int n) throws IOException {
        byte[] byArray;
        if (n == -1) {
            byArray = new byte[]{};
            int n2 = 0;
            int n3 = -1;
            do {
                int n4;
                if (n2 + (n4 = inputStream.available()) > byArray.length) {
                    byte[] byArray2 = byArray;
                    byArray = new byte[n2 + n4];
                    System.arraycopy(byArray2, 0, byArray, 0, n2);
                }
                if ((n3 = inputStream.read(byArray, n2, n4)) <= 0) continue;
                n2 += n3;
            } while (n3 > 0);
            if (n2 < byArray.length) {
                byte[] byArray3 = byArray;
                byArray = new byte[n2];
                System.arraycopy(byArray3, 0, byArray, 0, n2);
            }
        } else {
            byArray = new byte[n];
            int n5 = 0;
            int n6 = 0;
            while (n6 != -1 && n5 != n) {
                n6 = inputStream.read(byArray, n5 += n6, n - n5);
            }
        }
        return byArray;
    }

    public File verifyWorkingDirectory(ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        IPath iPath = this.getWorkingDirectoryPath(iLaunchConfiguration);
        if (iPath == null) {
            String string = JavaRuntime.getProjectOutputDirectory((ILaunchConfiguration)iLaunchConfiguration);
            if (string == null) {
                return new File(System.getProperty("user.dir"));
            }
            IResource iResource = ResourcesPlugin.getWorkspace().getRoot().findMember(string);
            if (iResource == null || !iResource.exists()) {
                return new File(System.getProperty("user.dir"));
            }
            return iResource.getLocation().toFile();
        }
        if (iPath.isAbsolute()) {
            File file = new File(iPath.toOSString());
            if (file.isDirectory()) {
                return file;
            }
            this.abort(MessageFormat.format((String)LaunchingMessages.getString((String)"AbstractJavaLaunchConfigurationDelegate.Working_directory_does_not_exist__{0}_12"), (Object[])new String[]{iPath.toString()}), null, 108);
        } else {
            IResource iResource = ResourcesPlugin.getWorkspace().getRoot().findMember(iPath);
            if (iResource instanceof IContainer && iResource.exists()) {
                return iResource.getLocation().toFile();
            }
            this.abort(MessageFormat.format((String)LaunchingMessages.getString((String)"AbstractJavaLaunchConfigurationDelegate.Working_directory_does_not_exist__{0}_12"), (Object[])new String[]{iPath.toString()}), null, 108);
        }
        return null;
    }

    private String getClasspathString(ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        String string = iLaunchConfiguration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_CLASSPATH, (String)null);
        if (string == null) {
            StringBuffer stringBuffer = new StringBuffer();
            String[] stringArray = this.getClasspath(iLaunchConfiguration);
            int n = 0;
            while (n < stringArray.length - 1) {
                stringBuffer.append(stringArray[n]);
                stringBuffer.append(File.pathSeparatorChar);
                ++n;
            }
            stringBuffer.append(stringArray[stringArray.length - 1]);
            return stringBuffer.toString();
        }
        return string;
    }
}

