/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.launcher;

import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.hyades.trace.internal.ui.PDPluginImages;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.TraceProfileCollectionsUI;
import org.eclipse.hyades.trace.ui.internal.launcher.IProfileLaunchConfigurationConstants;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfileTab;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Listener;

public class ProfileLimitsTab {
    private TraceProfileCollectionsUI _limitsUI;
    private ProfileTab parentTab;

    public ProfileLimitsTab(ProfileTab profileTab, boolean bl) {
        this._limitsUI = new TraceProfileCollectionsUI(bl);
        this.parentTab = profileTab;
    }

    public Composite createControl(Composite composite) {
        return this._limitsUI.createControl(composite);
    }

    public void addListener(Listener listener) {
        this._limitsUI.addListener(listener);
    }

    public void initializeFrom(ILaunchConfiguration iLaunchConfiguration) {
        IPreferenceStore iPreferenceStore = UIPlugin.getDefault().getPreferenceStore();
        try {
            this._limitsUI.setLimitInvocations(iLaunchConfiguration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILING_LIMIT_INVOCATIONS, iPreferenceStore.getBoolean("limitInvoc")));
            this._limitsUI.setLimitInvocNb(String.valueOf(iLaunchConfiguration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILING_LIMIT_INVOCATIONS_NUM, iPreferenceStore.getInt("invoc_nb"))));
            this._limitsUI.setLimitTime(iLaunchConfiguration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILING_LIMIT_SECONDS, iPreferenceStore.getBoolean("limitTime")));
            this._limitsUI.setLimitTimeNb(String.valueOf(iLaunchConfiguration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILING_LIMIT_SECONDS_NUM, iPreferenceStore.getInt("timeSec"))));
            this._limitsUI.setAutoMonitoring(iLaunchConfiguration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_AUTO_MONITORING, iPreferenceStore.getBoolean("prof_auto_monitor")));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        iLaunchConfigurationWorkingCopy.setAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILING_LIMIT_INVOCATIONS, this._limitsUI.getLimitInvocations());
        iLaunchConfigurationWorkingCopy.setAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILING_LIMIT_INVOCATIONS_NUM, this._limitsUI.getLimitInvocNb());
        iLaunchConfigurationWorkingCopy.setAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILING_LIMIT_SECONDS, this._limitsUI.getLimitTime());
        iLaunchConfigurationWorkingCopy.setAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILING_LIMIT_SECONDS_NUM, this._limitsUI.getLimitTimeNb());
        iLaunchConfigurationWorkingCopy.setAttribute(IProfileLaunchConfigurationConstants.ATTR_AUTO_MONITORING, this._limitsUI.getAutoMonitoring());
    }

    public boolean isValid(ILaunchConfiguration iLaunchConfiguration) {
        int n;
        this.parentTab.setErrorMessage(null);
        this.parentTab.setMessage(null);
        try {
            if (this._limitsUI.getLimitInvocations() && (n = this._limitsUI.getLimitInvocNb()) < 1) {
                this.parentTab.setErrorMessage(UIPlugin.getResourceString("TAB_ERROR_LIMITS_INVOCATIONS"));
                return false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.parentTab.setErrorMessage(UIPlugin.getResourceString("TAB_ERROR_LIMITS_INVOCATIONS"));
            return false;
        }
        try {
            if (this._limitsUI.getLimitTime() && (n = this._limitsUI.getLimitTimeNb()) < 1) {
                this.parentTab.setErrorMessage(UIPlugin.getResourceString("TAB_ERROR_LIMITS_TIME"));
                return false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.parentTab.setErrorMessage(UIPlugin.getResourceString("TAB_ERROR_LIMITS_TIME"));
            return false;
        }
        return true;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        IPreferenceStore iPreferenceStore = UIPlugin.getDefault().getPreferenceStore();
        iLaunchConfigurationWorkingCopy.setAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILING_LIMIT_INVOCATIONS, iPreferenceStore.getBoolean("limitInvoc"));
        iLaunchConfigurationWorkingCopy.setAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILING_LIMIT_INVOCATIONS_NUM, iPreferenceStore.getInt("invoc_nb"));
        iLaunchConfigurationWorkingCopy.setAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILING_LIMIT_SECONDS, iPreferenceStore.getBoolean("limitTime"));
        iLaunchConfigurationWorkingCopy.setAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILING_LIMIT_SECONDS_NUM, iPreferenceStore.getInt("timeSec"));
        iLaunchConfigurationWorkingCopy.setAttribute(IProfileLaunchConfigurationConstants.ATTR_AUTO_MONITORING, iPreferenceStore.getBoolean("prof_auto_monitor"));
    }

    public String getName() {
        return UIPlugin.getResourceString("TAB_NAME_LIMITS");
    }

    public Image getImage() {
        return PDPluginImages.getImage("options_obj.gif");
    }
}

