/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.launcher;

import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.trace.ui.DefaultPage;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.TraceProfileOverviewUI;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfileAttachDelegate;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfileTab;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.part.PageBook;

public class ProfileOverviewTab {
    private TraceProfileOverviewUI _overviewUI;
    private PageBook _book;
    private Composite _ui;
    private Composite _blank;

    public ProfileOverviewTab(ProfileTab profileTab) {
        this._overviewUI = new TraceProfileOverviewUI(profileTab);
    }

    public Composite createControl(Composite composite) {
        this._book = new PageBook(composite, 0);
        this._ui = this._overviewUI.createControl((Composite)this._book);
        DefaultPage defaultPage = new DefaultPage();
        defaultPage.setMessage(UIPlugin.getResourceString("STR_OPTION_IGNORED"));
        defaultPage.createControl((Composite)this._book);
        this._blank = (Composite)defaultPage.getControl();
        return this._book;
    }

    public void addListener(Listener listener) {
        this._overviewUI.addListener(listener);
    }

    public void initializeFrom(ILaunchConfiguration iLaunchConfiguration) {
        if (ProfileOverviewTab.optionsAllowed(iLaunchConfiguration)) {
            this._overviewUI.initializeFrom(iLaunchConfiguration);
            this._book.showPage((Control)this._ui);
        } else {
            this._book.showPage((Control)this._blank);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        this._overviewUI.performApply(iLaunchConfigurationWorkingCopy);
    }

    public void performApply(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy, boolean bl) {
        this.performApply(iLaunchConfigurationWorkingCopy);
        if (bl) {
            this.initializeFrom((ILaunchConfiguration)iLaunchConfigurationWorkingCopy);
        }
    }

    public boolean isValid(ILaunchConfiguration iLaunchConfiguration) {
        return this._overviewUI.isValid(iLaunchConfiguration);
    }

    private static boolean optionsAllowed(ILaunchConfiguration iLaunchConfiguration) {
        try {
            if (iLaunchConfiguration.getType().getIdentifier().equals("org.eclipse.hyades.trace.ui.internal.launcher.localJavaProcess")) {
                boolean bl = false;
                boolean bl2 = false;
                Iterator iterator = ProfileAttachDelegate.getAgents(iLaunchConfiguration).iterator();
                while (iterator.hasNext()) {
                    Agent agent = (Agent)iterator.next();
                    if (!agent.getType().equals("Profiler")) continue;
                    if (agent.getName().equals("J2EE Request Profiler")) {
                        bl = true;
                        continue;
                    }
                    bl2 = true;
                }
                return bl2 || !bl;
            }
        }
        catch (CoreException coreException) {
            HyadesUIPlugin.logError((Throwable)coreException);
        }
        return true;
    }
}

