/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.launcher.defaults;

import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.WorkbenchHelp;

public class ExecutionTimeUI
implements SelectionListener {
    private Composite _detailsHeapGroup;
    private Button _showHeapInstance;
    private Button _boundary;
    private Label _traceDepthLabel;
    private Text _traceDepth;
    private Composite _detailsExecGroup;
    private Button _showExecStatistic;
    private Button _showExecFlow;
    private Label titleLabel;
    private Label optionsLabel;

    public Composite createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.verticalSpacing = 2;
        GridData gridData = GridUtil.createFill();
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)gridData);
        this.titleLabel = new Label(composite2, 0);
        this.titleLabel.setText(UIPlugin.getResourceString("executionGroup"));
        this.titleLabel.setLayoutData((Object)GridUtil.createHorizontalFill());
        this.titleLabel.setBackground(new Color(null, 255, 255, 255));
        this.titleLabel.setFont(new Font(null, "Arial", 13, 1));
        new Label(composite2, 0);
        this.optionsLabel = new Label(composite2, 64);
        this.optionsLabel.setText(UIPlugin.getResourceString("STR_ANALYZE_EXE_TIME"));
        gridData = new GridData();
        gridData.horizontalIndent = 20;
        gridData.widthHint = 375;
        this.optionsLabel.setLayoutData((Object)gridData);
        Composite composite3 = new Composite(composite2, 0);
        gridData = GridUtil.createHorizontalFill();
        gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        composite3.setLayout((Layout)gridLayout);
        composite3.setLayoutData((Object)gridData);
        this.addHeapOption(composite3);
        this.addExecutionOption(composite3);
        this._detailsHeapGroup.setVisible(true);
        this._detailsExecGroup.setVisible(true);
        this._traceDepth.setEnabled(this._boundary.getSelection());
        return composite2;
    }

    public void enableButtons() {
        this._traceDepth.setEnabled(this._boundary.getSelection());
        this.enableHeapInstance(this._showExecFlow.getSelection());
    }

    private void addHeapOption(Composite composite) {
        this._detailsHeapGroup = new Composite(composite, 0);
        GridData gridData = GridUtil.createHorizontalFill();
        gridData.horizontalIndent = 20;
        this._detailsHeapGroup.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        this._detailsHeapGroup.setLayout((Layout)gridLayout);
        this._showHeapInstance = new Button(this._detailsHeapGroup, 32);
        this._showHeapInstance.setText(UIPlugin.getResourceString("STR_SHOW_INST_LEVEL_INFO"));
        WorkbenchHelp.setHelp((Control)this._showHeapInstance, (String)(UIPlugin.getPluginId() + ".topp0011"));
    }

    private void addExecutionOption(Composite composite) {
        this._detailsExecGroup = new Composite(composite, 0);
        GridData gridData = GridUtil.createHorizontalFill();
        gridData.horizontalIndent = 20;
        this._detailsExecGroup.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this._detailsExecGroup.setLayout((Layout)gridLayout);
        this._boundary = new Button(this._detailsExecGroup, 32);
        gridData = GridUtil.createHorizontalFill();
        gridData.horizontalSpan = 2;
        this._boundary.setLayoutData((Object)gridData);
        this._boundary.setText(UIPlugin.getResourceString("AGENT_UI_BOUNDARY_CLASS"));
        this._traceDepthLabel = new Label(this._detailsExecGroup, 0);
        this._traceDepthLabel.setText(UIPlugin.getResourceString("STR_COLLECT_DEPTH"));
        this._traceDepth = new Text(this._detailsExecGroup, 2048);
        gridData = new GridData();
        gridData.widthHint = 70;
        this._traceDepth.setLayoutData((Object)gridData);
        Group group = new Group(this._detailsExecGroup, 0);
        gridData = GridUtil.createHorizontalFill();
        gridData.horizontalSpan = 2;
        group.setLayoutData((Object)gridData);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        group.setLayout((Layout)gridLayout);
        this._showExecStatistic = new Button((Composite)group, 16);
        this._showExecStatistic.setText(UIPlugin.getResourceString("EXEC_STAT"));
        this._showExecFlow = new Button((Composite)group, 16);
        this._showExecFlow.setText(UIPlugin.getResourceString("DETAILED_DATA"));
        this._boundary.addSelectionListener((SelectionListener)this);
        this._showExecStatistic.addSelectionListener((SelectionListener)this);
        this._showExecFlow.addSelectionListener((SelectionListener)this);
        WorkbenchHelp.setHelp((Control)this._boundary, (String)(UIPlugin.getPluginId() + ".topp0002"));
        WorkbenchHelp.setHelp((Control)this._traceDepth, (String)(UIPlugin.getPluginId() + ".topp0008"));
        WorkbenchHelp.setHelp((Control)group, (String)(UIPlugin.getPluginId() + ".topp0009"));
    }

    public void enable(boolean bl) {
        this.enableExecutionButtons(true);
    }

    public void enableExecutionButtons(boolean bl) {
        this._boundary.setEnabled(bl);
        this._traceDepth.setEnabled(bl);
        this._traceDepthLabel.setEnabled(bl);
        this._showExecStatistic.setEnabled(bl);
        this._showExecFlow.setEnabled(bl);
    }

    public void enableBtnGroup() {
        this.enableExecutionBtnGroup();
    }

    private void enableExecutionBtnGroup() {
        this._boundary.setEnabled(true);
        this._showExecFlow.setEnabled(true);
        this._showExecStatistic.setEnabled(true);
        this._traceDepth.setEnabled(this._boundary.getSelection());
        this._traceDepthLabel.setEnabled(this._boundary.getSelection());
    }

    private boolean checkValidTraceDepth() {
        if (this._boundary.getSelection()) {
            String string = this._traceDepth.getText().trim();
            try {
                if (Integer.parseInt(string) <= 0) {
                    return false;
                }
            }
            catch (Exception exception) {
                return false;
            }
        }
        return true;
    }

    public boolean getExecutionStatistic() {
        return this._showExecStatistic.getSelection();
    }

    public boolean getExecutionFlow() {
        return this._showExecFlow.getSelection();
    }

    public boolean getExecutionBoundary() {
        return this._boundary.getSelection();
    }

    public boolean getInstance() {
        return this._showHeapInstance.getSelection();
    }

    public void setInstance(boolean bl) {
        this._showHeapInstance.setSelection(bl);
    }

    public int getCollectionDepth() {
        String string = this._traceDepth.getText().trim();
        try {
            int n = Integer.parseInt(string);
            if (n > 0) {
                return n;
            }
            return UIPlugin.getDefault().getPreferenceStore().getDefaultInt("collect_depth");
        }
        catch (Exception exception) {
            return UIPlugin.getDefault().getPreferenceStore().getDefaultInt("collect_depth");
        }
    }

    public void setExecutionStatistic(boolean bl) {
        this._showExecStatistic.setSelection(bl);
    }

    public void setExecutionFlow(boolean bl) {
        this._showExecFlow.setSelection(bl);
    }

    public void setExecutionBoundary(boolean bl) {
        this._boundary.setSelection(bl);
        this._traceDepth.setEnabled(this._boundary.getSelection());
        this._traceDepthLabel.setEnabled(this._boundary.getSelection());
    }

    public void setCollectionDepth(String string) {
        this._traceDepth.setText(string);
    }

    public void enableHeapInstance(boolean bl) {
        if (!bl) {
            this._showHeapInstance.setSelection(bl);
        }
        this._showHeapInstance.setEnabled(bl);
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        if (selectionEvent.widget == this._boundary) {
            this._traceDepth.setEnabled(this._boundary.getSelection());
            this._traceDepthLabel.setEnabled(this._boundary.getSelection());
        } else if (selectionEvent.widget == this._showExecStatistic) {
            this.enableHeapInstance(this._showExecFlow.getSelection());
        } else if (selectionEvent.widget == this._showExecFlow) {
            this.enableHeapInstance(this._showExecFlow.getSelection());
        }
    }
}

