/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.navigator;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCConfiguration;
import org.eclipse.hyades.models.hierarchy.TRCOption;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.navigator.ProfileDetailItem;
import org.eclipse.hyades.ui.extension.INavigatorContribution;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;

public class ProfileDetailNavigatorExtension
implements INavigatorContribution {
    protected static final String getProfilingTypesExtPoint = "profilingTypes";
    private static Map profilingTypes;

    public boolean hasChildren(Object object) {
        return object instanceof TRCAgentProxy;
    }

    public List getChildren(Object object) {
        if (object instanceof TRCAgentProxy) {
            return this.getProfileDetailItems((TRCAgentProxy)object);
        }
        return new ArrayList(0);
    }

    public Collection getModifiedItems() {
        return new ArrayList(0);
    }

    public void fillContextMenu(IMenuManager iMenuManager, IStructuredSelection iStructuredSelection) {
    }

    private List getProfileDetailItems(TRCAgentProxy tRCAgentProxy) {
        Vector<ProfileDetailItem> vector = new Vector<ProfileDetailItem>();
        if (profilingTypes == null) {
            this.initializeProfilingTypes();
        }
        EList eList = tRCAgentProxy.getConfigurations();
        int n = 0;
        while (n < eList.size()) {
            TRCConfiguration tRCConfiguration = (TRCConfiguration)eList.get(n);
            EList eList2 = tRCConfiguration.getOptions();
            int n2 = 0;
            while (n2 < eList2.size()) {
                TRCOption tRCOption = (TRCOption)eList2.get(n2);
                if (tRCOption.getKey().startsWith(UIPlugin.getPluginId() + ".type") && tRCOption.getValue().length() > 0) {
                    vector.add(this.createProfileDetailItem(tRCAgentProxy, tRCOption.getValue()));
                }
                ++n2;
            }
            if (vector.size() > 0) break;
            ++n;
        }
        return vector;
    }

    private ProfileDetailItem createProfileDetailItem(TRCAgentProxy tRCAgentProxy, String string) {
        IConfigurationElement iConfigurationElement = (IConfigurationElement)profilingTypes.get(string);
        URL uRL = iConfigurationElement.getDeclaringExtension().getDeclaringPluginDescriptor().find((IPath)new Path(iConfigurationElement.getAttribute("icon")));
        if (iConfigurationElement == null) {
            return null;
        }
        return new ProfileDetailItem(tRCAgentProxy, iConfigurationElement.getAttribute("name"), uRL);
    }

    private void initializeProfilingTypes() {
        profilingTypes = new HashMap();
        IExtensionPoint iExtensionPoint = UIPlugin.getDefault().getDescriptor().getExtensionPoint(getProfilingTypesExtPoint);
        if (iExtensionPoint != null) {
            IConfigurationElement[] iConfigurationElementArray = iExtensionPoint.getConfigurationElements();
            int n = 0;
            while (n < iConfigurationElementArray.length) {
                IConfigurationElement iConfigurationElement = iConfigurationElementArray[n];
                String string = iConfigurationElement.getAttribute("id");
                if (string.length() != 0) {
                    profilingTypes.put(string, iConfigurationElement);
                }
                ++n;
            }
        }
    }

    public void dispose() {
    }
}

