/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.util;

import java.util.StringTokenizer;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.WorkbenchHelp;

public class CorrelationUI
implements SelectionListener {
    private IExtension[] extensions;
    private Table correlationNames;
    private Text correlationDescription;
    private Text logTypesArea;
    private IConfigurationElement correlation;
    private String sHelpContext;

    public CorrelationUI(IExtension[] iExtensionArray, String string) {
        this.extensions = iExtensionArray;
        this.sHelpContext = string;
    }

    public Control createControl(Composite composite) {
        int n = 3;
        Composite composite2 = new Composite(composite, 16);
        GridData gridData = GridUtil.createFill();
        gridData.widthHint = 370;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)gridData);
        Label label = new Label(composite2, 0);
        label.setText(UIPlugin.getResourceString("STR_CHOOSE_CORRELATION"));
        Composite composite3 = new Composite(composite2, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.verticalSpacing = 5;
        composite3.setLayout((Layout)gridLayout);
        GridData gridData2 = new GridData(768);
        gridData2.horizontalIndent = n;
        composite3.setLayoutData((Object)gridData2);
        Label label2 = new Label(composite3, 0);
        label2.setText(UIPlugin.getResourceString("STR_CORRELATION_SCHEMAS"));
        gridData2 = new GridData(768);
        this.correlationNames = new Table(composite3, 2820);
        gridData2.heightHint = this.correlationNames.getItemHeight() * 4;
        this.correlationNames.setLayoutData((Object)gridData2);
        this.correlationNames.addSelectionListener((SelectionListener)this);
        Label label3 = new Label(composite3, 0);
        label3.setText(UIPlugin.getResourceString("STR_LOG_TYPES"));
        this.logTypesArea = new Text(composite3, 2826);
        this.logTypesArea.setLayoutData((Object)GridUtil.createFill());
        Composite composite4 = new Composite(composite2, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.verticalSpacing = 5;
        composite4.setLayout((Layout)gridLayout);
        gridData2 = new GridData(768);
        gridData2.horizontalIndent = n;
        composite4.setLayoutData((Object)gridData2);
        Label label4 = new Label(composite4, 0);
        label4.setText(UIPlugin.getResourceString("STR_CORRELATION_DESCRIPTION"));
        label4.setLayoutData((Object)new GridData(34));
        this.correlationDescription = new Text(composite4, 74);
        GridData gridData3 = GridUtil.createHorizontalFill();
        gridData3.heightHint = this.correlationDescription.getLineHeight() * 3;
        this.correlationDescription.setLayoutData((Object)gridData3);
        this.initializeCorrelations();
        WorkbenchHelp.setHelp((Control)composite2, (String)this.sHelpContext);
        return composite2;
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        if (selectionEvent.widget == this.correlationNames) {
            this.selectCorrelation(this.correlationNames.getSelectionIndex());
        }
        this.setCorrelation(this.getSelectedCorrelation());
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    public IConfigurationElement getSelectedCorrelation() {
        return (IConfigurationElement)this.correlationNames.getItem(this.correlationNames.getSelectionIndex()).getData();
    }

    private void initializeCorrelations() {
        int n = 0;
        while (n < this.extensions.length) {
            IConfigurationElement[] iConfigurationElementArray = this.extensions[n].getConfigurationElements();
            int n2 = 0;
            while (n2 < iConfigurationElementArray.length) {
                IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
                if ("view".equals(iConfigurationElement.getName())) {
                    TableItem tableItem = new TableItem(this.correlationNames, 0);
                    tableItem.setText(iConfigurationElement.getAttribute("name"));
                    tableItem.setData((Object)iConfigurationElement);
                }
                ++n2;
            }
            ++n;
        }
        this.correlationNames.setSelection(0);
        this.selectCorrelation(0);
        this.setCorrelation(this.getSelectedCorrelation());
    }

    public void selectCorrelation(int n) {
        String string = "";
        if (n < 0 || n >= this.correlationNames.getItemCount()) {
            return;
        }
        this.logTypesArea.setText("");
        IConfigurationElement iConfigurationElement = (IConfigurationElement)this.correlationNames.getItem(n).getData();
        if (iConfigurationElement != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(iConfigurationElement.getAttribute("log_types"), ",", false);
            this.logTypesArea.setText("");
            string = "";
            while (stringTokenizer.hasMoreTokens()) {
                string = string + stringTokenizer.nextToken() + "\n";
            }
            this.logTypesArea.setText(string);
        }
        this.correlationDescription.setText(iConfigurationElement.getAttribute("description"));
    }

    public IConfigurationElement getCorrelation() {
        return this.correlation;
    }

    public Text getCorrelationDescription() {
        return this.correlationDescription;
    }

    public Table getCorrelationNames() {
        return this.correlationNames;
    }

    public void setCorrelation(IConfigurationElement iConfigurationElement) {
        this.correlation = iConfigurationElement;
    }
}

