/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.util;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.Process;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.AbstractChangeable;
import org.eclipse.hyades.trace.ui.internal.util.CTree;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TreeItem;

public class DoubleCTree
extends AbstractChangeable {
    Composite _group;
    Composite groupWidget;
    public CTree sourceList;
    public CTree targetList;
    private CTree selectedList;
    public Label targetListLabel;
    public Label sourceListLabel;
    public Button add;
    public Button remove;
    public Button addAll;
    public Button removeAll;
    public Vector agentSelected = new Vector();
    private WizardPage _wizardPage;

    public void setSelectedAgents(Vector vector) {
        this.agentSelected = vector;
        this.updateSelectedTree(vector);
        this.changed();
    }

    private void updateSelectedTree(Vector vector) {
        TreeItem[] treeItemArray = this.sourceList.getTree().getItems();
        int n = 0;
        while (n < treeItemArray.length) {
            TreeItem treeItem = treeItemArray[n];
            if (treeItem.getData() instanceof Process) {
                TreeItem[] treeItemArray2 = treeItem.getItems();
                int n2 = 0;
                while (n2 < treeItemArray2.length) {
                    Agent agent;
                    if (treeItemArray2[n2].getData() instanceof Agent && this.IsAgentSelected(agent = (Agent)treeItemArray2[n2].getData(), vector)) {
                        this.moveFromSourceToTarget(treeItemArray2[n2]);
                    }
                    ++n2;
                }
            }
            ++n;
        }
    }

    private void moveFromSourceToTarget(TreeItem treeItem) {
        this.targetList.addItem(treeItem, true);
        this.sourceList.remove(treeItem);
    }

    private boolean IsAgentSelected(Agent agent, Vector vector) {
        int n = 0;
        while (n < vector.size()) {
            if (agent == (Agent)vector.elementAt(n)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void addAgentToSelectList(TreeItem treeItem) {
        if (treeItem.getParentItem() != null) {
            this.addAgentSelected(treeItem);
        } else {
            TreeItem[] treeItemArray = treeItem.getItems();
            int n = 0;
            while (n < treeItemArray.length) {
                this.addAgentSelected(treeItemArray[n]);
                ++n;
            }
        }
    }

    public void removeAgentFromSelectList(TreeItem treeItem) {
        if (treeItem.getParentItem() != null) {
            this.removeAgentSelected(treeItem);
        } else {
            TreeItem[] treeItemArray = treeItem.getItems();
            int n = 0;
            while (n < treeItemArray.length) {
                this.removeAgentSelected(treeItemArray[n]);
                ++n;
            }
        }
    }

    private boolean vaildItemtoAdd(TreeItem treeItem) {
        return !treeItem.isDisposed() && treeItem != null && (treeItem.getParentItem() == null || !treeItem.getParentItem().isDisposed());
    }

    public void addAgentSelected(TreeItem treeItem) {
        Agent agent = (Agent)treeItem.getData();
        if (!this.agentSelected.contains(agent)) {
            this.agentSelected.add(agent);
        }
    }

    public void removeAgentSelected(TreeItem treeItem) {
        Agent agent = (Agent)treeItem.getData();
        if (this.agentSelected.contains(agent)) {
            this.agentSelected.remove(agent);
        }
    }

    public void setWizardPage(WizardPage wizardPage) {
        this._wizardPage = wizardPage;
    }

    public DoubleCTree(Composite composite, int n, String string, String string2, String string3) {
        this._group = new Composite(composite, n);
        GridLayout gridLayout = new GridLayout();
        gridLayout.verticalSpacing = -10;
        gridLayout.horizontalSpacing = 0;
        this._group.setLayout((Layout)gridLayout);
        this._group.setLayoutData((Object)GridUtil.createFill());
        this.createDoubleTree(this._group, string2, string3);
        this.add.addListener(13, (Listener)new ButtonListener());
        this.remove.addListener(13, (Listener)new ButtonListener());
        this.addAll.addListener(13, (Listener)new ButtonListener());
        this.removeAll.addListener(13, (Listener)new ButtonListener());
        this.sourceList.getTree().addSelectionListener((SelectionListener)new TreeSelListener());
        this.targetList.getTree().addSelectionListener((SelectionListener)new TreeSelListener());
    }

    public void createDoubleTree(Composite composite, String string, String string2) {
        this.groupWidget = composite;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        this.groupWidget.setLayout((Layout)gridLayout);
        this.sourceList = new CTree(this.groupWidget, string);
        this.sourceList.getTree().setLayoutData((Object)GridUtil.createFill());
        Composite composite2 = new Composite(this.groupWidget, 0);
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.numColumns = 1;
        composite2.setLayout((Layout)gridLayout2);
        Label label = new Label(composite2, 8);
        label.setText("");
        GridData gridData = new GridData();
        gridData.grabExcessVerticalSpace = true;
        gridData.verticalAlignment = 4;
        label.setLayoutData((Object)gridData);
        this.add = new Button(composite2, 8);
        this.add.setText(UIPlugin.getResourceString("LEFT_TO_RIGHT"));
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        this.add.setLayoutData((Object)gridData);
        this.remove = new Button(composite2, 8);
        this.remove.setText(UIPlugin.getResourceString("RIGHT_TO_LEFT"));
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        this.remove.setLayoutData((Object)gridData);
        new Label(composite2, 0);
        this.addAll = new Button(composite2, 8);
        this.addAll.setText(UIPlugin.getResourceString("LEFT_ALL_TO_RIGHT"));
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        this.addAll.setLayoutData((Object)gridData);
        this.removeAll = new Button(composite2, 8);
        this.removeAll.setText(UIPlugin.getResourceString("RIGHT_ALL_TO_LEFT"));
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        this.removeAll.setLayoutData((Object)gridData);
        Label label2 = new Label(composite2, 8);
        label2.setText("");
        gridData = new GridData();
        gridData.grabExcessVerticalSpace = true;
        gridData.verticalAlignment = 4;
        label.setLayoutData((Object)gridData);
        this.targetList = new CTree(this.groupWidget, string2);
        this.targetList.getTree().setLayoutData((Object)GridUtil.createFill());
    }

    public void enable(boolean bl) {
        this._group.setEnabled(bl);
        this.add.setEnabled(bl);
        this.addAll.setEnabled(bl);
        this.remove.setEnabled(bl);
        this.removeAll.setEnabled(bl);
        this.sourceList.enable(bl);
        this.targetList.enable(bl);
    }

    public Control getControl() {
        return this._group;
    }

    private Vector getItems(CTree cTree) {
        Vector<TreeItem> vector = new Vector<TreeItem>();
        int n = 0;
        while (n < cTree.getTree().getItemCount()) {
            TreeItem treeItem = cTree.getItem(n);
            if (treeItem != null) {
                vector.addElement(treeItem);
            }
            ++n;
        }
        return vector;
    }

    public Vector getSelectedAgents() {
        return this.agentSelected;
    }

    public Vector getSourceItems() {
        return this.getItems(this.sourceList);
    }

    public Vector getTargetItems() {
        return this.getItems(this.targetList);
    }

    public String getText() {
        return this.getTargetItems().toString();
    }

    public Composite getWidget() {
        return this.groupWidget;
    }

    public void initialize(Enumeration enumeration, boolean bl) {
        this.initialize(enumeration, bl, false);
    }

    /*
     * Unable to fully structure code
     */
    public void initialize(Enumeration var1_1, boolean var2_2, boolean var3_3) {
        block9: {
            block10: {
                block8: {
                    if (var1_1 != null) break block8;
                    this.sourceList.initializeTree(null, var2_2, var3_3);
                    this.targetList.initializeTree(null, var2_2, var3_3);
                    break block9;
                }
                if (this.targetList.getItemCount() != 0) break block10;
                this.sourceList.initializeTree(var1_1, var2_2, var3_3);
                this.targetList.initializeTree(null, var2_2, var3_3);
                break block9;
            }
            var4_4 = new Vector<String>();
            while (var1_1.hasMoreElements()) {
                block11: {
                    var5_5 = (Process)var1_1.nextElement();
                    var6_6 = var5_5.listAgents();
                    var7_7 = null;
                    try {
                        var7_7 = var5_5.getProcessId();
                        var4_4.add(var7_7);
                    }
                    catch (Exception var8_9) {
                        System.out.println("null pid");
                    }
                    var8_8 = this.getItemFromTree(this.sourceList, var5_5);
                    var9_10 = this.getItemFromTree(this.targetList, var5_5);
                    if (var8_8 == null) break block11;
                    if (var9_10 == null) ** GOTO lbl39
                    while (var6_6.hasMoreElements()) {
                        var10_11 = (Agent)var6_6.nextElement();
                        var11_12 = this.getAgentItem(var9_10, var10_11);
                        if (var11_12 != null || (var11_12 = this.getAgentItem(var8_8, var10_11)) != null) continue;
                        this.createItemInSourceList(var8_8, var10_11, var3_3);
                    }
                    this.removeAgentsInLists(var5_5, var9_10, var8_8);
                    continue;
lbl-1000:
                    // 1 sources

                    {
                        var10_11 = (Agent)var6_6.nextElement();
                        var11_12 = this.getAgentItem(var8_8, var10_11);
                        if (var11_12 != null) continue;
                        this.createItemInSourceList(var8_8, var10_11, var3_3);
lbl39:
                        // 3 sources

                        ** while (var6_6.hasMoreElements())
                    }
lbl40:
                    // 1 sources

                    this.removeAgentsInLists(var5_5, var9_10, var8_8);
                    continue;
                }
                if (var9_10 != null) {
                    var10_11 = null;
                    while (var6_6.hasMoreElements()) {
                        var11_12 = (Agent)var6_6.nextElement();
                        var12_13 = this.getAgentItem(var9_10, var11_12);
                        if (var12_13 != null) continue;
                        if (var10_11 == null) {
                            var10_11 = this.sourceList.createItem(null, var5_5, false);
                        }
                        this.createItemInSourceList((TreeItem)var10_11, var11_12, var3_3);
                    }
                    this.removeAgentsInLists(var5_5, var9_10, var8_8);
                    continue;
                }
                this.sourceList.addProcessToTree(var5_5, var2_2, var3_3);
            }
            this.cleanUpSourceList(var4_4);
            this.cleanUpTargetList(var4_4);
        }
    }

    private void removeAgentsInLists(Process process, TreeItem treeItem, TreeItem treeItem2) {
        int n;
        int n2;
        TreeItem[] treeItemArray;
        Agent agent = null;
        if (treeItem != null) {
            treeItemArray = treeItem.getItems();
            n2 = treeItemArray.length;
            n = 0;
            while (n < n2) {
                agent = this.findAgentInProcess(process, treeItemArray[n].getText());
                if (agent == null) {
                    this.targetList.remove(treeItemArray[n]);
                    this.removeAgentFromSelectList(treeItemArray[n]);
                }
                ++n;
            }
        }
        if (treeItem2 != null) {
            treeItemArray = treeItem2.getItems();
            n2 = treeItemArray.length;
            n = 0;
            while (n < n2) {
                agent = this.findAgentInProcess(process, treeItemArray[n].getText());
                if (agent == null) {
                    this.sourceList.remove(treeItemArray[n]);
                    this.removeAgentFromSelectList(treeItemArray[n]);
                }
                ++n;
            }
        }
    }

    public Agent findAgentInProcess(Process process, String string) {
        Enumeration enumeration = process.listAgents();
        Agent agent = null;
        while (enumeration.hasMoreElements()) {
            agent = (Agent)enumeration.nextElement();
            if (!agent.getName().equals(string)) continue;
            return agent;
        }
        return null;
    }

    private void createItemInSourceList(TreeItem treeItem, Agent agent, boolean bl) {
        boolean bl2 = UIPlugin.getDefault().getPreferenceStore().getBoolean("log_option");
        boolean bl3 = UIPlugin.getDefault().getPreferenceStore().getBoolean("prof_option");
        if (agent.isActive() && (bl || !agent.isAttached())) {
            if (bl2 && agent.getType().equals("Logging")) {
                this.sourceList.createItem(treeItem, agent, false);
            } else if (bl3 && agent.getType().equals("Profiler")) {
                this.sourceList.createItem(treeItem, agent, false);
            } else {
                ArrayList arrayList = this.sourceList.getAgentTypeList();
                int n = 0;
                while (n < arrayList.size()) {
                    if (!agent.getType().equals("Logging") && agent.getType().equals((String)arrayList.get(n))) {
                        this.sourceList.createItem(treeItem, agent, false);
                    }
                    ++n;
                }
            }
        }
    }

    public TreeItem getAgentItem(TreeItem treeItem, Agent agent) {
        TreeItem[] treeItemArray = treeItem.getItems();
        int n = 0;
        while (n < treeItemArray.length) {
            if (treeItemArray[n].getText().equals(agent.getName())) {
                return treeItemArray[n];
            }
            ++n;
        }
        return null;
    }

    public TreeItem getItemFromTree(CTree cTree, Object object) {
        int n = 0;
        while (n < cTree.getTree().getItemCount()) {
            try {
                TreeItem treeItem = cTree.getItem(n);
                if (this.parseProcessID(treeItem.getText()).equals(((Process)object).getProcessId())) {
                    return treeItem;
                }
            }
            catch (Exception exception) {
                System.out.println("null pid");
            }
            ++n;
        }
        return null;
    }

    private String parseProcessID(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(":");
        int n2 = string.indexOf("]");
        String string2 = string.substring(n + 1, n2);
        return string2;
    }

    private void cleanUpSourceList(Vector vector) {
        TreeItem[] treeItemArray = this.sourceList.getTree().getItems();
        Vector<TreeItem> vector2 = new Vector<TreeItem>();
        int n = 0;
        while (n < treeItemArray.length) {
            if (!vector.contains(this.parseProcessID(treeItemArray[n].getText()))) {
                vector2.add(treeItemArray[n]);
                this.removeAgentFromSelectList(treeItemArray[n]);
            }
            ++n;
        }
        this.removeFromTree(this.sourceList, vector2);
    }

    private void cleanUpTargetList(Vector vector) {
        TreeItem[] treeItemArray = this.targetList.getTree().getItems();
        Vector<TreeItem> vector2 = new Vector<TreeItem>();
        int n = 0;
        while (n < treeItemArray.length) {
            if (!vector.contains(this.parseProcessID(treeItemArray[n].getText()))) {
                vector2.add(treeItemArray[n]);
                this.removeAgentFromSelectList(treeItemArray[n]);
            }
            ++n;
        }
        this.removeFromTree(this.targetList, vector2);
    }

    private void removeFromTree(CTree cTree, Vector vector) {
        int n = 0;
        while (n < vector.size()) {
            cTree.remove((TreeItem)vector.elementAt(n));
            ++n;
        }
    }

    public void removeAll() {
        this.targetList.getTree().removeAll();
        this.sourceList.getTree().removeAll();
    }

    public void setEnabled(boolean bl) {
        this.targetList.getTree().setEnabled(bl);
        this.sourceList.getTree().setEnabled(bl);
    }

    public void setToolTipText(String string) {
        this.sourceList.setToolTipText(string);
        this.targetList.setToolTipText(string);
    }

    class ButtonListener
    implements Listener {
        ButtonListener() {
        }

        public void handleEvent(Event event) {
            if (event.widget == DoubleCTree.this.add) {
                DoubleCTree.this.targetList.getTree().setRedraw(false);
                DoubleCTree.this.sourceList.getTree().setRedraw(false);
                TreeItem[] treeItemArray = DoubleCTree.this.sourceList.getSelectedItems();
                int n = 0;
                while (n < treeItemArray.length) {
                    if (DoubleCTree.this.vaildItemtoAdd(treeItemArray[n])) {
                        DoubleCTree.this.addAgentToSelectList(treeItemArray[n]);
                        DoubleCTree.this.targetList.addItem(treeItemArray[n], true);
                        DoubleCTree.this.sourceList.remove(treeItemArray[n]);
                    }
                    ++n;
                }
                DoubleCTree.this.sourceList.clearSelection();
                if (DoubleCTree.this._wizardPage != null && DoubleCTree.this.agentSelected.size() > 0) {
                    DoubleCTree.this._wizardPage.setPageComplete(true);
                }
                DoubleCTree.this.targetList.getTree().setRedraw(true);
                DoubleCTree.this.sourceList.getTree().setRedraw(true);
            } else if (event.widget == DoubleCTree.this.addAll) {
                DoubleCTree.this.targetList.getTree().setRedraw(false);
                DoubleCTree.this.sourceList.getTree().setRedraw(false);
                int n = 0;
                while (n < DoubleCTree.this.sourceList.getTree().getItemCount()) {
                    TreeItem treeItem = DoubleCTree.this.sourceList.getItem(n);
                    if (DoubleCTree.this.vaildItemtoAdd(treeItem)) {
                        DoubleCTree.this.addAgentToSelectList(treeItem);
                        DoubleCTree.this.targetList.addItem(treeItem, false);
                    }
                    ++n;
                }
                DoubleCTree.this.sourceList.getTree().removeAll();
                DoubleCTree.this.targetList.getTree().selectAll();
                if (DoubleCTree.this._wizardPage != null && DoubleCTree.this.agentSelected.size() > 0) {
                    DoubleCTree.this._wizardPage.setPageComplete(true);
                }
                DoubleCTree.this.targetList.getTree().setRedraw(true);
                DoubleCTree.this.sourceList.getTree().setRedraw(true);
            } else if (event.widget == DoubleCTree.this.remove) {
                DoubleCTree.this.targetList.getTree().setRedraw(false);
                DoubleCTree.this.sourceList.getTree().setRedraw(false);
                TreeItem[] treeItemArray = DoubleCTree.this.targetList.getSelectedItems();
                int n = 0;
                while (n < treeItemArray.length) {
                    DoubleCTree.this.removeAgentFromSelectList(treeItemArray[n]);
                    DoubleCTree.this.sourceList.addItem(treeItemArray[n], false);
                    DoubleCTree.this.targetList.remove(treeItemArray[n]);
                    ++n;
                }
                DoubleCTree.this.targetList.clearSelection();
                if (DoubleCTree.this.agentSelected.size() == 0 && DoubleCTree.this._wizardPage != null) {
                    DoubleCTree.this._wizardPage.setPageComplete(false);
                }
                DoubleCTree.this.targetList.getTree().setRedraw(true);
                DoubleCTree.this.sourceList.getTree().setRedraw(true);
            } else if (event.widget == DoubleCTree.this.removeAll) {
                DoubleCTree.this.targetList.getTree().setRedraw(false);
                DoubleCTree.this.sourceList.getTree().setRedraw(false);
                int n = 0;
                while (n < DoubleCTree.this.targetList.getTree().getItemCount()) {
                    TreeItem treeItem = DoubleCTree.this.targetList.getItem(n);
                    DoubleCTree.this.removeAgentFromSelectList(treeItem);
                    DoubleCTree.this.sourceList.addItem(treeItem, false);
                    ++n;
                }
                DoubleCTree.this.targetList.getTree().removeAll();
                if (DoubleCTree.this._wizardPage != null) {
                    DoubleCTree.this._wizardPage.setPageComplete(false);
                }
                DoubleCTree.this.targetList.getTree().setRedraw(true);
                DoubleCTree.this.sourceList.getTree().setRedraw(true);
            }
            DoubleCTree.this.changed();
        }
    }

    class TreeSelListener
    implements SelectionListener {
        TreeSelListener() {
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            if (selectionEvent.widget == DoubleCTree.this.sourceList.getTree() && DoubleCTree.this.sourceList.getTree().getSelection().length != 0) {
                DoubleCTree.this.targetList.clearSelection();
            } else if (selectionEvent.widget == DoubleCTree.this.targetList.getTree() && DoubleCTree.this.targetList.getTree().getSelection().length != 0) {
                DoubleCTree.this.sourceList.clearSelection();
            }
        }

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            TreeItem[] treeItemArray;
            if (selectionEvent.widget == DoubleCTree.this.sourceList.getTree()) {
                TreeItem[] treeItemArray2 = DoubleCTree.this.sourceList.getSelectedItems();
                if (treeItemArray2.length > 0) {
                    int n = 0;
                    while (n < treeItemArray2.length) {
                        DoubleCTree.this.addAgentToSelectList(treeItemArray2[n]);
                        DoubleCTree.this.targetList.addItem(treeItemArray2[n], true);
                        DoubleCTree.this.sourceList.remove(treeItemArray2[n]);
                        DoubleCTree.this.sourceList.clearSelection();
                        ++n;
                    }
                    DoubleCTree.this.changed();
                }
            } else if (selectionEvent.widget == DoubleCTree.this.targetList.getTree() && (treeItemArray = DoubleCTree.this.targetList.getSelectedItems()).length > 0) {
                int n = 0;
                while (n < treeItemArray.length) {
                    DoubleCTree.this.removeAgentFromSelectList(treeItemArray[n]);
                    DoubleCTree.this.sourceList.addItem(treeItemArray[n], false);
                    DoubleCTree.this.targetList.remove(treeItemArray[n]);
                    DoubleCTree.this.targetList.clearSelection();
                    ++n;
                }
                DoubleCTree.this.changed();
            }
        }
    }
}

