/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.util;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.hyades.internal.execution.local.common.Console;
import org.eclipse.hyades.internal.execution.local.common.DataProcessor;
import org.eclipse.hyades.internal.execution.local.control.Process;

class IOProxy
implements IStreamsProxy,
IStreamMonitor,
DataProcessor {
    private List _listeners = new ArrayList();
    private StringBuffer _buffer = new StringBuffer();
    private Console _console;

    public IOProxy(Process process) {
        this._console = process.getConsole();
        this._console.setDataProcessor((DataProcessor)this);
    }

    public IStreamMonitor getErrorStreamMonitor() {
        return null;
    }

    public IStreamMonitor getOutputStreamMonitor() {
        return this;
    }

    public void write(String string) throws IOException {
        this._console.write(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(IStreamListener iStreamListener) {
        List list = this._listeners;
        synchronized (list) {
            this._listeners.add(iStreamListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(IStreamListener iStreamListener) {
        List list = this._listeners;
        synchronized (list) {
            this._listeners.remove(iStreamListener);
        }
    }

    public String getContents() {
        return this._buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incommingData(byte[] byArray, int n, InetAddress inetAddress) {
        try {
            String string = new String(byArray, 0, n, "UTF8");
            this._buffer.append(string);
            List list = this._listeners;
            synchronized (list) {
                Iterator iterator = this._listeners.iterator();
                while (iterator.hasNext()) {
                    ((IStreamListener)iterator.next()).streamAppended(string, (IStreamMonitor)this);
                }
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
    }

    public void incommingData(char[] cArray, int n, InetAddress inetAddress) {
        byte[] byArray = new String(cArray).getBytes();
        this.incommingData(byArray, byArray.length, inetAddress);
    }

    public void invalidDataType(byte[] byArray, int n, InetAddress inetAddress) {
    }

    public void waitingForData() {
    }
}

