/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.datapool.internal.dialog;

import java.text.MessageFormat;
import java.text.NumberFormat;
import org.eclipse.hyades.edit.datapool.IDatapool;
import org.eclipse.hyades.edit.datapool.IDatapoolVariable;
import org.eclipse.hyades.execution.runtime.datapool.IDatapoolSuggestedType;
import org.eclipse.hyades.test.ui.datapool.DatapoolPlugin;
import org.eclipse.hyades.test.ui.datapool.internal.util.DatapoolUtil;
import org.eclipse.hyades.test.ui.datapool.internal.util.GridDataUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class DatapoolColumnDialog
extends Dialog
implements KeyListener,
SelectionListener {
    private static final String TAG_VARIABLES = "variables";
    private static final int HEIGHT = 100;
    private static final int WIDTH = 400;
    private Shell shell = null;
    private IDatapool datapool = null;
    private String title = null;
    private IDatapoolVariable selectedVariable = null;
    private IDatapoolVariable previousVariable = null;
    private Text nameField = null;
    private Text typeField = null;
    private Color nameFieldForeground = null;
    private Color typeFieldForeground = null;
    private Combo insertionVariables = null;
    private Label errorLabel = null;
    private String name = null;
    private String type = new String();
    private String insertionVariableID = null;
    private String insertionVariableName = null;
    private int defaultNameCounter = 1;

    public DatapoolColumnDialog(Shell shell, IDatapool iDatapool, IDatapoolVariable iDatapoolVariable, IDatapoolVariable iDatapoolVariable2, String string) {
        super(shell);
        this.shell = shell;
        this.datapool = iDatapool;
        this.title = string;
        this.selectedVariable = iDatapoolVariable;
        this.previousVariable = iDatapoolVariable2;
    }

    protected Control createContents(Composite composite) {
        Control control = super.createContents(composite);
        this.enableOK();
        return control;
    }

    protected Control createDialogArea(Composite composite) {
        IDatapoolSuggestedType iDatapoolSuggestedType;
        this.getShell().setText(this.title);
        Composite composite2 = (Composite)super.createDialogArea(composite);
        GridData gridData = GridDataUtil.createFill();
        gridData.heightHint = 100;
        gridData.widthHint = 400;
        composite2.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        Label label = new Label(composite2, 0);
        label.setText(DatapoolPlugin.getResourceString("DATA_COL_DLG_NAME"));
        this.nameField = new Text(composite2, 2052);
        gridData = new GridData(256);
        gridData.horizontalSpan = 1;
        gridData.widthHint = 300;
        this.nameField.setLayoutData((Object)gridData);
        this.nameField.addKeyListener((KeyListener)this);
        this.nameFieldForeground = this.nameField.getForeground();
        Label label2 = new Label(composite2, 0);
        label2.setText(DatapoolPlugin.getResourceString("DATA_COL_DLG_TYPE"));
        this.typeField = new Text(composite2, 2052);
        gridData = new GridData(256);
        gridData.horizontalSpan = 1;
        this.typeField.setLayoutData((Object)gridData);
        this.typeField.addKeyListener((KeyListener)this);
        this.typeFieldForeground = this.typeField.getForeground();
        IDatapoolVariable[] iDatapoolVariableArray = DatapoolUtil.getInstance().getVariables(this.datapool, null);
        if (this.selectedVariable != null) {
            this.name = this.selectedVariable.getName();
            this.nameField.setText(this.name);
            this.nameField.setSelection(this.name.length() + 1);
            iDatapoolSuggestedType = this.selectedVariable.getSuggestedType();
            if (iDatapoolSuggestedType != null) {
                this.type = iDatapoolSuggestedType.getSuggestedClassName();
                if (this.type != null) {
                    this.typeField.setText(this.type);
                    this.typeField.setSelection(this.type.length() + 1);
                }
            }
        }
        iDatapoolSuggestedType = this.getVariableLabels(iDatapoolVariableArray);
        Label label3 = new Label(composite2, 0);
        if (this.title.equals(DatapoolPlugin.getResourceString("DATA_COL_DLG_TITLE_INS"))) {
            label3.setText(DatapoolPlugin.getResourceString("DATA_DLG_INS"));
            this.name = this.createDefaultName();
            while (!DatapoolUtil.getInstance().isVariableNameUnique(this.datapool, this.name, null)) {
                this.name = this.createDefaultName();
            }
            this.nameField.setText(this.name);
            this.nameField.setSelection(this.name.length() + 1);
        } else {
            label3.setText(DatapoolPlugin.getResourceString("DATA_DLG_MOVE"));
        }
        this.insertionVariables = new Combo(composite2, 12);
        this.insertionVariables.setItems((String[])iDatapoolSuggestedType);
        this.insertionVariables.setData(TAG_VARIABLES, (Object)iDatapoolVariableArray);
        this.insertionVariables.setLayoutData((Object)new GridData(256));
        this.insertionVariables.addSelectionListener((SelectionListener)this);
        if (this.previousVariable != null) {
            int n = this.findVariableIndexInCombo(iDatapoolVariableArray, this.previousVariable);
            this.insertionVariables.select(n + 1);
            this.insertionVariableName = iDatapoolVariableArray[n].getName();
            this.insertionVariableID = iDatapoolVariableArray[n].getId();
        } else {
            this.insertionVariables.select(0);
            this.insertionVariableName = new String();
            this.insertionVariableID = new String();
        }
        gridData = new GridData(256);
        gridData.horizontalSpan = 2;
        this.errorLabel = new Label(composite2, 0);
        this.errorLabel.setLayoutData((Object)gridData);
        return composite2;
    }

    private boolean enableOK() {
        boolean bl;
        boolean bl2 = true;
        String string = new String();
        String string2 = new String();
        Display display = Display.getDefault();
        Color color = display.getSystemColor(3);
        String string3 = this.nameField.getText();
        if (string3 == null || string3.length() == 0) {
            this.getButton(0).setEnabled(false);
            return false;
        }
        String string4 = this.typeField.getText();
        if (string4 != null && string4.length() >= 1) {
            bl = DatapoolUtil.getInstance().isVariableTypeValid(string4);
            if (!bl) {
                this.typeField.setForeground(color);
                this.getButton(0).setEnabled(false);
                string = DatapoolPlugin.getResourceString("DATA_COL_DLG_ERROR_TYPE_NOT_VALID");
                bl2 = false;
            } else {
                this.typeField.setForeground(this.typeFieldForeground);
            }
        }
        if (string3 != null && string3.length() > 0) {
            bl = DatapoolUtil.getInstance().isVariableNameUnique(this.datapool, string3, this.selectedVariable);
            boolean bl3 = DatapoolUtil.getInstance().isVariableNameValid(string3);
            if (bl && bl3) {
                this.nameField.setForeground(this.nameFieldForeground);
            } else {
                this.nameField.setForeground(color);
                if (!bl) {
                    string2 = DatapoolPlugin.getResourceString("DATA_COL_DLG_ERROR_NAME_NOT_UNIQUE");
                } else if (!bl3) {
                    string2 = DatapoolPlugin.getResourceString("DATA_COL_DLG_ERROR_NAME_NOT_VALID");
                }
                if (string2.length() > 0) {
                    string2 = string2 + "  ";
                }
                bl2 = false;
            }
        }
        if (bl2) {
            this.getButton(0).setEnabled(true);
            this.errorLabel.setText(new String());
            return true;
        }
        String string5 = DatapoolPlugin.getResourceString("DATA_DLG_ERROR_INDICATOR") + string2 + string;
        this.errorLabel.setText(string5);
        this.errorLabel.setForeground(color);
        this.getButton(0).setEnabled(false);
        return false;
    }

    private String[] getVariableLabels(IDatapoolVariable[] iDatapoolVariableArray) {
        if (iDatapoolVariableArray == null) {
            return null;
        }
        int n = iDatapoolVariableArray.length;
        String[] stringArray = new String[n + 1];
        int n2 = 0;
        while (n2 < n) {
            IDatapoolVariable iDatapoolVariable = iDatapoolVariableArray[n2];
            if (iDatapoolVariable != null) {
                Object[] objectArray;
                String string = iDatapoolVariable.getName();
                if (n2 == 0) {
                    objectArray = new Object[]{DatapoolPlugin.getResourceString("DATA_DLG_BEFORE"), string};
                    stringArray[n2] = MessageFormat.format("{0} {1}", objectArray);
                }
                objectArray = new Object[]{DatapoolPlugin.getResourceString("DATA_DLG_AFTER"), string};
                stringArray[n2 + 1] = MessageFormat.format("{0} {1}", objectArray);
            }
            ++n2;
        }
        if (n == 0) {
            stringArray[0] = DatapoolPlugin.getResourceString("DATA_DLG_FIRST_ELEMENT");
        }
        return stringArray;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getInsertionVariableName() {
        return this.insertionVariableName;
    }

    public String getInsertionVariableID() {
        return this.insertionVariableID;
    }

    private int findVariableIndexInCombo(IDatapoolVariable[] iDatapoolVariableArray, IDatapoolVariable iDatapoolVariable) {
        if (iDatapoolVariableArray == null || iDatapoolVariable == null) {
            return -1;
        }
        int n = 0;
        while (n < iDatapoolVariableArray.length) {
            if (iDatapoolVariableArray[n].equals(iDatapoolVariable)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        Combo combo = (Combo)selectionEvent.widget;
        int n = combo.getSelectionIndex();
        IDatapoolVariable[] iDatapoolVariableArray = (IDatapoolVariable[])combo.getData(TAG_VARIABLES);
        if (n > 0 && n <= iDatapoolVariableArray.length) {
            IDatapoolVariable iDatapoolVariable = iDatapoolVariableArray[n - 1];
            this.insertionVariableName = iDatapoolVariable.getName();
            this.insertionVariableID = iDatapoolVariable.getId();
        } else {
            this.insertionVariableName = new String();
            this.insertionVariableID = new String();
        }
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (this.nameField != null) {
            this.name = this.nameField.getText();
        }
        if (this.typeField != null) {
            this.type = this.typeField.getText();
        }
        this.enableOK();
    }

    private String createDefaultName() {
        Object[] objectArray = new Object[]{DatapoolPlugin.getResourceString("DATA_VARIABLE_NAME"), NumberFormat.getInstance().format(this.defaultNameCounter)};
        ++this.defaultNameCounter;
        return MessageFormat.format("{0}{1}", objectArray);
    }
}

