/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.datapool.internal.dialog;

import org.eclipse.hyades.edit.datapool.IDatapool;
import org.eclipse.hyades.edit.datapool.IDatapoolVariable;
import org.eclipse.hyades.test.ui.datapool.DatapoolPlugin;
import org.eclipse.hyades.test.ui.datapool.internal.util.DatapoolUtil;
import org.eclipse.hyades.test.ui.datapool.internal.util.GridDataUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class DatapoolDeleteColumnDialog
extends Dialog
implements SelectionListener {
    private static final String TAG_VARIABLES = "variables";
    private static final int HEIGHT = 40;
    private static final int WIDTH = 280;
    private IDatapool datapool = null;
    private Combo variableCombo = null;
    private String deletionVariableID = null;

    public DatapoolDeleteColumnDialog(Shell shell, IDatapool iDatapool) {
        super(shell);
        this.datapool = iDatapool;
    }

    protected Control createContents(Composite composite) {
        Control control = super.createContents(composite);
        this.enableOK();
        return control;
    }

    protected Control createDialogArea(Composite composite) {
        this.getShell().setText(DatapoolPlugin.getResourceString("DATA_DEL_VAR_DLG_TITLE"));
        Composite composite2 = (Composite)super.createDialogArea(composite);
        GridData gridData = GridDataUtil.createFill();
        gridData.heightHint = 40;
        gridData.widthHint = 280;
        composite2.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        Label label = new Label(composite2, 0);
        label.setText(DatapoolPlugin.getResourceString("DATA_DEL_VAR_DLG_SEL"));
        this.variableCombo = new Combo(composite2, 12);
        IDatapoolVariable[] iDatapoolVariableArray = DatapoolUtil.getInstance().getVariables(this.datapool, null);
        String[] stringArray = this.getVariableLabels(iDatapoolVariableArray);
        gridData = new GridData(256);
        gridData.widthHint = 155;
        this.variableCombo.setItems(stringArray);
        this.variableCombo.setData(TAG_VARIABLES, (Object)iDatapoolVariableArray);
        this.variableCombo.setLayoutData((Object)gridData);
        this.variableCombo.addSelectionListener((SelectionListener)this);
        return composite2;
    }

    private boolean enableOK() {
        if (this.deletionVariableID == null) {
            this.getButton(0).setEnabled(false);
            return false;
        }
        this.getButton(0).setEnabled(true);
        return true;
    }

    private String[] getVariableLabels(IDatapoolVariable[] iDatapoolVariableArray) {
        if (iDatapoolVariableArray == null) {
            return null;
        }
        int n = iDatapoolVariableArray.length;
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            IDatapoolVariable iDatapoolVariable = iDatapoolVariableArray[n2];
            if (iDatapoolVariable != null) {
                String string;
                stringArray[n2] = string = iDatapoolVariable.getName();
            }
            ++n2;
        }
        return stringArray;
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        Combo combo = (Combo)selectionEvent.widget;
        int n = combo.getSelectionIndex();
        IDatapoolVariable[] iDatapoolVariableArray = (IDatapoolVariable[])combo.getData(TAG_VARIABLES);
        if (n >= 0 && n < iDatapoolVariableArray.length) {
            IDatapoolVariable iDatapoolVariable = iDatapoolVariableArray[n];
            this.deletionVariableID = iDatapoolVariable.getId();
        } else {
            this.deletionVariableID = new String();
        }
        this.enableOK();
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    public String getDeletedVariableID() {
        return this.deletionVariableID;
    }
}

