/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.datapool.internal.dialog;

import java.text.MessageFormat;
import org.eclipse.hyades.edit.datapool.IDatapool;
import org.eclipse.hyades.edit.datapool.IDatapoolEquivalenceClass;
import org.eclipse.hyades.edit.datapool.IDatapoolRecord;
import org.eclipse.hyades.test.ui.datapool.DatapoolPlugin;
import org.eclipse.hyades.test.ui.datapool.internal.util.DatapoolUtil;
import org.eclipse.hyades.test.ui.datapool.internal.util.GridDataUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class DatapoolRowDialog
extends Dialog {
    private static final String TAG_EQUIVALENCE_CLASSES = "equivalenceClasses";
    private static final String TAG_EQUIVALENCE_CLASS = "equivalenceClass";
    private static final String TAG_RECORD = "record";
    private static final int HEIGHT = 40;
    private static final int WIDTH = 380;
    private Shell shell = null;
    private IDatapool datapool = null;
    private String title = null;
    private boolean insertionMode = false;
    private Table table = null;
    private TableItem previousTableItem = null;
    private TableItem selectedTableItem = null;
    private Combo equivalenceClassCombo = null;
    private Combo recordIndexCombo = null;
    private int insertionEquivalenceClassIndex = -1;
    private int insertionRecordIndex = -1;
    private TableItem insertionTableItem = null;
    private SelectionListener equivalenceClassListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            IDatapoolEquivalenceClass iDatapoolEquivalenceClass = null;
            Combo combo = (Combo)selectionEvent.widget;
            DatapoolRowDialog.this.insertionEquivalenceClassIndex = combo.getSelectionIndex();
            IDatapoolEquivalenceClass[] iDatapoolEquivalenceClassArray = (IDatapoolEquivalenceClass[])combo.getData(DatapoolRowDialog.TAG_EQUIVALENCE_CLASSES);
            iDatapoolEquivalenceClass = iDatapoolEquivalenceClassArray[DatapoolRowDialog.this.insertionEquivalenceClassIndex];
            String[] stringArray = DatapoolRowDialog.this.getRecordIndexLabels(iDatapoolEquivalenceClass);
            DatapoolRowDialog.this.recordIndexCombo.setItems(stringArray);
            DatapoolRowDialog.this.recordIndexCombo.select(0);
            DatapoolRowDialog.this.insertionRecordIndex = -1;
            DatapoolRowDialog.this.recordIndexCombo.setData(DatapoolRowDialog.TAG_EQUIVALENCE_CLASS, (Object)iDatapoolEquivalenceClass);
            DatapoolRowDialog.this.enableOK();
        }
    };
    private SelectionListener recordIndexListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            Combo combo = (Combo)selectionEvent.widget;
            DatapoolRowDialog.this.insertionRecordIndex = combo.getSelectionIndex() - 1;
            DatapoolRowDialog.this.enableOK();
        }
    };

    public DatapoolRowDialog(Shell shell, IDatapool iDatapool, Table table, TableItem tableItem, TableItem tableItem2, String string) {
        super(shell);
        this.shell = shell;
        this.datapool = iDatapool;
        this.title = string;
        this.table = table;
        this.selectedTableItem = tableItem;
        this.previousTableItem = tableItem2;
        if (string.equals(DatapoolPlugin.getResourceString("DATA_ROW_DLG_TITLE_INS"))) {
            this.insertionMode = true;
        }
    }

    protected Control createContents(Composite composite) {
        Control control = super.createContents(composite);
        this.enableOK();
        return control;
    }

    protected Control createDialogArea(Composite composite) {
        this.getShell().setText(this.title);
        Composite composite2 = (Composite)super.createDialogArea(composite);
        GridData gridData = GridDataUtil.createFill();
        gridData.heightHint = 40;
        gridData.widthHint = 380;
        composite2.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        composite2.setLayout((Layout)gridLayout);
        Label label = new Label(composite2, 0);
        if (this.insertionMode) {
            label.setText(DatapoolPlugin.getResourceString("DATA_ROW_DLG_INS_INTO"));
        } else {
            label.setText(DatapoolPlugin.getResourceString("DATA_ROW_DLG_MOVE_INTO"));
        }
        this.equivalenceClassCombo = new Combo(composite2, 12);
        IDatapoolEquivalenceClass[] iDatapoolEquivalenceClassArray = DatapoolUtil.getInstance().getEquivalenceClasses(this.datapool, null);
        String[] stringArray = this.getEquivalenceClassLabels(iDatapoolEquivalenceClassArray);
        this.equivalenceClassCombo.setItems(stringArray);
        this.equivalenceClassCombo.setData(TAG_EQUIVALENCE_CLASSES, (Object)iDatapoolEquivalenceClassArray);
        gridData = new GridData(256);
        gridData.horizontalSpan = 1;
        gridData.widthHint = 150;
        this.equivalenceClassCombo.setLayoutData((Object)gridData);
        this.equivalenceClassCombo.addSelectionListener(this.equivalenceClassListener);
        Label label2 = new Label(composite2, 0);
        label2.setText(DatapoolPlugin.getResourceString("DATA_ROW_DLG_INDEX"));
        IDatapoolEquivalenceClass iDatapoolEquivalenceClass = null;
        IDatapoolRecord iDatapoolRecord = null;
        IDatapoolEquivalenceClass iDatapoolEquivalenceClass2 = null;
        IDatapoolRecord iDatapoolRecord2 = null;
        if (this.selectedTableItem != null) {
            iDatapoolEquivalenceClass = (IDatapoolEquivalenceClass)this.selectedTableItem.getData(TAG_EQUIVALENCE_CLASS);
            iDatapoolRecord = (IDatapoolRecord)this.selectedTableItem.getData(TAG_RECORD);
        }
        if (this.previousTableItem != null) {
            iDatapoolEquivalenceClass2 = (IDatapoolEquivalenceClass)this.previousTableItem.getData(TAG_EQUIVALENCE_CLASS);
            iDatapoolRecord2 = (IDatapoolRecord)this.previousTableItem.getData(TAG_RECORD);
        }
        String[] stringArray2 = null;
        stringArray2 = this.insertionMode ? this.getRecordIndexLabels(iDatapoolEquivalenceClass2) : this.getRecordIndexLabels(iDatapoolEquivalenceClass);
        this.recordIndexCombo = new Combo(composite2, 12);
        if (stringArray2 != null) {
            this.recordIndexCombo.setItems(stringArray2);
        }
        this.recordIndexCombo.setData(TAG_EQUIVALENCE_CLASS, (Object)iDatapoolEquivalenceClass2);
        gridData = new GridData(256);
        gridData.horizontalSpan = 1;
        gridData.widthHint = 55;
        this.recordIndexCombo.setLayoutData((Object)gridData);
        this.recordIndexCombo.addSelectionListener(this.recordIndexListener);
        if (!(this.insertionMode || iDatapoolEquivalenceClass2 != null && iDatapoolEquivalenceClass2.equals(iDatapoolEquivalenceClass))) {
            int n = this.datapool.getEquivalenceClassIndexById(iDatapoolEquivalenceClass.getId());
            if (n != -1) {
                this.equivalenceClassCombo.select(n);
                this.insertionEquivalenceClassIndex = n;
            }
            this.recordIndexCombo.select(0);
            this.insertionRecordIndex = -1;
        } else {
            int n = this.datapool.getEquivalenceClassIndexById(iDatapoolEquivalenceClass2.getId());
            int n2 = this.getRecordIndex(iDatapoolEquivalenceClass2, iDatapoolRecord2);
            if (n2 != -1) {
                this.recordIndexCombo.select(n2 + 1);
                this.insertionRecordIndex = n2;
            }
            if (n != -1) {
                this.equivalenceClassCombo.select(n);
                this.insertionEquivalenceClassIndex = n;
            }
        }
        return composite2;
    }

    private boolean enableOK() {
        this.getButton(0).setEnabled(true);
        return true;
    }

    private String[] getEquivalenceClassLabels(IDatapoolEquivalenceClass[] iDatapoolEquivalenceClassArray) {
        if (iDatapoolEquivalenceClassArray == null) {
            return null;
        }
        int n = iDatapoolEquivalenceClassArray.length;
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            IDatapoolEquivalenceClass iDatapoolEquivalenceClass = iDatapoolEquivalenceClassArray[n2];
            stringArray[n2] = iDatapoolEquivalenceClass.getName();
            ++n2;
        }
        return stringArray;
    }

    private String[] getRecordIndexLabels(IDatapoolEquivalenceClass iDatapoolEquivalenceClass) {
        int n = 0;
        if (iDatapoolEquivalenceClass != null) {
            n = iDatapoolEquivalenceClass.getRecordCount();
        }
        String[] stringArray = new String[n + 1];
        int n2 = 0;
        while (n2 < n) {
            Object[] objectArray;
            String string = String.valueOf(n2);
            if (n2 == 0) {
                objectArray = new Object[]{DatapoolPlugin.getResourceString("DATA_DLG_BEFORE"), new Integer(string)};
                stringArray[n2] = MessageFormat.format("{0} {1}", objectArray);
            }
            objectArray = new Object[]{DatapoolPlugin.getResourceString("DATA_DLG_AFTER"), new Integer(string)};
            stringArray[n2 + 1] = MessageFormat.format("{0} {1}", objectArray);
            ++n2;
        }
        if (n == 0) {
            stringArray[0] = DatapoolPlugin.getResourceString("DATA_DLG_FIRST_ELEMENT");
        }
        return stringArray;
    }

    private int findEquivalenceClassIndexInCombo(IDatapoolEquivalenceClass[] iDatapoolEquivalenceClassArray, IDatapoolEquivalenceClass iDatapoolEquivalenceClass) {
        if (iDatapoolEquivalenceClassArray == null || iDatapoolEquivalenceClass == null) {
            return -1;
        }
        int n = 0;
        while (n < iDatapoolEquivalenceClassArray.length) {
            if (iDatapoolEquivalenceClassArray[n].equals(iDatapoolEquivalenceClass)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int getInsertionEquivalenceClassIndex() {
        return this.insertionEquivalenceClassIndex;
    }

    public int getInsertionRecordIndex() {
        return this.insertionRecordIndex;
    }

    private int getRecordIndex(IDatapoolEquivalenceClass iDatapoolEquivalenceClass, IDatapoolRecord iDatapoolRecord) {
        int n = 0;
        while (n < iDatapoolEquivalenceClass.getRecordCount()) {
            org.eclipse.hyades.execution.runtime.datapool.IDatapoolRecord iDatapoolRecord2 = iDatapoolEquivalenceClass.getRecord(n);
            if (iDatapoolRecord2.equals(iDatapoolRecord)) {
                return n;
            }
            ++n;
        }
        return -1;
    }
}

