/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.datapool.internal.util;

import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.Vector;
import org.eclipse.hyades.edit.datapool.IDatapool;
import org.eclipse.hyades.edit.datapool.IDatapoolEquivalenceClass;
import org.eclipse.hyades.edit.datapool.IDatapoolRecord;
import org.eclipse.hyades.edit.datapool.IDatapoolSuggestedType;
import org.eclipse.hyades.edit.datapool.IDatapoolVariable;
import org.eclipse.hyades.test.ui.datapool.DatapoolPlugin;
import org.eclipse.hyades.test.ui.datapool.internal.util.CSVBufferedReader;
import org.eclipse.hyades.test.ui.datapool.internal.util.CSVTokenizer;
import org.eclipse.hyades.test.ui.datapool.internal.util.CorruptCSVFileException;
import org.eclipse.hyades.test.ui.datapool.internal.util.DatapoolUtil;
import org.eclipse.hyades.test.ui.datapool.internal.util.TypeChecker;

public class CSVImportExportUtil {
    private static final String SEPERATOR = ",";
    private static final String LINEFEED = "\n";
    private static final char DOUBLEQUOTE = '\"';
    private static final char COMMA = ',';
    private static final String TWOQUOTES = "\"\"";
    private static final String QUOTE = "\"";
    private static final String COLON = ":";
    private static int ecCounter = 1;
    private static final CSVImportExportUtil instance = new CSVImportExportUtil();
    private static long lineCounter = 1L;

    public static CSVImportExportUtil getInstance() {
        return instance;
    }

    protected CSVImportExportUtil() {
    }

    public void importCSV(IDatapool iDatapool, String string, boolean bl, boolean bl2) throws IOException, CorruptCSVFileException {
        if (iDatapool == null || string == null) {
            return;
        }
        try {
            try {
                InputStreamReader inputStreamReader = null;
                CSVBufferedReader cSVBufferedReader = null;
                String string2 = null;
                try {
                    inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(string), "UTF8");
                    cSVBufferedReader = new CSVBufferedReader(inputStreamReader);
                    string2 = cSVBufferedReader.readLine();
                }
                catch (IOException iOException) {
                    inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(string), "UTF-16");
                    cSVBufferedReader = new CSVBufferedReader(inputStreamReader);
                    string2 = cSVBufferedReader.readLine();
                }
                if (bl) {
                    this.createVariablesFromFile(iDatapool, string2, bl2);
                    string2 = cSVBufferedReader.readLine();
                    ++lineCounter;
                } else {
                    this.createVariables(iDatapool, string2, bl2);
                }
                String string3 = string2;
                while (string3 != null) {
                    this.createRecord(iDatapool, string3, bl2);
                    string3 = cSVBufferedReader.readLine();
                    ++lineCounter;
                }
                cSVBufferedReader.close();
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (CorruptCSVFileException corruptCSVFileException) {
                throw corruptCSVFileException;
            }
            Object var10_12 = null;
            lineCounter = 1L;
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            lineCounter = 1L;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportCSV(IDatapool iDatapool, String string, boolean bl, boolean bl2, boolean bl3) {
        if (iDatapool == null || string == null) {
            return;
        }
        try {
            try {
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(string), "UTF8");
                BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
                if (bl) {
                    this.writeVariables(iDatapool, bufferedWriter, true, bl2);
                }
                this.writeRecords(iDatapool, bufferedWriter, bl2, bl3);
                bufferedWriter.close();
            }
            catch (IOException iOException) {
                Object var9_10 = null;
                lineCounter = 1L;
            }
            Object var9_9 = null;
            lineCounter = 1L;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            lineCounter = 1L;
            throw throwable;
        }
    }

    private void createVariablesFromFile(IDatapool iDatapool, String string, boolean bl) throws CorruptCSVFileException {
        boolean bl2 = true;
        CSVTokenizer cSVTokenizer = new CSVTokenizer(string);
        while (cSVTokenizer.hasMoreTokens()) {
            Object object;
            Object[] objectArray;
            String string2 = cSVTokenizer.nextToken();
            if (bl && bl2) {
                bl2 = false;
                continue;
            }
            int n = string2.indexOf(DatapoolPlugin.getResourceString("DATA_EDT_DIVIDER"));
            String string3 = new String();
            String string4 = new String();
            if (n == -1) {
                string3 = string2;
            } else {
                string3 = string2.substring(0, n);
                string4 = string2.substring(n + 2);
            }
            if (!DatapoolUtil.getInstance().isVariableNameUnique(iDatapool, string3, null)) {
                objectArray = new Object[]{DatapoolPlugin.getResourceString("DATA_CSV_LINE"), NumberFormat.getInstance().format(lineCounter), COLON, DatapoolPlugin.getResourceString("DATA_COL_DLG_ERROR_NAME_NOT_UNIQUE")};
                object = MessageFormat.format("{0} {1}{2} {3}", objectArray);
                throw new CorruptCSVFileException((String)object);
            }
            if (!DatapoolUtil.getInstance().isVariableNameValid(string3)) {
                objectArray = new Object[]{DatapoolPlugin.getResourceString("DATA_CSV_LINE"), NumberFormat.getInstance().format(lineCounter), COLON, DatapoolPlugin.getResourceString("DATA_COL_DLG_ERROR_NAME_NOT_VALID")};
                object = MessageFormat.format("{0} {1}{2} {3}", objectArray);
                throw new CorruptCSVFileException((String)object);
            }
            if (!DatapoolUtil.getInstance().isVariableTypeValid(string4)) {
                objectArray = new Object[]{DatapoolPlugin.getResourceString("DATA_CSV_LINE"), NumberFormat.getInstance().format(lineCounter), COLON, DatapoolPlugin.getResourceString("DATA_COL_DLG_ERROR_TYPE_NOT_VALID")};
                object = MessageFormat.format("{0} {1}{2} {3}", objectArray);
                throw new CorruptCSVFileException((String)object);
            }
            objectArray = iDatapool.constructVariable();
            objectArray.setName(string3);
            object = (IDatapoolSuggestedType)objectArray.getSuggestedType();
            TypeChecker.getInstance().setVariableType((IDatapoolSuggestedType)object, string4);
            objectArray.setSuggestedType(object);
            iDatapool.appendVariable((IDatapoolVariable)objectArray);
        }
    }

    private void createVariables(IDatapool iDatapool, String string, boolean bl) {
        CSVTokenizer cSVTokenizer = new CSVTokenizer(string);
        int n = 1;
        while (cSVTokenizer.hasMoreTokens()) {
            cSVTokenizer.nextToken();
            Object[] objectArray = new Object[]{DatapoolPlugin.getResourceString("DATA_VARIABLE_NAME"), String.valueOf(n)};
            String string2 = MessageFormat.format("{0}{1}", objectArray);
            IDatapoolVariable iDatapoolVariable = iDatapool.constructVariable();
            IDatapoolSuggestedType iDatapoolSuggestedType = (IDatapoolSuggestedType)iDatapoolVariable.getSuggestedType();
            iDatapoolSuggestedType.setSuggestedClassName(new String());
            iDatapoolVariable.setSuggestedType(iDatapoolSuggestedType);
            iDatapoolVariable.setName(string2);
            iDatapool.appendVariable(iDatapoolVariable);
            ++n;
        }
    }

    private void createRecord(IDatapool iDatapool, String string, boolean bl) throws CorruptCSVFileException {
        int n;
        Object object;
        CSVTokenizer cSVTokenizer = new CSVTokenizer(string);
        IDatapoolEquivalenceClass iDatapoolEquivalenceClass = null;
        String string2 = null;
        int n2 = -1;
        if (bl) {
            Object[] objectArray;
            object = cSVTokenizer.nextToken();
            int n3 = ((String)object).indexOf(DatapoolPlugin.getResourceString("DATA_EDT_DIVIDER"));
            if (n3 >= 0) {
                try {
                    string2 = ((String)object).substring(n3 + 2);
                    objectArray = NumberFormat.getInstance().parse(string2);
                    n2 = objectArray.intValue();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                object = ((String)object).substring(0, n3);
            }
            if (!DatapoolUtil.getInstance().isEquivalenceClassNameValid((String)object)) {
                objectArray = new Object[]{DatapoolPlugin.getResourceString("DATA_CSV_LINE"), NumberFormat.getInstance().format(lineCounter), COLON, DatapoolPlugin.getResourceString("DATA_ROW_GRP_DLG_ERROR_NAME_NOT_VALID")};
                String string3 = MessageFormat.format("{0} {1}{2} {3}", objectArray);
                throw new CorruptCSVFileException(string3);
            }
            n = iDatapool.getEquivalenceClassIndex((String)object);
            if (n >= 0) {
                iDatapoolEquivalenceClass = (IDatapoolEquivalenceClass)iDatapool.getEquivalenceClass(n);
            } else {
                iDatapoolEquivalenceClass = iDatapool.constructEquivalenceClass();
                iDatapoolEquivalenceClass.setName((String)object);
                iDatapool.appendEquivalenceClass(iDatapoolEquivalenceClass);
            }
        } else {
            object = new Object[]{DatapoolPlugin.getResourceString("DATA_EC_NAME"), String.valueOf(ecCounter)};
            String string4 = MessageFormat.format("{0}{1}", (Object[])object);
            ++ecCounter;
            iDatapoolEquivalenceClass = iDatapool.constructEquivalenceClass();
            iDatapoolEquivalenceClass.setName(string4);
            iDatapool.appendEquivalenceClass(iDatapoolEquivalenceClass);
        }
        object = new Vector();
        while (cSVTokenizer.hasMoreTokens()) {
            String string5 = cSVTokenizer.nextToken();
            ((Vector)object).add(string5);
        }
        Object[] objectArray = new String[((Vector)object).size()];
        n = 0;
        while (n < ((Vector)object).size()) {
            objectArray[n] = (String)((Vector)object).get(n);
            ++n;
        }
        IDatapoolRecord iDatapoolRecord = iDatapoolEquivalenceClass.constructRecord(objectArray);
        if (n2 != -1) {
            IDatapoolRecord iDatapoolRecord2 = null;
            try {
                iDatapoolRecord2 = (IDatapoolRecord)iDatapoolEquivalenceClass.getRecord(n2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (iDatapoolRecord2 != null) {
                Object[] objectArray2 = new Object[]{DatapoolPlugin.getResourceString("DATA_CSV_LINE"), NumberFormat.getInstance().format(lineCounter), COLON, DatapoolPlugin.getResourceString("DATA_CSV_ERROR_RECORD_INDEX_DUP")};
                String string6 = MessageFormat.format("{0} {1}{2} {3}", objectArray2);
                throw new CorruptCSVFileException(string6);
            }
            if (n2 > iDatapoolEquivalenceClass.getRecordCount()) {
                Object[] objectArray3 = new Object[]{DatapoolPlugin.getResourceString("DATA_CSV_LINE"), NumberFormat.getInstance().format(lineCounter), COLON, DatapoolPlugin.getResourceString("DATA_CSV_ERROR_RECORD_INDEX_ORDER")};
                String string7 = MessageFormat.format("{0} {1}{2} {3}", objectArray3);
                throw new CorruptCSVFileException(string7);
            }
            iDatapoolEquivalenceClass.insertRecord(iDatapoolRecord, n2);
        } else {
            iDatapoolEquivalenceClass.appendRecord(iDatapoolRecord);
        }
    }

    private void writeVariables(IDatapool iDatapool, BufferedWriter bufferedWriter, boolean bl, boolean bl2) {
        String string = new String();
        int n = iDatapool.getVariableCount();
        if (n != 0) {
            Object[] objectArray;
            if (bl2) {
                Object[] objectArray2 = new Object[]{string, SEPERATOR};
                string = MessageFormat.format("{0}{1}", objectArray2);
            }
            int n2 = 0;
            while (n2 < n) {
                Object[] objectArray3;
                objectArray = (Object[])iDatapool.getVariable(n2);
                String string2 = objectArray.getName();
                String string3 = new String();
                if (n2 != n - 1) {
                    string3 = SEPERATOR;
                }
                if (bl) {
                    objectArray3 = objectArray.getSuggestedType().getSuggestedClassName();
                    Object[] objectArray4 = new Object[]{string2, DatapoolPlugin.getResourceString("DATA_EDT_DIVIDER"), objectArray3};
                    String string4 = MessageFormat.format("{0}{1}{2}", objectArray4);
                    string4 = this.processString(string4);
                    Object[] objectArray5 = new Object[]{string, string4, string3};
                    string = MessageFormat.format("{0}{1}{2}", objectArray5);
                } else {
                    string2 = this.processString(string2);
                    objectArray3 = new Object[]{string, string2, string3};
                    string = MessageFormat.format("{0}{1}{2}", objectArray3);
                }
                ++n2;
            }
            objectArray = new Object[]{string, LINEFEED};
            string = MessageFormat.format("{0}{1}", objectArray);
        } else {
            string = LINEFEED;
        }
        try {
            bufferedWriter.write(string);
        }
        catch (IOException iOException) {}
    }

    private void writeRecords(IDatapool iDatapool, BufferedWriter bufferedWriter, boolean bl, boolean bl2) {
        String string = new String();
        int n = 0;
        while (n < iDatapool.getEquivalenceClassCount()) {
            IDatapoolEquivalenceClass iDatapoolEquivalenceClass = (IDatapoolEquivalenceClass)iDatapool.getEquivalenceClass(n);
            String string2 = new String();
            if (bl) {
                string2 = iDatapoolEquivalenceClass.getName();
                Object[] objectArray = new Object[]{string2, DatapoolPlugin.getResourceString("DATA_EDT_DIVIDER")};
                string2 = MessageFormat.format("{0}{1}", objectArray);
            }
            int n2 = 0;
            while (n2 < iDatapoolEquivalenceClass.getRecordCount()) {
                Object[] objectArray;
                IDatapoolRecord iDatapoolRecord = (IDatapoolRecord)iDatapoolEquivalenceClass.getRecord(n2);
                if (bl) {
                    Object[] objectArray2 = new Object[]{string2, NumberFormat.getInstance().format(n2)};
                    String string3 = MessageFormat.format("{0}{1}", objectArray2);
                    string3 = this.processString(string3);
                    objectArray = new Object[]{string, string3, SEPERATOR};
                    string = MessageFormat.format("{0}{1}{2}", objectArray);
                }
                int n3 = iDatapoolRecord.getCellCount();
                int n4 = 0;
                while (n4 < n3) {
                    objectArray = (Object[])iDatapoolRecord.getCell(n4);
                    String string4 = new String();
                    string4 = bl2 ? objectArray.getPersistedRepresentation() : objectArray.getStringValue();
                    String string5 = new String();
                    if (n4 != n3 - 1) {
                        string5 = SEPERATOR;
                    }
                    string4 = this.processString(string4);
                    Object[] objectArray3 = new Object[]{string, string4, string5};
                    string = MessageFormat.format("{0}{1}{2}", objectArray3);
                    ++n4;
                }
                objectArray = new Object[]{string, LINEFEED};
                string = MessageFormat.format("{0}{1}", objectArray);
                ++n2;
            }
            ++n;
        }
        try {
            bufferedWriter.write(string);
        }
        catch (IOException iOException) {}
    }

    private String processString(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string;
        boolean bl = false;
        if (string.trim().length() < string.length()) {
            bl = true;
        }
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == ',') {
                bl = true;
            }
            if (c == '\"') {
                bl = true;
            }
            ++n;
        }
        string2 = string2.replaceAll(QUOTE, TWOQUOTES);
        if (bl) {
            string2 = this.wrapString(string2);
        }
        return string2;
    }

    private String wrapString(String string) {
        Object[] objectArray = new Object[]{QUOTE, string, QUOTE};
        return MessageFormat.format("{0}{1}{2}", objectArray);
    }
}

