/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.datapool.internal.util;

import java.util.ArrayList;
import org.eclipse.hyades.edit.datapool.IDatapool;
import org.eclipse.hyades.edit.datapool.IDatapoolEquivalenceClass;
import org.eclipse.hyades.edit.datapool.IDatapoolVariable;
import org.eclipse.hyades.test.ui.datapool.DatapoolPlugin;

public class DatapoolUtil {
    private static final DatapoolUtil instance = new DatapoolUtil();

    public static DatapoolUtil getInstance() {
        return instance;
    }

    protected DatapoolUtil() {
    }

    public boolean isVariableNameValid(String string) {
        if (string.length() == 0) {
            return false;
        }
        String string2 = DatapoolPlugin.getResourceString("DATA_DLG_INVALID_NAME_CHARACTERS");
        return !this.hasInvalidCharacters(string, string2 = string2.replaceAll(" ", ""));
    }

    public boolean isVariableTypeValid(String string) {
        if (string.length() == 0) {
            return true;
        }
        String string2 = DatapoolPlugin.getResourceString("DATA_DLG_INVALID_TYPE_CHARACTERS");
        String string3 = DatapoolPlugin.getResourceString("DATA_DLG_INVALID_TYPE_FIRST_CHARACTER");
        if (this.hasInvalidCharacters(string.substring(0, 1), string3)) {
            return false;
        }
        return !this.hasInvalidCharacters(string, string2);
    }

    public boolean isEquivalenceClassNameValid(String string) {
        if (string.length() == 0) {
            return false;
        }
        String string2 = DatapoolPlugin.getResourceString("DATA_DLG_INVALID_NAME_CHARACTERS");
        return !this.hasInvalidCharacters(string, string2 = string2.replaceAll(" ", ""));
    }

    public boolean hasInvalidCharacters(String string, String string2) {
        if (string2 == null) {
            return false;
        }
        int n = 0;
        while (n < string2.length()) {
            String string3 = string2.substring(n, n + 1);
            if (string.lastIndexOf(string3) != -1) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean isEquivalenceClassNameUnique(IDatapool iDatapool, String string, IDatapoolEquivalenceClass iDatapoolEquivalenceClass) {
        if (iDatapool == null) {
            return true;
        }
        int n = 0;
        while (n < iDatapool.getEquivalenceClassCount()) {
            IDatapoolEquivalenceClass iDatapoolEquivalenceClass2 = (IDatapoolEquivalenceClass)iDatapool.getEquivalenceClass(n);
            if (!iDatapoolEquivalenceClass2.equals(iDatapoolEquivalenceClass) && string.equals(iDatapoolEquivalenceClass2.getName())) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean isVariableNameUnique(IDatapool iDatapool, String string, IDatapoolVariable iDatapoolVariable) {
        if (iDatapool == null) {
            return true;
        }
        int n = 0;
        while (n < iDatapool.getVariableCount()) {
            IDatapoolVariable iDatapoolVariable2 = (IDatapoolVariable)iDatapool.getVariable(n);
            if (!iDatapoolVariable2.equals(iDatapoolVariable) && string.equals(iDatapoolVariable2.getName())) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public IDatapoolVariable[] getVariables(IDatapool iDatapool, String string) {
        Object object;
        if (iDatapool == null) {
            return null;
        }
        int n = iDatapool.getVariableCount();
        ArrayList<IDatapoolVariable> arrayList = new ArrayList<IDatapoolVariable>();
        int n2 = 0;
        while (n2 < n) {
            IDatapoolVariable iDatapoolVariable = (IDatapoolVariable)iDatapool.getVariable(n2);
            object = iDatapoolVariable.getName();
            if (!((String)object).equals(string)) {
                arrayList.add(iDatapoolVariable);
            }
            ++n2;
        }
        int n3 = arrayList.size();
        object = new IDatapoolVariable[n3];
        arrayList.toArray((T[])object);
        return object;
    }

    public IDatapoolEquivalenceClass[] getEquivalenceClasses(IDatapool iDatapool, String string) {
        Object object;
        if (iDatapool == null) {
            return null;
        }
        int n = iDatapool.getEquivalenceClassCount();
        ArrayList<IDatapoolEquivalenceClass> arrayList = new ArrayList<IDatapoolEquivalenceClass>();
        int n2 = 0;
        while (n2 < n) {
            IDatapoolEquivalenceClass iDatapoolEquivalenceClass = (IDatapoolEquivalenceClass)iDatapool.getEquivalenceClass(n2);
            object = iDatapoolEquivalenceClass.getId();
            if (!((String)object).equals(string)) {
                arrayList.add(iDatapoolEquivalenceClass);
            }
            ++n2;
        }
        int n3 = arrayList.size();
        object = new IDatapoolEquivalenceClass[n3];
        arrayList.toArray((T[])object);
        return object;
    }
}

