/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.datapool.internal.util;

import java.util.HashMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.test.ui.datapool.internal.interfaces.IDisplayValueClass;
import org.eclipse.hyades.test.ui.datapool.internal.interfaces.IValidateValueClass;
import org.eclipse.hyades.test.ui.datapool.internal.interfaces.IValueClassFactory;
import org.eclipse.hyades.test.ui.datapool.internal.util.StringValidatorValueClass;
import org.eclipse.hyades.test.ui.datapool.internal.util.StringValueClass;
import org.eclipse.hyades.test.ui.datapool.internal.util.StringValueFactory;

public class ValueClassMap {
    private static HashMap displayMap = null;
    private static HashMap validatorMap = null;
    private static HashMap valueFactoryMap = null;
    private static String mapVendorID = null;

    public static IDisplayValueClass getSWTValueDisplayClass(Object object) {
        if (object == null) {
            return null;
        }
        Class<?> clazz = object.getClass();
        return ValueClassMap.getValueDisplayClass(clazz);
    }

    public static IValidateValueClass getValueValidatorClass(Object object) {
        if (object == null) {
            return null;
        }
        Class<?> clazz = object.getClass();
        return ValueClassMap.getValidatorClass(clazz);
    }

    public static IValidateValueClass getValueValidatorClass(String string) {
        if (string == null) {
            return null;
        }
        return ValueClassMap.getValidatorClass(string);
    }

    public static IValueClassFactory getValueClassFactory(String string) {
        if (string == null) {
            return null;
        }
        return ValueClassMap.getClassFactory(string);
    }

    public static void setVendorID(String string) {
        mapVendorID = string;
    }

    private static IDisplayValueClass getValueDisplayClass(Class clazz) {
        if (clazz == null) {
            return null;
        }
        String string = clazz.getName();
        ValueClassMap.loadDisplayClassMap();
        Object object = displayMap.get(string);
        if (object == null) {
            object = ValueClassMap.getValueDisplayClass(clazz.getSuperclass());
        }
        if (object == null && string.equals("java.lang.String")) {
            object = new StringValueClass();
        }
        return (IDisplayValueClass)object;
    }

    private static IDisplayValueClass getValueDisplayClass(String string) {
        if (string == null) {
            return null;
        }
        ValueClassMap.loadDisplayClassMap();
        Object object = displayMap.get(string);
        if (object == null && string.equals("java.lang.String")) {
            object = new StringValueClass();
        }
        return (IDisplayValueClass)object;
    }

    private static IValidateValueClass getValidatorClass(Class clazz) {
        if (clazz == null) {
            return null;
        }
        String string = clazz.getName();
        ValueClassMap.loadValidatorClassMap();
        Object object = validatorMap.get(string);
        if (object == null) {
            object = ValueClassMap.getValidatorClass(clazz.getSuperclass());
        }
        if (object == null && string.equals("java.lang.String")) {
            object = new StringValidatorValueClass();
        }
        return (IValidateValueClass)object;
    }

    private static IValidateValueClass getValidatorClass(String string) {
        if (string == null) {
            return null;
        }
        ValueClassMap.loadDisplayClassMap();
        Object object = validatorMap.get(string);
        if (object == null && string.equals("java.lang.String")) {
            object = new StringValidatorValueClass();
        }
        return (IValidateValueClass)object;
    }

    private static IValueClassFactory getClassFactory(String string) {
        if (string == null) {
            return null;
        }
        ValueClassMap.loadValueFactoryMap();
        Object object = valueFactoryMap.get(string);
        if (object == null && string.equals("java.lang.String")) {
            object = new StringValueFactory();
        }
        return (IValueClassFactory)object;
    }

    private static void loadDisplayClassMap() {
        block5: {
            IExtensionPoint iExtensionPoint;
            if (displayMap == null) {
                displayMap = new HashMap(64);
            }
            if ((iExtensionPoint = Platform.getPluginRegistry().getExtensionPoint("org.eclipse.hyades.test.ui.datapool.valueObjectExtension")) == null) break block5;
            try {
                IConfigurationElement[] iConfigurationElementArray = iExtensionPoint.getConfigurationElements();
                int n = 0;
                while (n < iConfigurationElementArray.length) {
                    String string;
                    if (mapVendorID == null || mapVendorID.equals(string = iConfigurationElementArray[n].getAttribute("vendorID"))) {
                        string = iConfigurationElementArray[n].getAttribute("type");
                        IDisplayValueClass iDisplayValueClass = (IDisplayValueClass)iConfigurationElementArray[n].createExecutableExtension("displayValueClass");
                        displayMap.put(string, iDisplayValueClass);
                    }
                    ++n;
                }
            }
            catch (Exception exception) {}
        }
    }

    private static void loadValidatorClassMap() {
        block5: {
            IExtensionPoint iExtensionPoint;
            if (validatorMap == null) {
                validatorMap = new HashMap(64);
            }
            if ((iExtensionPoint = Platform.getPluginRegistry().getExtensionPoint("org.eclipse.hyades.test.ui.datapool.valueObjectValidatorExtension")) == null) break block5;
            try {
                IConfigurationElement[] iConfigurationElementArray = iExtensionPoint.getConfigurationElements();
                int n = 0;
                while (n < iConfigurationElementArray.length) {
                    String string;
                    if (mapVendorID == null || mapVendorID.equals(string = iConfigurationElementArray[n].getAttribute("vendorID"))) {
                        string = iConfigurationElementArray[n].getAttribute("type");
                        IValidateValueClass iValidateValueClass = (IValidateValueClass)iConfigurationElementArray[n].createExecutableExtension("validateValueClass");
                        validatorMap.put(string, iValidateValueClass);
                    }
                    ++n;
                }
            }
            catch (Exception exception) {}
        }
    }

    private static void loadValueFactoryMap() {
        block5: {
            IExtensionPoint iExtensionPoint;
            if (valueFactoryMap == null) {
                valueFactoryMap = new HashMap(64);
            }
            if ((iExtensionPoint = Platform.getPluginRegistry().getExtensionPoint("org.eclipse.hyades.test.ui.datapool.valueObjectExtension")) == null) break block5;
            try {
                IConfigurationElement[] iConfigurationElementArray = iExtensionPoint.getConfigurationElements();
                int n = 0;
                while (n < iConfigurationElementArray.length) {
                    String string;
                    if (mapVendorID == null || mapVendorID.equals(string = iConfigurationElementArray[n].getAttribute("vendorID"))) {
                        string = iConfigurationElementArray[n].getAttribute("type");
                        IValueClassFactory iValueClassFactory = (IValueClassFactory)iConfigurationElementArray[n].createExecutableExtension("valueClassFactory");
                        valueFactoryMap.put(string, iValueClassFactory);
                    }
                    ++n;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

