/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.trace;

import java.util.HashMap;
import org.eclipse.hyades.execution.trace.TraceCorrelator;
import org.eclipse.hyades.execution.trace.util.ProfilerImpl;
import org.eclipse.hyades.execution.trace.util.RecordClassDef;
import org.eclipse.hyades.execution.trace.util.RecordMethodAccess;
import org.eclipse.hyades.execution.trace.util.RecordMethodDef;
import org.eclipse.hyades.execution.trace.util.RecordObjAlloc;
import org.eclipse.hyades.execution.trace.util.RecordParameterDef;
import org.eclipse.hyades.execution.trace.util.RecordThreadStart;
import org.eclipse.hyades.execution.trace.util.RecordVariable;
import org.eclipse.hyades.execution.trace.util.Utilities;

public class TraceLogger
extends ProfilerImpl {
    private static final String DISTRIBUTED_TRACE_PROFILER = "Distributed Trace Profiler";
    private static final String TYPE_PROFILER = "Profiler";
    private static TraceLogger _profiler = null;
    private HashMap methodCollection = new HashMap();
    private HashMap classCollection = new HashMap();
    private HashMap objectCollection = new HashMap();
    private HashMap parameterCollection = new HashMap();
    private HashMap threadCollection = new HashMap();
    static /* synthetic */ Class class$org$eclipse$hyades$execution$trace$TraceLogger;

    private TraceLogger() {
        super(DISTRIBUTED_TRACE_PROFILER, TYPE_PROFILER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TraceLogger getInstance() {
        Class clazz = class$org$eclipse$hyades$execution$trace$TraceLogger == null ? (class$org$eclipse$hyades$execution$trace$TraceLogger = TraceLogger.class$("org.eclipse.hyades.execution.trace.TraceLogger")) : class$org$eclipse$hyades$execution$trace$TraceLogger;
        synchronized (clazz) {
            if (_profiler == null) {
                _profiler = new TraceLogger();
            }
        }
        return _profiler;
    }

    public void monitorInactive() {
        super.monitorInactive();
        this.classCollection.clear();
        this.methodCollection.clear();
        this.objectCollection.clear();
        this.parameterCollection.clear();
        this.threadCollection.clear();
    }

    public void logCorrelator(String string, TraceCorrelator traceCorrelator, TraceCorrelator traceCorrelator2) {
        Object object;
        int n;
        RecordObjAlloc recordObjAlloc;
        Thread thread = Thread.currentThread();
        RecordThreadStart recordThreadStart = (RecordThreadStart)this.threadCollection.get(thread);
        if (recordThreadStart == null) {
            recordThreadStart = new RecordThreadStart();
            recordThreadStart.setTime(Utilities.getCurrentTimeStamp());
            this.threadCollection.put(thread, recordThreadStart);
            this.write(recordThreadStart.toString());
        }
        int n2 = recordThreadStart.getThreadId();
        String string2 = traceCorrelator.getClazz().getName();
        RecordClassDef recordClassDef = (RecordClassDef)this.classCollection.get(string2);
        if (recordClassDef == null) {
            recordClassDef = new RecordClassDef(string2);
            recordClassDef.setTime(Utilities.getCurrentTimeStamp());
            recordClassDef.setThreadIdRef(n2);
            this.classCollection.put(string2, recordClassDef);
            this.write(recordClassDef.toString());
        }
        if ((recordObjAlloc = (RecordObjAlloc)this.objectCollection.get(new Integer(n = traceCorrelator.getObject()))) == null) {
            recordObjAlloc = new RecordObjAlloc();
            recordObjAlloc.setTime(Utilities.getCurrentTimeStamp());
            recordObjAlloc.setClassIdRef(recordClassDef.getClassId());
            recordObjAlloc.setThreadIdRef(n2);
            this.objectCollection.put(new Integer(n), recordObjAlloc);
            this.write(recordObjAlloc.toString());
        }
        String string3 = traceCorrelator.getInvokedMethod().toString();
        String string4 = Utilities.getInvokedMethodSignature(traceCorrelator.getParmClasses(), traceCorrelator.getReturnClass() == null ? null : Utilities.getJniNotation(traceCorrelator.getReturnClass()));
        String string5 = string2 + "#" + string3 + string4;
        RecordMethodDef recordMethodDef = (RecordMethodDef)this.methodCollection.get(string5);
        if (recordMethodDef == null) {
            recordMethodDef = new RecordMethodDef(string3, string4, recordClassDef.getClassId());
            this.methodCollection.put(string5, recordMethodDef);
            this.write(recordMethodDef.toString());
        }
        String[] stringArray = traceCorrelator.getParmNames();
        Class[] classArray = traceCorrelator.getParmClasses();
        Object[] objectArray = traceCorrelator.getParmValues();
        int n3 = stringArray == null || classArray == null || objectArray == null || stringArray.length != classArray.length || classArray.length != objectArray.length ? 0 : stringArray.length;
        int[] nArray = new int[n3];
        int n4 = 0;
        while (n4 < n3) {
            object = Integer.toString(recordMethodDef.getMethodId()) + "@" + Integer.toString(n4);
            RecordParameterDef recordParameterDef = (RecordParameterDef)this.parameterCollection.get(object);
            if (recordParameterDef == null) {
                recordParameterDef = new RecordParameterDef(classArray[n4], recordMethodDef.getMethodId(), n4);
                recordParameterDef.setName(stringArray[n4]);
                this.parameterCollection.put(object, recordParameterDef);
                this.write(recordParameterDef.toString());
            }
            nArray[n4] = recordParameterDef.getParameterId();
            ++n4;
        }
        object = new RecordMethodAccess(string, recordMethodDef.getMethodId(), recordObjAlloc.getObjId());
        ((RecordMethodAccess)object).setTime(Utilities.getCurrentTimeStamp());
        ((RecordMethodAccess)object).setSequenceCounter(traceCorrelator.getOperationCounter());
        ((RecordMethodAccess)object).setTicket(Long.toString(traceCorrelator.getApplicationCounter()));
        ((RecordMethodAccess)object).setParameterList(nArray, classArray, objectArray);
        ((RecordMethodAccess)object).setThreadIdRef(n2);
        traceCorrelator.setAgentIdRef(this.getAgentId());
        traceCorrelator.setProcessIdRef(this.getProcessId());
        traceCorrelator.setNodeIdRef(this.getNodeId());
        traceCorrelator.setThreadIdRef(n2);
        if (!(traceCorrelator2 == null || traceCorrelator2.getAgentIdRef() == null || traceCorrelator.getAgentIdRef().equals(traceCorrelator2.getAgentIdRef()) || string != "methodReceive" && string != "methodReturn")) {
            ((RecordMethodAccess)object).setRemoteContext(traceCorrelator2.getNodeIdRef(), traceCorrelator2.getProcessIdRef(), traceCorrelator2.getAgentIdRef(), traceCorrelator2.getThreadIdRef(), traceCorrelator2.getApplicationCounter(), traceCorrelator2.getOperationCounter());
        }
        if (string == "methodExit" && traceCorrelator.getReturnClass() != null && traceCorrelator.getReturnClass() != Void.TYPE) {
            ((RecordMethodAccess)object).setReturnValue(new RecordVariable("returnValue", 0, traceCorrelator.getReturnClass(), traceCorrelator.getReturnValue()));
        }
        this.write(((RecordMethodAccess)object).toString());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

