/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.parsers;

import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.eclipse.hyades.logging.core.Guid;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.events.cbe.ComponentIdentification;
import org.eclipse.hyades.logging.events.cbe.ReportSituation;
import org.eclipse.hyades.logging.events.cbe.Situation;
import org.eclipse.hyades.logging.events.cbe.SituationType;
import org.eclipse.hyades.logging.events.cbe.util.EventHelpers;
import org.eclipse.hyades.logging.parsers.LogParserException;
import org.eclipse.hyades.logging.parsers.Parser;
import org.eclipse.hyades.logging.parsers.ParserConstants;
import org.eclipse.hyades.logging.parsers.ParserUtilities;

public abstract class AbstractErrorLogParser
extends Parser {
    protected String category = null;
    protected short severity = 0;
    protected String clientIP = null;
    protected String message = null;
    protected String fileName = null;
    protected StringBuffer cgiDebuggingOutput = new StringBuffer();
    protected StringBuffer currentTimeStamp = null;
    protected String productVersion = null;
    protected String sourceID = null;
    private String previousTimeStamp = EventHelpers.longToDate((long)0L);
    private long duplicateTimeStampCounter = 0L;

    public void preParse() throws LogParserException {
        super.preParse();
    }

    public void postParse() throws LogParserException {
        super.postParse();
    }

    public CommonBaseEvent[] parseNext() throws LogParserException {
        CommonBaseEvent[] commonBaseEventArray = null;
        this.curLine = this.readLine();
        this.arrayIndex = 0;
        try {
            while (this.curLine != null) {
                this.curLine = this.curLine.trim();
                if (this.curLine.length() > 0 && this.parseLogRecord()) {
                    if (this.cgiDebuggingOutput.length() > 0) {
                        this.createCGIDebuggingOutputCBE();
                        ++this.arrayIndex;
                        if (this.arrayIndex == this.MessageArraySize) {
                            this.increaseMsgArraySize();
                        }
                        ++this.recordCount;
                    }
                    this.reinitializeCBE();
                    if (this.previousTimeStamp.equals(this.currentTimeStamp.toString())) {
                        this.messages[this.arrayIndex].setSequenceNumber(++this.duplicateTimeStampCounter);
                    } else {
                        this.previousTimeStamp = this.currentTimeStamp.toString();
                        this.duplicateTimeStampCounter = 0L;
                    }
                    this.messages[this.arrayIndex].setCreationTime(this.currentTimeStamp.toString());
                    this.messages[this.arrayIndex].setMsg(this.message);
                    this.messages[this.arrayIndex].setSeverity(this.severity);
                    if (this.category != null) {
                        this.messages[this.arrayIndex].addExtendedDataElement(Parser.createStringEDE("category", this.category));
                    }
                    if (this.clientIP != null) {
                        this.messages[this.arrayIndex].addExtendedDataElement(Parser.createStringEDE("client", this.clientIP));
                    }
                    if (this.fileName != null) {
                        this.messages[this.arrayIndex].addExtendedDataElement(Parser.createStringEDE("file", this.fileName));
                    }
                    ++this.arrayIndex;
                    if (this.arrayIndex == this.MessageArraySize) {
                        this.arrayIndex = 0;
                        ++this.recordCount;
                        this.reset();
                        return this.messages;
                    }
                    ++this.recordCount;
                    this.reset();
                }
                this.curLine = this.readLine();
            }
            if (this.cgiDebuggingOutput.length() > 0) {
                if (this.recordCount == 0) {
                    throw new LogParserException(ParserUtilities.getResourceString("INVALID_ERROR_LOG_ERROR_", this.file_path));
                }
                this.createCGIDebuggingOutputCBE();
                ++this.arrayIndex;
                if (this.arrayIndex == this.MessageArraySize) {
                    this.arrayIndex = 0;
                    ++this.recordCount;
                    this.reset();
                    return this.messages;
                }
                ++this.recordCount;
            }
            if (this.arrayIndex == 0) {
                commonBaseEventArray = null;
            } else {
                int n = this.arrayIndex;
                while (n < this.MessageArraySize) {
                    this.messages[n] = null;
                    ++n;
                }
                commonBaseEventArray = this.messages;
            }
            if (this.recordCount == 0) {
                throw new LogParserException(ParserUtilities.getResourceString("NO_ERROR_LOG_RECORDS_ERROR_", this.file_path));
            }
        }
        catch (LogParserException logParserException) {
            throw logParserException;
        }
        catch (Throwable throwable) {
            ParserUtilities.exceptionHandler(throwable, this.curLineNumber, this.curLine, ParserUtilities.getResourceString("ERROR_LOG_PARSER_ERROR_"));
        }
        return commonBaseEventArray;
    }

    private void createCGIDebuggingOutputCBE() {
        this.reinitializeCBE();
        this.messages[this.arrayIndex].setSequenceNumber(++this.duplicateTimeStampCounter);
        this.messages[this.arrayIndex].setCreationTime(this.previousTimeStamp);
        this.messages[this.arrayIndex].setMsg(this.cgiDebuggingOutput.toString().trim());
        this.messages[this.arrayIndex].setSeverity((short)10);
        this.messages[this.arrayIndex].addExtendedDataElement(Parser.createStringEDE("CGI_debugging_output", this.cgiDebuggingOutput.toString().trim()));
    }

    private void reinitializeCBE() {
        this.messages[this.arrayIndex].init();
        this.messages[this.arrayIndex].setGlobalInstanceId(Guid.generate());
        ComponentIdentification componentIdentification = Parser.eventFactory.createComponentIdentification();
        componentIdentification.setLocation(this.localHostId);
        componentIdentification.setLocationType(this.localHostIdFormat);
        componentIdentification.setComponent(this.sourceID);
        componentIdentification.setSubComponent("Unknown");
        componentIdentification.setComponentType("ApacheHTTPServer");
        componentIdentification.setComponentIdType("ProductName");
        this.messages[this.arrayIndex].setSourceComponentId(componentIdentification);
        this.messages[this.arrayIndex].setSituation(this.createSituation());
    }

    private Situation createSituation() {
        Situation situation = Parser.eventFactory.createSituation();
        ReportSituation reportSituation = Parser.eventFactory.createReportSituation();
        reportSituation.setReasoningScope("INTERNAL");
        reportSituation.setReportCategory("LOG");
        situation.setCategoryName("ReportSituation");
        situation.setSituationType((SituationType)reportSituation);
        return situation;
    }

    protected boolean parseDate(int n, int n2) {
        SimpleDateFormat simpleDateFormat;
        Date date;
        if (this.curLine.charAt(n) == '[' && this.curLine.charAt(n2) == ']' && (date = (simpleDateFormat = new SimpleDateFormat("EEE MMM d HH:mm:ss yyyy", Locale.US)).parse(this.curLine.substring(n + 1, n2).trim(), new ParsePosition(0))) != null) {
            simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            this.currentTimeStamp = new StringBuffer(simpleDateFormat.format(date).trim());
            this.currentTimeStamp.replace(10, 11, "T");
            this.currentTimeStamp.append(".000000");
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            int n3 = (calendar.get(15) + calendar.get(16)) / 60000;
            if (n3 < 0) {
                this.currentTimeStamp.append("-");
            } else {
                this.currentTimeStamp.append("+");
            }
            n3 = Math.abs(n3);
            String string = String.valueOf(n3 / 60);
            if (string.length() == 1) {
                this.currentTimeStamp.append("0");
            }
            this.currentTimeStamp.append(string);
            this.currentTimeStamp.append(":");
            String string2 = String.valueOf(n3 % 60);
            if (string2.length() == 1) {
                this.currentTimeStamp.append("0");
            }
            this.currentTimeStamp.append(string2);
            return true;
        }
        return false;
    }

    protected boolean parseLogRecord() {
        int n = 0;
        int n2 = this.curLine.indexOf("[", n);
        if (n2 == -1) {
            this.cgiDebuggingOutput.append(this.curLine);
            this.cgiDebuggingOutput.append(ParserConstants.LINE_SEPARATOR);
            return false;
        }
        n = n2;
        if ((n2 = this.curLine.indexOf("]", n)) == -1 || !this.parseDate(n, n2)) {
            this.cgiDebuggingOutput.append(this.curLine);
            this.cgiDebuggingOutput.append(ParserConstants.LINE_SEPARATOR);
            return false;
        }
        n = n2;
        if ((n2 = this.curLine.indexOf("[", n)) == -1) {
            return false;
        }
        n = n2;
        if ((n2 = this.curLine.indexOf("]", n)) == -1) {
            return false;
        }
        this.category = this.curLine.substring(n + 1, n2).trim();
        this.severity = this.category.equals("emerg") || this.category.equals("alert") || this.category.equals("crit") || this.category.equals("error") ? (short)50 : (this.category.equals("warn") ? (short)30 : (short)10);
        n = n2;
        if ((n2 = this.curLine.indexOf("[client", n)) != -1) {
            n = n2;
            if ((n2 = this.curLine.indexOf("]", n)) == -1) {
                return false;
            }
            this.clientIP = this.curLine.substring(n + 7, n2).trim();
            n = n2;
        }
        this.message = this.curLine.substring(n + 1).trim();
        n2 = this.curLine.indexOf(": ", n);
        if (n2 != -1) {
            this.fileName = this.curLine.substring(n2 + 2).trim();
        }
        return true;
    }

    protected void reset() {
        this.severity = 0;
        this.message = null;
        this.clientIP = null;
        this.fileName = null;
        this.cgiDebuggingOutput = new StringBuffer();
        this.category = null;
        this.currentTimeStamp = null;
    }
}

