/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.sd.logc.internal.actions;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.log.ui.internal.util.LogUtil;
import org.eclipse.hyades.log.ui.internal.views.LogViewer;
import org.eclipse.hyades.models.hierarchy.CorrelationContainerProxy;
import org.eclipse.hyades.sd.logc.internal.loader.LogInteractions;
import org.eclipse.hyades.sd.logc.internal.uml2sd.LogGraphNode;
import org.eclipse.hyades.trace.ui.HyadesUtil;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.uml2sd.ui.load.LoadersManager;
import org.eclipse.hyades.uml2sd.ui.view.SDView;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

public class OpenLogView
implements IObjectActionDelegate {
    private SDView view;
    private CorrelationContainerProxy proxy;
    private EObject cbeEvent;

    public void run(IAction iAction) {
        this.openView();
    }

    private void openView() {
        try {
            LogViewer logViewer;
            IWorkbenchPage iWorkbenchPage = UIPlugin.getActivePage();
            EObject eObject = HyadesUtil.getObjectToView((EObject)HyadesUtil.getMofObject());
            if (eObject == null) {
                this.selectCorrelationProxyInNavigator();
                eObject = this.proxy;
            }
            if ((logViewer = (LogViewer)iWorkbenchPage.showView("org.eclipse.hyades.log.ui.internal.views.LogViewer")) != null) {
                logViewer.addViewPage(eObject);
                logViewer.getLogPage().getView().revealObject(this.cbeEvent);
                LogUtil.notifyViewSelectionChanged((Object)logViewer.getLogPage().getView(), (Object)this.cbeEvent);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
        if (iSelection != null && ((IStructuredSelection)iSelection).getFirstElement() instanceof LogGraphNode) {
            LogGraphNode logGraphNode = (LogGraphNode)((Object)((IStructuredSelection)iSelection).getFirstElement());
            if (logGraphNode != null) {
                this.cbeEvent = logGraphNode.hasElements() ? (EObject)logGraphNode.getElements().get(0) : logGraphNode.getElement();
            }
        } else {
            this.cbeEvent = null;
        }
    }

    public void setActivePart(IAction iAction, IWorkbenchPart iWorkbenchPart) {
        if (iWorkbenchPart != null && iWorkbenchPart instanceof SDView) {
            LogInteractions logInteractions = (LogInteractions)LoadersManager.getLoadersManager().getCurrentLoader();
            this.proxy = logInteractions.getCorrelationContainerProxy();
        } else {
            this.proxy = null;
        }
    }

    public void selectCorrelationProxyInNavigator() {
        if (this.proxy != null) {
            LogUtil.selectInLogNavigator((EObject)this.proxy);
            if (this.cbeEvent != null) {
                UIPlugin.getDefault().getSelectionModel((EObject)this.proxy).add((Object)this.cbeEvent);
            }
        }
    }
}

