/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.sd.logc.internal.loader;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.loaders.cbe.CBEUtils;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.actions.provider.ILogFilterProvider;
import org.eclipse.hyades.log.ui.internal.actions.provider.ILogFindProvider;
import org.eclipse.hyades.log.ui.internal.actions.provider.LogFilterCriteria;
import org.eclipse.hyades.log.ui.internal.actions.provider.LogFindCriteria;
import org.eclipse.hyades.log.ui.internal.util.FilterTableElement;
import org.eclipse.hyades.log.ui.internal.util.FiltersDialog;
import org.eclipse.hyades.log.ui.internal.util.LogRecordSearch;
import org.eclipse.hyades.log.ui.internal.util.LogUtil;
import org.eclipse.hyades.log.ui.internal.util.RecordFilterSearchUtil;
import org.eclipse.hyades.log.ui.internal.util.SearchRecordDialog;
import org.eclipse.hyades.logc.internal.util.CorrelationHelper;
import org.eclipse.hyades.models.cbe.CBECommonBaseEvent;
import org.eclipse.hyades.models.hierarchy.CorrelationContainerProxy;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.impl.CorrelationEntryImpl;
import org.eclipse.hyades.sd.logc.SDLogcPlugin;
import org.eclipse.hyades.sd.logc.SDLogcPluginImages;
import org.eclipse.hyades.sd.logc.internal.preferences.ILogInteractionsPreferenceListener;
import org.eclipse.hyades.sd.logc.internal.uml2sd.LogAsyncMessage;
import org.eclipse.hyades.sd.logc.internal.uml2sd.LogAsyncReturnMessage;
import org.eclipse.hyades.sd.logc.internal.uml2sd.LogGraphNode;
import org.eclipse.hyades.sd.logc.internal.uml2sd.SourceOutOfPageMessage;
import org.eclipse.hyades.sd.logc.internal.uml2sd.TargetOutOfPageMessage;
import org.eclipse.hyades.sd.logc.internal.util.ContextIds;
import org.eclipse.hyades.sd.logc.internal.util.LogCorrelationSelectionDialog;
import org.eclipse.hyades.security.util.TString;
import org.eclipse.hyades.trace.ui.HyadesUtil;
import org.eclipse.hyades.trace.ui.IProfileEventListener;
import org.eclipse.hyades.trace.ui.IViewSelectionChangedListener;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.ViewSelectionChangedEvent;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.hyades.uml2sd.ui.actions.provider.IExtendedFilterProvider;
import org.eclipse.hyades.uml2sd.ui.actions.provider.IExtendedFindProvider;
import org.eclipse.hyades.uml2sd.ui.actions.provider.ISDAdvancedPagingProvider;
import org.eclipse.hyades.uml2sd.ui.actions.provider.ISDPagingProvider;
import org.eclipse.hyades.uml2sd.ui.core.AsyncMessage;
import org.eclipse.hyades.uml2sd.ui.core.BaseMessage;
import org.eclipse.hyades.uml2sd.ui.core.BasicExecutionOccurrence;
import org.eclipse.hyades.uml2sd.ui.core.Frame;
import org.eclipse.hyades.uml2sd.ui.core.GraphNode;
import org.eclipse.hyades.uml2sd.ui.core.Lifeline;
import org.eclipse.hyades.uml2sd.ui.core.LifelineCategories;
import org.eclipse.hyades.uml2sd.ui.drawings.IImage;
import org.eclipse.hyades.uml2sd.ui.load.IUml2SDLoader;
import org.eclipse.hyades.uml2sd.ui.view.SDView;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.help.WorkbenchHelp;

public class LogInteractions
implements IUml2SDLoader,
ISelectionListener,
ISelectionChangedListener,
IViewSelectionChangedListener,
ISDAdvancedPagingProvider,
ILogInteractionsPreferenceListener,
IExtendedFilterProvider,
IExtendedFindProvider,
ILogFilterProvider,
ILogFindProvider,
IProfileEventListener {
    protected CorrelationContainerProxy correlationContainerProxy;
    protected EObject inputObject;
    protected Map graphNodes = new HashMap();
    protected Map lifelinesMap = new HashMap();
    protected List eventsList = new ArrayList();
    protected Map eventsMap = new HashMap();
    protected Map currentPageEvents = new HashMap();
    protected List agentsList = new ArrayList();
    protected SDView view;
    private Map sourceOutOfPageMessages;
    private Map targetOutOfPageMessages;
    private Map dummyMessages;
    private IConfigurationElement correlationType;
    private LogRecordComparator comparator;
    private CBECommonBaseEvent currentSelection;
    private CBECommonBaseEvent thisSelection;
    private int currentPageIndex = 0;
    private int nrOfPages = 0;
    private int PAGE_SIZE = 0;
    private int MAX_NR_OF_RECORDS = 99999;
    private int totalSize = 0;
    private final int NODE_SIZE = 24;
    private ArrayList filterTableElements = null;
    private RecordFilterSearchUtil recordFilterSearch = null;
    private boolean displayOnlyCorrelations = true;
    private Object[] pageCache;
    private LogRecordSearch logRecordSearch = null;
    private Label lblMessage;
    protected List expandedList = new ArrayList();
    protected LogInteractionsFrame frame;
    protected static LifelineCategories[] traceCategories = new LifelineCategories[1];
    protected static IImage image;
    public static final int CATEGORY_LOGS = 0;

    public LogInteractions() {
        UIPlugin.getDefault().addSelectionListener((ISelectionListener)this);
        UIPlugin.getDefault().addViewSelectionChangedListener((IViewSelectionChangedListener)this);
        UIPlugin.getDefault().addProfileEventListener((IProfileEventListener)this);
        this.recordFilterSearch = new RecordFilterSearchUtil();
    }

    public void setViewer(SDView sDView) {
        this.view = sDView;
        sDView.setSDPagingProvider((ISDPagingProvider)this);
        sDView.setExtendedFilterProvider((IExtendedFilterProvider)this);
        sDView.setExtendedFindProvider((IExtendedFindProvider)this);
        sDView.getSDWidget().getSelectionProvider().addSelectionChangedListener((ISelectionChangedListener)this);
        sDView.getSite().setSelectionProvider(sDView.getSDWidget().getSelectionProvider());
        WorkbenchHelp.setHelp((Control)this.view.getSDWidget(), (String)ContextIds.INTERACTION_VIEW);
    }

    public void aboutToBeReplaced() {
        UIPlugin.getDefault().removeSelectionListener((ISelectionListener)this);
        UIPlugin.getDefault().removeViewSelectionChangedListener((IViewSelectionChangedListener)this);
        UIPlugin.getDefault().removeProfileEventListener((IProfileEventListener)this);
        if (this.view != null) {
            this.view.getSDWidget().getSelectionProvider().removeSelectionChangedListener((ISelectionChangedListener)this);
        }
        this.clearDiagramCaches();
        this.recordFilterSearch = null;
    }

    public void generateLogInteractions(EObject eObject, boolean bl) {
        this.view.setFrame((Frame)this.parseModel(eObject, bl, false));
        this.disableMessageActions();
    }

    public void generateLogInteractions(EObject eObject, IConfigurationElement iConfigurationElement) {
        this.setCorrelationType(iConfigurationElement);
        this.view.setFrame((Frame)this.parseModel((EObject)CorrelationHelper.getInstance().createCorrelationContainer(this.correlationType, (Object)eObject, this.correlationType.getAttribute("name")), false, false));
        this.disableMessageActions();
    }

    public LogInteractionsFrame parseModel(EObject eObject, final boolean bl, final boolean bl2) {
        this.inputObject = eObject;
        IPreferenceStore iPreferenceStore = LogUIPlugin.getDefault().getPreferenceStore();
        this.displayOnlyCorrelations = iPreferenceStore.getString("pd_filter_show_correlation_only").equals("1");
        this.correlationContainerProxy = null;
        this.clearDiagramCaches();
        BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

            public void run() {
                LogInteractions.this.loadCorrelations(bl);
                LogInteractions.this.createPartition();
                LogInteractions.this.frame = LogInteractions.this.createPage(bl2);
            }
        });
        return this.frame;
    }

    public LogInteractionsFrame parseModel(EObject eObject) {
        return this.parseModel(eObject, false, false);
    }

    protected void refresh() {
        if (this.inputObject != null) {
            this.view.setFrame((Frame)this.parseModel(this.inputObject, false, true));
        } else {
            this.view.setFrame(new Frame());
        }
    }

    protected List getFilteredEvents(List list) {
        if (list == null) {
            return list;
        }
        ArrayList arrayList = new ArrayList();
        int n = 0;
        while (n < list.size()) {
            Object e = list.get(n);
            if (this.isFilterApplied((EObject)e)) {
                arrayList.add(e);
            }
            ++n;
        }
        Collections.sort(arrayList, this.getComparator());
        return arrayList;
    }

    private boolean isFilterApplied(EObject eObject) {
        if (this.filterTableElements == null || this.filterTableElements.size() == 0) {
            return true;
        }
        return this.recordFilterSearch.isAdvFilterApply(eObject, this.filterTableElements);
    }

    protected void clearTemporaryCaches() {
        this.graphNodes.clear();
        this.lifelinesMap.clear();
        this.currentPageEvents.clear();
        if (this.sourceOutOfPageMessages != null) {
            this.sourceOutOfPageMessages.clear();
        }
        if (this.targetOutOfPageMessages != null) {
            this.targetOutOfPageMessages.clear();
        }
        if (this.dummyMessages != null) {
            this.dummyMessages.clear();
        }
    }

    protected void clearDiagramCaches() {
        this.clearTemporaryCaches();
        this.agentsList.clear();
        this.eventsMap.clear();
        if (this.eventsList != null) {
            this.eventsList.clear();
        }
        if (this.pageCache != null) {
            int n = 0;
            while (n < this.pageCache.length) {
                this.pageCache[n] = null;
                ++n;
            }
            this.pageCache = null;
        }
        this.expandedList.clear();
    }

    protected void loadCorrelations(boolean bl) {
        if (this.inputObject instanceof CorrelationContainerProxy) {
            this.correlationContainerProxy = (CorrelationContainerProxy)this.inputObject;
        } else if (bl) {
            this.showCorrelationDialog();
        }
        if (this.correlationContainerProxy != null) {
            this.agentsList.addAll(this.correlationContainerProxy.getCorrelatedAgents());
        } else {
            this.agentsList.addAll(HyadesUtil.getLogAgents((EObject)this.inputObject));
        }
        this.loadEvents();
        this.eventsList = this.getFilteredEvents(this.eventsList);
    }

    protected void loadEvents() {
        if (!this.displayOnlyCorrelations) {
            Iterator iterator = this.agentsList.iterator();
            while (iterator.hasNext()) {
                TRCAgentProxy tRCAgentProxy = (TRCAgentProxy)iterator.next();
                if (tRCAgentProxy == null || tRCAgentProxy.eIsProxy()) continue;
                this.addEvents(tRCAgentProxy);
            }
        } else {
            this.loadEventsFromCorrelations();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadEventsFromCorrelations() {
        EMap eMap;
        if (this.correlationContainerProxy == null || this.correlationContainerProxy.getCorrelationContainer() == null) {
            return;
        }
        EMap eMap2 = eMap = this.correlationContainerProxy.getCorrelationContainer().getCorrelations();
        synchronized (eMap2) {
            Iterator iterator = eMap.iterator();
            while (iterator.hasNext()) {
                CorrelationEntryImpl correlationEntryImpl = (CorrelationEntryImpl)iterator.next();
                this.eventsMap.put(correlationEntryImpl.getKey(), "");
                List list = (List)correlationEntryImpl.getValue();
                if (list == null || list.size() <= 0) continue;
                int n = list.size();
                int n2 = 0;
                while (n2 < n) {
                    this.eventsMap.put(list.get(n2), "");
                    ++n2;
                }
            }
        }
        this.eventsList.addAll(this.eventsMap.keySet());
        this.eventsMap.clear();
    }

    protected Comparator getComparator() {
        if (this.comparator == null) {
            this.comparator = new LogRecordComparator();
        }
        return this.comparator;
    }

    protected void generateDiagram() {
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

            public void run() {
                LogInteractions.this.generateGraphNodes();
                LogInteractions.this.generateGraphConnections();
            }
        });
    }

    protected void generateGraphNodes() {
        EObject eObject = null;
        CBECommonBaseEvent cBECommonBaseEvent = null;
        TraceLifeline traceLifeline = null;
        LogGraphNode logGraphNode = null;
        LogGraphNode logGraphNode2 = null;
        int n = this.getMaxCurrentPageRangeIndex();
        int n2 = this.currentPageIndex * this.PAGE_SIZE;
        int n3 = this.currentPageIndex * this.PAGE_SIZE + n;
        int n4 = n2;
        while (n4 < n3) {
            eObject = (EObject)this.eventsList.get(n4);
            if (eObject instanceof CBECommonBaseEvent) {
                cBECommonBaseEvent = (CBECommonBaseEvent)eObject;
                traceLifeline = (TraceLifeline)((Object)this.lifelinesMap.get(this.getLifelinesMapKey(cBECommonBaseEvent)));
                if (this.graphNodes.get(cBECommonBaseEvent) == null) {
                    logGraphNode = this.createLogGraphNode(traceLifeline, cBECommonBaseEvent, logGraphNode2);
                    this.cacheLogGraphNode(logGraphNode, cBECommonBaseEvent);
                    logGraphNode2 = logGraphNode;
                }
            }
            ++n4;
        }
    }

    protected Object getLifelinesMapKey(CBECommonBaseEvent cBECommonBaseEvent) {
        return cBECommonBaseEvent.getAgent().getAgentProxy();
    }

    protected void cacheLogGraphNode(LogGraphNode logGraphNode, CBECommonBaseEvent cBECommonBaseEvent) {
        if (this.correlationContainerProxy == null) {
            return;
        }
        this.graphNodes.put(cBECommonBaseEvent, logGraphNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateGraphConnections() {
        EMap eMap;
        if (this.correlationContainerProxy == null) {
            return;
        }
        CBECommonBaseEvent cBECommonBaseEvent = null;
        List list = null;
        CorrelationEntryImpl correlationEntryImpl = null;
        Object object = null;
        if (this.correlationContainerProxy == null || this.correlationContainerProxy.getCorrelationContainer() == null) {
            return;
        }
        EMap eMap2 = eMap = this.correlationContainerProxy.getCorrelationContainer().getCorrelations();
        synchronized (eMap2) {
            Iterator iterator = eMap.iterator();
            while (iterator.hasNext()) {
                correlationEntryImpl = (CorrelationEntryImpl)iterator.next();
                object = correlationEntryImpl.getKey();
                if (!(object instanceof CBECommonBaseEvent) || !this.isFilterApplied((EObject)(cBECommonBaseEvent = (CBECommonBaseEvent)object)) || (list = (List)correlationEntryImpl.getValue()) == null) continue;
                int n = list.size();
                int n2 = 0;
                while (n2 < n) {
                    CBECommonBaseEvent cBECommonBaseEvent2 = (CBECommonBaseEvent)list.get(n2);
                    if (this.isFilterApplied((EObject)cBECommonBaseEvent2)) {
                        if (this.currentPageEvents.get(cBECommonBaseEvent) == null) {
                            if (this.currentPageEvents.get(cBECommonBaseEvent2) != null) {
                                this.createSourceOutOfPageMessage(cBECommonBaseEvent, cBECommonBaseEvent2);
                            }
                        } else if (this.currentPageEvents.get(cBECommonBaseEvent2) != null) {
                            if (this.inExpandedList(cBECommonBaseEvent) && cBECommonBaseEvent != this.thisSelection && cBECommonBaseEvent2 != this.thisSelection) {
                                this.createDummyMessage(cBECommonBaseEvent);
                            } else {
                                this.createAsyncMessage(cBECommonBaseEvent, cBECommonBaseEvent2);
                            }
                        } else if (!this.inExpandedList(cBECommonBaseEvent) || cBECommonBaseEvent == this.thisSelection) {
                            this.createTargetOutOfPageMessage(cBECommonBaseEvent, cBECommonBaseEvent2);
                        } else {
                            this.createDummyMessage(cBECommonBaseEvent);
                        }
                    }
                    ++n2;
                }
            }
        }
    }

    private LogAsyncReturnMessage createDummyMessage(CBECommonBaseEvent cBECommonBaseEvent) {
        LogGraphNode logGraphNode = (LogGraphNode)((Object)this.graphNodes.get(cBECommonBaseEvent));
        LogAsyncReturnMessage logAsyncReturnMessage = this.getDummyMessage(cBECommonBaseEvent);
        if (logAsyncReturnMessage != null) {
            return logAsyncReturnMessage;
        }
        logAsyncReturnMessage = new LogAsyncReturnMessage();
        logAsyncReturnMessage.setStartLifeline((TraceLifeline)((Object)this.lifelinesMap.get(this.getLifelinesMapKey(cBECommonBaseEvent))));
        logAsyncReturnMessage.setSource(cBECommonBaseEvent);
        logAsyncReturnMessage.setStartOccurrence(((LogGraphNode)((Object)this.graphNodes.get(cBECommonBaseEvent))).getStartOccurrence());
        this.frame.addMessage((BaseMessage)logAsyncReturnMessage);
        this.dummyMessages.put(cBECommonBaseEvent, logAsyncReturnMessage);
        return logAsyncReturnMessage;
    }

    private SourceOutOfPageMessage createSourceOutOfPageMessage(CBECommonBaseEvent cBECommonBaseEvent, CBECommonBaseEvent cBECommonBaseEvent2) {
        SourceOutOfPageMessage sourceOutOfPageMessage = this.getSourceMessage(cBECommonBaseEvent2);
        ArrayList<CBECommonBaseEvent> arrayList = null;
        if (sourceOutOfPageMessage == null) {
            arrayList = new ArrayList<CBECommonBaseEvent>();
            arrayList.add(cBECommonBaseEvent);
            sourceOutOfPageMessage = new SourceOutOfPageMessage();
            sourceOutOfPageMessage.setEndLifeline((TraceLifeline)((Object)this.lifelinesMap.get(this.getLifelinesMapKey(cBECommonBaseEvent2))));
            LogGraphNode logGraphNode = (LogGraphNode)((Object)this.graphNodes.get(cBECommonBaseEvent2));
            sourceOutOfPageMessage.setEndOccurrence(logGraphNode.getEndOccurrence());
            sourceOutOfPageMessage.setSource(arrayList);
            this.sourceOutOfPageMessages.put(cBECommonBaseEvent2, sourceOutOfPageMessage);
        } else {
            arrayList = sourceOutOfPageMessage.getSource();
            arrayList.add(cBECommonBaseEvent);
        }
        this.frame.addMessage((BaseMessage)sourceOutOfPageMessage);
        return sourceOutOfPageMessage;
    }

    protected LogInteractionsFrame createPage(boolean bl) {
        if (this.currentPageIndex > this.pageCache.length - 1 || bl) {
            this.frame = new LogInteractionsFrame();
        } else {
            LogInteractionsFrame logInteractionsFrame = (LogInteractionsFrame)((Object)this.pageCache[this.currentPageIndex]);
            if (logInteractionsFrame != null) {
                this.frame = logInteractionsFrame;
                this.cacheGraphNodes();
                return this.frame;
            }
            this.frame = new LogInteractionsFrame();
        }
        this.frame.setLifelineCategories(traceCategories);
        this.frame.forceEventOccurrenceSpacing(24);
        this.clearTemporaryCaches();
        this.generateLifelines();
        int n = this.getMaxCurrentPageRangeIndex();
        int n2 = this.currentPageIndex * this.PAGE_SIZE;
        int n3 = this.currentPageIndex * this.PAGE_SIZE + n;
        if (n3 > this.eventsList.size()) {
            this.currentPageIndex = 0;
            n = this.getMaxCurrentPageRangeIndex();
            n2 = 0;
            n3 = n;
        }
        int n4 = n2;
        while (n4 < n3) {
            EObject eObject = (EObject)this.eventsList.get(n4);
            if (eObject instanceof CBECommonBaseEvent) {
                this.currentPageEvents.put(eObject, "");
            }
            ++n4;
        }
        this.frame.setName(this.getFrameTitle());
        this.generateDiagram();
        this.pageCache[this.currentPageIndex] = this.frame;
        return this.frame;
    }

    protected String getFrameTitle() {
        return SDLogcPlugin.getString("STR_MENU_LOR") + ":      " + this.getFrameName();
    }

    protected void generateLifelines() {
        Iterator iterator = this.getLifelineArtifactsList().iterator();
        while (iterator.hasNext()) {
            TRCAgentProxy tRCAgentProxy = (TRCAgentProxy)iterator.next();
            TraceLifeline traceLifeline = new TraceLifeline();
            traceLifeline.setName(tRCAgentProxy.getName());
            traceLifeline.setCategory(0);
            this.lifelinesMap.put(tRCAgentProxy, traceLifeline);
            this.frame.addLifeLine(traceLifeline);
        }
    }

    protected List getLifelineArtifactsList() {
        return this.agentsList;
    }

    private int getMaxCurrentPageRangeIndex() {
        int n = this.totalSize % this.PAGE_SIZE;
        if (this.totalSize == 0) {
            return 0;
        }
        if (this.currentPageIndex + 1 < this.nrOfPages) {
            return this.PAGE_SIZE;
        }
        if (n == 0) {
            return this.PAGE_SIZE;
        }
        return n;
    }

    protected LogGraphNode createLogGraphNode(TraceLifeline traceLifeline, CBECommonBaseEvent cBECommonBaseEvent, LogGraphNode logGraphNode) {
        LogGraphNode logGraphNode2 = null;
        if (logGraphNode != null) {
            if (((LogRecordComparator)this.getComparator()).compareByTime(cBECommonBaseEvent, logGraphNode.getElement()) == 1) {
                logGraphNode2 = new LogGraphNode((EObject)cBECommonBaseEvent);
                traceLifeline.setCurrentEventOccurrence(this.frame.getMaxEventOccurrence());
                logGraphNode2.setStartOccurrence(traceLifeline.getNewEventOccurrence());
                logGraphNode2.setEndOccurrence(traceLifeline.getNewEventOccurrence());
                logGraphNode2.setName(cBECommonBaseEvent.getMsg());
                traceLifeline.addExecution((BasicExecutionOccurrence)logGraphNode2);
                logGraphNode2.setStartTime(CBEUtils.computeAdjustedCreationTime((CBECommonBaseEvent)cBECommonBaseEvent));
                logGraphNode2.setEndTime(CBEUtils.computeAdjustedCreationTime((CBECommonBaseEvent)cBECommonBaseEvent));
            } else if ((TraceLifeline)((Object)this.lifelinesMap.get(this.getLifelinesMapKey((CBECommonBaseEvent)logGraphNode.getElement()))) == traceLifeline) {
                if (!this.inExpandedList(cBECommonBaseEvent)) {
                    logGraphNode.addElement((EObject)cBECommonBaseEvent);
                    logGraphNode2 = logGraphNode;
                    logGraphNode2.setName(TString.change((String)SDLogcPlugin.getString("STR_EXPAND_NODE"), (String)"%1", (String)("" + logGraphNode2.getElements().size())));
                    logGraphNode2.setEndTime(CBEUtils.computeAdjustedCreationTime((CBECommonBaseEvent)cBECommonBaseEvent));
                } else {
                    logGraphNode2 = new LogGraphNode((EObject)cBECommonBaseEvent);
                    logGraphNode2.setStartOccurrence(logGraphNode.getEndOccurrence());
                    traceLifeline.setCurrentEventOccurrence(logGraphNode.getEndOccurrence());
                    logGraphNode2.setEndOccurrence(traceLifeline.getNewEventOccurrence());
                    logGraphNode2.setExpanded(true);
                    logGraphNode2.setName(cBECommonBaseEvent.getMsg());
                    traceLifeline.addExecution((BasicExecutionOccurrence)logGraphNode2);
                    LogGraphNode logGraphNode3 = this.getParentNode(cBECommonBaseEvent);
                    logGraphNode3.addElement((EObject)cBECommonBaseEvent);
                    logGraphNode3.setExpanded(true);
                    logGraphNode3.setBackgroundColor();
                    logGraphNode2.setStartTime(CBEUtils.computeAdjustedCreationTime((CBECommonBaseEvent)cBECommonBaseEvent));
                    logGraphNode2.setEndTime(CBEUtils.computeAdjustedCreationTime((CBECommonBaseEvent)cBECommonBaseEvent));
                }
            } else {
                List list = traceLifeline.getExecutions();
                if (list.size() > 0) {
                    LogGraphNode logGraphNode4 = (LogGraphNode)((Object)list.get(list.size() - 1));
                    if (logGraphNode4 != null) {
                        if (((LogRecordComparator)this.getComparator()).compareByTime(cBECommonBaseEvent, logGraphNode4.getElement()) == 1) {
                            logGraphNode2 = new LogGraphNode((EObject)cBECommonBaseEvent);
                            logGraphNode2.setStartOccurrence(logGraphNode.getStartOccurrence());
                            logGraphNode2.setEndOccurrence(logGraphNode.getEndOccurrence());
                            logGraphNode2.setName(cBECommonBaseEvent.getMsg());
                            traceLifeline.addExecution((BasicExecutionOccurrence)logGraphNode2);
                            logGraphNode2.setStartTime(CBEUtils.computeAdjustedCreationTime((CBECommonBaseEvent)cBECommonBaseEvent));
                            logGraphNode2.setEndTime(CBEUtils.computeAdjustedCreationTime((CBECommonBaseEvent)cBECommonBaseEvent));
                        } else if (!this.inExpandedList(cBECommonBaseEvent)) {
                            logGraphNode4.addElement((EObject)cBECommonBaseEvent);
                            logGraphNode2 = logGraphNode4;
                            logGraphNode2.setName(TString.change((String)SDLogcPlugin.getString("STR_EXPAND_NODE"), (String)"%1", (String)("" + logGraphNode2.getElements().size())));
                            logGraphNode2.setEndTime(CBEUtils.computeAdjustedCreationTime((CBECommonBaseEvent)cBECommonBaseEvent));
                        } else {
                            logGraphNode2 = new LogGraphNode((EObject)cBECommonBaseEvent);
                            logGraphNode2.setStartOccurrence(logGraphNode4.getEndOccurrence());
                            traceLifeline.setCurrentEventOccurrence(logGraphNode4.getEndOccurrence());
                            logGraphNode2.setEndOccurrence(traceLifeline.getNewEventOccurrence());
                            logGraphNode2.setName(cBECommonBaseEvent.getMsg());
                            logGraphNode2.setExpanded(true);
                            traceLifeline.addExecution((BasicExecutionOccurrence)logGraphNode2);
                            LogGraphNode logGraphNode5 = this.getParentNode(cBECommonBaseEvent);
                            logGraphNode5.addElement((EObject)cBECommonBaseEvent);
                            logGraphNode5.setExpanded(true);
                            logGraphNode5.setBackgroundColor();
                            logGraphNode2.setStartTime(CBEUtils.computeAdjustedCreationTime((CBECommonBaseEvent)cBECommonBaseEvent));
                            logGraphNode2.setEndTime(CBEUtils.computeAdjustedCreationTime((CBECommonBaseEvent)cBECommonBaseEvent));
                        }
                    }
                } else {
                    logGraphNode2 = new LogGraphNode((EObject)cBECommonBaseEvent);
                    logGraphNode2.setStartOccurrence(logGraphNode.getStartOccurrence());
                    logGraphNode2.setEndOccurrence(logGraphNode.getEndOccurrence());
                    logGraphNode2.setName(cBECommonBaseEvent.getMsg());
                    traceLifeline.addExecution((BasicExecutionOccurrence)logGraphNode2);
                    logGraphNode2.setStartTime(CBEUtils.computeAdjustedCreationTime((CBECommonBaseEvent)cBECommonBaseEvent));
                    logGraphNode2.setEndTime(CBEUtils.computeAdjustedCreationTime((CBECommonBaseEvent)cBECommonBaseEvent));
                }
            }
        } else {
            logGraphNode2 = new LogGraphNode((EObject)cBECommonBaseEvent);
            logGraphNode2.setStartOccurrence(traceLifeline.getNewEventOccurrence());
            logGraphNode2.setEndOccurrence(traceLifeline.getNewEventOccurrence());
            logGraphNode2.setName(cBECommonBaseEvent.getMsg());
            traceLifeline.addExecution((BasicExecutionOccurrence)logGraphNode2);
            logGraphNode2.setStartTime(CBEUtils.computeAdjustedCreationTime((CBECommonBaseEvent)cBECommonBaseEvent));
            logGraphNode2.setEndTime(CBEUtils.computeAdjustedCreationTime((CBECommonBaseEvent)cBECommonBaseEvent));
        }
        logGraphNode2.setBackgroundColor();
        return logGraphNode2;
    }

    private AsyncMessage createAsyncMessage(CBECommonBaseEvent cBECommonBaseEvent, CBECommonBaseEvent cBECommonBaseEvent2) {
        TraceLifeline traceLifeline = (TraceLifeline)((Object)this.lifelinesMap.get(this.getLifelinesMapKey(cBECommonBaseEvent)));
        TraceLifeline traceLifeline2 = (TraceLifeline)((Object)this.lifelinesMap.get(this.getLifelinesMapKey(cBECommonBaseEvent2)));
        LogGraphNode logGraphNode = (LogGraphNode)((Object)this.graphNodes.get(cBECommonBaseEvent));
        LogGraphNode logGraphNode2 = (LogGraphNode)((Object)this.graphNodes.get(cBECommonBaseEvent2));
        LogAsyncMessage logAsyncMessage = new LogAsyncMessage();
        logAsyncMessage.setStartLifeline(traceLifeline);
        logAsyncMessage.setEndLifeline(traceLifeline2);
        logAsyncMessage.setStartOccurrence(logGraphNode.getStartOccurrence());
        logAsyncMessage.setEndOccurrence(logGraphNode2.getStartOccurrence());
        logAsyncMessage.setSourceNode(logGraphNode);
        logAsyncMessage.setTargetNode(logGraphNode2);
        this.frame.addMessage((BaseMessage)logAsyncMessage);
        return logAsyncMessage;
    }

    private TargetOutOfPageMessage createTargetOutOfPageMessage(CBECommonBaseEvent cBECommonBaseEvent, CBECommonBaseEvent cBECommonBaseEvent2) {
        TraceLifeline traceLifeline = (TraceLifeline)((Object)this.lifelinesMap.get(this.getLifelinesMapKey(cBECommonBaseEvent)));
        LogGraphNode logGraphNode = (LogGraphNode)((Object)this.graphNodes.get(cBECommonBaseEvent));
        ArrayList<CBECommonBaseEvent> arrayList = null;
        TargetOutOfPageMessage targetOutOfPageMessage = this.getTargetMessage(cBECommonBaseEvent);
        if (targetOutOfPageMessage == null) {
            arrayList = new ArrayList<CBECommonBaseEvent>();
            arrayList.add(cBECommonBaseEvent2);
            targetOutOfPageMessage = new TargetOutOfPageMessage();
            targetOutOfPageMessage.setStartLifeline(traceLifeline);
            targetOutOfPageMessage.setStartOccurrence(logGraphNode.getEndOccurrence());
            targetOutOfPageMessage.setTarget(arrayList);
            this.targetOutOfPageMessages.put(cBECommonBaseEvent, targetOutOfPageMessage);
            this.frame.addMessage((BaseMessage)targetOutOfPageMessage);
        } else {
            arrayList = targetOutOfPageMessage.getTarget();
            arrayList.add(cBECommonBaseEvent2);
        }
        return targetOutOfPageMessage;
    }

    protected void addEvents(TRCAgentProxy tRCAgentProxy) {
        this.eventsList.addAll(tRCAgentProxy.getAgent().getDefaultEvents());
    }

    protected void cacheGraphNodes() {
        this.graphNodes.clear();
        TraceLifeline traceLifeline = null;
        int n = 0;
        while (n < this.frame.getLifelines().size()) {
            traceLifeline = (TraceLifeline)((Object)this.frame.getLifelines().get(n));
            int n2 = 0;
            while (n2 < traceLifeline.getExecutions().size()) {
                LogGraphNode logGraphNode = (LogGraphNode)((Object)traceLifeline.getExecutions().get(n2));
                if (logGraphNode != null) {
                    if (logGraphNode.hasElements()) {
                        int n3 = 0;
                        while (n3 < logGraphNode.getElements().size()) {
                            this.graphNodes.put(logGraphNode.getElements().get(n3), logGraphNode);
                            ++n3;
                        }
                    } else {
                        this.graphNodes.put(logGraphNode.getElement(), logGraphNode);
                    }
                }
                ++n2;
            }
            ++n;
        }
    }

    protected LogGraphNode getGraphNodeFromArtifact(CBECommonBaseEvent cBECommonBaseEvent) {
        Object var2_2 = null;
        LogGraphNode logGraphNode = null;
        logGraphNode = (LogGraphNode)((Object)this.graphNodes.get(cBECommonBaseEvent));
        return logGraphNode;
    }

    public void selectionChanged(IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
        if (iWorkbenchPart instanceof INavigator && !((INavigator)iWorkbenchPart).isLinkingEnabled()) {
            return;
        }
        if (this.view != null && this.view.getSDWidget() != null && !this.view.getSDWidget().isDisposed()) {
            EObject eObject = HyadesUtil.getMofObject();
            if (eObject != null && eObject != this.inputObject) {
                this.view.setFrame((Frame)this.parseModel(eObject));
                this.disableMessageActions();
            } else if (eObject == null) {
                this.inputObject = eObject;
                this.view.setFrame(new Frame());
            }
        }
    }

    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        if (selectionChangedEvent.getSelection() == null || ((IStructuredSelection)selectionChangedEvent.getSelection()).size() == 0) {
            return;
        }
        Object object = ((IStructuredSelection)selectionChangedEvent.getSelection()).getFirstElement();
        if (object instanceof LogGraphNode && this.view.getSDWidget().getViewControl().isFocusControl()) {
            CBECommonBaseEvent cBECommonBaseEvent = this.currentSelection;
            this.thisSelection = (CBECommonBaseEvent)((LogGraphNode)((Object)object)).getElement();
            if (this.thisSelection != cBECommonBaseEvent && (this.inExpandedList(this.thisSelection) || this.inExpandedList(cBECommonBaseEvent))) {
                this.revealGraphConnections(this.thisSelection);
                return;
            }
            this.currentSelection = (CBECommonBaseEvent)((LogGraphNode)((Object)object)).getElement();
            LogUtil.notifyViewSelectionChanged((Object)this, (Object)this.currentSelection);
        }
    }

    public boolean isDisplayingOnlyCorrelations() {
        return this.displayOnlyCorrelations;
    }

    public boolean isLifelineSupported() {
        return true;
    }

    public boolean isSyncMessageSupported() {
        return true;
    }

    public boolean isSyncMessageReturnSupported() {
        return true;
    }

    public boolean isAsyncMessageSupported() {
        return true;
    }

    public boolean isAsyncMessageReturnSupported() {
        return false;
    }

    public boolean isStopSupported() {
        return false;
    }

    public boolean hasNextPage() {
        return this.currentPageIndex + 1 < this.nrOfPages;
    }

    public boolean hasPrevPage() {
        return this.currentPageIndex > 0;
    }

    public void nextPage() {
        if (this.currentPageIndex + 1 < this.nrOfPages) {
            ++this.currentPageIndex;
            this.view.setFrame((Frame)this.createPage(false));
            this.disableMessageActions();
        }
    }

    public void prevPage() {
        if (this.currentPageIndex > 0) {
            --this.currentPageIndex;
            this.view.setFrame((Frame)this.createPage(false));
            this.disableMessageActions();
        }
    }

    protected void createPartition() {
        this.totalSize = this.eventsList.size();
        this.PAGE_SIZE = (int)SDLogcPlugin.getDefault().getPreferenceStore().getLong("page_size");
        this.nrOfPages = this.totalSize % this.PAGE_SIZE > 0 ? this.totalSize / this.PAGE_SIZE + 1 : this.totalSize / this.PAGE_SIZE;
        this.pageCache = this.nrOfPages == 0 ? new Object[1] : new Object[this.nrOfPages];
    }

    public String getTitleString() {
        String string = SDLogcPlugin.getString("STR_VIEW_TITLE") + ": " + SDLogcPlugin.getString("STR_MENU_LOR");
        if (this.correlationContainerProxy != null) {
            string = string + " <" + this.correlationContainerProxy.getCorrelationEngine().getName() + "> ";
        }
        return string;
    }

    public void handleViewSelectionChangedEvent(ViewSelectionChangedEvent viewSelectionChangedEvent) {
        Object object;
        Object object2 = viewSelectionChangedEvent.getSource();
        if (object2 != this && (object = UIPlugin.getDefault().getSelectionModel(HyadesUtil.getMofObject()).getFirstElement()) instanceof CBECommonBaseEvent) {
            this.setSelection((CBECommonBaseEvent)object);
        }
    }

    private void showCorrelationDialog() {
        LogCorrelationSelectionDialog logCorrelationSelectionDialog = new LogCorrelationSelectionDialog(null, CorrelationHelper.getInstance().getCorrelationExtensions());
        logCorrelationSelectionDialog.open();
        if (logCorrelationSelectionDialog.getReturnCode() == 0) {
            this.setCorrelationType(logCorrelationSelectionDialog.getSelectedCorrelation());
            this.correlationContainerProxy = CorrelationHelper.getInstance().createCorrelationContainer(this.correlationType, (Object)this.inputObject, this.correlationType.getAttribute("name"));
            this.inputObject = this.correlationContainerProxy;
            LogUtil.selectInLogNavigator((EObject)this.correlationContainerProxy);
        }
    }

    public void setSelection(CBECommonBaseEvent cBECommonBaseEvent) {
        this.view.getSDWidget().clearSelection();
        if (this.eventsList != null) {
            int n = this.eventsList.indexOf(cBECommonBaseEvent);
            int n2 = 0;
            if (n > -1) {
                n2 = n / this.PAGE_SIZE;
            }
            this.goToPage(n2);
            LogGraphNode logGraphNode = this.getGraphNodeFromArtifact(cBECommonBaseEvent);
            CBECommonBaseEvent cBECommonBaseEvent2 = this.currentSelection;
            this.thisSelection = cBECommonBaseEvent;
            if (this.thisSelection != cBECommonBaseEvent2 && (this.inExpandedList(this.thisSelection) || this.inExpandedList(cBECommonBaseEvent2))) {
                this.revealGraphConnections(this.thisSelection);
            } else {
                this.currentSelection = cBECommonBaseEvent;
                this.view.setFrameAndEnsureVisible((Frame)this.frame, (GraphNode)logGraphNode);
                this.disableMessageActions();
                this.view.getSDWidget().addSelection((GraphNode)logGraphNode);
            }
        }
    }

    private void goToPage(int n) {
        this.currentPageIndex = n;
        this.view.setFrame((Frame)this.createPage(false));
        this.disableMessageActions();
        this.view.updateCoolBar();
    }

    public IConfigurationElement getCorrelationType() {
        return this.correlationType;
    }

    public void setCorrelationType(IConfigurationElement iConfigurationElement) {
        this.correlationType = iConfigurationElement;
    }

    public Action getFilterAction() {
        String string = SDLogcPlugin.getString("STR_FILTER_RECORD");
        Action action = new Action(string){

            public void run() {
                LogInteractions.this.filter();
            }
        };
        action.setText(string);
        action.setDescription(string);
        action.setToolTipText(string);
        return action;
    }

    public void filter() {
        FiltersDialog filtersDialog = new FiltersDialog(this.view.getViewSite().getShell(), SDLogcPlugin.getString("STR_ST_FILTER_SETTINGS"), null, (ILogFilterProvider)this, true);
        filtersDialog.open();
    }

    public Action getFindAction() {
        String string = SDLogcPlugin.getString("STR_FIND_RECORD");
        Action action = new Action(string){

            public void run() {
                LogInteractions.this.find();
            }
        };
        action.setText(string);
        action.setDescription(string);
        action.setToolTipText(string);
        return action;
    }

    public void find() {
        SearchRecordDialog searchRecordDialog = new SearchRecordDialog(this.view.getViewSite().getShell(), SDLogcPlugin.getString("STR_ST_FIND_SETTINGS"), null, (ILogFindProvider)this);
        searchRecordDialog.open();
    }

    public boolean filterRecord(LogFilterCriteria logFilterCriteria) {
        this.filterTableElements = logFilterCriteria.getFilters();
        this.displayOnlyCorrelations = logFilterCriteria.isShowCorrelationOnly();
        this.generateLogInteractions(this.inputObject, false);
        return true;
    }

    public boolean findRecord(LogFindCriteria logFindCriteria) {
        this.lblMessage = logFindCriteria.getFindMessage();
        Object object = this.getRecordSearchEngine().search(logFindCriteria.getFilters(), logFindCriteria.isForwardDirection() ? 1 : -1, (Object)this.currentSelection);
        this.selectFindRecord(object);
        return true;
    }

    public LogRecordSearch getRecordSearchEngine() {
        if (this.logRecordSearch == null) {
            this.logRecordSearch = new LogRecordSearch();
        }
        Object object = this.getStartNode();
        this.logRecordSearch.initialize(this.eventsList, object);
        return this.logRecordSearch;
    }

    private Object getStartNode() {
        return this.currentSelection;
    }

    private void selectFindRecord(Object object) {
        if (object == null) {
            this.lblMessage.setText(SDLogcPlugin.getString("STR_STRING_NOT_FOUND"));
            return;
        }
        this.setSelection((CBECommonBaseEvent)object);
    }

    public boolean storeFindOptions(LogFindCriteria logFindCriteria) {
        FilterTableElement.saveFilters((ArrayList)logFindCriteria.getFilters(), (String)"uml2sd_extend_find_options", (IPreferenceStore)SDLogcPlugin.getDefault().getPreferenceStore());
        SDLogcPlugin.getDefault().getPreferenceStore().setValue("uml2sd_extend_find_direction_options", logFindCriteria.isForwardDirection() ? "1" : "-1");
        return true;
    }

    public String loadFindPreferenceString() {
        IPreferenceStore iPreferenceStore = SDLogcPlugin.getDefault().getPreferenceStore();
        return iPreferenceStore.getString("uml2sd_extend_find_options");
    }

    public boolean loadFindDirection() {
        return SDLogcPlugin.getDefault().getPreferenceStore().getString("uml2sd_extend_find_direction_options").equals("1");
    }

    private SourceOutOfPageMessage getSourceMessage(CBECommonBaseEvent cBECommonBaseEvent) {
        if (this.sourceOutOfPageMessages == null) {
            this.sourceOutOfPageMessages = new HashMap();
        }
        return (SourceOutOfPageMessage)((Object)this.sourceOutOfPageMessages.get(cBECommonBaseEvent));
    }

    private TargetOutOfPageMessage getTargetMessage(CBECommonBaseEvent cBECommonBaseEvent) {
        if (this.targetOutOfPageMessages == null) {
            this.targetOutOfPageMessages = new HashMap();
        }
        return (TargetOutOfPageMessage)((Object)this.targetOutOfPageMessages.get(cBECommonBaseEvent));
    }

    private LogAsyncReturnMessage getDummyMessage(CBECommonBaseEvent cBECommonBaseEvent) {
        if (this.dummyMessages == null) {
            this.dummyMessages = new HashMap();
        }
        return (LogAsyncReturnMessage)((Object)this.dummyMessages.get(cBECommonBaseEvent));
    }

    public void handleProfileEvent(ProfileEvent profileEvent) {
        if ((profileEvent.getType() == 64 || profileEvent.getType() == 32) && profileEvent.getSource() instanceof EObject) {
            this.refresh();
        }
    }

    public int currentPage() {
        if (this.nrOfPages == 0) {
            return -1;
        }
        return this.currentPageIndex;
    }

    public String itemsText() {
        return SDLogcPlugin.getString("STR_ITEMS");
    }

    public int itemsTotalCount() {
        return this.eventsList.size();
    }

    public int maxItemsByPageCount() {
        return this.PAGE_SIZE;
    }

    public String noItemsText() {
        return SDLogcPlugin.getString("STR_ITEMS");
    }

    public String oneItemText() {
        return SDLogcPlugin.getString("STR_ITEM");
    }

    public int pagesCount() {
        return this.nrOfPages;
    }

    public void pageSettingsChanged(int n, int n2) {
        if (0 <= n2 && n2 < this.nrOfPages) {
            this.goToPage(n2);
        }
        if (n > this.MAX_NR_OF_RECORDS) {
            n = this.MAX_NR_OF_RECORDS;
        }
        if (this.PAGE_SIZE != n) {
            SDLogcPlugin.getDefault().getPreferenceStore().setValue("page_size", n);
            this.PAGE_SIZE = n;
        }
    }

    public void pageNumberChanged(int n) {
        this.goToPage(n);
    }

    public CorrelationContainerProxy getCorrelationContainerProxy() {
        return this.correlationContainerProxy;
    }

    public String getFrameName() {
        return MessageFormat.format(SDLogcPlugin.getString("STR_PAGE_INFO"), String.valueOf(this.currentPage() + 1), String.valueOf(this.nrOfPages));
    }

    public void applyPreferences() {
        this.view.setFrame((Frame)this.parseModel(this.inputObject));
        this.disableMessageActions();
    }

    public void preserveSelection(CBECommonBaseEvent cBECommonBaseEvent) {
        if (cBECommonBaseEvent == null) {
            return;
        }
        this.view.getSDWidget().clearSelection();
        LogGraphNode logGraphNode = (LogGraphNode)((Object)this.graphNodes.get(cBECommonBaseEvent));
        if (logGraphNode != null) {
            this.currentSelection = cBECommonBaseEvent;
            this.view.setFrameAndEnsureVisible((Frame)this.frame, (GraphNode)logGraphNode);
            this.disableMessageActions();
            this.view.getSDWidget().addSelection((GraphNode)logGraphNode);
        }
    }

    public void collapseLogGraphNode(List list) {
        LogGraphNode logGraphNode = null;
        int n = 0;
        while (n < list.size()) {
            logGraphNode = (LogGraphNode)((Object)list.get(n));
            this.removeFromExpandedList(logGraphNode);
            ++n;
        }
        logGraphNode = (LogGraphNode)((Object)list.get(0));
        CBECommonBaseEvent cBECommonBaseEvent = (CBECommonBaseEvent)logGraphNode.getElement();
        this.pageCache[this.currentPageIndex] = null;
        this.view.setFrame((Frame)this.createPage(false));
        this.disableMessageActions();
        this.preserveSelection(cBECommonBaseEvent);
    }

    public void expandLogGraphNode(List list) {
        LogGraphNode logGraphNode = null;
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            logGraphNode = (LogGraphNode)((Object)list.get(n2));
            this.addToExpandedList(logGraphNode);
            ++n2;
        }
        logGraphNode = (LogGraphNode)((Object)list.get(0));
        CBECommonBaseEvent cBECommonBaseEvent = (CBECommonBaseEvent)logGraphNode.getElement();
        this.pageCache[this.currentPageIndex] = null;
        this.view.setFrame((Frame)this.createPage(false));
        this.disableMessageActions();
        this.preserveSelection(cBECommonBaseEvent);
    }

    public LogGraphNode getParentNode(CBECommonBaseEvent cBECommonBaseEvent) {
        TraceLifeline traceLifeline = (TraceLifeline)((Object)this.lifelinesMap.get(this.getLifelinesMapKey(cBECommonBaseEvent)));
        int n = 0;
        while (n < this.expandedList.size()) {
            CBECommonBaseEvent cBECommonBaseEvent2 = (CBECommonBaseEvent)this.expandedList.get(n);
            if (this.currentPageEvents.get(cBECommonBaseEvent2) != null && ((LogRecordComparator)this.getComparator()).compareByTime(cBECommonBaseEvent, cBECommonBaseEvent2) == 0 && traceLifeline == (TraceLifeline)((Object)this.lifelinesMap.get(this.getLifelinesMapKey(cBECommonBaseEvent2)))) {
                return (LogGraphNode)((Object)this.graphNodes.get(cBECommonBaseEvent2));
            }
            ++n;
        }
        return null;
    }

    public boolean inExpandedList(CBECommonBaseEvent cBECommonBaseEvent) {
        if (cBECommonBaseEvent == null) {
            return false;
        }
        return this.getParentNode(cBECommonBaseEvent) != null;
    }

    public void addToExpandedList(LogGraphNode logGraphNode) {
        this.expandedList.add(logGraphNode.getElement());
    }

    public void removeFromExpandedList(LogGraphNode logGraphNode) {
        if (logGraphNode.hasElements()) {
            this.expandedList.remove(logGraphNode.getElement());
        } else {
            CBECommonBaseEvent cBECommonBaseEvent = (CBECommonBaseEvent)this.getParentNode((CBECommonBaseEvent)logGraphNode.getElement()).getElement();
            if (cBECommonBaseEvent != null) {
                this.expandedList.remove(cBECommonBaseEvent);
            }
        }
    }

    private void revealGraphConnections(CBECommonBaseEvent cBECommonBaseEvent) {
        this.pageCache[this.currentPageIndex] = null;
        this.view.setFrame((Frame)this.createPage(false));
        this.disableMessageActions();
        this.preserveSelection(cBECommonBaseEvent);
    }

    private void disableMessageActions() {
        this.view.setEnableCommand("org.eclipse.hyades.uml2sd.ui.actions.GoToCalled", false);
        this.view.setEnableCommand("org.eclipse.hyades.uml2sd.ui.actions.GoToCaller", false);
    }

    static {
        LogInteractions.traceCategories[0] = new LifelineCategories();
        traceCategories[0].setName("");
        image = SDLogcPluginImages.getImage("log_obj.gif");
        traceCategories[0].setImage(image);
    }

    protected class LogRecordComparator
    implements Comparator {
        protected LogRecordComparator() {
        }

        public int compare(Object object, Object object2) {
            if (CBEUtils.computeAdjustedCreationTime((CBECommonBaseEvent)((CBECommonBaseEvent)object)) > CBEUtils.computeAdjustedCreationTime((CBECommonBaseEvent)((CBECommonBaseEvent)object2))) {
                return 1;
            }
            if (CBEUtils.computeAdjustedCreationTime((CBECommonBaseEvent)((CBECommonBaseEvent)object)) == CBEUtils.computeAdjustedCreationTime((CBECommonBaseEvent)((CBECommonBaseEvent)object2))) {
                if (((CBECommonBaseEvent)object).getSequenceNumber() > ((CBECommonBaseEvent)object2).getSequenceNumber()) {
                    return 1;
                }
                if (((CBECommonBaseEvent)object).getSequenceNumber() == ((CBECommonBaseEvent)object2).getSequenceNumber()) {
                    return 0;
                }
                return -1;
            }
            return -1;
        }

        public int compareByTime(Object object, Object object2) {
            if (CBEUtils.computeAdjustedCreationTime((CBECommonBaseEvent)((CBECommonBaseEvent)object)) > CBEUtils.computeAdjustedCreationTime((CBECommonBaseEvent)((CBECommonBaseEvent)object2))) {
                return 1;
            }
            if (CBEUtils.computeAdjustedCreationTime((CBECommonBaseEvent)((CBECommonBaseEvent)object)) == CBEUtils.computeAdjustedCreationTime((CBECommonBaseEvent)((CBECommonBaseEvent)object2))) {
                return 0;
            }
            return -1;
        }
    }

    public class TraceLifeline
    extends Lifeline {
        public EObject model;
        public int start;
        public int end;
    }

    public class LogInteractionsFrame
    extends Frame {
        public int getMaxEventOccurrence() {
            return super.getMaxEventOccurrence();
        }

        public List getLifelines() {
            return super.getLifelines();
        }
    }
}

