/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.loaders.trace;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.hyades.loaders.trace.CallStackPerThread;
import org.eclipse.hyades.loaders.trace.InvocationContext;
import org.eclipse.hyades.loaders.trace.TString;
import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.loaders.util.LookupServiceExtensions;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCConfiguration;
import org.eclipse.hyades.models.hierarchy.TRCOption;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCFullMethodInvocation;
import org.eclipse.hyades.models.trace.TRCFullTraceObject;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCObject;
import org.eclipse.hyades.models.trace.TRCPackage;
import org.eclipse.hyades.models.trace.TRCProcess;
import org.eclipse.hyades.models.trace.TRCSourceInfo;
import org.eclipse.hyades.models.trace.TraceFactory;

public final class TraceUtils {
    private static StringBuffer strBuf = new StringBuffer();
    static /* synthetic */ Class class$org$eclipse$hyades$models$trace$impl$TRCSourceInfoImpl;
    static /* synthetic */ Class class$org$eclipse$hyades$models$trace$impl$TRCPackageImpl;
    static /* synthetic */ Class class$org$eclipse$hyades$loaders$trace$VirtualObjectInfo;

    public static boolean isConstructor(String string) {
        return string.equals("<clinit>") || string.equals("-clinit-") || string.equals("-init-");
    }

    public static String getForwardInvocationsId(InvocationContext invocationContext) {
        return TraceUtils.getForwardInvocationsId(invocationContext.getInvocationAgentIdRef());
    }

    public static String getForwardInvocationsId(String string) {
        return string;
    }

    public static String getMethodInvocationId(InvocationContext invocationContext) {
        return TraceUtils.getMethodInvocationId(invocationContext.getInvocationThreadIdRef(), invocationContext.getInvocationTicket());
    }

    public static String getMethodInvocationId(int n, long l) {
        return n + "_" + l;
    }

    public static String getMethodName(TRCMethod tRCMethod, String string) {
        if (string.equals("-init-")) {
            return tRCMethod.getDefiningClass().getName();
        }
        return string;
    }

    public static TRCProcess getProcess(TRCAgent tRCAgent) {
        if (tRCAgent != null && tRCAgent.getProcess() instanceof TRCProcess) {
            return (TRCProcess)tRCAgent.getProcess();
        }
        return null;
    }

    public static String getOptionValue(TRCAgentProxy tRCAgentProxy, String string) {
        if (tRCAgentProxy == null || tRCAgentProxy.getConfigurations() == null) {
            return null;
        }
        Object[] objectArray = tRCAgentProxy.getConfigurations().toArray();
        int n = 0;
        while (n < objectArray.length) {
            TRCConfiguration tRCConfiguration = (TRCConfiguration)objectArray[n];
            if (tRCConfiguration.isActive()) {
                Object[] objectArray2 = tRCConfiguration.getOptions().toArray();
                int n2 = 0;
                while (n2 < objectArray2.length) {
                    TRCOption tRCOption = (TRCOption)objectArray2[n2];
                    if (tRCOption.getKey().equals(string)) {
                        return tRCOption.getValue();
                    }
                    ++n2;
                }
            }
            ++n;
        }
        return null;
    }

    public static boolean isBooleanOptionEnabled(HierarchyContext hierarchyContext, String string) {
        boolean bl;
        boolean bl2 = hierarchyContext.getCustomData().containsKey(string);
        if (!bl2) {
            String string2 = TraceUtils.getOptionValue(hierarchyContext.getAgentProxy(), string);
            if (string2 != null && Boolean.valueOf(string2).booleanValue()) {
                hierarchyContext.getCustomData().put(string, Boolean.TRUE);
                bl = true;
            } else {
                hierarchyContext.getCustomData().put(string, Boolean.FALSE);
                bl = false;
            }
        } else {
            bl = (Boolean)hierarchyContext.getCustomData().get(string);
        }
        return bl;
    }

    public static void setSourceInfo(HierarchyContext hierarchyContext, TRCProcess tRCProcess, TRCClass tRCClass, String string) {
        TRCSourceInfo tRCSourceInfo = (TRCSourceInfo)LookupServiceExtensions.getInstance().locate(hierarchyContext, class$org$eclipse$hyades$models$trace$impl$TRCSourceInfoImpl == null ? (class$org$eclipse$hyades$models$trace$impl$TRCSourceInfoImpl = TraceUtils.class$("org.eclipse.hyades.models.trace.impl.TRCSourceInfoImpl")) : class$org$eclipse$hyades$models$trace$impl$TRCSourceInfoImpl, LoadersUtils.getLookUpKey((String)string));
        if (tRCSourceInfo == null) {
            tRCSourceInfo = TraceUtils.isBooleanOptionEnabled(hierarchyContext, "LLDATA_ENABLED") ? TraceFactory.eINSTANCE.createTRCSourceInfoWithLLData() : TraceFactory.eINSTANCE.createTRCSourceInfo();
            tRCSourceInfo.setLocation(string);
            tRCProcess.getSourceInfos().add((Object)tRCSourceInfo);
        }
        if (tRCClass.getSourceInfo() == null) {
            tRCClass.setSourceInfo(tRCSourceInfo);
        } else if (!tRCClass.getSourceInfo().getLocation().equals(string)) {
            tRCClass.setSourceInfo(tRCSourceInfo);
        }
    }

    public static void addClassObjectToClassClass(HierarchyContext hierarchyContext, TRCProcess tRCProcess, TRCObject tRCObject) {
        TRCClass tRCClass = tRCProcess.getClassClass();
        if (tRCClass == null) {
            tRCClass = TraceFactory.eINSTANCE.createTRCClass();
            tRCClass.setId(-1);
            tRCClass.setName("Class");
            TraceUtils.addClassToPackage(hierarchyContext, tRCClass, "java.lang.Class", tRCProcess);
            TraceUtils.setSourceInfo(hierarchyContext, tRCProcess, tRCClass, "Class.java");
            tRCClass.getSourceInfo().setLocation("Class.java");
            LookupServiceExtensions.getInstance().register(hierarchyContext, (Object)tRCClass);
            tRCProcess.setClassClass(tRCClass);
        }
        if (tRCObject != null && tRCObject.getIsA() != tRCClass) {
            tRCObject.setIsA(tRCClass);
        }
    }

    public static void addClassToPackage(HierarchyContext hierarchyContext, TRCClass tRCClass, String string, TRCProcess tRCProcess) {
        if (tRCClass.getPackage() != null) {
            return;
        }
        String string2 = TraceUtils.packageName(string);
        TRCPackage tRCPackage = (TRCPackage)LookupServiceExtensions.getInstance().locate(hierarchyContext, class$org$eclipse$hyades$models$trace$impl$TRCPackageImpl == null ? (class$org$eclipse$hyades$models$trace$impl$TRCPackageImpl = TraceUtils.class$("org.eclipse.hyades.models.trace.impl.TRCPackageImpl")) : class$org$eclipse$hyades$models$trace$impl$TRCPackageImpl, LoadersUtils.getLookUpKey((String)string2));
        if (tRCPackage != null) {
            tRCClass.setPackage(tRCPackage);
            return;
        }
        tRCPackage = TraceFactory.eINSTANCE.createTRCPackage();
        tRCPackage.setName(string2);
        tRCPackage.setProcess(tRCProcess);
        tRCClass.setPackage(tRCPackage);
        TraceUtils.createSuperPackages(hierarchyContext, tRCPackage);
    }

    public static String className(String string) {
        if (string.startsWith("[")) {
            strBuf.setLength(0);
            TraceUtils.expandArrayType(string, 0, strBuf);
            String string2 = strBuf.toString();
            strBuf.setLength(0);
            return string2;
        }
        int n = Math.max(string.lastIndexOf(47), string.lastIndexOf(92));
        int n2 = string.lastIndexOf(46);
        if ((n = Math.max(n, n2)) < 0) {
            return string;
        }
        return string.substring(n + 1);
    }

    public static String convertMethodSignature(TRCMethod tRCMethod, String string) {
        return TraceUtils.convertMethodSignature(tRCMethod.getModifier(), string);
    }

    public static String convertMethodSignature(int n, String string) {
        if (string == null) {
            return "()";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = string.indexOf(40);
        if (n2 >= 0) {
            int n3 = string.indexOf(41);
            if (n3 == ++n2) {
                stringBuffer.append("()");
            } else {
                stringBuffer.append("(");
                while (n2 < n3) {
                    if ((n2 = TraceUtils.expandMessageFieldType(string, n2, stringBuffer)) >= n3) continue;
                    stringBuffer.append(", ");
                }
                stringBuffer.append(")");
            }
            if ((n & 0x80) == 0) {
                stringBuffer.append(" ");
                TraceUtils.expandMessageFieldType(string, ++n2, stringBuffer);
            }
        }
        return stringBuffer.toString();
    }

    public static void createSuperPackages(HierarchyContext hierarchyContext, TRCPackage tRCPackage) {
        TRCProcess tRCProcess = tRCPackage.getProcess();
        String string = tRCPackage.getName();
        int n = 0;
        int n2 = string.length();
        while (n2 > 0) {
            n = string.lastIndexOf(46, n2);
            if (n < 0) break;
            String string2 = string.substring(0, n);
            TRCPackage tRCPackage2 = (TRCPackage)LookupServiceExtensions.getInstance().locate(hierarchyContext, class$org$eclipse$hyades$models$trace$impl$TRCPackageImpl == null ? TraceUtils.class$("org.eclipse.hyades.models.trace.impl.TRCPackageImpl") : class$org$eclipse$hyades$models$trace$impl$TRCPackageImpl, LoadersUtils.getLookUpKey((String)string2));
            if (tRCPackage2 == null) {
                tRCPackage2 = TraceFactory.eINSTANCE.createTRCPackage();
                tRCPackage2.setName(string2);
                tRCPackage2.setProcess(tRCProcess);
            }
            tRCPackage.setParent(tRCPackage2);
            tRCPackage = tRCPackage2;
            n2 = n - 1;
        }
    }

    public static int expandMessageFieldType(String string, int n, StringBuffer stringBuffer) {
        int n2 = 0;
        char c = string.charAt(n);
        while (c == '[') {
            ++n2;
            c = string.charAt(++n);
        }
        switch (c) {
            case 'B': {
                stringBuffer.append("byte");
                break;
            }
            case 'C': {
                stringBuffer.append("char");
                break;
            }
            case 'D': {
                stringBuffer.append("double");
                break;
            }
            case 'F': {
                stringBuffer.append("float");
                break;
            }
            case 'I': {
                stringBuffer.append("int");
                break;
            }
            case 'J': {
                stringBuffer.append("long");
                break;
            }
            case 'S': {
                stringBuffer.append("short");
                break;
            }
            case 'Z': {
                stringBuffer.append("boolean");
                break;
            }
            case 'V': {
                stringBuffer.append("void");
                break;
            }
            case 'L': {
                int n3 = string.indexOf(59, n);
                stringBuffer.append(string.substring(n + 1, n3).replace('/', '.'));
                n = n3;
            }
        }
        while (n2 > 0) {
            stringBuffer.append("[]");
            --n2;
        }
        return ++n;
    }

    public static String fullClassName(String string) {
        String string2 = TString.change(string, "/", ".");
        string2 = TString.change(string2, "\\", ".");
        return string2;
    }

    public static String packageName(String string) {
        int n = Math.max(string.lastIndexOf(47), string.lastIndexOf(92));
        if (string.startsWith("[")) {
            return "";
        }
        int n2 = string.lastIndexOf(46);
        if ((n = Math.max(n, n2)) < 0) {
            return "";
        }
        String string2 = string.substring(0, n);
        string2 = TString.change(string2, "/", ".");
        string2 = TString.change(string2, "\\", ".");
        return string2;
    }

    public static void removeSnapshot(TRCProcess tRCProcess) {
        tRCProcess.removeSnapshot();
        Iterator iterator = tRCProcess.getPackages().iterator();
        while (iterator.hasNext()) {
            TRCPackage tRCPackage = (TRCPackage)iterator.next();
            tRCPackage.removeSnapshot();
            Iterator iterator2 = tRCPackage.getClasses().iterator();
            while (iterator2.hasNext()) {
                TRCClass tRCClass = (TRCClass)iterator2.next();
                tRCClass.removeSnapshot();
                Iterator iterator3 = tRCClass.getMethods().iterator();
                while (iterator3.hasNext()) {
                    TRCMethod tRCMethod = (TRCMethod)iterator3.next();
                    tRCMethod.removeSnapshot();
                }
            }
        }
    }

    public static void removeVirtualObject(HierarchyContext hierarchyContext, long l) {
        LookupServiceExtensions.getInstance().deregister(hierarchyContext, class$org$eclipse$hyades$loaders$trace$VirtualObjectInfo == null ? (class$org$eclipse$hyades$loaders$trace$VirtualObjectInfo = TraceUtils.class$("org.eclipse.hyades.loaders.trace.VirtualObjectInfo")) : class$org$eclipse$hyades$loaders$trace$VirtualObjectInfo, LoadersUtils.getLookUpKey((long)l));
    }

    public static void takeSnapshot(TRCProcess tRCProcess) {
        tRCProcess.takeSnapshot();
        Iterator iterator = tRCProcess.getPackages().iterator();
        while (iterator.hasNext()) {
            TRCPackage tRCPackage = (TRCPackage)iterator.next();
            tRCPackage.takeSnapshot();
            Iterator iterator2 = tRCPackage.getClasses().iterator();
            while (iterator2.hasNext()) {
                TRCClass tRCClass = (TRCClass)iterator2.next();
                tRCClass.takeSnapshot();
                Iterator iterator3 = tRCClass.getMethods().iterator();
                while (iterator3.hasNext()) {
                    TRCMethod tRCMethod = (TRCMethod)iterator3.next();
                    tRCMethod.takeSnapshot();
                }
            }
        }
    }

    private static int expandArrayType(String string, int n, StringBuffer stringBuffer) {
        int n2 = 0;
        char c = string.charAt(n);
        while (c == '[') {
            ++n2;
            stringBuffer.append(c);
            c = string.charAt(++n);
        }
        switch (c) {
            case 'B': {
                stringBuffer.append("byte");
                break;
            }
            case 'C': {
                stringBuffer.append("char");
                break;
            }
            case 'D': {
                stringBuffer.append("double");
                break;
            }
            case 'F': {
                stringBuffer.append("float");
                break;
            }
            case 'I': {
                stringBuffer.append("int");
                break;
            }
            case 'J': {
                stringBuffer.append("long");
                break;
            }
            case 'S': {
                stringBuffer.append("short");
                break;
            }
            case 'Z': {
                stringBuffer.append("boolean");
                break;
            }
            case 'V': {
                stringBuffer.append("void");
                break;
            }
            case 'L': {
                int n3 = string.indexOf(59, n);
                stringBuffer.append(string.substring(++n, n3).replace('/', '.'));
                n = n3;
                break;
            }
            default: {
                stringBuffer.append(string.substring(n).replace('/', '.'));
            }
        }
        return ++n;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static final class InvocationPool {
        private ArrayList invocations = new ArrayList(20);
        private int currentEntryIndex = -1;

        public InvocationInfo allocInvocation(TRCFullMethodInvocation tRCFullMethodInvocation, CallStackPerThread callStackPerThread) {
            InvocationInfo invocationInfo;
            if (this.invocations.size() == this.currentEntryIndex + 1) {
                invocationInfo = new InvocationInfo(tRCFullMethodInvocation, callStackPerThread);
                this.invocations.add(invocationInfo);
                ++this.currentEntryIndex;
            } else {
                ++this.currentEntryIndex;
                invocationInfo = (InvocationInfo)this.invocations.get(this.currentEntryIndex);
                invocationInfo.callStackPerThread = callStackPerThread;
                invocationInfo.update(tRCFullMethodInvocation);
            }
            return invocationInfo;
        }

        public InvocationInfo allocInvocation(CallStackPerThread callStackPerThread, TRCFullTraceObject tRCFullTraceObject, TRCClass tRCClass, TRCMethod tRCMethod, double d) {
            InvocationInfo invocationInfo;
            if (this.invocations.size() == this.currentEntryIndex + 1) {
                invocationInfo = new InvocationInfo(callStackPerThread, tRCFullTraceObject, tRCClass, tRCMethod, d);
                this.invocations.add(invocationInfo);
                ++this.currentEntryIndex;
            } else {
                ++this.currentEntryIndex;
                invocationInfo = (InvocationInfo)this.invocations.get(this.currentEntryIndex);
                invocationInfo.callStackPerThread = callStackPerThread;
                invocationInfo.update(tRCFullTraceObject, tRCClass, tRCMethod, d);
            }
            return invocationInfo;
        }

        public void release(InvocationInfo invocationInfo) {
            invocationInfo.reset();
            --this.currentEntryIndex;
        }
    }

    public static final class InvocationInfo {
        private CallStackPerThread callStackPerThread;
        private TRCClass theClass;
        private TRCClass theObjectClass;
        private TRCFullMethodInvocation methodInvocation;
        private TRCFullTraceObject theObject;
        private TRCMethod theMethod;
        private boolean classLocked = false;
        private boolean methodLocked = false;
        private boolean objectClassLocked = false;
        private boolean objectLocked = false;
        private double entryTime = -1.0;
        private double lastChildExitTime = -1.0;

        public InvocationInfo(TRCFullMethodInvocation tRCFullMethodInvocation, CallStackPerThread callStackPerThread) {
            this.callStackPerThread = callStackPerThread;
            this.update(tRCFullMethodInvocation);
        }

        public InvocationInfo(CallStackPerThread callStackPerThread, TRCFullTraceObject tRCFullTraceObject, TRCClass tRCClass, TRCMethod tRCMethod, double d) {
            this.callStackPerThread = callStackPerThread;
            this.update(tRCFullTraceObject, tRCClass, tRCMethod, d);
        }

        public boolean isClassLocked() {
            return this.classLocked;
        }

        public double getEntryTime() {
            return this.entryTime;
        }

        public void setLastChildExitTime(double d) {
            this.lastChildExitTime = d;
        }

        public double getLastChildExitTime() {
            return this.lastChildExitTime;
        }

        public TRCMethod getMethod() {
            return this.theMethod;
        }

        public TRCFullMethodInvocation getMethodInvocation() {
            return this.methodInvocation;
        }

        public boolean isMethodLocked() {
            return this.methodLocked;
        }

        public TRCFullTraceObject getObject() {
            return this.theObject;
        }

        public TRCClass getObjectClass() {
            return this.theObjectClass;
        }

        public boolean isObjectClassLocked() {
            return this.objectClassLocked;
        }

        public boolean isObjectLocked() {
            return this.objectLocked;
        }

        public TRCClass getTheClass() {
            return this.theClass;
        }

        public void initInvocationInfo(double d) {
            this.theObjectClass = null;
            if (this.theObject.getIsA() != this.theClass && this.theObject.getIsA() != this.theObject.getProcess().getClassClass()) {
                this.theObjectClass = this.theObject.getIsA();
            }
            this.entryTime = d;
            if (this.callStackPerThread.locks.containsKey(this.theObject)) {
                this.objectLocked = true;
            } else {
                this.callStackPerThread.locks.put(this.theObject, null);
            }
            if (this.callStackPerThread.locks.containsKey(this.theMethod)) {
                this.methodLocked = true;
            } else {
                this.callStackPerThread.locks.put(this.theMethod, null);
            }
            if (this.callStackPerThread.locks.containsKey(this.theClass)) {
                this.classLocked = true;
            } else {
                this.callStackPerThread.locks.put(this.theClass, null);
            }
            if (this.theObjectClass != null) {
                if (this.callStackPerThread.locksInherited.containsKey(this.theObjectClass)) {
                    this.objectClassLocked = true;
                } else {
                    this.callStackPerThread.locksInherited.put(this.theObjectClass, null);
                }
            }
        }

        public void removeLocks() {
            if (!this.methodLocked) {
                this.callStackPerThread.locks.remove(this.theMethod);
            }
            if (!this.objectLocked) {
                this.callStackPerThread.locks.remove(this.theObject);
            }
            if (!this.classLocked) {
                this.callStackPerThread.locks.remove(this.theClass);
            }
            if (!this.objectClassLocked) {
                this.callStackPerThread.locksInherited.remove(this.theObjectClass);
            }
        }

        public void reset() {
            this.removeLocks();
            this.methodLocked = false;
            this.objectLocked = false;
            this.objectClassLocked = false;
            this.classLocked = false;
            this.entryTime = -1.0;
            this.lastChildExitTime = -1.0;
            this.theClass = null;
            this.theObject = null;
            this.theObjectClass = null;
            this.theMethod = null;
            this.methodInvocation = null;
            this.callStackPerThread = null;
        }

        public void update(TRCFullTraceObject tRCFullTraceObject, TRCClass tRCClass, TRCMethod tRCMethod, double d) {
            this.theMethod = tRCMethod;
            this.theObject = tRCFullTraceObject;
            this.theClass = tRCClass;
            this.initInvocationInfo(d);
        }

        public void update(TRCFullMethodInvocation tRCFullMethodInvocation) {
            this.methodInvocation = tRCFullMethodInvocation;
            this.theObject = (TRCFullTraceObject)tRCFullMethodInvocation.getOwningObject();
            this.theMethod = tRCFullMethodInvocation.getMethod();
            this.theClass = this.theMethod.getDefiningClass();
            this.initInvocationInfo(tRCFullMethodInvocation.getEntryTime());
        }
    }
}

