/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.loaders.trace;

import java.util.Iterator;
import org.eclipse.hyades.loaders.hierarchy.IgnoredXMLFragmentLoader;
import org.eclipse.hyades.loaders.trace.TRCObjectEntry;
import org.eclipse.hyades.loaders.trace.TraceUtils;
import org.eclipse.hyades.loaders.trace.VirtualObjectInfo;
import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.loaders.util.LookupServiceExtensions;
import org.eclipse.hyades.models.trace.TRCArrayClass;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCFullHeapObject;
import org.eclipse.hyades.models.trace.TRCFullTraceObject;
import org.eclipse.hyades.models.trace.TRCHeapDump;
import org.eclipse.hyades.models.trace.TRCHeapObject;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCObject;
import org.eclipse.hyades.models.trace.TRCPrimitiveType;
import org.eclipse.hyades.models.trace.TRCProcess;
import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.models.trace.TraceFactory;

public class TraceXMLFragmentLoader
extends IgnoredXMLFragmentLoader {
    protected static final String NAME = "name";
    protected static final String OBJ_ID_REF = "objIdRef";
    protected static final String METHOD_ID_REF = "methodIdRef";
    protected static final String CLASS_ID_REF = "classIdRef";
    protected static final String THREAD_ID_REF = "threadIdRef";
    protected static final String TIME = "time";
    protected static final String CLASS_CLASS1 = "java/lang/Class";
    protected static final String CLASS_CLASS2 = "java.lang.Class";
    protected static final String UNKNOWN = "unknown";
    protected TRCClass theClass;
    protected TRCHeapDump theHeapDump;
    protected TRCMethod theMethod;
    protected TRCObject theObject;
    protected TRCProcess theProcess;
    protected TRCThread theThread;
    protected VirtualObjectInfo virtualObject;
    protected boolean loadToModel;
    protected double time = 0.0;
    protected int classIdRef;
    protected int deltaSize = 0;
    protected int methodIdRef;
    protected int threadIdRef = 0;
    protected long objIdRef;
    protected TRCClass aClass;
    static /* synthetic */ Class class$org$eclipse$hyades$models$trace$impl$TRCArrayClassImpl;
    static /* synthetic */ Class class$org$eclipse$hyades$models$trace$impl$TRCClassImpl;
    static /* synthetic */ Class class$org$eclipse$hyades$models$trace$impl$TRCMethodWithLLDataImpl;
    static /* synthetic */ Class class$org$eclipse$hyades$models$trace$impl$TRCMethodImpl;
    static /* synthetic */ Class class$org$eclipse$hyades$models$trace$impl$TRCThreadImpl;
    static /* synthetic */ Class class$org$eclipse$hyades$models$trace$impl$TRCHeapObjectImpl;
    static /* synthetic */ Class class$org$eclipse$hyades$models$trace$impl$TRCFullHeapObjectImpl;
    static /* synthetic */ Class class$org$eclipse$hyades$models$trace$impl$TRCFullTraceObjectImpl;
    static /* synthetic */ Class class$org$eclipse$hyades$loaders$trace$VirtualObjectInfo;
    static /* synthetic */ Class class$org$eclipse$hyades$loaders$trace$TRCObjectEntry;

    public void addAttribute(String string, String string2) {
        switch (LoadersUtils.getHashCode((String)string)) {
            case 3560141: {
                this.time = Double.parseDouble(string2);
                break;
            }
            case 1910215054: {
                this.threadIdRef = Integer.parseInt(string2);
                break;
            }
            case -311104800: {
                this.classIdRef = Integer.parseInt(string2);
                break;
            }
            case -947782377: {
                this.methodIdRef = Integer.parseInt(string2);
                break;
            }
            case 64634561: {
                this.objIdRef = Long.parseLong(string2);
                break;
            }
        }
    }

    public void initialize(HierarchyContext hierarchyContext, String string) {
        super.initialize(hierarchyContext, string);
        this.threadIdRef = 0;
        this.classIdRef = 0;
        this.methodIdRef = 0;
        this.objIdRef = 0L;
        this.time = 0.0;
        this.theProcess = null;
        this.theThread = null;
        this.theClass = null;
        this.theMethod = null;
        this.theObject = null;
        this.virtualObject = null;
    }

    protected TRCClass getClassByIdRef(TRCThread tRCThread, Class clazz, int n) {
        int n2;
        String string;
        TRCClass tRCClass = null;
        TRCObject tRCObject = null;
        if (n > 0) {
            Object object = LoadersUtils.getLookUpKey((int)(-this.classIdRef));
            this.theClass = (TRCClass)LookupServiceExtensions.getInstance().locate(this.context, class$org$eclipse$hyades$models$trace$impl$TRCArrayClassImpl == null ? (class$org$eclipse$hyades$models$trace$impl$TRCArrayClassImpl = TraceXMLFragmentLoader.class$("org.eclipse.hyades.models.trace.impl.TRCArrayClassImpl")) : class$org$eclipse$hyades$models$trace$impl$TRCArrayClassImpl, object);
            if (this.theClass != null) {
                return this.theClass;
            }
            object = LoadersUtils.getLookUpKey((int)this.classIdRef);
            tRCClass = (TRCClass)LookupServiceExtensions.getInstance().locate(this.context, class$org$eclipse$hyades$models$trace$impl$TRCClassImpl == null ? (class$org$eclipse$hyades$models$trace$impl$TRCClassImpl = TraceXMLFragmentLoader.class$("org.eclipse.hyades.models.trace.impl.TRCClassImpl")) : class$org$eclipse$hyades$models$trace$impl$TRCClassImpl, object);
            if (tRCClass == null) {
                tRCClass = (TRCClass)LookupServiceExtensions.getInstance().locate(this.context, class$org$eclipse$hyades$models$trace$impl$TRCArrayClassImpl == null ? (class$org$eclipse$hyades$models$trace$impl$TRCArrayClassImpl = TraceXMLFragmentLoader.class$("org.eclipse.hyades.models.trace.impl.TRCArrayClassImpl")) : class$org$eclipse$hyades$models$trace$impl$TRCArrayClassImpl, object);
            }
        } else {
            Object object = LoadersUtils.getLookUpKey((int)this.classIdRef);
            this.theClass = (TRCClass)LookupServiceExtensions.getInstance().locate(this.context, class$org$eclipse$hyades$models$trace$impl$TRCClassImpl == null ? (class$org$eclipse$hyades$models$trace$impl$TRCClassImpl = TraceXMLFragmentLoader.class$("org.eclipse.hyades.models.trace.impl.TRCClassImpl")) : class$org$eclipse$hyades$models$trace$impl$TRCClassImpl, object);
            if (this.theClass != null) {
                return this.theClass;
            }
        }
        if (n > 0) {
            this.theClass = TraceFactory.eINSTANCE.createTRCArrayClass();
            this.theClass.setId(-this.classIdRef);
            ((TRCArrayClass)this.theClass).setArrayType(TRCPrimitiveType.get(n));
        } else {
            this.theClass = TraceFactory.eINSTANCE.createTRCClass();
            this.theClass.setId(this.classIdRef);
        }
        if (tRCClass != null) {
            this.theClass.setName("[" + tRCClass.getName());
            this.theClass.setLoadTime(this.createDeltaTime());
            this.theClass.setLoadedBy(tRCThread);
            this.theClass.setPackage(tRCClass.getPackage());
            tRCObject = this.getClassObjectByIdRef(-this.classIdRef, clazz);
            this.theClass.getClassObjects().add((Object)tRCObject);
            tRCObject.setSize(this.theClass.getSize());
            TraceUtils.addClassObjectToClassClass(this.context, this.theProcess, tRCObject);
            return this.theClass;
        }
        String string2 = string = UNKNOWN + this.classIdRef;
        this.theClass.setName(TraceUtils.className(string));
        this.theClass.setLoadTime(this.createDeltaTime());
        TraceUtils.addClassToPackage(this.context, this.theClass, string, this.theProcess);
        TraceUtils.setSourceInfo(this.context, this.theProcess, this.theClass, string2);
        if (this.theProcess.getClassClass() == null && ((n2 = LoadersUtils.getHashCode((String)string)) == 1995981828 || n2 == -530663260)) {
            this.theProcess.setClassClass(this.theClass);
        }
        tRCObject = this.getClassObjectByIdRef(-this.classIdRef, clazz);
        tRCObject.setSize(this.theClass.getSize());
        this.theClass.getClassObjects().add((Object)tRCObject);
        this.theClass.setLoadedBy(tRCThread);
        TraceUtils.addClassObjectToClassClass(this.context, this.theProcess, tRCObject);
        return this.theClass;
    }

    protected TRCObject getClassObjectByIdRef(long l, Class clazz) {
        this.aClass = this.theProcess.getClassClass();
        if (this.aClass == null) {
            TraceUtils.addClassObjectToClassClass(this.context, this.theProcess, null);
            this.aClass = this.theProcess.getClassClass();
        }
        return this.createObjectAndClassObject(l, clazz);
    }

    protected TRCMethod getMethodByIdRef(TRCClass tRCClass) {
        Class clazz = TraceUtils.isBooleanOptionEnabled(this.context, "LLDATA_ENABLED") ? (class$org$eclipse$hyades$models$trace$impl$TRCMethodWithLLDataImpl == null ? (class$org$eclipse$hyades$models$trace$impl$TRCMethodWithLLDataImpl = TraceXMLFragmentLoader.class$("org.eclipse.hyades.models.trace.impl.TRCMethodWithLLDataImpl")) : class$org$eclipse$hyades$models$trace$impl$TRCMethodWithLLDataImpl) : (class$org$eclipse$hyades$models$trace$impl$TRCMethodImpl == null ? (class$org$eclipse$hyades$models$trace$impl$TRCMethodImpl = TraceXMLFragmentLoader.class$("org.eclipse.hyades.models.trace.impl.TRCMethodImpl")) : class$org$eclipse$hyades$models$trace$impl$TRCMethodImpl);
        Class clazz2 = clazz;
        TRCMethod tRCMethod = (TRCMethod)LookupServiceExtensions.getInstance().locate(this.context, clazz2, LoadersUtils.getLookUpKey((int)this.methodIdRef));
        if (tRCMethod == null) {
            tRCMethod = this.createTRCMethod(tRCClass);
            tRCMethod.setId(this.methodIdRef);
            tRCMethod.setName(UNKNOWN + this.methodIdRef);
            tRCMethod.setSignature("()");
            tRCMethod.setDefiningClass(tRCClass);
        }
        return tRCMethod;
    }

    protected TRCMethod createTRCMethod(TRCClass tRCClass) {
        TRCMethod tRCMethod = null;
        tRCMethod = TraceUtils.isBooleanOptionEnabled(this.context, "LLDATA_ENABLED") ? TraceFactory.eINSTANCE.createTRCMethodWithLLData() : TraceFactory.eINSTANCE.createTRCMethod();
        return tRCMethod;
    }

    protected TRCObject getObjectByIdRef(long l, Class clazz) {
        this.aClass = this.theClass;
        if (this.aClass == null) {
            this.theProcess = this.getProcess();
            this.aClass = this.theProcess.getClassClass();
            if (this.aClass == null) {
                TraceUtils.addClassObjectToClassClass(this.context, this.theProcess, null);
                this.aClass = this.theProcess.getClassClass();
            }
        }
        return this.createObjectAndClassObject(l, clazz);
    }

    protected TRCProcess getProcess() {
        TRCProcess tRCProcess;
        if (this.context.getAgent() == null) {
            LoadersUtils.createAgent((HierarchyContext)this.context);
        }
        if ((tRCProcess = TraceUtils.getProcess(this.context.getAgent())) == null) {
            tRCProcess = TraceFactory.eINSTANCE.createTRCProcess();
            tRCProcess.setId(this.context.getProcessProxy().getRuntimeId());
            tRCProcess.setPid(this.context.getProcessProxy().getPid());
            tRCProcess.setAgent(this.context.getAgent());
            tRCProcess.setStartTime(this.createDeltaTime());
        }
        return tRCProcess;
    }

    protected TRCThread getThreadByIdRef(TRCProcess tRCProcess) {
        TRCThread tRCThread = (TRCThread)LookupServiceExtensions.getInstance().locate(this.context, class$org$eclipse$hyades$models$trace$impl$TRCThreadImpl == null ? (class$org$eclipse$hyades$models$trace$impl$TRCThreadImpl = TraceXMLFragmentLoader.class$("org.eclipse.hyades.models.trace.impl.TRCThreadImpl")) : class$org$eclipse$hyades$models$trace$impl$TRCThreadImpl, LoadersUtils.getLookUpKey((int)this.threadIdRef));
        if (tRCThread == null) {
            tRCThread = TraceFactory.eINSTANCE.createTRCThread();
            tRCThread.setId(this.threadIdRef);
            tRCThread.setName(UNKNOWN + this.threadIdRef);
            tRCThread.setStartTime(this.createDeltaTime());
            tRCThread.setProcess(tRCProcess);
        }
        return tRCThread;
    }

    protected double createDeltaTime() {
        return this.time - this.getZeroTime();
    }

    protected TRCObject createObject(long l, Class clazz) {
        if (clazz == (class$org$eclipse$hyades$models$trace$impl$TRCHeapObjectImpl == null ? (class$org$eclipse$hyades$models$trace$impl$TRCHeapObjectImpl = TraceXMLFragmentLoader.class$("org.eclipse.hyades.models.trace.impl.TRCHeapObjectImpl")) : class$org$eclipse$hyades$models$trace$impl$TRCHeapObjectImpl)) {
            return this.createTRCHeapObject(l);
        }
        if (clazz == (class$org$eclipse$hyades$models$trace$impl$TRCFullHeapObjectImpl == null ? (class$org$eclipse$hyades$models$trace$impl$TRCFullHeapObjectImpl = TraceXMLFragmentLoader.class$("org.eclipse.hyades.models.trace.impl.TRCFullHeapObjectImpl")) : class$org$eclipse$hyades$models$trace$impl$TRCFullHeapObjectImpl)) {
            return this.createTRCFullHeapObject(l);
        }
        if (clazz == (class$org$eclipse$hyades$models$trace$impl$TRCFullTraceObjectImpl == null ? (class$org$eclipse$hyades$models$trace$impl$TRCFullTraceObjectImpl = TraceXMLFragmentLoader.class$("org.eclipse.hyades.models.trace.impl.TRCFullTraceObjectImpl")) : class$org$eclipse$hyades$models$trace$impl$TRCFullTraceObjectImpl)) {
            return this.createTRCFullTraceObject(l);
        }
        return this.createTRCObject(l);
    }

    protected TRCObject createObject(long l, Class clazz, TRCObjectEntry tRCObjectEntry) {
        if (clazz == (class$org$eclipse$hyades$models$trace$impl$TRCHeapObjectImpl == null ? (class$org$eclipse$hyades$models$trace$impl$TRCHeapObjectImpl = TraceXMLFragmentLoader.class$("org.eclipse.hyades.models.trace.impl.TRCHeapObjectImpl")) : class$org$eclipse$hyades$models$trace$impl$TRCHeapObjectImpl)) {
            return this.createTRCHeapObject(l, tRCObjectEntry);
        }
        if (clazz == (class$org$eclipse$hyades$models$trace$impl$TRCFullHeapObjectImpl == null ? (class$org$eclipse$hyades$models$trace$impl$TRCFullHeapObjectImpl = TraceXMLFragmentLoader.class$("org.eclipse.hyades.models.trace.impl.TRCFullHeapObjectImpl")) : class$org$eclipse$hyades$models$trace$impl$TRCFullHeapObjectImpl)) {
            return this.createTRCHeapObject(l, tRCObjectEntry);
        }
        if (clazz == (class$org$eclipse$hyades$models$trace$impl$TRCFullTraceObjectImpl == null ? (class$org$eclipse$hyades$models$trace$impl$TRCFullTraceObjectImpl = TraceXMLFragmentLoader.class$("org.eclipse.hyades.models.trace.impl.TRCFullTraceObjectImpl")) : class$org$eclipse$hyades$models$trace$impl$TRCFullTraceObjectImpl)) {
            return this.createTRCFullTraceObject(l, tRCObjectEntry);
        }
        return this.createTRCObject(l);
    }

    protected TRCObject createTRCFullTraceObject(long l) {
        TRCFullTraceObject tRCFullTraceObject = TraceFactory.eINSTANCE.createTRCFullTraceObject();
        tRCFullTraceObject.setId(l);
        tRCFullTraceObject.setCreateTime(this.createDeltaTime());
        tRCFullTraceObject.setThread(this.theClass.getLoadedBy());
        tRCFullTraceObject.setIsA(this.aClass);
        tRCFullTraceObject.setProcess(this.getTRCObjectProcess());
        return tRCFullTraceObject;
    }

    protected TRCObject createTRCFullTraceObject(long l, TRCObjectEntry tRCObjectEntry) {
        TRCFullTraceObject tRCFullTraceObject = TraceFactory.eINSTANCE.createTRCFullTraceObject();
        tRCFullTraceObject.setId(l);
        TRCHeapObject tRCHeapObject = (TRCHeapObject)tRCObjectEntry.get(class$org$eclipse$hyades$models$trace$impl$TRCHeapObjectImpl == null ? (class$org$eclipse$hyades$models$trace$impl$TRCHeapObjectImpl = TraceXMLFragmentLoader.class$("org.eclipse.hyades.models.trace.impl.TRCHeapObjectImpl")) : class$org$eclipse$hyades$models$trace$impl$TRCHeapObjectImpl);
        if (tRCHeapObject != null) {
            tRCFullTraceObject.setIsA(tRCHeapObject.getIsA());
        } else {
            tRCFullTraceObject.setIsA(this.theClass);
        }
        tRCFullTraceObject.setCreateTime(this.createDeltaTime());
        tRCFullTraceObject.setThread(this.theClass.getLoadedBy());
        tRCFullTraceObject.setProcess(this.getTRCObjectProcess());
        return tRCFullTraceObject;
    }

    protected TRCObject createTRCHeapObject(long l) {
        TRCHeapObject tRCHeapObject = TraceFactory.eINSTANCE.createTRCHeapObject();
        tRCHeapObject.setId(l);
        tRCHeapObject.setIsA(this.aClass);
        tRCHeapObject.setProcess(this.getTRCObjectProcess());
        return tRCHeapObject;
    }

    protected TRCObject createTRCFullHeapObject(long l) {
        TRCFullHeapObject tRCFullHeapObject = TraceFactory.eINSTANCE.createTRCFullHeapObject();
        tRCFullHeapObject.setId(l);
        tRCFullHeapObject.setIsA(this.aClass);
        tRCFullHeapObject.setProcess(this.getTRCObjectProcess());
        return tRCFullHeapObject;
    }

    protected TRCObject createTRCHeapObject(long l, TRCObjectEntry tRCObjectEntry) {
        TRCHeapObject tRCHeapObject = TraceFactory.eINSTANCE.createTRCHeapObject();
        tRCHeapObject.setId(l);
        TRCFullTraceObject tRCFullTraceObject = (TRCFullTraceObject)tRCObjectEntry.get(class$org$eclipse$hyades$models$trace$impl$TRCFullTraceObjectImpl == null ? (class$org$eclipse$hyades$models$trace$impl$TRCFullTraceObjectImpl = TraceXMLFragmentLoader.class$("org.eclipse.hyades.models.trace.impl.TRCFullTraceObjectImpl")) : class$org$eclipse$hyades$models$trace$impl$TRCFullTraceObjectImpl);
        if (tRCFullTraceObject != null) {
            tRCHeapObject.setIsA(tRCFullTraceObject.getIsA());
        } else {
            tRCHeapObject.setIsA(this.theClass);
        }
        tRCHeapObject.setProcess(this.getTRCObjectProcess());
        return tRCHeapObject;
    }

    protected TRCObject createTRCFullHeapObject(long l, TRCObjectEntry tRCObjectEntry) {
        TRCFullHeapObject tRCFullHeapObject = TraceFactory.eINSTANCE.createTRCFullHeapObject();
        tRCFullHeapObject.setId(l);
        TRCFullTraceObject tRCFullTraceObject = (TRCFullTraceObject)tRCObjectEntry.get(class$org$eclipse$hyades$models$trace$impl$TRCFullTraceObjectImpl == null ? (class$org$eclipse$hyades$models$trace$impl$TRCFullTraceObjectImpl = TraceXMLFragmentLoader.class$("org.eclipse.hyades.models.trace.impl.TRCFullTraceObjectImpl")) : class$org$eclipse$hyades$models$trace$impl$TRCFullTraceObjectImpl);
        if (tRCFullTraceObject != null) {
            tRCFullHeapObject.setIsA(tRCFullTraceObject.getIsA());
        } else {
            tRCFullHeapObject.setIsA(this.theClass);
        }
        tRCFullHeapObject.setProcess(this.getTRCObjectProcess());
        return tRCFullHeapObject;
    }

    protected TRCObject createTRCObject(long l) {
        TRCObject tRCObject = TraceFactory.eINSTANCE.createTRCObject();
        tRCObject.setId(l);
        tRCObject.setIsA(this.aClass);
        tRCObject.setProcess(this.getTRCObjectProcess());
        return tRCObject;
    }

    protected void dispatchProcessMode(int n) {
        switch (this.context.getCollectionMode().getValue()) {
            case 0: {
                this.processHS(n);
                break;
            }
            case 1: {
                this.processHF(n);
                break;
            }
            case 2: {
                this.processHF_EF(n);
                break;
            }
            case 3: {
                this.processHS_ES(n);
                break;
            }
            case 5: {
                this.processENI(n);
                break;
            }
            case 6: {
                this.processEF(n);
                break;
            }
            case 7: {
                this.processHF_ES(n);
                break;
            }
            case 4: {
                this.processES(n);
                break;
            }
            default: {
                this.dynamicProcess(this, n);
            }
        }
    }

    protected void dynamicProcess(TraceXMLFragmentLoader traceXMLFragmentLoader, int n) {
    }

    protected void processEF(int n) {
    }

    protected void processENI(int n) {
        this.processEF(n);
    }

    protected void processES(int n) {
    }

    protected void processHF(int n) {
    }

    protected void processHF_EF(int n) {
        this.processHF(n);
        this.processEF(n);
    }

    protected void processHF_ES(int n) {
        this.processHF(n);
        this.processES(n);
    }

    protected void processHS(int n) {
    }

    protected void processHS_ES(int n) {
        this.processHS(n);
        this.processES(n);
    }

    protected void updateVirtualObject(long l, int n) {
        this.virtualObject = (VirtualObjectInfo)LookupServiceExtensions.getInstance().locate(this.context, class$org$eclipse$hyades$loaders$trace$VirtualObjectInfo == null ? (class$org$eclipse$hyades$loaders$trace$VirtualObjectInfo = TraceXMLFragmentLoader.class$("org.eclipse.hyades.loaders.trace.VirtualObjectInfo")) : class$org$eclipse$hyades$loaders$trace$VirtualObjectInfo, LoadersUtils.getLookUpKey((long)l));
        if (this.virtualObject == null) {
            this.virtualObject = new VirtualObjectInfo();
            LoadersUtils.registerGenericLookUpEntry((HierarchyContext)this.context, (Object)LoadersUtils.getLookUpKey((long)l), (Object)this.virtualObject);
        }
        this.virtualObject.myClass = this.theClass;
        this.virtualObject.myThread = this.theThread;
        this.virtualObject.createTime = this.createDeltaTime();
        this.virtualObject.size = n;
    }

    protected TRCProcess getTRCObjectProcess() {
        return this.getProcess();
    }

    protected double getZeroTime() {
        return this.getProcess().getAgent().getStartTime();
    }

    protected TRCObject createObjectAndClassObject(long l, Class clazz) {
        Object object = LoadersUtils.getLookUpKey((long)l);
        TRCObjectEntry tRCObjectEntry = (TRCObjectEntry)LookupServiceExtensions.getInstance().locate(this.context, class$org$eclipse$hyades$loaders$trace$TRCObjectEntry == null ? (class$org$eclipse$hyades$loaders$trace$TRCObjectEntry = TraceXMLFragmentLoader.class$("org.eclipse.hyades.loaders.trace.TRCObjectEntry")) : class$org$eclipse$hyades$loaders$trace$TRCObjectEntry, object);
        TRCObject tRCObject = null;
        if (tRCObjectEntry != null) {
            tRCObject = tRCObjectEntry.get(clazz);
            if (tRCObject == null) {
                tRCObject = this.createObject(l, clazz, tRCObjectEntry);
                tRCObjectEntry.put(tRCObject.getClass(), tRCObject);
            }
        } else {
            tRCObject = this.createObject(l, clazz);
        }
        return tRCObject;
    }

    protected TRCObject getClassObject(TRCClass tRCClass, Class clazz) {
        TRCObject tRCObject;
        Iterator iterator = tRCClass.getClassObjects().iterator();
        while (iterator.hasNext()) {
            tRCObject = (TRCObject)iterator.next();
            if (tRCObject.getClass() != clazz) continue;
            return tRCObject;
        }
        tRCObject = this.getClassObjectByIdRef(-this.classIdRef, clazz);
        tRCObject.setSize(tRCClass.getSize());
        this.theClass.getClassObjects().add((Object)tRCObject);
        TraceUtils.addClassObjectToClassClass(this.context, this.theProcess, tRCObject);
        return tRCObject;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

