/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.sample.loganalyzer;

import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.hyades.trace.sample.loganalyzer.LogAnalyzerCreationWizard;
import org.eclipse.hyades.trace.sample.loganalyzer.LogAnalyzerSamplePage;
import org.eclipse.hyades.ui.internal.wizard.exampleproject.CreationWizard;
import org.eclipse.hyades.ui.internal.wizard.exampleproject.CreationWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.internal.WorkbenchMessages;

public class LogAnalyzerCreationPage
extends CreationWizardPage {
    public LogAnalyzerCreationPage(CreationWizard creationWizard, String string, IConfigurationElement iConfigurationElement) {
        super(creationWizard, string, iConfigurationElement);
    }

    public Text getProjectText() {
        if (!(this.getControl() instanceof Composite)) {
            return null;
        }
        if (this.getProjectName() == null) {
            return null;
        }
        Composite composite = (Composite)this.getControl();
        Control[] controlArray = composite.getChildren();
        int n = 0;
        while (n < controlArray.length) {
            if (controlArray[n] instanceof Composite) {
                Control[] controlArray2 = ((Composite)controlArray[n]).getChildren();
                int n2 = 0;
                while (n2 < controlArray2.length) {
                    if (controlArray2[n2] instanceof Text) {
                        Text text = (Text)controlArray2[n2];
                        if (this.getProjectName().equals(text.getText())) {
                            return text;
                        }
                    }
                    ++n2;
                }
            }
            ++n;
        }
        return null;
    }

    protected boolean validatePage() {
        LogAnalyzerCreationWizard logAnalyzerCreationWizard;
        LogAnalyzerSamplePage logAnalyzerSamplePage;
        String string = this.getProjectName();
        if (string == null) {
            return false;
        }
        if (this.getWizard() instanceof LogAnalyzerCreationWizard && (logAnalyzerSamplePage = (logAnalyzerCreationWizard = (LogAnalyzerCreationWizard)this.getWizard()).getPageTwo()) != null) {
            logAnalyzerSamplePage.setAccessLog(this.getLocationPath().toString());
            logAnalyzerSamplePage.setErrorLog(this.getLocationPath().toString());
        }
        return true;
    }

    protected boolean projectValidatePage() {
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        String string = this.getProjectText().getText();
        if (string.equals("")) {
            this.setErrorMessage(null);
            this.setMessage(WorkbenchMessages.getString((String)"WizardNewProjectCreationPage.projectNameEmpty"));
            return false;
        }
        IStatus iStatus = iWorkspace.validateName(string, 4);
        if (!iStatus.isOK()) {
            this.setErrorMessage(iStatus.getMessage());
            return false;
        }
        if (this.getProjectHandle().exists()) {
            this.setErrorMessage(WorkbenchMessages.getString((String)"WizardNewProjectCreationPage.projectExistsMessage"));
            return false;
        }
        this.setErrorMessage(null);
        this.setMessage(null);
        return true;
    }
}

