/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.uml2sd.trace.loaders;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.trace.TRCFullMethodInvocation;
import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.trace.internal.ui.PDProjectExplorer;
import org.eclipse.hyades.trace.ui.HyadesUtil;
import org.eclipse.hyades.trace.ui.IProfileEventListener;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.uml2sd.trace.TraceSDPlugin;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.ContextIds;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.DateComparator;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceCallStack;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceInteractionUpdate;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceInteractionUtils;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceLifelineDraft;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceProcesses;
import org.eclipse.hyades.uml2sd.trace.selection.IDateSelection;
import org.eclipse.hyades.uml2sd.ui.actions.provider.ISDFindProvider;
import org.eclipse.hyades.uml2sd.ui.actions.widgets.Criteria;
import org.eclipse.hyades.uml2sd.ui.core.BasicExecutionOccurrence;
import org.eclipse.hyades.uml2sd.ui.core.Frame;
import org.eclipse.hyades.uml2sd.ui.core.GraphNode;
import org.eclipse.hyades.uml2sd.ui.load.BackgroundLoader;
import org.eclipse.hyades.uml2sd.ui.load.IUml2SDLoader;
import org.eclipse.hyades.uml2sd.ui.view.SDView;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.help.WorkbenchHelp;

public abstract class BaseTraceInteractions
implements IUml2SDLoader,
ISelectionListener,
ISDFindProvider,
IProfileEventListener {
    protected SDView view;
    protected Frame frame;
    protected TraceProcesses currentProcesses;
    protected EObject currentMofObjectFromPDProjectExplorer;
    private Cursor waitCursor;
    private IProgressMonitor monitor;
    protected HashMap traceThreadMap;
    protected ArrayList traceThreadList;
    protected ArrayList findResults;
    protected Criteria findCriteria;
    protected int currentFindIndex;

    public void setViewer(SDView sDView) {
        this.view = sDView;
        this.view.getSite().getWorkbenchWindow().getSelectionService().addSelectionListener((ISelectionListener)this);
        UIPlugin.getDefault().addProfileEventListener((IProfileEventListener)this);
        this.view.setSDFindProvider((ISDFindProvider)this);
        this.onSetViewer();
        WorkbenchHelp.setHelp((Control)this.view.getSDWidget(), (String)ContextIds.INTERACTION_VIEW);
        this.parseModelBackground();
    }

    public abstract void onSetViewer();

    public void aboutToBeReplaced() {
        UIPlugin.getDefault().removeSelectionListener((ISelectionListener)this);
        UIPlugin.getDefault().removeProfileEventListener((IProfileEventListener)this);
        this.clearInternals();
        this.view = null;
    }

    protected void clearInternals() {
        this.currentMofObjectFromPDProjectExplorer = null;
        this.currentProcesses = null;
        this.frame = null;
        if (this.waitCursor != null && !this.waitCursor.isDisposed()) {
            this.waitCursor.dispose();
        }
        this.waitCursor = null;
        this.clearFindInternals();
    }

    protected void clearFindInternals() {
        this.findResults = null;
        this.findCriteria = null;
        this.currentFindIndex = 0;
    }

    protected synchronized void parseModel(EObject eObject) {
        long l = 0L;
        if (TraceSDPlugin.debugEvents) {
            l = System.currentTimeMillis();
        }
        if (TraceSDPlugin.debugEvents) {
            TraceSDPlugin.debugTraceEvents("Start parseModel()");
        }
        this.clearInternals();
        this.currentMofObjectFromPDProjectExplorer = eObject;
        this.createFrame();
        if (this.currentProcesses == null) {
            if (this.view != null && !this.view.getSDWidget().isDisposed()) {
                this.setFrameName();
                this.view.setFrameSync(this.frame);
            }
            if (TraceSDPlugin.debugEvents) {
                TraceSDPlugin.debugTraceEvents("Abort parseModel()");
            }
            return;
        }
        this.computeModel();
        try {
            this.fillPage(new TraceInteractionUpdate());
            if (this.view != null && !this.view.getSDWidget().isDisposed() && this.frame != null && !this.isCurrentLoadCanceled()) {
                this.setFrameName();
                this.view.setFrameSync(this.frame);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        if (TraceSDPlugin.debugEvents) {
            if (this.isCurrentLoadCanceled()) {
                TraceSDPlugin.debugTraceEvents("Cancelled parseModel() after " + (System.currentTimeMillis() - l) + "ms");
            } else {
                TraceSDPlugin.debugTraceEvents("End parseModel() after " + (System.currentTimeMillis() - l) + "ms");
            }
        }
    }

    protected abstract void computeModel();

    protected abstract void updateSD(TraceInteractionUpdate var1);

    protected boolean isCurrentLoadCanceled() {
        return this.monitor != null && this.monitor.isCanceled();
    }

    private void beforeLongTask(IProgressMonitor iProgressMonitor, String string) {
        if (this.view == null || this.view.getSDWidget().isDisposed()) {
            iProgressMonitor.setCanceled(true);
            return;
        }
        this.view.toggleWaitCursorSync(true);
        this.monitor = iProgressMonitor;
        this.monitor.beginTask(string, 100);
    }

    private void afterLongTask() {
        this.monitor.done();
        this.monitor = null;
        if (this.view != null && !this.view.getSDWidget().isDisposed()) {
            this.view.toggleWaitCursorSync(false);
        }
    }

    protected void parseModelBackground() {
        final EObject eObject = HyadesUtil.getMofObject();
        if (eObject == null) {
            return;
        }
        BackgroundLoader.getInstance().newTask(new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) throws InterruptedException {
                BaseTraceInteractions.this.beforeLongTask(iProgressMonitor, TraceSDPlugin.getResourceString("TASK_NAME_CREATING_SD"));
                if (!BaseTraceInteractions.this.isCurrentLoadCanceled()) {
                    BaseTraceInteractions.this.parseModel(eObject);
                }
                BaseTraceInteractions.this.afterLongTask();
            }
        });
    }

    protected void updateSDBackground(final TraceInteractionUpdate traceInteractionUpdate) {
        BackgroundLoader.getInstance().newTask(new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) throws InterruptedException {
                BaseTraceInteractions.this.beforeLongTask(iProgressMonitor, TraceSDPlugin.getResourceString("TASK_NAME_UPDATING_SD"));
                if (!BaseTraceInteractions.this.isCurrentLoadCanceled()) {
                    BaseTraceInteractions.this.updateSD(traceInteractionUpdate);
                }
                BaseTraceInteractions.this.afterLongTask();
            }
        });
    }

    protected void createFrame() {
        if (this.currentProcesses == null) {
            this.currentProcesses = TraceProcesses.getTraceProcesses(this.currentMofObjectFromPDProjectExplorer, this.monitor);
        }
        this.frame = new Frame();
        if (this.currentProcesses == null) {
            this.frame.setName(TraceSDPlugin.getResourceString("STR_NO_PROCESSES_HERE"));
        } else {
            this.frame.setTimeUnitName(TraceSDPlugin.getResourceString("STR_TIME_UNIT_IS_SECOND"));
        }
    }

    public abstract void setFrameName();

    public abstract void fillPage(TraceInteractionUpdate var1);

    protected TraceCallStack getTraceCallStack(TRCThread tRCThread) {
        TraceCallStack traceCallStack = (TraceCallStack)this.traceThreadMap.get(tRCThread);
        if (traceCallStack == null) {
            traceCallStack = new TraceCallStack(this, tRCThread);
            this.traceThreadMap.put(tRCThread, traceCallStack);
            this.traceThreadList.add(traceCallStack);
        }
        return traceCallStack;
    }

    public void sortTraceThreadList(TraceCallStack traceCallStack) {
        this.traceThreadList.remove(traceCallStack);
        int n = 0;
        while (n < this.traceThreadList.size()) {
            TraceCallStack traceCallStack2 = (TraceCallStack)this.traceThreadList.get(n);
            if (traceCallStack.getCurrentExitTime() < traceCallStack2.getCurrentExitTime()) {
                this.traceThreadList.add(n, traceCallStack);
                return;
            }
            ++n;
        }
        this.traceThreadList.add(traceCallStack);
    }

    protected double getTraceThreadListFirstTime() {
        double d = this.traceThreadList != null && this.traceThreadList.size() > 0 ? ((TraceCallStack)this.traceThreadList.get(0)).getCurrentExitTime() : Double.MAX_VALUE;
        return d;
    }

    protected void setExecutionOccurence(TraceLifelineDraft traceLifelineDraft) {
        if (traceLifelineDraft != null) {
            if (traceLifelineDraft.getStart() == Integer.MAX_VALUE) {
                traceLifelineDraft.setStart(0);
            }
            BasicExecutionOccurrence basicExecutionOccurrence = new BasicExecutionOccurrence();
            basicExecutionOccurrence.setStartOccurrence(traceLifelineDraft.getStart());
            basicExecutionOccurrence.setEndOccurrence(traceLifelineDraft.getEnd());
            traceLifelineDraft.getLifeline().addExecution(basicExecutionOccurrence);
        }
    }

    protected abstract EObject getLifelineEObjectFromMethodInvocation(TRCFullMethodInvocation var1);

    protected abstract String getLifeLineTitle(EObject var1, boolean var2);

    protected abstract int getLifeLineCategory(EObject var1);

    public void selectionChanged(IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
        if (TraceSDPlugin.debugEvents) {
            TraceSDPlugin.debugTraceEvents("selectionChanged(" + iWorkbenchPart + ")=" + iSelection);
        }
        if (iWorkbenchPart instanceof PDProjectExplorer) {
            if (!((PDProjectExplorer)iWorkbenchPart).isLinkingEnabled()) {
                return;
            }
            if (this.view != null && this.view.getSDWidget() != null && !this.view.getSDWidget().isDisposed()) {
                if (this.currentMofObjectFromPDProjectExplorer == HyadesUtil.getMofObject()) {
                    return;
                }
                this.parseModelBackground();
            }
        } else if (iWorkbenchPart instanceof SDView) {
            if (TraceSDPlugin.debugEvents) {
                this.showInternalSelection(iSelection);
            }
        } else {
            if (this.frame == null) {
                return;
            }
            TraceInteractionUpdate traceInteractionUpdate = new TraceInteractionUpdate();
            this.externalSelectionChanged(iWorkbenchPart, iSelection, traceInteractionUpdate);
            this.finishExternalExtendedSelection(traceInteractionUpdate);
            if (traceInteractionUpdate.needsUpdate()) {
                this.updateSDBackground(traceInteractionUpdate);
            }
        }
    }

    public void handleProfileEvent(ProfileEvent profileEvent) {
        if (TraceSDPlugin.debugEvents) {
            TraceSDPlugin.debugTraceEvents("handleProfileEvent(" + profileEvent + ")=" + " " + profileEvent.getType());
        }
        if (profileEvent.getSource() instanceof EObject && (profileEvent.getType() & 0x460) != 0 && this.view != null && this.view.getSDWidget() != null && !this.view.getSDWidget().isDisposed()) {
            if (profileEvent.getType() == 64 && this.currentMofObjectFromPDProjectExplorer == HyadesUtil.getMofObject()) {
                return;
            }
            this.parseModelBackground();
        }
    }

    private void showInternalSelection(Object object) {
        if (TraceSDPlugin.debugEvents) {
            TraceSDPlugin.debugTraceEvents("showInternalSelection(" + object + ")");
        }
        if (object instanceof IDateSelection) {
            IDateSelection iDateSelection = (IDateSelection)object;
            if (TraceSDPlugin.debugEvents) {
                TraceSDPlugin.debugTraceEvents(Double.toString(iDateSelection.getStartDate()));
            }
        } else if (object instanceof IStructuredSelection) {
            IStructuredSelection iStructuredSelection = (IStructuredSelection)object;
            Iterator iterator = iStructuredSelection.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (TraceSDPlugin.debugEvents) {
                    TraceSDPlugin.debugTraceEvents("IStructuredSelection:showInternalSelection(" + e + ")");
                }
                this.showInternalSelection(e);
            }
        }
    }

    protected void externalSelectionChanged(IWorkbenchPart iWorkbenchPart, Object object, TraceInteractionUpdate traceInteractionUpdate) {
        if (TraceSDPlugin.debugEvents) {
            TraceSDPlugin.debugTraceEvents("External selection from " + iWorkbenchPart + " is " + object);
        }
        if (object instanceof IStructuredSelection) {
            if (TraceSDPlugin.debugEvents) {
                TraceSDPlugin.debugTraceEvents("IStructuredSelection");
            }
            IStructuredSelection iStructuredSelection = (IStructuredSelection)object;
            Iterator iterator = iStructuredSelection.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                this.externalSelectionChanged(iWorkbenchPart, e, traceInteractionUpdate);
            }
        } else if (this.externalExtendedSelectionChanged(iWorkbenchPart, object, traceInteractionUpdate)) {
            // empty if block
        }
    }

    protected abstract boolean externalExtendedSelectionChanged(IWorkbenchPart var1, Object var2, TraceInteractionUpdate var3);

    protected abstract void finishExternalExtendedSelection(TraceInteractionUpdate var1);

    public boolean isLifelineSupported() {
        return true;
    }

    public boolean isSyncMessageSupported() {
        return false;
    }

    public boolean isSyncMessageReturnSupported() {
        return false;
    }

    public boolean isAsyncMessageSupported() {
        return false;
    }

    public boolean isAsyncMessageReturnSupported() {
        return false;
    }

    public boolean isStopSupported() {
        return false;
    }

    public boolean find(Criteria criteria) {
        GraphNode graphNode;
        if (this.frame == null) {
            return false;
        }
        if (this.findResults == null || this.findCriteria == null || !this.findCriteria.equals(criteria)) {
            List list;
            this.findResults = new ArrayList();
            this.findCriteria = criteria;
            if (this.findCriteria.isLifeLineSelected()) {
                int n = 0;
                while (n < this.frame.lifeLinesCount()) {
                    if (TraceInteractionUtils.matchCriteria(this.frame.getLifeline(n).getName(), this.findCriteria)) {
                        this.findResults.add(this.frame.getLifeline(n));
                    }
                    ++n;
                }
            }
            graphNode = new ArrayList();
            if (this.findCriteria.isSyncMessageSelected()) {
                int n = 0;
                while (n < this.frame.syncMessageCount()) {
                    if (TraceInteractionUtils.matchCriteria(this.frame.getSyncMessage(n).getName(), this.findCriteria)) {
                        graphNode.add(this.frame.getSyncMessage(n));
                    }
                    ++n;
                }
                int n2 = 0;
                while (n2 < this.frame.syncMessageReturnCount()) {
                    if (TraceInteractionUtils.matchCriteria(this.frame.getSyncMessageReturn(n2).getName(), this.findCriteria)) {
                        graphNode.add(this.frame.getSyncMessageReturn(n2));
                    }
                    ++n2;
                }
            }
            if (graphNode.size() > 0) {
                Object[] objectArray = graphNode.toArray();
                Arrays.sort(objectArray, new DateComparator());
                this.findResults.addAll(Arrays.asList(objectArray));
            }
            this.currentFindIndex = (list = this.view.getSDWidget().getSelection()) != null && list.size() == 1 ? this.findResults.indexOf(list.get(0)) + 1 : 0;
        } else {
            ++this.currentFindIndex;
        }
        if (this.findResults.size() > this.currentFindIndex) {
            graphNode = (GraphNode)this.findResults.get(this.currentFindIndex);
            this.view.getSDWidget().moveTo(graphNode);
            return true;
        }
        return this.notFoundYet(this.findCriteria);
    }

    public void cancel() {
        this.clearFindInternals();
    }

    public abstract boolean notFoundYet(Criteria var1);
}

