/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.uml2sd.trace.loaders;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.trace.TRCFullMethodInvocation;
import org.eclipse.hyades.models.trace.TRCProcess;
import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.models.trace.TRCTraceObject;
import org.eclipse.hyades.uml2sd.trace.TraceSDPlugin;
import org.eclipse.hyades.uml2sd.trace.loaders.BaseTraceInteractions;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.FoundInPage;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceCallStack;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceCollapsableSyncMessage;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceCollapsableSyncMessageReturn;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceCollapsedLifelines;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceCollapsedSyncMessage;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceCollapsedSyncMessageReturn;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceInteractionUpdate;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceInteractionUtils;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceLifeline;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceLifelineDraft;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceMessageAndCallAssociation;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TracePage;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceProcess;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceSyncMessage;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceSyncMessageReturn;
import org.eclipse.hyades.uml2sd.trace.preferences.ITraceInteractionPreferenceListener;
import org.eclipse.hyades.uml2sd.trace.selection.IDateSelection;
import org.eclipse.hyades.uml2sd.trace.selection.IEObjectSelection;
import org.eclipse.hyades.uml2sd.ui.actions.provider.ISDAdvancedPagingProvider;
import org.eclipse.hyades.uml2sd.ui.actions.provider.ISDFilterProvider;
import org.eclipse.hyades.uml2sd.ui.actions.provider.ISDInternalMesFilterProvider;
import org.eclipse.hyades.uml2sd.ui.actions.provider.ISDPagingProvider;
import org.eclipse.hyades.uml2sd.ui.actions.widgets.Criteria;
import org.eclipse.hyades.uml2sd.ui.actions.widgets.FilterCriteria;
import org.eclipse.hyades.uml2sd.ui.core.BaseMessage;
import org.eclipse.hyades.uml2sd.ui.core.Frame;
import org.eclipse.hyades.uml2sd.ui.core.GraphNode;
import org.eclipse.hyades.uml2sd.ui.core.ITimeRange;
import org.eclipse.hyades.uml2sd.ui.core.LifelineCategories;
import org.eclipse.hyades.uml2sd.ui.drawings.IImage;
import org.eclipse.hyades.uml2sd.ui.drawings.impl.ImageImpl;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPart;

public abstract class TraceInteractions
extends BaseTraceInteractions
implements ISDFilterProvider,
ISDAdvancedPagingProvider,
ISDInternalMesFilterProvider,
ITraceInteractionPreferenceListener {
    public static final int CATEGORY_CLASSES = 0;
    public static final int CATEGORY_OBJECTS = 1;
    public static final int CATEGORY_NODE = 2;
    public static final int CATEGORY_AGENT = 3;
    public static final int CATEGORY_PROCESS = 4;
    public static final int CATEGORY_THREAD = 5;
    public static final int CATEGORY_COLLAPSED = 6;
    public static final int CATEGORY_CARD = 7;
    protected static LifelineCategories[] traceCategories = new LifelineCategories[7];
    private boolean internalMessagesFiltered = false;
    private int maximumMessagesByPage = (int)TraceSDPlugin.getDefault().getPreferenceStore().getLong("page_size");
    private int nbMessages;
    private int nbMessagesInThisPage;
    private int pageNumber = 0;
    private boolean hasNextPage = false;
    private int totalNbMessages;
    private int pages;
    private ArrayList tracePages;
    private HashMap instancesMap;
    private double lastValidTime;
    private int currentMethodInvocationIndex;
    protected Timer subscribeSelectionTimer;
    private ArrayList selectedThreadList;
    private ArrayList currentFilters;
    private HashMap collapsedLifelines;
    private HashMap collapsedMessages;

    public void onSetViewer() {
        this.view.setSDFilterProvider((ISDFilterProvider)this);
        this.view.setSDPagingProvider((ISDPagingProvider)this);
        this.view.setInternalMessageFilterProvider((ISDInternalMesFilterProvider)this);
    }

    public void clearInternals() {
        super.clearInternals();
        this.pageNumber = 0;
        this.tracePages = null;
        this.collapsedLifelines = null;
        this.collapsedMessages = null;
        this.currentFilters = null;
        this.selectedThreadList = null;
    }

    protected TraceInteractionUpdate createTraceInteractionUpdate() {
        TraceInteractionUpdate traceInteractionUpdate = new TraceInteractionUpdate();
        if (this.selectedThreadList != null) {
            traceInteractionUpdate.setSelectedThreadList(this.selectedThreadList);
        }
        return traceInteractionUpdate;
    }

    protected synchronized void updateSD(TraceInteractionUpdate traceInteractionUpdate) {
        Frame frame = this.frame;
        if (!(this.frame == null || traceInteractionUpdate.isDateSelectionChanged() || traceInteractionUpdate.isPageChanged() || traceInteractionUpdate.isFindRequired())) {
            double d = 0.0;
            this.currentProcesses.init();
            TraceSyncMessage traceSyncMessage = (TraceSyncMessage)this.frame.getSyncMessage(this.frame.getFirstVisibleSyncMessage());
            if (traceSyncMessage != null) {
                d = traceSyncMessage.getStartDate() + this.currentProcesses.getStartTime();
            } else {
                TraceSyncMessageReturn traceSyncMessageReturn = (TraceSyncMessageReturn)this.frame.getSyncMessageReturn(this.frame.getFirstVisibleSyncMessageReturn());
                if (traceSyncMessageReturn != null) {
                    d = traceSyncMessageReturn.getStartDate() + this.currentProcesses.getStartTime();
                }
            }
            if (d != 0.0) {
                traceInteractionUpdate.setDateSelectionChanged(true);
                traceInteractionUpdate.setDateToShow(d);
            }
            if (TraceSDPlugin.debugLoader) {
                TraceSDPlugin.debugTraceLoader("visibleDate=" + d + " " + traceInteractionUpdate.isPageChanged() + " " + traceInteractionUpdate.isDateSelectionChanged());
            }
        }
        this.createFrame();
        if (this.currentProcesses == null) {
            return;
        }
        if (!traceInteractionUpdate.isPageChanged() && (traceInteractionUpdate.isInternalMessageFilteringChanged() || traceInteractionUpdate.isMaxMessagesByPageChanged() || traceInteractionUpdate.isFilteringChanged() || traceInteractionUpdate.isThreadSelectionChanged() || traceInteractionUpdate.isHorizontalCollapsingChanged() || traceInteractionUpdate.isVerticalCollapsingChanged())) {
            this.computeModel();
        }
        try {
            this.fillPage(traceInteractionUpdate);
        }
        catch (FoundInPage foundInPage) {
            if (TraceSDPlugin.debugLoader) {
                foundInPage.printStackTrace();
            }
            if (traceInteractionUpdate.isDateSelectionChanged() || traceInteractionUpdate.isFindRequired()) {
                traceInteractionUpdate.setPageChanged(true);
                this.pageNumber = foundInPage.getPage();
                this.updateSD(traceInteractionUpdate);
                return;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        if (!traceInteractionUpdate.isPageChanged()) {
            if (traceInteractionUpdate.isDateSelectionChanged() && this.frame.lifeLinesCount() > 0 && traceInteractionUpdate.getVisibleGraphNode() == null) {
                traceInteractionUpdate.setPageChanged(true);
                this.pageNumber = this.pages - 1;
                try {
                    this.fillPage(traceInteractionUpdate);
                }
                catch (FoundInPage foundInPage) {
                    // empty catch block
                }
                traceInteractionUpdate.setVisibleGraphNode((GraphNode)this.frame.getSyncMessageReturn(this.frame.syncMessageReturnCount() - 1));
            } else if (traceInteractionUpdate.isFindRequired() && (traceInteractionUpdate.getFindResults() == null || traceInteractionUpdate.getFindResults().size() == 0)) {
                this.frame = frame;
                return;
            }
        }
        if (traceInteractionUpdate.getVisibleGraphNode() != null && this.view != null && !this.view.getSDWidget().isDisposed()) {
            this.setFrameName();
            this.view.setFrameAndEnsureVisibleSync(this.frame, traceInteractionUpdate.getVisibleGraphNode());
            return;
        }
        if (this.view != null && !this.view.getSDWidget().isDisposed() && !this.isCurrentLoadCanceled()) {
            this.setFrameName();
            this.view.setFrameSync(this.frame);
        }
    }

    protected void createFrame() {
        super.createFrame();
        this.frame.setLifelineCategories(traceCategories);
    }

    public void setFrameName() {
        if (this.frame == null) {
            return;
        }
        if (this.currentProcesses != null && this.currentProcesses.size() >= 1) {
            if (this.currentProcesses.size() == 1) {
                TRCProcess tRCProcess = ((TraceProcess)this.currentProcesses.get(0)).getProcess();
                this.frame.setName(tRCProcess.getAgent().getAgentProxy().getProcessProxy().getName() + " [Pid " + tRCProcess.getPid() + "]" + this.pageMessage());
            } else {
                this.frame.setName(TraceSDPlugin.getResourceString("STR_SEVERAL_PROCESSES") + this.pageMessage());
            }
        } else {
            this.frame.setName(TraceSDPlugin.getResourceString("STR_NO_DATA_AVAILABLE"));
        }
        if (TraceSDPlugin.debugLoader) {
            TraceSDPlugin.debugTraceLoader("setFrameName() " + this.frame.getName());
        }
    }

    public String getTitleString() {
        String string = this.getFinalTitleString();
        if (this.pages <= 1) {
            return string;
        }
        return string + this.pageMessage();
    }

    public abstract String getFinalTitleString();

    protected String pageMessage() {
        String string = "";
        if (this.pages <= 1) {
            return string;
        }
        string = " [" + (1 + this.pageNumber) + "/" + this.pages + " " + TraceSDPlugin.getResourceString("STR_PAGES") + "]";
        return string;
    }

    protected void computeModel() {
        if (TraceSDPlugin.debugLoader) {
            TraceSDPlugin.debugTraceLoader("computeModel() " + this.maximumMessagesByPage);
        }
        this.totalNbMessages = 0;
        this.instancesMap = new HashMap();
        this.currentProcesses.init();
        TRCFullMethodInvocation tRCFullMethodInvocation = this.currentProcesses.consumeMethodInvocation();
        while (tRCFullMethodInvocation != null && !this.isCurrentLoadCanceled()) {
            block11: {
                TRCFullMethodInvocation tRCFullMethodInvocation2;
                block12: {
                    tRCFullMethodInvocation2 = (TRCFullMethodInvocation)tRCFullMethodInvocation.getInvokedBy();
                    if (this.isMessageCollapsed(tRCFullMethodInvocation2)) break block11;
                    EObject eObject = null;
                    EObject eObject2 = null;
                    if (tRCFullMethodInvocation2 == null) break block12;
                    eObject = this.getLifelineEObjectFromMethodInvocation(tRCFullMethodInvocation2);
                    eObject2 = this.getLifelineEObjectFromMethodInvocation(tRCFullMethodInvocation);
                    if (this.internalMessagesFiltered && eObject == eObject2) break block11;
                }
                TraceLifelineDraft traceLifelineDraft = this.getTraceLifelineDraftForMethodInvocation(null, tRCFullMethodInvocation);
                TraceLifelineDraft traceLifelineDraft2 = null;
                if (tRCFullMethodInvocation2 != null) {
                    traceLifelineDraft2 = this.getTraceLifelineDraftForMethodInvocation(null, tRCFullMethodInvocation2);
                }
                if (!(traceLifelineDraft.isFiltered() || traceLifelineDraft2 != null && traceLifelineDraft2.isFiltered())) {
                    String string = tRCFullMethodInvocation.getMethod().getName();
                    if (this.isSyncMessageFiltered(string)) {
                        this.collapseCalledMessage(tRCFullMethodInvocation, this.instancesMap);
                    } else {
                        this.totalNbMessages += 2;
                    }
                }
            }
            tRCFullMethodInvocation = this.currentProcesses.consumeMethodInvocation();
        }
        this.pages = this.totalNbMessages / this.maximumMessagesByPage;
        if (this.totalNbMessages % this.maximumMessagesByPage > 0) {
            ++this.pages;
        }
        this.cleanCollapsedMessage(this.instancesMap);
        this.instancesMap = null;
        if (TraceSDPlugin.debugLoader) {
            TraceSDPlugin.debugTraceLoader("computeModel() interrupted(" + this.isCurrentLoadCanceled() + ") has counted " + this.pages + " pages");
        }
    }

    public void fillPage(TraceInteractionUpdate traceInteractionUpdate) {
        Object object;
        Object object2;
        if (!traceInteractionUpdate.isThreadSelectionChanged()) {
            traceInteractionUpdate.setSelectedThreadList(this.selectedThreadList);
        }
        this.tracePages = new ArrayList();
        this.instancesMap = new HashMap();
        this.traceThreadMap = new HashMap();
        this.traceThreadList = new ArrayList();
        this.lastValidTime = 0.0;
        this.nbMessages = 0;
        this.nbMessagesInThisPage = 0;
        this.hasNextPage = false;
        this.currentMethodInvocationIndex = 0;
        this.currentProcesses.init();
        TRCFullMethodInvocation tRCFullMethodInvocation = this.currentProcesses.consumeMethodInvocation();
        while (tRCFullMethodInvocation != null && !this.isCurrentLoadCanceled() && this.nbMessagesInThisPage < this.maximumMessagesByPage) {
            if (TraceSDPlugin.debugLoader) {
                TraceSDPlugin.debugTraceLoader(this.nbMessages + ":" + this.nbMessages / this.maximumMessagesByPage + " " + tRCFullMethodInvocation);
            }
            if (!this.isThreadFiltered(traceInteractionUpdate, tRCFullMethodInvocation.getThread())) {
                this.finishPendingReturns(traceInteractionUpdate, TraceInteractionUtils.getAbsoluteEntryTime(tRCFullMethodInvocation));
                object2 = this.createSyncMessage(tRCFullMethodInvocation, traceInteractionUpdate);
                object = this.getTraceCallStack(tRCFullMethodInvocation.getThread());
                ((TraceCallStack)object).pushCall((TraceSyncMessage)object2, tRCFullMethodInvocation);
            }
            tRCFullMethodInvocation = this.currentProcesses.consumeMethodInvocation();
        }
        this.finishPendingReturns(traceInteractionUpdate, Double.MAX_VALUE);
        object2 = this.instancesMap.entrySet();
        object = object2.iterator();
        while (object.hasNext()) {
            Map.Entry entry = (Map.Entry)object.next();
            TraceLifelineDraft traceLifelineDraft = (TraceLifelineDraft)entry.getValue();
            if (TraceSDPlugin.debugLoader) {
                TraceSDPlugin.debugTraceLoader(traceLifelineDraft.getLifeline() + ":" + traceLifelineDraft.getNbUser());
            }
            if (traceLifelineDraft.getNbUser() <= 0) continue;
            traceLifelineDraft.setEnd(this.nbMessagesInThisPage + 1);
            if (traceLifelineDraft.getStart() == Integer.MAX_VALUE) {
                traceLifelineDraft.setStart(0);
            }
            this.setExecutionOccurence(traceLifelineDraft);
        }
        this.instancesMap = null;
        this.traceThreadMap = null;
        this.traceThreadList = null;
        this.cleanCollapsedMessage(this.frame);
    }

    protected void finishPendingReturns(TraceInteractionUpdate traceInteractionUpdate, double d) {
        while (this.getTraceThreadListFirstTime() < d) {
            TraceCallStack traceCallStack = (TraceCallStack)this.traceThreadList.get(0);
            TraceMessageAndCallAssociation traceMessageAndCallAssociation = traceCallStack.popCall();
            TraceSyncMessageReturn traceSyncMessageReturn = this.createSyncMessageReturn(traceMessageAndCallAssociation.getMethodInvocation(), traceInteractionUpdate);
            if (traceMessageAndCallAssociation.getMessage() == null || traceSyncMessageReturn == null) continue;
            traceSyncMessageReturn.setMessage(traceMessageAndCallAssociation.getMessage());
        }
    }

    private TraceSyncMessage createSyncMessage(TRCFullMethodInvocation tRCFullMethodInvocation, TraceInteractionUpdate traceInteractionUpdate) {
        TRCFullMethodInvocation tRCFullMethodInvocation2 = (TRCFullMethodInvocation)tRCFullMethodInvocation.getInvokedBy();
        if (this.isMessageCollapsed(tRCFullMethodInvocation2)) {
            return null;
        }
        TraceLifelineDraft traceLifelineDraft = this.getTraceLifelineDraftForMethodInvocation(this.frame, tRCFullMethodInvocation);
        TraceLifelineDraft traceLifelineDraft2 = null;
        if (tRCFullMethodInvocation2 != null) {
            traceLifelineDraft2 = this.getTraceLifelineDraftForMethodInvocation(this.frame, tRCFullMethodInvocation2);
        }
        if (traceLifelineDraft.isFiltered() || traceLifelineDraft2 != null && traceLifelineDraft2.isFiltered()) {
            return null;
        }
        if (this.internalMessagesFiltered && traceLifelineDraft2 == traceLifelineDraft) {
            return null;
        }
        if (this.isSyncMessageFiltered(tRCFullMethodInvocation.getMethod().getName())) {
            this.collapseCalledMessage(tRCFullMethodInvocation, this.frame);
            return null;
        }
        ++this.nbMessages;
        String string = this.getMessageName(tRCFullMethodInvocation, traceLifelineDraft2 == null);
        if (TraceSDPlugin.debugLoader) {
            TraceSDPlugin.debugTraceLoader("in:" + this.nbMessages + ":" + this.nbMessages / this.maximumMessagesByPage + " " + string + " " + TraceInteractionUtils.getAbsoluteEntryTime(tRCFullMethodInvocation));
        }
        if (this.nbMessagesInThisPage == this.maximumMessagesByPage) {
            this.hasNextPage = true;
            return null;
        }
        if (traceLifelineDraft2 != null && traceLifelineDraft2 != traceLifelineDraft) {
            traceLifelineDraft2.addAUser();
        }
        traceLifelineDraft.addAUser();
        if ((this.nbMessages - 1) % this.maximumMessagesByPage == 0) {
            this.tracePages.add(new TracePage(TraceInteractionUtils.getAbsoluteEntryTime(tRCFullMethodInvocation)));
        } else if ((this.nbMessages - 1) % this.maximumMessagesByPage == this.maximumMessagesByPage - 1) {
            ((TracePage)this.tracePages.get(this.tracePages.size() - 1)).setLastTime(TraceInteractionUtils.getAbsoluteExitTime(tRCFullMethodInvocation));
        }
        if (traceInteractionUpdate.isPageChanged() && this.nbMessages - 1 < this.pageNumber * this.maximumMessagesByPage) {
            return null;
        }
        if (!traceInteractionUpdate.isPageChanged()) {
            if (traceInteractionUpdate.isDateSelectionChanged()) {
                if (TraceInteractionUtils.getAbsoluteEntryTime(tRCFullMethodInvocation) < traceInteractionUpdate.getDateToShow()) {
                    return null;
                }
                throw new FoundInPage(this.tracePages.size() - 1);
            }
            if (traceInteractionUpdate.isFindRequired() && traceInteractionUpdate.getFindCriteria().isSyncMessageSelected()) {
                if (traceInteractionUpdate.getFindStartingPage() <= this.tracePages.size() - 1 && TraceInteractionUtils.matchCriteria(string, traceInteractionUpdate.getFindCriteria())) {
                    throw new FoundInPage(this.tracePages.size() - 1);
                }
                return null;
            }
        }
        if (traceLifelineDraft2 != null && traceLifelineDraft2 != traceLifelineDraft && traceLifelineDraft2.getNbUser() == 1) {
            traceLifelineDraft2.setStart(this.nbMessagesInThisPage + 1);
        }
        if (traceLifelineDraft.getNbUser() == 1) {
            traceLifelineDraft.setStart(this.nbMessagesInThisPage + 1);
        }
        TraceSyncMessage traceSyncMessage = this.isMessageCollapsed(tRCFullMethodInvocation) ? new TraceCollapsedSyncMessage() : (tRCFullMethodInvocation.getInvokes() != null && tRCFullMethodInvocation.getInvokes().size() > 0 ? new TraceCollapsableSyncMessage() : new TraceSyncMessage());
        if (traceInteractionUpdate.isPageChanged()) {
            if (traceInteractionUpdate.isDateSelectionChanged() && TraceInteractionUtils.getAbsoluteEntryTime(tRCFullMethodInvocation) >= traceInteractionUpdate.getDateToShow() && traceInteractionUpdate.getVisibleGraphNode() == null) {
                traceInteractionUpdate.setVisibleGraphNode((GraphNode)traceSyncMessage);
            }
            if (traceInteractionUpdate.isFindRequired() && traceInteractionUpdate.getFindCriteria().isSyncMessageSelected() && TraceInteractionUtils.matchCriteria(string, traceInteractionUpdate.getFindCriteria())) {
                traceInteractionUpdate.addFindResult((GraphNode)traceSyncMessage);
            }
        }
        traceSyncMessage.model = tRCFullMethodInvocation;
        if (traceLifelineDraft2 != null) {
            traceLifelineDraft2.getLifeline().setCurrentEventOccurrence(this.nbMessagesInThisPage + 1);
            traceSyncMessage.setStartLifeline(traceLifelineDraft2.getLifeline());
        } else {
            traceLifelineDraft.getLifeline().setCurrentEventOccurrence(this.nbMessagesInThisPage + 1);
        }
        traceSyncMessage.setName(string);
        traceSyncMessage.setEndLifeline(traceLifelineDraft.getLifeline());
        traceSyncMessage.setTime(TraceInteractionUtils.getAbsoluteEntryTime(tRCFullMethodInvocation));
        this.lastValidTime = TraceInteractionUtils.getAbsoluteEntryTime(tRCFullMethodInvocation);
        if (this.isCurrentLoadCanceled()) {
            return null;
        }
        this.frame.addMessage((BaseMessage)traceSyncMessage);
        ++this.nbMessagesInThisPage;
        return traceSyncMessage;
    }

    private TraceSyncMessageReturn createSyncMessageReturn(TRCFullMethodInvocation tRCFullMethodInvocation, TraceInteractionUpdate traceInteractionUpdate) {
        TRCFullMethodInvocation tRCFullMethodInvocation2 = (TRCFullMethodInvocation)tRCFullMethodInvocation.getInvokedBy();
        if (this.isMessageCollapsed(tRCFullMethodInvocation2)) {
            return null;
        }
        TraceLifelineDraft traceLifelineDraft = this.getTraceLifelineDraftForMethodInvocation(this.frame, tRCFullMethodInvocation);
        TraceLifelineDraft traceLifelineDraft2 = null;
        if (tRCFullMethodInvocation2 != null) {
            traceLifelineDraft2 = this.getTraceLifelineDraftForMethodInvocation(this.frame, tRCFullMethodInvocation2);
        }
        if (traceLifelineDraft.isFiltered() || traceLifelineDraft2 != null && traceLifelineDraft2.isFiltered()) {
            return null;
        }
        if (this.internalMessagesFiltered && traceLifelineDraft2 == traceLifelineDraft) {
            return null;
        }
        if (this.isSyncMessageFiltered(tRCFullMethodInvocation.getMethod().getName())) {
            this.collapseCalledMessage(tRCFullMethodInvocation, this.frame);
            return null;
        }
        ++this.nbMessages;
        String string = this.getMessageName(tRCFullMethodInvocation, traceLifelineDraft2 == null);
        if (TraceSDPlugin.debugLoader) {
            TraceSDPlugin.debugTraceLoader("out:" + this.nbMessages + ":" + this.nbMessages / this.maximumMessagesByPage + " " + string + " " + TraceInteractionUtils.getAbsoluteExitTime(tRCFullMethodInvocation));
        }
        if (this.nbMessagesInThisPage == this.maximumMessagesByPage) {
            this.hasNextPage = true;
            return null;
        }
        if (traceLifelineDraft2 != null && traceLifelineDraft2 != traceLifelineDraft) {
            traceLifelineDraft2.removeAUser();
        }
        traceLifelineDraft.removeAUser();
        if ((this.nbMessages - 1) % this.maximumMessagesByPage == 0) {
            this.tracePages.add(new TracePage(TraceInteractionUtils.getAbsoluteExitTime(tRCFullMethodInvocation)));
        } else if ((this.nbMessages - 1) % this.maximumMessagesByPage == this.maximumMessagesByPage - 1) {
            ((TracePage)this.tracePages.get(this.tracePages.size() - 1)).setLastTime(TraceInteractionUtils.getAbsoluteExitTime(tRCFullMethodInvocation));
        }
        if (traceInteractionUpdate.isPageChanged() && this.nbMessages - 1 < this.pageNumber * this.maximumMessagesByPage) {
            return null;
        }
        if (!traceInteractionUpdate.isPageChanged()) {
            if (traceInteractionUpdate.isDateSelectionChanged()) {
                if (TraceInteractionUtils.getAbsoluteExitTime(tRCFullMethodInvocation) < traceInteractionUpdate.getDateToShow()) {
                    return null;
                }
                throw new FoundInPage(this.tracePages.size() - 1);
            }
            if (traceInteractionUpdate.isFindRequired() && traceInteractionUpdate.getFindCriteria().isSyncMessageSelected()) {
                if (traceInteractionUpdate.getFindStartingPage() <= this.tracePages.size() - 1 && TraceInteractionUtils.matchCriteria(string, traceInteractionUpdate.getFindCriteria())) {
                    throw new FoundInPage(this.tracePages.size() - 1);
                }
                return null;
            }
        }
        if (traceLifelineDraft2 != null && traceLifelineDraft2 != traceLifelineDraft && traceLifelineDraft2.getNbUser() == 0) {
            traceLifelineDraft2.setEnd(this.nbMessagesInThisPage + 1);
            this.setExecutionOccurence(traceLifelineDraft2);
        }
        if (traceLifelineDraft.getNbUser() == 0) {
            traceLifelineDraft.setEnd(this.nbMessagesInThisPage + 1);
            this.setExecutionOccurence(traceLifelineDraft);
        }
        TraceSyncMessageReturn traceSyncMessageReturn = this.isMessageCollapsed(tRCFullMethodInvocation) ? new TraceCollapsedSyncMessageReturn() : (tRCFullMethodInvocation.getInvokes() != null && tRCFullMethodInvocation.getInvokes().size() > 0 ? new TraceCollapsableSyncMessageReturn() : new TraceSyncMessageReturn());
        if (traceInteractionUpdate.isPageChanged()) {
            if (traceInteractionUpdate.isDateSelectionChanged() && TraceInteractionUtils.getAbsoluteExitTime(tRCFullMethodInvocation) >= traceInteractionUpdate.getDateToShow() && traceInteractionUpdate.getVisibleGraphNode() == null) {
                traceInteractionUpdate.setVisibleGraphNode((GraphNode)traceSyncMessageReturn);
            }
            if (traceInteractionUpdate.isFindRequired() && traceInteractionUpdate.getFindCriteria().isSyncMessageSelected() && TraceInteractionUtils.matchCriteria(string, traceInteractionUpdate.getFindCriteria())) {
                traceInteractionUpdate.addFindResult((GraphNode)traceSyncMessageReturn);
            }
        }
        traceSyncMessageReturn.model = tRCFullMethodInvocation;
        if (traceLifelineDraft2 != null) {
            traceLifelineDraft2.getLifeline().setCurrentEventOccurrence(this.nbMessagesInThisPage + 1);
            traceSyncMessageReturn.setEndLifeline(traceLifelineDraft2.getLifeline());
        } else {
            traceLifelineDraft.getLifeline().setCurrentEventOccurrence(this.nbMessagesInThisPage + 1);
        }
        traceSyncMessageReturn.setName(string);
        traceSyncMessageReturn.setStartLifeline(traceLifelineDraft.getLifeline());
        if (tRCFullMethodInvocation.getExitTime() > 0.0) {
            traceSyncMessageReturn.setTime(TraceInteractionUtils.getAbsoluteExitTime(tRCFullMethodInvocation));
            this.lastValidTime = TraceInteractionUtils.getAbsoluteExitTime(tRCFullMethodInvocation);
        } else {
            traceSyncMessageReturn.setTime(this.lastValidTime);
        }
        if (this.isCurrentLoadCanceled()) {
            return null;
        }
        this.frame.addMessage((BaseMessage)traceSyncMessageReturn);
        ++this.nbMessagesInThisPage;
        return traceSyncMessageReturn;
    }

    private String getMessageName(TRCFullMethodInvocation tRCFullMethodInvocation, boolean bl) {
        if (bl) {
            return tRCFullMethodInvocation.getMethod().getName() + " (" + tRCFullMethodInvocation.getThread().getName() + ")";
        }
        return tRCFullMethodInvocation.getMethod().getName().intern();
    }

    protected TraceLifelineDraft getTraceLifelineDraftForMethodInvocation(Frame frame, TRCFullMethodInvocation tRCFullMethodInvocation) {
        EObject eObject = this.getLifelineEObjectFromMethodInvocation(tRCFullMethodInvocation);
        TRCTraceObject tRCTraceObject = tRCFullMethodInvocation.getOwningObject();
        TraceLifelineDraft traceLifelineDraft = (TraceLifelineDraft)this.instancesMap.get(eObject);
        if (traceLifelineDraft == null) {
            ArrayList arrayList;
            traceLifelineDraft = new TraceLifelineDraft();
            String string = this.getLifeLineTitle(eObject, true);
            if (this.isLifelineFiltered(string)) {
                traceLifelineDraft.setFiltered(true);
                return traceLifelineDraft;
            }
            ArrayList arrayList2 = arrayList = this.collapsedLifelines != null ? (ArrayList)this.collapsedLifelines.get(eObject) : null;
            if (arrayList != null) {
                ArrayList arrayList3 = (ArrayList)this.collapsedLifelines.get(arrayList);
                while (arrayList3 != null) {
                    arrayList = arrayList3;
                    arrayList3 = (ArrayList)this.collapsedLifelines.get(arrayList3);
                }
                string = this.getCollapsedLifelineName(arrayList, "");
                if (string.length() > 80) {
                    string = string.substring(0, 77) + "...";
                }
                if (this.isLifelineFiltered(string)) {
                    traceLifelineDraft.setFiltered(true);
                    return traceLifelineDraft;
                }
                if (frame == null) {
                    return traceLifelineDraft;
                }
                TraceCollapsedLifelines traceCollapsedLifelines = new TraceCollapsedLifelines();
                traceLifelineDraft.setLifeline(traceCollapsedLifelines);
                traceCollapsedLifelines.setCollapsedLifelines(arrayList);
                traceCollapsedLifelines.setName(string);
                this.putInstancesMap(arrayList, traceLifelineDraft);
                traceCollapsedLifelines.setCategory(6);
            } else {
                if (frame == null) {
                    return traceLifelineDraft;
                }
                TraceLifeline traceLifeline = new TraceLifeline();
                traceLifelineDraft.setLifeline(traceLifeline);
                traceLifeline.setEObject(eObject);
                this.instancesMap.put(eObject, traceLifelineDraft);
                if (tRCTraceObject.getIsA() != null) {
                    traceLifeline.setName(string);
                    traceLifeline.setCategory(this.getLifeLineCategory(eObject));
                }
            }
            frame.addLifeLine(traceLifelineDraft.getLifeline());
            traceLifelineDraft.setStart(Integer.MAX_VALUE);
            traceLifelineDraft.setEnd(0);
        }
        return traceLifelineDraft;
    }

    private void putInstancesMap(ArrayList arrayList, TraceLifelineDraft traceLifelineDraft) {
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof EObject) {
                this.instancesMap.put(e, traceLifelineDraft);
                continue;
            }
            if (!(e instanceof ArrayList)) continue;
            this.putInstancesMap((ArrayList)e, traceLifelineDraft);
        }
    }

    private String getCollapsedLifelineName(ArrayList arrayList, String string) {
        String string2 = "[";
        int n = 0;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof EObject) {
                if (n > 0) {
                    string2 = string2 + "," + string;
                }
                string2 = string2 + this.getLifeLineTitle((EObject)e, false);
            } else if (e instanceof ArrayList) {
                if (n > 0) {
                    string2 = string2 + "," + string;
                }
                string2 = string2 + this.getCollapsedLifelineName((ArrayList)e, string + " ");
            }
            ++n;
        }
        return string2 + "]";
    }

    private void externalDateSelectionChanged(IDateSelection iDateSelection, TraceInteractionUpdate traceInteractionUpdate) {
        if (this.frame == null) {
            return;
        }
        if (TraceSDPlugin.debugEvents) {
            TraceSDPlugin.debugTraceEvents("External Date selection is " + iDateSelection);
        }
        IDateSelection iDateSelection2 = iDateSelection;
        EObject eObject = iDateSelection.getEObject();
        if (!(eObject instanceof TRCProcess) || this.currentProcesses == null || !this.currentProcesses.contains((TRCProcess)eObject)) {
            return;
        }
        TRCProcess tRCProcess = (TRCProcess)eObject;
        double d = iDateSelection2.getStartDate();
        double d2 = d;
        if (d2 < TraceInteractionUtils.getAbsoluteEntryTime(tRCProcess)) {
            d2 += TraceInteractionUtils.getAbsoluteEntryTime(tRCProcess);
        } else {
            d -= TraceInteractionUtils.getAbsoluteEntryTime(tRCProcess);
        }
        if (iDateSelection2.getMeaning() == 0) {
            ITimeRange[] iTimeRangeArray;
            if (TraceSDPlugin.debugEvents) {
                TraceSDPlugin.debugTraceEvents("dateSelection=" + d + "; absoluteDateSelection=" + d2 + "; getAbsoluteEntryTime(process)=" + TraceInteractionUtils.getAbsoluteEntryTime(tRCProcess));
            }
            if (this.frame.findDateBounds(d2, iTimeRangeArray = new ITimeRange[2])) {
                if (iTimeRangeArray[0] instanceof GraphNode) {
                    this.view.getSDWidget().ensureVisible((GraphNode)iTimeRangeArray[0]);
                    if (TraceSDPlugin.debugEvents) {
                        TraceSDPlugin.debugTraceEvents("Found a graph node");
                    }
                    return;
                }
                if (TraceSDPlugin.debugEvents) {
                    TraceSDPlugin.debugTraceEvents("Found something else than a graph node: ignored");
                }
                return;
            }
            if (this.pages == 1) {
                ITimeRange iTimeRange;
                ITimeRange iTimeRange2 = iTimeRange = iTimeRangeArray[0] != null ? iTimeRangeArray[0] : iTimeRangeArray[1];
                if (iTimeRange != null && iTimeRange instanceof GraphNode) {
                    this.view.getSDWidget().ensureVisible((GraphNode)iTimeRange);
                    if (TraceSDPlugin.debugEvents) {
                        TraceSDPlugin.debugTraceEvents(iTimeRangeArray[0] == null ? "Before any graph node" : "After any graph node");
                    }
                    return;
                }
                if (TraceSDPlugin.debugEvents) {
                    TraceSDPlugin.debugTraceEvents("Found something else than a graph node (#2): ignored");
                }
                return;
            }
            if (this.tracePages != null && this.tracePages.size() > 0 && d <= ((TracePage)this.tracePages.get(this.tracePages.size() - 1)).getLastTime()) {
                int n = 0;
                while (n < this.tracePages.size()) {
                    TracePage tracePage = (TracePage)this.tracePages.get(n);
                    if (d >= tracePage.getFirstTime() && d <= tracePage.getLastTime()) {
                        traceInteractionUpdate.setDateSelectionChanged(true);
                        traceInteractionUpdate.setDateToShow(d2);
                        traceInteractionUpdate.setPageChanged(true);
                        this.pageNumber = n;
                        if (TraceSDPlugin.debugEvents) {
                            TraceSDPlugin.debugTraceEvents("Found in a previous page");
                        }
                        return;
                    }
                    ++n;
                }
            }
            traceInteractionUpdate.setDateSelectionChanged(true);
            traceInteractionUpdate.setDateToShow(d2);
            if (TraceSDPlugin.debugEvents) {
                TraceSDPlugin.debugTraceEvents("Looking in all pages");
            }
        }
    }

    private void subscribeForDateSelectionChanged(final IDateSelection iDateSelection) {
        if (this.subscribeSelectionTimer != null) {
            this.subscribeSelectionTimer.cancel();
        }
        this.subscribeSelectionTimer = new Timer();
        this.subscribeSelectionTimer.schedule(new TimerTask(){

            public void run() {
                Display.getDefault().syncExec(new Runnable(this){
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        TraceInteractionUpdate traceInteractionUpdate = new TraceInteractionUpdate();
                        TraceInteractions.access$200(1.access$100(this.this$1), 1.access$000(this.this$1), traceInteractionUpdate);
                        if (traceInteractionUpdate.needsUpdate()) {
                            1.access$100(this.this$1).updateSDBackground(traceInteractionUpdate);
                        }
                    }
                });
                TraceInteractions.this.subscribeSelectionTimer = null;
            }

            static /* synthetic */ IDateSelection access$000(1 var0) {
                return var0.iDateSelection;
            }

            static /* synthetic */ TraceInteractions access$100(1 var0) {
                return var0.TraceInteractions.this;
            }
        }, 50L);
    }

    private boolean isThreadFiltered(TraceInteractionUpdate traceInteractionUpdate, TRCThread tRCThread) {
        if (traceInteractionUpdate.getSelectedThreadList() != null) {
            return !traceInteractionUpdate.getSelectedThreadList().contains(tRCThread);
        }
        return false;
    }

    protected void finishExternalExtendedSelection(TraceInteractionUpdate traceInteractionUpdate) {
        if (traceInteractionUpdate.isThreadSelectionChanged()) {
            this.selectedThreadList = traceInteractionUpdate.getSelectedThreadList();
        }
    }

    protected boolean externalExtendedSelectionChanged(IWorkbenchPart iWorkbenchPart, Object object, TraceInteractionUpdate traceInteractionUpdate) {
        if (TraceSDPlugin.debugEvents) {
            TraceSDPlugin.debugTraceEvents("TraceInteractions: External extended selection from " + iWorkbenchPart + " is " + object);
        }
        if (object instanceof IDateSelection) {
            if (TraceSDPlugin.debugEvents) {
                TraceSDPlugin.debugTraceEvents("TraceInteractions: IDateSelection: " + ((IDateSelection)object).getStartDate());
            }
            this.subscribeForDateSelectionChanged((IDateSelection)object);
            return true;
        }
        if (object instanceof IEObjectSelection) {
            EObject eObject = ((IEObjectSelection)object).getEObject();
            if (TraceSDPlugin.debugEvents) {
                TraceSDPlugin.debugTraceEvents("TraceInteractions: IEObjectSelection: " + eObject);
            }
            if (eObject instanceof TRCThread) {
                traceInteractionUpdate.setThreadSelectionChanged(true);
                traceInteractionUpdate.addSelectedThread((TRCThread)eObject);
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean isSyncMessageSupported() {
        return true;
    }

    public boolean hasNextPage() {
        return this.hasNextPage;
    }

    public boolean hasPrevPage() {
        return this.pageNumber > 0;
    }

    public void nextPage() {
        ++this.pageNumber;
        TraceInteractionUpdate traceInteractionUpdate = new TraceInteractionUpdate();
        traceInteractionUpdate.setPageChanged(true);
        this.updateSDBackground(traceInteractionUpdate);
    }

    public void prevPage() {
        --this.pageNumber;
        TraceInteractionUpdate traceInteractionUpdate = new TraceInteractionUpdate();
        traceInteractionUpdate.setPageChanged(true);
        this.updateSDBackground(traceInteractionUpdate);
    }

    public int maxItemsByPageCount() {
        return this.maximumMessagesByPage;
    }

    public int itemsTotalCount() {
        return this.totalNbMessages;
    }

    public String noItemsText() {
        return TraceSDPlugin.getResourceString("PAGES_COUNT_NO_ITEMS");
    }

    public String oneItemText() {
        return TraceSDPlugin.getResourceString("PAGES_COUNT_ONE_ITEM");
    }

    public String itemsText() {
        return TraceSDPlugin.getResourceString("PAGES_COUNT_SEVERAL_ITEMS");
    }

    public int currentPage() {
        return this.pageNumber;
    }

    public int pagesCount() {
        return this.pages;
    }

    public void pageSettingsChanged(int n, int n2) {
        TraceInteractionUpdate traceInteractionUpdate = new TraceInteractionUpdate();
        traceInteractionUpdate.setMaxMessagesByPageChanged(this.maximumMessagesByPage != n);
        this.maximumMessagesByPage = n;
        traceInteractionUpdate.setPageChanged(this.pageNumber != n2);
        this.pageNumber = n2;
        if (traceInteractionUpdate.isMaxMessagesByPageChanged() || traceInteractionUpdate.isPageChanged()) {
            this.updateSDBackground(traceInteractionUpdate);
        }
    }

    public void pageNumberChanged(int n) {
        TraceInteractionUpdate traceInteractionUpdate = new TraceInteractionUpdate();
        traceInteractionUpdate.setPageChanged(this.pageNumber != n);
        this.pageNumber = n;
        if (traceInteractionUpdate.isPageChanged()) {
            this.updateSDBackground(traceInteractionUpdate);
        }
    }

    public boolean notFoundYet(Criteria criteria) {
        if (this.pages > 1 && this.pageNumber + 1 < this.pages) {
            TraceInteractionUpdate traceInteractionUpdate = new TraceInteractionUpdate();
            traceInteractionUpdate.setFindRequired(true);
            traceInteractionUpdate.setFindCriteria(criteria);
            traceInteractionUpdate.setFindStartingPage(this.pageNumber + 1);
            this.updateSD(traceInteractionUpdate);
            ArrayList arrayList = traceInteractionUpdate.getFindResults();
            if (arrayList != null && !arrayList.isEmpty()) {
                this.findResults = arrayList;
                this.currentFindIndex = 0;
                GraphNode graphNode = (GraphNode)this.findResults.get(this.currentFindIndex);
                this.view.getSDWidget().moveTo(graphNode);
                return true;
            }
        }
        return false;
    }

    public void setFiltered(boolean bl) {
        if (this.internalMessagesFiltered != bl) {
            this.internalMessagesFiltered = bl;
            TraceInteractionUpdate traceInteractionUpdate = new TraceInteractionUpdate();
            traceInteractionUpdate.setInternalMessageFilteringChanged(true);
            this.updateSDBackground(traceInteractionUpdate);
        }
    }

    public ArrayList getCurrentFilters() {
        return this.currentFilters;
    }

    private boolean isLifelineFiltered(String string) {
        if (this.currentFilters != null) {
            Iterator iterator = this.currentFilters.iterator();
            while (iterator.hasNext()) {
                FilterCriteria filterCriteria = (FilterCriteria)iterator.next();
                if (!filterCriteria.isActive() || !filterCriteria.getCriteria().isLifeLineSelected() || !TraceInteractionUtils.matchCriteria(string, filterCriteria.getCriteria())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isSyncMessageFiltered(String string) {
        if (this.currentFilters != null) {
            Iterator iterator = this.currentFilters.iterator();
            while (iterator.hasNext()) {
                FilterCriteria filterCriteria = (FilterCriteria)iterator.next();
                if (!filterCriteria.isActive() || !filterCriteria.getCriteria().isSyncMessageSelected() || !TraceInteractionUtils.matchCriteria(string, filterCriteria.getCriteria())) continue;
                return true;
            }
        }
        return false;
    }

    public void filterSelectedGraphNodes(ArrayList arrayList) {
        TraceInteractionUpdate traceInteractionUpdate;
        if (TraceSDPlugin.debugEvents) {
            TraceSDPlugin.debugTraceEvents("filterGraphNodes(" + (arrayList != null ? arrayList.size() : 0) + " selected graph nodes)");
        }
        if (this.currentFilters == null) {
            this.currentFilters = new ArrayList();
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            EObject eObject;
            traceInteractionUpdate = (GraphNode)iterator.next();
            Criteria criteria = new Criteria();
            if (traceInteractionUpdate instanceof IEObjectSelection && (eObject = ((IEObjectSelection)((Object)traceInteractionUpdate)).getEObject()) instanceof TRCFullMethodInvocation) {
                criteria.setExpression(((TRCFullMethodInvocation)eObject).getMethod().getName());
            }
            criteria.setCaseSenstiveSelected(true);
            if (traceInteractionUpdate instanceof TraceLifeline) {
                criteria.setExpression(traceInteractionUpdate.getName());
                criteria.setLifeLineSelected(true);
            } else if (traceInteractionUpdate instanceof TraceSyncMessage) {
                criteria.setExpression(((TRCFullMethodInvocation)((TraceSyncMessage)((Object)traceInteractionUpdate)).getEObject()).getMethod().getName());
                criteria.setSyncMessageSelected(true);
            } else if (traceInteractionUpdate instanceof TraceSyncMessageReturn) {
                criteria.setExpression(((TRCFullMethodInvocation)((TraceSyncMessageReturn)((Object)traceInteractionUpdate)).getEObject()).getMethod().getName());
                criteria.setSyncMessageSelected(true);
            }
            this.currentFilters.add(new FilterCriteria(criteria, true));
        }
        traceInteractionUpdate = new TraceInteractionUpdate();
        traceInteractionUpdate.setFilteringChanged(true);
        this.updateSDBackground(traceInteractionUpdate);
    }

    public boolean filter(ArrayList arrayList) {
        if (TraceSDPlugin.debugEvents) {
            TraceSDPlugin.debugTraceEvents("filter(" + (arrayList != null ? arrayList.size() : 0) + " filters)");
        }
        this.currentFilters = arrayList;
        TraceInteractionUpdate traceInteractionUpdate = new TraceInteractionUpdate();
        traceInteractionUpdate.setFilteringChanged(true);
        this.updateSDBackground(traceInteractionUpdate);
        return true;
    }

    public void collapseLifelines(ArrayList arrayList) {
        TraceInteractionUpdate traceInteractionUpdate;
        if (TraceSDPlugin.debugEvents) {
            TraceSDPlugin.debugTraceEvents("collapseLifelines(" + (arrayList != null ? arrayList.size() : 0) + ")");
        }
        if (this.collapsedLifelines == null) {
            this.collapsedLifelines = new HashMap();
        }
        ArrayList<ArrayList> arrayList2 = new ArrayList<ArrayList>();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            traceInteractionUpdate = (GraphNode)iterator.next();
            ArrayList arrayList3 = null;
            if (traceInteractionUpdate instanceof TraceCollapsedLifelines) {
                arrayList3 = ((TraceCollapsedLifelines)((Object)traceInteractionUpdate)).getCollapsedLifelines();
            } else {
                if (!(traceInteractionUpdate instanceof TraceLifeline)) continue;
                arrayList3 = ((TraceLifeline)((Object)traceInteractionUpdate)).getEObject();
            }
            arrayList2.add(arrayList3);
            this.collapsedLifelines.put(arrayList3, arrayList2);
        }
        traceInteractionUpdate = new TraceInteractionUpdate();
        traceInteractionUpdate.setHorizontalCollapsingChanged(true);
        this.updateSDBackground(traceInteractionUpdate);
    }

    public void expandLifelines(ArrayList arrayList) {
        TraceInteractionUpdate traceInteractionUpdate;
        if (TraceSDPlugin.debugEvents) {
            TraceSDPlugin.debugTraceEvents("expandLifelines(" + (arrayList != null ? arrayList.size() : 0) + ")");
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            traceInteractionUpdate = (GraphNode)iterator.next();
            if (!(traceInteractionUpdate instanceof TraceCollapsedLifelines)) continue;
            ArrayList arrayList2 = ((TraceCollapsedLifelines)((Object)traceInteractionUpdate)).getCollapsedLifelines();
            Iterator iterator2 = arrayList2.iterator();
            while (iterator2.hasNext()) {
                Object e = iterator2.next();
                this.collapsedLifelines.put(e, null);
            }
        }
        traceInteractionUpdate = new TraceInteractionUpdate();
        traceInteractionUpdate.setHorizontalCollapsingChanged(true);
        this.updateSDBackground(traceInteractionUpdate);
    }

    private boolean isMessageCollapsed(TRCFullMethodInvocation tRCFullMethodInvocation) {
        if (tRCFullMethodInvocation == null || this.collapsedMessages == null) {
            return false;
        }
        if (this.collapsedMessages.get(tRCFullMethodInvocation) != null) {
            return true;
        }
        TRCFullMethodInvocation tRCFullMethodInvocation2 = (TRCFullMethodInvocation)tRCFullMethodInvocation.getInvokedBy();
        while (tRCFullMethodInvocation2 != null) {
            if (this.collapsedMessages.get(tRCFullMethodInvocation2) != null) {
                return true;
            }
            tRCFullMethodInvocation2 = (TRCFullMethodInvocation)tRCFullMethodInvocation2.getInvokedBy();
        }
        return false;
    }

    public void collapseCalledMessages(ArrayList arrayList) {
        Object object;
        if (TraceSDPlugin.debugEvents) {
            TraceSDPlugin.debugTraceEvents("collapseCalledMessages(" + (arrayList != null ? arrayList.size() : 0) + ")");
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            IDateSelection iDateSelection;
            object = iterator.next();
            TRCFullMethodInvocation tRCFullMethodInvocation = null;
            if (object instanceof TraceSyncMessage) {
                iDateSelection = (TraceSyncMessage)object;
                tRCFullMethodInvocation = (TRCFullMethodInvocation)((TraceSyncMessage)iDateSelection).getEObject();
            } else if (object instanceof TraceSyncMessageReturn) {
                iDateSelection = (TraceSyncMessageReturn)object;
                tRCFullMethodInvocation = (TRCFullMethodInvocation)((TraceSyncMessageReturn)iDateSelection).getEObject();
            }
            this.collapseCalledMessage(tRCFullMethodInvocation, this.currentMofObjectFromPDProjectExplorer);
        }
        object = new TraceInteractionUpdate();
        ((TraceInteractionUpdate)object).setVerticalCollapsingChanged(true);
        this.updateSDBackground((TraceInteractionUpdate)object);
    }

    private void collapseCalledMessage(TRCFullMethodInvocation tRCFullMethodInvocation, Object object) {
        if (tRCFullMethodInvocation != null) {
            if (this.collapsedMessages == null) {
                this.collapsedMessages = new HashMap();
            }
            this.collapsedMessages.put(tRCFullMethodInvocation, object);
        }
    }

    private void cleanCollapsedMessage(Object object) {
        if (this.collapsedMessages == null) {
            return;
        }
        Set set = this.collapsedMessages.entrySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (entry.getValue() != object) continue;
            iterator.remove();
        }
    }

    public void expandCalledMessages(ArrayList arrayList) {
        Object object;
        if (TraceSDPlugin.debugEvents) {
            TraceSDPlugin.debugTraceEvents("expandCalledMessages(" + (arrayList != null ? arrayList.size() : 0) + ")");
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            IDateSelection iDateSelection;
            object = iterator.next();
            TRCFullMethodInvocation tRCFullMethodInvocation = null;
            if (object instanceof TraceSyncMessage) {
                iDateSelection = (TraceSyncMessage)object;
                tRCFullMethodInvocation = (TRCFullMethodInvocation)((TraceSyncMessage)iDateSelection).getEObject();
            } else if (object instanceof TraceSyncMessageReturn) {
                iDateSelection = (TraceSyncMessageReturn)object;
                tRCFullMethodInvocation = (TRCFullMethodInvocation)((TraceSyncMessageReturn)iDateSelection).getEObject();
            }
            if (tRCFullMethodInvocation == null) continue;
            this.collapsedMessages.put(tRCFullMethodInvocation, null);
        }
        object = new TraceInteractionUpdate();
        ((TraceInteractionUpdate)object).setVerticalCollapsingChanged(true);
        this.updateSDBackground((TraceInteractionUpdate)object);
    }

    public void applyPreferences() {
        int n = (int)TraceSDPlugin.getDefault().getPreferenceStore().getLong("page_size");
        if (this.maximumMessagesByPage == n) {
            return;
        }
        TraceInteractionUpdate traceInteractionUpdate = new TraceInteractionUpdate();
        traceInteractionUpdate.setMaxMessagesByPageChanged(true);
        this.maximumMessagesByPage = n;
        this.updateSDBackground(traceInteractionUpdate);
    }

    static /* synthetic */ void access$200(TraceInteractions traceInteractions, IDateSelection iDateSelection, TraceInteractionUpdate traceInteractionUpdate) {
        traceInteractions.externalDateSelectionChanged(iDateSelection, traceInteractionUpdate);
    }

    static {
        TraceInteractions.traceCategories[0] = new LifelineCategories();
        traceCategories[0].setName(TraceSDPlugin.getResourceString("STR_CLASS"));
        traceCategories[0].setImage((IImage)new ImageImpl(TraceSDPlugin.getResourceImage("class.gif")));
        TraceInteractions.traceCategories[1] = new LifelineCategories();
        traceCategories[1].setName(TraceSDPlugin.getResourceString("STR_OBJECT"));
        traceCategories[1].setImage((IImage)new ImageImpl(TraceSDPlugin.getResourceImage("classobject_obj.gif")));
        TraceInteractions.traceCategories[2] = new LifelineCategories();
        traceCategories[2].setName(TraceSDPlugin.getResourceString("STR_NODE"));
        traceCategories[2].setImage((IImage)new ImageImpl(TraceSDPlugin.getResourceImage("node_obj.gif")));
        TraceInteractions.traceCategories[3] = new LifelineCategories();
        traceCategories[3].setName(TraceSDPlugin.getResourceString("STR_AGENT"));
        traceCategories[3].setImage((IImage)new ImageImpl(TraceSDPlugin.getResourceImage("agent_run_obj.gif")));
        TraceInteractions.traceCategories[4] = new LifelineCategories();
        traceCategories[4].setName(TraceSDPlugin.getResourceString("STR_PROCESS"));
        traceCategories[4].setImage((IImage)new ImageImpl(TraceSDPlugin.getResourceImage("process_obj.gif")));
        TraceInteractions.traceCategories[5] = new LifelineCategories();
        traceCategories[5].setName(TraceSDPlugin.getResourceString("STR_THREAD"));
        traceCategories[5].setImage((IImage)new ImageImpl(TraceSDPlugin.getResourceImage("thread_obj.gif")));
        TraceInteractions.traceCategories[6] = new LifelineCategories();
        traceCategories[6].setName(TraceSDPlugin.getResourceString("STR_COLLAPSED_LIFELINE"));
        traceCategories[6].setImage((IImage)new ImageImpl(TraceSDPlugin.getResourceImage("collapsed_obj.gif")));
    }
}

