/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.uml2sd.trace.loaders.internal;

import java.util.ArrayList;
import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.uml2sd.ui.actions.widgets.Criteria;
import org.eclipse.hyades.uml2sd.ui.core.GraphNode;

public class TraceInteractionUpdate {
    private GraphNode visibleGraphNode;
    private boolean pageChanged;
    private boolean maxMessagesByPageChanged;
    private boolean internalMessageFilteringChanged;
    private boolean findRequired;
    private ArrayList findResults;
    private Criteria findCriteria;
    private int findStartingPage;
    private boolean filteringChanged;
    private boolean dateSelectionChanged;
    private double dateToShow;
    private boolean threadSelectionChanged;
    private ArrayList selectedThreadList;
    private boolean horizontalCollapsingChanged;
    private boolean verticalCollapsingChanged;

    public TraceInteractionUpdate() {
    }

    public TraceInteractionUpdate(TraceInteractionUpdate traceInteractionUpdate) {
        this.setSelectedThreadList(traceInteractionUpdate.getSelectedThreadList());
    }

    public boolean needsUpdate() {
        return this.pageChanged || this.internalMessageFilteringChanged || this.findRequired || this.filteringChanged || this.dateSelectionChanged || this.threadSelectionChanged || this.isHorizontalCollapsingChanged() || this.isVerticalCollapsingChanged();
    }

    public void setVisibleGraphNode(GraphNode graphNode) {
        this.visibleGraphNode = graphNode;
    }

    public GraphNode getVisibleGraphNode() {
        return this.visibleGraphNode;
    }

    public void setPageChanged(boolean bl) {
        this.pageChanged = bl;
    }

    public boolean isPageChanged() {
        return this.pageChanged;
    }

    public void setMaxMessagesByPageChanged(boolean bl) {
        this.maxMessagesByPageChanged = bl;
    }

    public boolean isMaxMessagesByPageChanged() {
        return this.maxMessagesByPageChanged;
    }

    public void setInternalMessageFilteringChanged(boolean bl) {
        this.internalMessageFilteringChanged = bl;
    }

    public boolean isInternalMessageFilteringChanged() {
        return this.internalMessageFilteringChanged;
    }

    public void setFindRequired(boolean bl) {
        this.findRequired = bl;
    }

    public boolean isFindRequired() {
        return this.findRequired;
    }

    public void addFindResult(GraphNode graphNode) {
        if (this.findResults == null) {
            this.findResults = new ArrayList();
        }
        this.findResults.add(graphNode);
    }

    public ArrayList getFindResults() {
        return this.findResults;
    }

    public void setFilteringChanged(boolean bl) {
        this.filteringChanged = bl;
    }

    public boolean isFilteringChanged() {
        return this.filteringChanged;
    }

    public void setFindCriteria(Criteria criteria) {
        this.findCriteria = criteria;
    }

    public Criteria getFindCriteria() {
        return this.findCriteria;
    }

    public void setFindStartingPage(int n) {
        this.findStartingPage = n;
    }

    public int getFindStartingPage() {
        return this.findStartingPage;
    }

    public void setDateSelectionChanged(boolean bl) {
        this.dateSelectionChanged = bl;
    }

    public boolean isDateSelectionChanged() {
        return this.dateSelectionChanged;
    }

    public void setDateToShow(double d) {
        this.dateToShow = d;
    }

    public double getDateToShow() {
        return this.dateToShow;
    }

    public void setThreadSelectionChanged(boolean bl) {
        this.threadSelectionChanged = bl;
    }

    public boolean isThreadSelectionChanged() {
        return this.threadSelectionChanged;
    }

    public void addSelectedThread(TRCThread tRCThread) {
        if (this.selectedThreadList == null) {
            this.selectedThreadList = new ArrayList();
        }
        this.selectedThreadList.add(tRCThread);
    }

    public void setSelectedThreadList(ArrayList arrayList) {
        this.selectedThreadList = arrayList;
    }

    public ArrayList getSelectedThreadList() {
        return this.selectedThreadList;
    }

    public void setHorizontalCollapsingChanged(boolean bl) {
        this.horizontalCollapsingChanged = bl;
    }

    public boolean isHorizontalCollapsingChanged() {
        return this.horizontalCollapsingChanged;
    }

    public void setVerticalCollapsingChanged(boolean bl) {
        this.verticalCollapsingChanged = bl;
    }

    public boolean isVerticalCollapsingChanged() {
        return this.verticalCollapsingChanged;
    }
}

