/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.uml2sd.trace.loaders.internal;

import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.loaders.trace.TraceUtils;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.models.trace.TRCFullMethodInvocation;
import org.eclipse.hyades.models.trace.TRCProcess;
import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.uml2sd.trace.TraceSDPlugin;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceProcess;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceProcesses;
import org.eclipse.hyades.uml2sd.ui.actions.widgets.Criteria;

public class TraceInteractionUtils {
    public static void searchTRCProcesses(EObject eObject, TraceProcesses traceProcesses, IProgressMonitor iProgressMonitor) {
        TRCAgent tRCAgent;
        TRCProcess tRCProcess;
        if (iProgressMonitor.isCanceled()) {
            return;
        }
        if (eObject instanceof TRCMonitor) {
            TRCMonitor tRCMonitor = (TRCMonitor)eObject;
            if (tRCMonitor.getNodes() == null || tRCMonitor.getNodes().isEmpty()) {
                return;
            }
            Iterator iterator = tRCMonitor.getNodes().iterator();
            while (iterator.hasNext() && !iProgressMonitor.isCanceled()) {
                TraceInteractionUtils.searchTRCProcesses((EObject)iterator.next(), traceProcesses, iProgressMonitor);
            }
        } else if (eObject instanceof TRCNode) {
            TRCNode tRCNode = (TRCNode)eObject;
            if (tRCNode.getProcessProxies() == null || tRCNode.getProcessProxies().isEmpty()) {
                return;
            }
            Iterator iterator = tRCNode.getProcessProxies().iterator();
            while (iterator.hasNext() && !iProgressMonitor.isCanceled()) {
                TraceInteractionUtils.searchTRCProcesses((EObject)iterator.next(), traceProcesses, iProgressMonitor);
            }
        } else if (eObject instanceof TRCProcessProxy) {
            TRCProcessProxy tRCProcessProxy = (TRCProcessProxy)eObject;
            if (tRCProcessProxy.getAgentProxies() == null || tRCProcessProxy.getAgentProxies().isEmpty()) {
                return;
            }
            Iterator iterator = tRCProcessProxy.getAgentProxies().iterator();
            while (iterator.hasNext() && !iProgressMonitor.isCanceled()) {
                TraceInteractionUtils.searchTRCProcesses((EObject)iterator.next(), traceProcesses, iProgressMonitor);
            }
        } else if (eObject instanceof TRCAgentProxy && ((TRCAgentProxy)eObject).getType().equals("Profiler") && (tRCProcess = TraceUtils.getProcess((TRCAgent)(tRCAgent = ((TRCAgentProxy)eObject).getAgent()))) != null && tRCProcess.getInvocations() != null && tRCProcess.getInvocations().size() > 0) {
            traceProcesses.add(new TraceProcess(tRCProcess));
        }
    }

    public static double getAbsoluteEntryTime(TRCFullMethodInvocation tRCFullMethodInvocation) {
        return TraceInteractionUtils.getAbsoluteEntryTime(tRCFullMethodInvocation.getProcess().getAgent()) + tRCFullMethodInvocation.getEntryTime();
    }

    public static double getAbsoluteEntryTime(TRCAgent tRCAgent) {
        double d = tRCAgent.getAgentProxy().getProcessProxy().getNode().getDeltaTime() / 1000000.0;
        return d + tRCAgent.getStartTime();
    }

    public static double getAbsoluteEntryTime(TRCProcess tRCProcess) {
        return TraceInteractionUtils.getAbsoluteEntryTime(tRCProcess.getAgent()) + tRCProcess.getStartTime();
    }

    public static double getAbsoluteEntryTime(TRCThread tRCThread) {
        return TraceInteractionUtils.getAbsoluteEntryTime(tRCThread.getProcess().getAgent()) + tRCThread.getStartTime();
    }

    public static double getAbsoluteExitTime(TRCFullMethodInvocation tRCFullMethodInvocation) {
        double d = TraceInteractionUtils.getAbsoluteEntryTime(tRCFullMethodInvocation.getProcess().getAgent());
        if (tRCFullMethodInvocation.getExitTime() != 0.0) {
            return d + tRCFullMethodInvocation.getExitTime();
        }
        if (tRCFullMethodInvocation.getInvokes() == null || tRCFullMethodInvocation.getInvokes().size() == 0) {
            return TraceInteractionUtils.getAbsoluteExitTime(tRCFullMethodInvocation.getThread());
        }
        TRCFullMethodInvocation tRCFullMethodInvocation2 = (TRCFullMethodInvocation)tRCFullMethodInvocation.getInvokes().get(tRCFullMethodInvocation.getInvokes().size() - 1);
        if (tRCFullMethodInvocation2.getExitTime() == 0.0) {
            return TraceInteractionUtils.getAbsoluteExitTime(tRCFullMethodInvocation2);
        }
        return d + tRCFullMethodInvocation2.getExitTime();
    }

    public static double getAbsoluteExitTime(TRCAgent tRCAgent) {
        double d = tRCAgent.getAgentProxy().getProcessProxy().getNode().getDeltaTime() / 1000000.0;
        return d + tRCAgent.getStopTime();
    }

    public static double getAbsoluteExitTime(TRCProcess tRCProcess) {
        if (tRCProcess.getStopTime() == 0.0) {
            return TraceInteractionUtils.getAbsoluteExitTime(tRCProcess.getAgent());
        }
        return TraceInteractionUtils.getAbsoluteEntryTime(tRCProcess.getAgent()) + tRCProcess.getStopTime();
    }

    public static double getAbsoluteExitTime(TRCThread tRCThread) {
        if (tRCThread.getStopTime() == 0.0) {
            return TraceInteractionUtils.getAbsoluteExitTime(tRCThread.getProcess().getAgent());
        }
        return TraceInteractionUtils.getAbsoluteEntryTime(tRCThread.getProcess().getAgent()) + tRCThread.getStopTime();
    }

    public static boolean matchCharacter(char c, char c2, boolean bl) {
        return c == c2 || !bl && Character.toLowerCase(c) == Character.toLowerCase(c2);
    }

    private static boolean trailingStars(String string, int n) {
        int n2 = n;
        while (n2 < string.length() && string.charAt(n2) == '*') {
            ++n2;
        }
        return n2 == string.length();
    }

    /*
     * Unable to fully structure code
     */
    public static boolean matchCriteria(String var0, Criteria var1_1) {
        var2_2 = var1_1.getExpression();
        if (TraceSDPlugin.debugMatch) {
            TraceSDPlugin.debugTraceMatch("Comparing " + var0 + " to " + var2_2);
        }
        var3_3 = 0;
        var4_4 = 0;
        while (var3_3 < var0.length() && var4_4 < var2_2.length()) {
            block17: {
                block16: {
                    var5_5 = var0.charAt(var3_3);
                    var6_6 = var2_2.charAt(var4_4);
                    if (TraceSDPlugin.debugMatch) {
                        TraceSDPlugin.debugTraceMatch("s[" + var3_3 + "]=" + var5_5 + " e[" + var4_4 + "]=" + var6_6);
                    }
                    if (var6_6 != '*') break block16;
                    if (var4_4 + 1 == var2_2.length()) {
                        if (TraceSDPlugin.debugMatch) {
                            TraceSDPlugin.debugTraceMatch("#1a true");
                        }
                        return true;
                    }
                    var7_7 = 1;
                    while (var4_4 + var7_7 < var2_2.length()) {
                        if (var2_2.charAt(var4_4 + var7_7) == '*' || var2_2.charAt(var4_4 + var7_7) == '?') {
                            var4_4 += var7_7;
                            var3_3 += var7_7 - 2;
                            break;
                        }
                        if (!TraceInteractionUtils.matchCharacter(var0.charAt(var3_3 + var7_7 - 1), var2_2.charAt(var4_4 + var7_7), var1_1.isCaseSenstiveSelected())) {
                            var3_3 += var7_7 - 1;
                            break;
                        }
                        ++var7_7;
                    }
                    if (var3_3 + var7_7 - 1 == var0.length() && var4_4 + var7_7 == var2_2.length()) {
                        if (TraceSDPlugin.debugMatch) {
                            TraceSDPlugin.debugTraceMatch("#1b true");
                        }
                        return true;
                    }
                    break block17;
                }
                if (var6_6 != '?') ** GOTO lbl40
                if (var3_3 + 1 < var0.length() && var4_4 + 1 < var2_2.length()) {
                    ++var4_4;
                } else {
                    if (TraceSDPlugin.debugMatch) {
                        TraceSDPlugin.debugTraceMatch(var3_3 + 1 == var0.length() && TraceInteractionUtils.trailingStars(var2_2, var4_4 + 1) != false ? "#3 true" : "#3 false");
                    }
                    return var3_3 + 1 == var0.length() && TraceInteractionUtils.trailingStars(var2_2, var4_4 + 1) != false;
lbl40:
                    // 1 sources

                    if (!TraceInteractionUtils.matchCharacter(var5_5, var6_6, var1_1.isCaseSenstiveSelected())) {
                        if (TraceSDPlugin.debugMatch) {
                            TraceSDPlugin.debugTraceMatch("#4 false");
                        }
                        return false;
                    }
                    ++var4_4;
                }
            }
            ++var3_3;
        }
        if (TraceSDPlugin.debugMatch) {
            TraceSDPlugin.debugTraceMatch(var3_3 == var0.length() && (var4_4 == var2_2.length() || var4_4 + 1 == var2_2.length() && (var2_2.charAt(var4_4) == '*' || var2_2.charAt(var4_4) == '?')) ? "#5 true" : "#5 false");
        }
        return var3_3 == var0.length() && TraceInteractionUtils.trailingStars(var2_2, var4_4) != false;
    }
}

