/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.sample.report.svg;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionEvent;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.models.common.testprofile.TPFVerdict;
import org.eclipse.hyades.models.common.util.ExecutionUtil;
import org.eclipse.hyades.ui.internal.util.XMLUtil;
import org.eclipse.hyades.ui.report.IReportGenerator;
import org.eclipse.hyades.ui.sample.HyadesSamplePlugin;
import org.eclipse.hyades.ui.sample.report.svg.DayHelper;
import org.eclipse.hyades.ui.sample.svg.generator.GraphicDocumentProperties;
import org.eclipse.hyades.ui.sample.svg.generator.SVGLineChart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SVGReport
implements IReportGenerator {
    private String usedClasspath = null;

    public void setUsedClasspath(String string) {
        this.usedClasspath = string;
    }

    public String getReportFileExtension(ISelection iSelection) {
        return "html";
    }

    public boolean isAvailable(ISelection iSelection) {
        if (iSelection instanceof IStructuredSelection) {
            int n = 0;
            Iterator iterator = ((IStructuredSelection)iSelection).iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (e instanceof TPFTestSuite) {
                    ++n;
                }
                if (n < 2) continue;
                return true;
            }
        }
        return false;
    }

    public InputStream generate(IFile iFile, ISelection iSelection) throws Exception {
        int n;
        if (iSelection == null) {
            return null;
        }
        Map map = ExecutionUtil.findExecutionResults((List)((IStructuredSelection)iSelection).toList());
        DayHelper.GraphDay.reset();
        ArrayList arrayList = this.analyseTestcaseInstances(map);
        if (arrayList.isEmpty()) {
            return null;
        }
        DayHelper.GraphDay[] graphDayArray = this.createGraphDays(arrayList);
        int n2 = this.loadExpectedExecutionValues(iFile.getParent(), graphDayArray);
        if (n2 < (n = this.countTestcaseWithData(map))) {
            n2 = n;
        }
        return this.generate(iFile, graphDayArray, n2);
    }

    protected ArrayList analyseTestcaseInstances(Map map) {
        Hashtable<String, DayHelper.DataDay> hashtable = new Hashtable<String, DayHelper.DataDay>();
        if (map != null) {
            Iterator iterator = map.values().iterator();
            while (iterator.hasNext()) {
                List list = (List)iterator.next();
                Hashtable hashtable2 = this.getLastExecutionByDay(list);
                Iterator iterator2 = hashtable2.keySet().iterator();
                while (iterator2.hasNext()) {
                    String string = (String)iterator2.next();
                    TPFExecutionResult tPFExecutionResult = (TPFExecutionResult)hashtable2.get(string);
                    DayHelper.DataDay dataDay = (DayHelper.DataDay)hashtable.get(string);
                    if (dataDay == null) {
                        dataDay = new DayHelper.DataDay(string);
                        hashtable.put(string, dataDay);
                    }
                    dataDay.addVerdict((TPFTestSuite)tPFExecutionResult.getTest(), tPFExecutionResult.getVerdict());
                }
            }
        }
        return new ArrayList(hashtable.values());
    }

    protected String getDayTime(long l) {
        return new SimpleDateFormat("yyyyMMddHHmmss").format(new Date(l));
    }

    protected Hashtable getLastExecutionByDay(List list) {
        Object object;
        Object object2;
        TPFExecutionResult tPFExecutionResult;
        Object object3;
        Hashtable<String, TPFExecutionResult> hashtable = new Hashtable<String, TPFExecutionResult>();
        Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
        if (list != null) {
            object3 = list.iterator();
            while (object3.hasNext()) {
                String string;
                tPFExecutionResult = (TPFExecutionResult)object3.next();
                if (tPFExecutionResult == null || (object2 = tPFExecutionResult.getExecutionHistory()) == null || (object = object2.getExecutionEvents()) == null || object.isEmpty() || (string = this.getDayTime(((TPFExecutionEvent)object.get(0)).getTimestamp())) == null) continue;
                String string2 = string.substring(0, "yyyyMMdd".length());
                String string3 = string.substring("yyyyMMdd".length());
                hashtable.put(string, tPFExecutionResult);
                String string4 = (String)hashtable2.get(string2);
                if (string4 != null && string3.compareTo(string4) <= 0) continue;
                hashtable2.put(string2, string3);
            }
        }
        object3 = new Hashtable();
        tPFExecutionResult = hashtable2.keySet().iterator();
        while (tPFExecutionResult.hasNext()) {
            object2 = (String)tPFExecutionResult.next();
            object = (String)hashtable2.get(object2);
            ((Hashtable)object3).put(object2, hashtable.get((String)object2 + (String)object));
        }
        return object3;
    }

    protected DayHelper.GraphDay[] createGraphDays(ArrayList arrayList) {
        Object[] objectArray = arrayList.toArray(new DayHelper.DataDay[arrayList.size()]);
        Arrays.sort(objectArray);
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        Hashtable<TPFTestSuite, TPFVerdict> hashtable = new Hashtable<TPFTestSuite, TPFVerdict>();
        int n = 0;
        int n2 = objectArray.length;
        while (n < n2) {
            Object object;
            Object object2;
            Iterator iterator = ((DayHelper.DataDay)objectArray[n]).testcaseIterator();
            while (iterator.hasNext()) {
                object2 = (TPFTestSuite)iterator.next();
                hashtable.put((TPFTestSuite)object2, ((DayHelper.DataDay)objectArray[n]).getVerdict((TPFTestSuite)object2));
            }
            object2 = new DayHelper.GraphDay(((DayHelper.DataDay)objectArray[n]).getDay());
            arrayList2.add(object2);
            Iterator iterator2 = hashtable.values().iterator();
            while (iterator2.hasNext()) {
                object = (TPFVerdict)iterator2.next();
                ((DayHelper.GraphDay)object2).addStatistic(-104, 1);
                if (object == TPFVerdict.ERROR_LITERAL) {
                    ((DayHelper.GraphDay)object2).addStatistic(-103, 1);
                    continue;
                }
                if (object == TPFVerdict.PASS_LITERAL) {
                    ((DayHelper.GraphDay)object2).addStatistic(-102, 1);
                    continue;
                }
                if (object == TPFVerdict.FAIL_LITERAL) {
                    ((DayHelper.GraphDay)object2).addStatistic(-101, 1);
                    continue;
                }
                if (object != TPFVerdict.INCONCLUSIVE_LITERAL) continue;
                ((DayHelper.GraphDay)object2).addStatistic(-100, 1);
            }
            if (n < n2 - 1) {
                object = ((DayHelper.GraphDay)((DayHelper.GraphDay)object2).clone()).incrementDay();
                while (((DayHelper.GraphDay)object).getDay().compareTo(((DayHelper.DataDay)objectArray[n + 1]).getDay()) < 0) {
                    arrayList2.add(((DayHelper.GraphDay)object).clone());
                    ((DayHelper.GraphDay)object).incrementDay();
                }
            }
            ++n;
        }
        return arrayList2.toArray(new DayHelper.GraphDay[arrayList2.size()]);
    }

    protected int loadExpectedExecutionValues(IContainer iContainer, DayHelper.GraphDay[] graphDayArray) {
        IFile iFile = iContainer.getFile((IPath)new Path("expected_execution.xml"));
        if (iFile == null || !iFile.exists()) {
            return 0;
        }
        Element element = null;
        Document document = XMLUtil.getXmlDom((String)iFile.getLocation().makeAbsolute().toOSString());
        NodeList nodeList = document.getElementsByTagName("ComponentTest_ExpectedExecution");
        if (nodeList.getLength() != 1 || !(nodeList.item(0) instanceof Element)) {
            return 0;
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        element = (Element)nodeList.item(0);
        nodeList = element.getElementsByTagName("day");
        int n8 = 0;
        int n9 = nodeList.getLength();
        while (n8 < n9) {
            Element element2;
            int n10;
            Node node = nodeList.item(n8);
            if (node instanceof Element && (n10 = XMLUtil.getIntValue((Element)(element2 = (Element)node), (String)"index")) > 0) {
                if (--n10 >= graphDayArray.length) break;
                if (n10 < graphDayArray.length) {
                    int n11 = n7;
                    while (n11 < n10) {
                        graphDayArray[n11].addStatistic(-109, n2);
                        graphDayArray[n11].addStatistic(-108, n3);
                        graphDayArray[n11].addStatistic(-107, n4);
                        graphDayArray[n11].addStatistic(-106, n5);
                        graphDayArray[n11].addStatistic(-105, n6);
                        ++n11;
                    }
                    n2 = XMLUtil.getIntValue((Element)element2, (String)"attempt");
                    if (n < n2) {
                        n = n2;
                    }
                    n4 = XMLUtil.getIntValue((Element)element2, (String)"error");
                    if (n < n3) {
                        n = n3;
                    }
                    if (n < (n4 = XMLUtil.getIntValue((Element)element2, (String)"pass"))) {
                        n = n4;
                    }
                    if (n < (n5 = XMLUtil.getIntValue((Element)element2, (String)"fail"))) {
                        n = n5;
                    }
                    if (n < (n6 = XMLUtil.getIntValue((Element)element2, (String)"inconclusive"))) {
                        n = n6;
                    }
                    n7 = n10;
                }
            }
            ++n8;
        }
        int n12 = n7;
        while (n12 < graphDayArray.length) {
            graphDayArray[n12].addStatistic(-109, n2);
            graphDayArray[n12].addStatistic(-108, n3);
            graphDayArray[n12].addStatistic(-107, n4);
            graphDayArray[n12].addStatistic(-106, n5);
            graphDayArray[n12].addStatistic(-105, n6);
            ++n12;
        }
        return n;
    }

    protected int countTestcaseWithData(Map map) {
        HashSet<TPFTest> hashSet = new HashSet<TPFTest>();
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            Iterator iterator2 = ((List)iterator.next()).iterator();
            while (iterator2.hasNext()) {
                TPFExecutionResult tPFExecutionResult = (TPFExecutionResult)iterator2.next();
                TPFTest tPFTest = tPFExecutionResult.getTest();
                if (!(tPFTest instanceof TPFTestSuite)) continue;
                hashSet.add(tPFTest);
            }
        }
        return hashSet.size();
    }

    protected InputStream generate(IFile iFile, DayHelper.GraphDay[] graphDayArray, int n) throws Exception {
        String string = "750";
        String string2 = "500";
        ArrayList arrayList = new ArrayList();
        Document document = this.generateDataDocument(graphDayArray, n, arrayList);
        if (document == null) {
            return null;
        }
        GraphicDocumentProperties graphicDocumentProperties = new GraphicDocumentProperties();
        graphicDocumentProperties.setDataDocument(document);
        graphicDocumentProperties.setGraphicWidth(string);
        graphicDocumentProperties.setGraphicHeight(string2);
        String string3 = this.getSVGPreferencePageDirectory();
        if (string3 != null) {
            graphicDocumentProperties.setResourcesFolder("file://" + string3.replace('\\', '/') + "/");
        }
        graphicDocumentProperties.addGraphicColorPalette("Test Status", arrayList.toArray(new String[arrayList.size()]));
        graphicDocumentProperties.setGraphicColorPaletteName("Test Status");
        SVGLineChart sVGLineChart = new SVGLineChart();
        Document document2 = sVGLineChart.generateGraphicDocument(graphicDocumentProperties);
        String string4 = this.createFile(iFile, "svg", sVGLineChart.serializeGeneratedDocumentToString(document2)).getName();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<html>\n").append("<head>\n").append("<title>").append(this.getUserText("chart.Title")).append("</title>").append("</head>\n");
        stringBuffer.append("<body>\n").append("<object type=\"image/svg+xml\" data=\"");
        stringBuffer.append(string4).append("\" ").append("width=\"").append(string).append("\" ");
        stringBuffer.append("height=\"").append(string2).append("\" ");
        stringBuffer.append("name=\"mySvgDocument\"");
        stringBuffer.append("/>\n");
        stringBuffer.append("</body>").append("</html>");
        return new ByteArrayInputStream(stringBuffer.toString().getBytes());
    }

    protected Document generateDataDocument(DayHelper.GraphDay[] graphDayArray, int n, ArrayList arrayList) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        Element element = document.createElement("configuration");
        document.appendChild(element);
        element.setAttribute("title", this.getUserText("chart.Title"));
        element.setAttribute("legendtitle", this.getUserText("chart.Legend"));
        element.setAttribute("timestampPrefix", this.getUserText("chart.timestampPrefix"));
        Element element2 = document.createElement("dataUpdate");
        element.appendChild(element2);
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss");
        element2.setAttribute("timestamp", simpleDateFormat.format(date));
        int n2 = 0;
        if (this.addLineData(document, element2, n2, this.getUserText("chart.expectedAttempt"), -109, graphDayArray)) {
            arrayList.add("#D3D3D3");
            ++n2;
        }
        if (this.addLineData(document, element2, n2, this.getUserText("chart.expectedPass"), -107, graphDayArray)) {
            arrayList.add("#ADFF2F");
            ++n2;
        }
        if (this.addLineData(document, element2, n2, this.getUserText("chart.expectedFail"), -106, graphDayArray)) {
            arrayList.add("#DB7093");
            ++n2;
        }
        if (this.addLineData(document, element2, n2, this.getUserText("chart.expectedError"), -108, graphDayArray)) {
            arrayList.add("#DB9993");
            ++n2;
        }
        if (this.addLineData(document, element2, n2, this.getUserText("chart.expectedInconclusive"), -105, graphDayArray)) {
            arrayList.add("#FAFAD2");
            ++n2;
        }
        if (this.addLineData(document, element2, n2, this.getUserText("chart.attempt"), -104, graphDayArray)) {
            arrayList.add("#000000");
            ++n2;
        }
        if (this.addLineData(document, element2, n2, this.getUserText("chart.pass"), -102, graphDayArray)) {
            arrayList.add("#008000");
            ++n2;
        }
        if (this.addLineData(document, element2, n2, this.getUserText("chart.fail"), -101, graphDayArray)) {
            arrayList.add("#FF0000");
            ++n2;
        }
        if (this.addLineData(document, element2, n2, this.getUserText("chart.error"), -103, graphDayArray)) {
            arrayList.add("#FFAA00");
            ++n2;
        }
        if (this.addLineData(document, element2, n2, this.getUserText("chart.inconclusive"), -100, graphDayArray)) {
            arrayList.add("#FFFF00");
            ++n2;
        }
        this.createXData(document, element2, graphDayArray);
        this.createYData(document, element2, n);
        return document;
    }

    protected boolean addLineData(Document document, Element element, int n, String string, int n2, DayHelper.GraphDay[] graphDayArray) {
        if (!DayHelper.GraphDay.hasStatistic(n2)) {
            return false;
        }
        Element element2 = document.createElement("dataSet");
        element.appendChild(element2);
        element2.setAttribute("label", string);
        element2.setAttribute("position", new Integer(n).toString());
        element2.setAttribute("dataRange1Ref", "day");
        element2.setAttribute("dataRange2Ref", "count");
        Element element3 = document.createElement("dataPoint");
        element2.appendChild(element3);
        element3.setAttribute("value1", "0");
        element3.setAttribute("value2", "0");
        int n3 = 0;
        while (n3 < graphDayArray.length) {
            element3 = document.createElement("dataPoint");
            element2.appendChild(element3);
            element3.setAttribute("value1", Integer.toString(n3 + 1));
            element3.setAttribute("value2", Integer.toString(graphDayArray[n3].getStatistic(n2)));
            ++n3;
        }
        return true;
    }

    protected void createXData(Document document, Element element, DayHelper.GraphDay[] graphDayArray) {
        Element element2 = document.createElement("dataRange");
        element.appendChild(element2);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getUserText("chart.Xtitle"));
        stringBuffer.append(" ").append(graphDayArray[0].getFormattedDay());
        element2.setAttribute("id", "day");
        element2.setAttribute("location", "S");
        element2.setAttribute("label", stringBuffer.toString());
        Element element3 = document.createElement("segmentMarker");
        element2.appendChild(element3);
        element3.setAttribute("value", "0");
        element3.setAttribute("label", "0");
        int n = 0;
        while (n < graphDayArray.length) {
            element3 = document.createElement("segmentMarker");
            element2.appendChild(element3);
            String string = graphDayArray[n].getDayOfMonth();
            element3.setAttribute("value", Integer.toString(n + 1));
            element3.setAttribute("label", string);
            ++n;
        }
    }

    protected void createYData(Document document, Element element, int n) {
        Element element2 = document.createElement("dataRange");
        element.appendChild(element2);
        element2.setAttribute("id", "count");
        element2.setAttribute("location", "W");
        element2.setAttribute("label", this.getUserText("chart.Ytitle"));
        int n2 = 0;
        while (n2 <= n) {
            Element element3 = document.createElement("segmentMarker");
            element2.appendChild(element3);
            element3.setAttribute("value", Integer.toString(n2));
            element3.setAttribute("label", Integer.toString(n2));
            ++n2;
        }
    }

    protected String createStyleSheet(IFile iFile) throws CoreException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("rect.outline{stroke-width:0.75pt; stroke:#666666; fill:#ffffff; }\n");
        stringBuffer.append("polyline.keyline{stroke-width:0.75pt; stroke:#666666;}\n");
        stringBuffer.append("text.title{font-family:Arial; font-style:bold; font-size:11; text-anchor:left;}\n");
        stringBuffer.append("text.xtitle{font-family:Arial; font-style:regular; font-size:10; text-anchor:middle;}\n");
        stringBuffer.append("text.ytitle{font-family:Arial; font-style:regular; font-size:10; text-anchor:start; writing-mode:tb;}\n");
        stringBuffer.append("text.axislabel{font-family:Arial; font-style:regular; font-size:8; text-anchor:middle;}\n");
        stringBuffer.append("text.ydata{font-family:Arial; font-style:regular; font-size:8; text-anchor:middle;}\n");
        stringBuffer.append("text.legendtitle{font-family:Arial; font-style:regular; font-size:9; text-anchor:start;}\n");
        stringBuffer.append("text.legendlabel{font-family:Arial; font-style:regular; font-size:8; text-anchor:start;}\n");
        stringBuffer.append("polyline.grid{stroke-width:0.75pt; stroke:#000000;}\n");
        stringBuffer.append("polyline.gridline{stroke-width:0.75pt; stroke:#cccccc;}\n");
        stringBuffer.append("polyline.griddashline{stroke-width:0.75pt; stroke:#cccccc; stroke-dasharray:2; fill:none;}\n");
        stringBuffer.append("polyline.dataset0{stroke-width:0.75pt; stroke:#003399;}\n");
        stringBuffer.append("polyline.dataset1{stroke-width:0.75pt; stroke:#0066CC;}\n");
        stringBuffer.append("polyline.dataset2{stroke-width:0.75pt; stroke:#3399FF;}\n");
        stringBuffer.append("polyline.dataset3{stroke-width:0.75pt; stroke:#66CCFF;}\n");
        stringBuffer.append(".shape0{stroke:black; fill:#003399;}\n");
        stringBuffer.append(".shape1{stroke:black; fill:#0066CC;}\n");
        stringBuffer.append(".shape2{stroke:black; fill:#3399FF;}\n");
        stringBuffer.append(".shape3{stroke:black; fill:#66CCFF;}\n");
        return this.createFile(iFile, "css", stringBuffer.toString()).getName();
    }

    protected String getSVGPreferencePageDirectory() {
        File file = this.getPluginDirectory();
        if (file != null) {
            file = new File(file, "preferences");
        } else if (this.usedClasspath != null) {
            String string = this.usedClasspath;
            int n = string.indexOf(File.pathSeparator);
            if (n >= 0) {
                string = string.substring(0, n);
            }
            if ((n = string.lastIndexOf(File.separator)) >= 0) {
                string = string.substring(0, n);
            }
            file = new File(string + "/preferences");
        }
        if (file != null && file.exists() && file.isDirectory()) {
            return file.getAbsolutePath();
        }
        return null;
    }

    protected File getPluginDirectory() {
        File file = null;
        try {
            URL uRL = new URL(Platform.getPlugin((String)HyadesSamplePlugin.getID()).getDescriptor().getInstallURL(), "plugin.xml");
            File file2 = new File(Platform.asLocalURL((URL)uRL).getFile()).getAbsoluteFile();
            if (file2.exists()) {
                file = file2.getParentFile();
            }
        }
        catch (Throwable throwable) {}
        return file;
    }

    protected IFile createFile(IFile iFile, String string, String string2) throws CoreException {
        IPath iPath = iFile.getProjectRelativePath().removeFileExtension().addFileExtension(string);
        IFile iFile2 = iFile.getProject().getFile(iPath);
        if (iFile2.exists()) {
            iFile2.delete(true, true, null);
        }
        iFile2.create((InputStream)new ByteArrayInputStream(string2.getBytes()), true, null);
        return iFile2;
    }

    protected String getUserText(String string) {
        if ("chart.Title".equals(string)) {
            return "Test progress over time in days";
        }
        if ("chart.Legend".equals(string)) {
            return "Status";
        }
        if ("chart.timestampPrefix".equals(string)) {
            return "Last update:";
        }
        if ("chart.Xtitle".equals(string)) {
            return "Date starting at:";
        }
        if ("chart.Ytitle".equals(string)) {
            return "Tests";
        }
        if ("chart.attempt".equals(string)) {
            return "Attempt";
        }
        if ("chart.error".equals(string)) {
            return "Error";
        }
        if ("chart.pass".equals(string)) {
            return "Pass";
        }
        if ("chart.fail".equals(string)) {
            return "Fail";
        }
        if ("chart.inconclusive".equals(string)) {
            return "Inconclusive";
        }
        if ("chart.expectedAttempt".equals(string)) {
            return "Expected Attempt";
        }
        if ("chart.expectedError".equals(string)) {
            return "Expected Error";
        }
        if ("chart.expectedPass".equals(string)) {
            return "Expected Pass";
        }
        if ("chart.expectedFail".equals(string)) {
            return "Expected Fail";
        }
        if ("chart.expectedInconclusive".equals(string)) {
            return "Expected Inconclusive";
        }
        return string;
    }
}

