/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.sample.svg.generator;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import javax.xml.transform.TransformerException;
import org.eclipse.hyades.logging.core.XmlUtility;
import org.eclipse.hyades.ui.sample.svg.generator.DataInputProcessingException;
import org.eclipse.hyades.ui.sample.svg.generator.GraphicDocumentProperties;
import org.eclipse.hyades.ui.sample.svg.generator.IGraphicDocumentGenerator;
import org.w3c.dom.Document;

public abstract class GraphicDocumentGenerator
implements IGraphicDocumentGenerator,
Serializable {
    protected String graphicType;

    public String getGraphicType() {
        return this.graphicType;
    }

    public Document generateGraphicDocument(Document document) throws DataInputProcessingException {
        GraphicDocumentProperties graphicDocumentProperties = new GraphicDocumentProperties();
        graphicDocumentProperties.setDataDocument(document);
        return this.generateGraphicDocument(graphicDocumentProperties);
    }

    public String generateAndSerializeToString(GraphicDocumentProperties graphicDocumentProperties) throws DataInputProcessingException, IOException {
        Document document = this.generateGraphicDocument(graphicDocumentProperties);
        return this.serializeGeneratedDocumentToString(document);
    }

    public boolean generateAndSerializeToFile(GraphicDocumentProperties graphicDocumentProperties, String string) throws DataInputProcessingException, IOException {
        Document document = this.generateGraphicDocument(graphicDocumentProperties);
        if (document != null) {
            return this.serializeGeneratedDocumentToFile(document, string);
        }
        return false;
    }

    public boolean serializeGeneratedDocumentToFile(Document document, String string) throws IOException {
        if (document != null) {
            try {
                XmlUtility.serialize((Document)document, (File)new File(string));
                return true;
            }
            catch (TransformerException transformerException) {
            }
        }
        return false;
    }

    public String serializeGeneratedDocumentToString(Document document) throws IOException {
        if (document != null) {
            try {
                return XmlUtility.serialize((Document)document);
            }
            catch (TransformerException transformerException) {
            }
        }
        return null;
    }

    public static byte[] serializeGeneratedDocumentToStream(Document document) {
        if (document != null) {
            try {
                return XmlUtility.serializeAsByteArray((Document)document);
            }
            catch (TransformerException transformerException) {
            }
        }
        return null;
    }
}

