/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.sample.svg.generator;

import java.io.Serializable;
import java.util.Date;
import org.eclipse.hyades.ui.sample.svg.generator.DataInputProcessingException;
import org.eclipse.hyades.ui.sample.svg.generator.DataPoint;
import org.eclipse.hyades.ui.sample.svg.generator.DataRange;
import org.eclipse.hyades.ui.sample.svg.generator.DataSet;
import org.eclipse.hyades.ui.sample.svg.generator.GraphicAttributes;
import org.eclipse.hyades.ui.sample.svg.generator.GraphicDocumentProperties;
import org.eclipse.hyades.ui.sample.svg.generator.IDataInputProcessingExceptionCodes;
import org.eclipse.hyades.ui.sample.svg.generator.IGraphicDocumentStyle;
import org.eclipse.hyades.ui.sample.svg.generator.SVGXYChart;
import org.eclipse.hyades.ui.sample.svg.generator.SegmentMarker;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SVGBarChart
extends SVGXYChart
implements IGraphicDocumentStyle,
IDataInputProcessingExceptionCodes,
Serializable {
    public SVGBarChart() {
        this.graphicType = "bar";
    }

    public Document generateGraphicDocument(GraphicDocumentProperties graphicDocumentProperties) throws DataInputProcessingException {
        GraphicAttributes graphicAttributes = this.createGraphicAttributes(graphicDocumentProperties);
        Document document = graphicAttributes.getDataDocument();
        String string = null;
        int n = 60;
        int n2 = 50;
        DataRange dataRange = null;
        DataRange dataRange2 = null;
        SegmentMarker[] segmentMarkerArray = null;
        SegmentMarker[] segmentMarkerArray2 = null;
        try {
            dataRange = this.dataRetriever.getDataRange(document, "S");
        }
        catch (DataInputProcessingException dataInputProcessingException) {
            dataInputProcessingException.setWidgetType(this.getGraphicType());
            throw dataInputProcessingException;
        }
        try {
            dataRange2 = this.dataRetriever.getDataRange(document, "W");
        }
        catch (DataInputProcessingException dataInputProcessingException) {
            dataInputProcessingException.setWidgetType(this.getGraphicType());
            throw dataInputProcessingException;
        }
        if (dataRange == null || dataRange2 == null) {
            throw new DataInputProcessingException("", 126, "dataRange", this.getGraphicType());
        }
        if (dataRange.getType() != 1 || dataRange2.getType() != 0) {
            throw new DataInputProcessingException("", 129, "dataRange", this.getGraphicType());
        }
        segmentMarkerArray = dataRange.getSegmentMarkers();
        segmentMarkerArray2 = dataRange2.getSegmentMarkers();
        if (segmentMarkerArray2 != null && segmentMarkerArray2.length > 0) {
            string = segmentMarkerArray2[segmentMarkerArray2.length - 1].getValueString();
        }
        DataSet dataSet = this.dataRetriever.getDatasetWithPosition(document, "0");
        int n3 = (int)((double)graphicAttributes.getGraphicWidth() - (double)n * 2.25);
        int n4 = this.getNumberOfAxisLabels(graphicAttributes, n3, dataRange);
        int n5 = (int)((double)graphicAttributes.getGraphicHeight() - (double)n2 * 2.5 - (double)(n4 * 10));
        Document document2 = this.createSvgDocument(document.getImplementation(), Short.toString(graphicAttributes.getGraphicWidth()), Short.toString(graphicAttributes.getGraphicHeight()));
        Element element = document2.getDocumentElement();
        this.addDefinitions(document2, graphicAttributes, dataSet.getDataPoints().length);
        this.registerEventHandler(document2.getDocumentElement(), "onload", "init(evt)");
        this.addJavaScriptFunctions(document2, graphicAttributes, dataSet.getDataPoints().length, n, n2, n3, n5);
        if (!graphicAttributes.isOutlineSuppressed()) {
            this.addOutline(document2, graphicAttributes);
        }
        if (!graphicAttributes.isTimestampSuppressed()) {
            try {
                String string2 = this.dataRetriever.getTimestamp(document);
                Date date = GraphicAttributes.parseISO8601Date(string2);
                this.addTimeStamp(document2, graphicAttributes, date == null ? string2 : graphicAttributes.formatDate(date));
            }
            catch (DataInputProcessingException dataInputProcessingException) {
                dataInputProcessingException.setWidgetType(this.graphicType);
                throw dataInputProcessingException;
            }
        }
        if (!graphicAttributes.isTitlebarSuppressed()) {
            this.addTitleBar(document2, graphicAttributes);
        } else {
            n2 = super.resetGridOffsetForCenter(graphicAttributes.getGraphicHeight(), n5, 3.0);
        }
        if (!graphicAttributes.isUserPreferencesSuppressed() && graphicAttributes.getSvgFormatOnly()) {
            this.addPreferenceIcon(document2, graphicAttributes);
        }
        n = super.resetGridOffsetForCenter(graphicAttributes.getGraphicWidth(), n3, 2.0);
        if (string != null && string.length() > 2) {
            n = (int)((double)n + (double)(string.length() - 2) * 7.5);
        }
        this.evenlyDistributeSegmentMarkers(dataRange);
        this.addGrid(document2, element, n3, n5, n, n2, dataRange, dataRange2);
        this.addAxisLabels(document2, graphicAttributes, element, n3, n5, n, n2, dataRange, dataRange2);
        this.addTitles(document2, graphicAttributes, element, n3, n5, n, n2, dataRange, dataRange2, n4, string);
        this.addDataSet(document2, graphicAttributes, element, n3, n5, n, n2, dataRange, dataRange2, dataSet);
        return document2;
    }

    private void addDefinitions(Document document, GraphicAttributes graphicAttributes, int n) {
        Element element = super.addDefinitions(document, graphicAttributes);
        this.addDefaultInternalStylesheet(document, graphicAttributes, element, n);
    }

    private void addDefaultInternalStylesheet(Document document, GraphicAttributes graphicAttributes, Element element, int n) {
        StringBuffer stringBuffer = new StringBuffer(" .st1{fill-rule:nonzero;clip-rule:nonzero;stroke:#000000;stroke-miterlimit:4;} .outline{stroke-width:0.75pt; stroke:#666666; fill:#ffffff;} .keyline{stroke-width:0.75pt; stroke:#666666;} .graphTitle {font-weight:bold; font-style:normal; font-size:11pt; fill:#000000; stroke-width:0.75pt;} .labelsValues {font-weight:normal; font-style:normal; font-size:10pt; fill:#000000;} .dataValues {font-weight:normal; font-style:normal; font-size:8pt; fill:#000000;} .timeStamp {font-weight:normal; font-style:normal; font-size:8pt; fill:#000000; text-anchor:end; opacity:0.5} .legendTitle {font-weight:normal; font-style:normal; font-size:10pt; fill:#000000; text-anchor:start; opacity:0.6} .legendData {font-weight:normal; font-style:normal; font-size:9pt; text-anchor:start; fill:#000000;} .anchorAtEnd {text-anchor: end;} .anchorAtStart {text-anchor: start;} .anchorAtMiddle {text-anchor: middle;}");
        stringBuffer.append(" ");
        stringBuffer.append(" .grid{stroke-width:0.75pt; stroke:#000000;} .gridline{stroke-width:0.75pt; stroke:#cccccc;} .griddashline{stroke-width:0.75pt; stroke:#cccccc; stroke-dasharray:2; fill:none;} .axisLines{fill:none;} .axisTicks{fill:none;} .solidLine{fill:none;stroke:#CCCCCC;stroke-width:1;} .dashLine{fill:none;stroke:#CCCCCC;stroke-width:1;stroke-dasharray:2;} .catOutline{fill:none;} .catColor{fill:#003399;stroke:none;} .exactValuesBox{fill:#FFFFCC;stroke:#999999;stroke-width:1;} .xyTitleLabels {font-weight:normal; font-style:normal; font-size:10pt; fill:#000000; opacity:0.6}");
        String[] stringArray = (String[])graphicAttributes.getGraphicColorPalette().get(graphicAttributes.getGraphicColorPaletteName());
        int n2 = stringArray.length;
        int n3 = 0;
        int n4 = 0;
        while (n3 < n) {
            n4 = (n3 + 1) % n2;
            n4 = n4 == 0 ? n2 - 1 : n4 - 1;
            stringBuffer.append(" .dataset" + n3 + "{stroke-width:0.75pt; stroke:" + stringArray[n4] + ";}");
            stringBuffer.append(" .shape" + n3 + "{stroke:none; fill:" + stringArray[n4] + ";}");
            ++n3;
        }
        CDATASection cDATASection = document.createCDATASection(stringBuffer.toString());
        Element element2 = document.createElement("style");
        element2.setAttribute("id", "defaultStyleRules");
        element2.setAttribute("type", "text/css");
        element2.appendChild(cDATASection);
        element.appendChild(element2);
    }

    private void addDataSet(Document document, GraphicAttributes graphicAttributes, Element element, int n, int n2, int n3, int n4, DataRange dataRange, DataRange dataRange2, DataSet dataSet) throws DataInputProcessingException {
        int n5 = dataRange.getSegmentMarkers().length;
        double d = n5 > 0 ? (double)(n / n5 / 2) : 0.0;
        Element element2 = document.createElement("g");
        String string = "dataValues anchorAtMiddle";
        element2.setAttribute("id", "exactValues");
        element2.setAttribute("class", string);
        element2.setAttribute("transform", "translate(" + n3 + "," + n4 + ")");
        element2.setAttribute("visibility", "hidden");
        element2.setAttribute("onclick", "toggleVisibility(\"exactValues\")");
        element.appendChild(element2);
        Element element3 = document.createElement("g");
        element3.setAttribute("id", "dataset");
        element3.setAttribute("onclick", "toggleVisibility(\"exactValues\")");
        element3.setAttribute("transform", "translate(" + n3 + "," + n4 + ")");
        element.appendChild(element3);
        this.addBars(document, graphicAttributes, element3, element2, n, n2, dataRange, dataRange2, d, dataSet);
    }

    private void addBars(Document document, GraphicAttributes graphicAttributes, Element element, Element element2, int n, int n2, DataRange dataRange, DataRange dataRange2, double d, DataSet dataSet) throws DataInputProcessingException {
        SegmentMarker[] segmentMarkerArray = dataRange.getSegmentMarkers();
        double d2 = dataRange2.getMaxValue();
        double d3 = dataRange2.getMinValue();
        int n3 = 0;
        while (n3 < segmentMarkerArray.length) {
            SegmentMarker segmentMarker = segmentMarkerArray[n3];
            DataPoint dataPoint = dataSet.findDataPoint(segmentMarker.getValue());
            if (dataPoint != null && dataPoint.getType() != 1) {
                double d4 = segmentMarker.getPosition() * (double)n - d / 2.0;
                double d5 = dataPoint.getValue2();
                if (d5 < d3) {
                    d5 = d3;
                }
                if (d5 > d2) {
                    d5 = d2;
                }
                double d6 = (double)n2 * (d2 - d5) / (d2 - d3);
                Element element3 = document.createElement("rect");
                element3.setAttribute("id", "dataColour" + n3);
                element3.setAttribute("class", "shape" + n3);
                element3.setAttribute("x", Double.toString(d4));
                element3.setAttribute("y", Double.toString(d6));
                element3.setAttribute("width", Double.toString(d));
                element3.setAttribute("height", Double.toString((double)n2 - d6 - 0.9));
                element3.setAttribute("stroke-width", "0.75pt");
                element3.setAttribute("stroke", "#666666");
                element.appendChild(element3);
                double d7 = d4 + d / 2.0;
                double d8 = d6 - 5.0;
                String string = dataPoint.getLabel();
                if (string == null) {
                    string = graphicAttributes.formatNumber(dataPoint.getValue2());
                }
                this.addExactValue(document, graphicAttributes, element2, d7, d8, string);
            }
            ++n3;
        }
    }

    private void addExactValue(Document document, GraphicAttributes graphicAttributes, Element element, double d, double d2, String string) {
        Element element2 = document.createElement("g");
        element2.setAttribute("id", "text1");
        this.addLabel(document, graphicAttributes, element2, string, "dataValues anchorAtMiddle", d, d2, 0);
        element.appendChild(element2);
    }

    private GraphicAttributes createGraphicAttributes(GraphicDocumentProperties graphicDocumentProperties) throws DataInputProcessingException {
        GraphicAttributes graphicAttributes = new GraphicAttributes();
        graphicAttributes.setPreferencesPage("prefs_bar.htm");
        graphicAttributes.setPreferencesPageWidth("430");
        graphicAttributes.setPreferencesPageHeight("435");
        graphicAttributes.setConfigDocument(graphicDocumentProperties.getConfigDocument());
        graphicAttributes.setDataDocument(graphicDocumentProperties.getDataDocument());
        this.getConfigAttributes(graphicAttributes);
        graphicAttributes.setAttributesFrom(graphicDocumentProperties);
        return graphicAttributes;
    }
}

