/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.dialog;

import java.util.Iterator;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.dialog.EObjectResourceContentProvider;
import org.eclipse.hyades.test.ui.dialog.EObjectResourceLabelProvider;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;

public class EObjectResourceSelectionDialog
extends Dialog
implements SelectionListener,
IDoubleClickListener {
    private String[] fileExtensions;
    private String title;
    private Button filterButton;
    private TreeViewer hostViewer;
    private EObjectResourceContentProvider contentProvider;
    private Image fileImage;
    private EObject[] selectedEObjects;

    public EObjectResourceSelectionDialog(Shell shell, String string, String[] stringArray, Image image) {
        super(shell);
        this.title = string;
        this.fileExtensions = stringArray;
        this.fileImage = image;
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        GridData gridData = GridDataUtil.createFill();
        gridData.heightHint = 300;
        gridData.widthHint = 250;
        composite2.setLayoutData((Object)gridData);
        this.filterButton = new Button(composite2, 32);
        this.filterButton.setText(TestUIPlugin.getString("SHOW_FOLDERS"));
        this.filterButton.addSelectionListener((SelectionListener)this);
        this.createViewer(composite2);
        this.hostViewer.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        ((Tree)this.hostViewer.getControl()).addSelectionListener((SelectionListener)this);
        this.hostViewer.expandToLevel(2);
        return composite2;
    }

    protected StructuredViewer createViewer(Composite composite) {
        Tree tree = new Tree(composite, 67586);
        GridData gridData = GridDataUtil.createFill();
        gridData.heightHint = 150;
        tree.setLayoutData((Object)gridData);
        this.contentProvider = new EObjectResourceContentProvider(this.fileExtensions);
        this.hostViewer = new TreeViewer(tree);
        this.hostViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.hostViewer.setLabelProvider((IBaseLabelProvider)new EObjectResourceLabelProvider(true, this.fileImage));
        this.hostViewer.addDoubleClickListener((IDoubleClickListener)this);
        this.contentProvider.setFilter(2);
        ViewerSorter viewerSorter = new ViewerSorter(){

            public void sort(Viewer viewer, Object[] objectArray) {
                if (objectArray.length > 0) {
                    super.sort(viewer, objectArray);
                }
            }

            public int category(Object object) {
                if (object instanceof IResource) {
                    return 0;
                }
                return 10;
            }
        };
        this.hostViewer.setSorter(viewerSorter);
        return this.hostViewer;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        if (selectionEvent.widget == this.filterButton) {
            this.contentProvider.setFilter(this.filterButton.getSelection() ? 4 : 2);
            ISelection iSelection = this.hostViewer.getSelection();
            this.hostViewer.refresh();
            if (!iSelection.isEmpty()) {
                this.hostViewer.setSelection(iSelection, true);
            }
        }
        if (selectionEvent.widget == this.hostViewer.getControl()) {
            this.setSelection();
        }
    }

    private void setSelection() {
        ISelection iSelection = this.hostViewer.getSelection();
        if (iSelection != null && !iSelection.isEmpty()) {
            Iterator iterator = ((IStructuredSelection)iSelection).iterator();
            Vector<EObject> vector = new Vector<EObject>();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof EObject)) continue;
                vector.add((EObject)e);
            }
            this.selectedEObjects = new EObject[vector.size()];
            int n = 0;
            while (n < vector.size()) {
                this.selectedEObjects[n] = (EObject)vector.get(n);
                ++n;
            }
        }
    }

    public EObject[] getSelectedObjects() {
        if (this.selectedEObjects == null) {
            this.selectedEObjects = new EObject[0];
        }
        return this.selectedEObjects;
    }

    public IFile[] getSelectedFiles() {
        if (this.selectedEObjects == null) {
            return new IFile[0];
        }
        IFile[] iFileArray = new IFile[this.selectedEObjects.length];
        int n = 0;
        while (n < this.selectedEObjects.length) {
            iFileArray[n] = EMFUtil.getWorkspaceFile(this.selectedEObjects[n]);
            ++n;
        }
        return iFileArray;
    }

    public void doubleClick(DoubleClickEvent doubleClickEvent) {
        if (doubleClickEvent.getViewer() == this.hostViewer) {
            this.setSelection();
            this.buttonPressed(0);
        }
    }
}

