/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.editor.form.util;

import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.models.common.testprofile.Common_TestprofileFactory;
import org.eclipse.hyades.models.common.testprofile.TPFTestObjective;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.editor.extension.BaseEditorExtension;
import org.eclipse.hyades.test.ui.editor.form.util.WidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.form.base.FormSection;
import org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class TestObjectiveSection
extends FormSection
implements ModifyListener {
    protected WidgetFactory widgetFactory;
    protected BaseEditorExtension baseEditorExtension;
    protected String testObjectiveReference;
    protected StyledText testObjectiveDescription;
    protected TPFTestSuite testSuite;
    private String[] types = new String[]{TestUIPlugin.getString("L_STRING_TYPE"), TestUIPlugin.getString("L_FILE_TYPE")};
    protected Composite typeComposite;
    protected CCombo type;

    public TestObjectiveSection(BaseEditorExtension baseEditorExtension, WidgetFactory widgetFactory) {
        this.setWidgetFactory(widgetFactory);
        this.setBaseEditorExtension(baseEditorExtension);
    }

    public Composite createClient(Composite composite, FormWidgetFactory formWidgetFactory) {
        Composite composite2 = this.getWidgetFactory().createComposite(composite);
        composite2.setLayout((Layout)new GridLayout(3, false));
        composite.setLayoutData((Object)GridDataUtil.createHorizontalFill());
        this.getWidgetFactory().createLabel(composite2, TestUIPlugin.getString("L_TYPE"));
        this.type = this.getWidgetFactory().createCCombo(composite2, 4);
        this.type.setLayoutData((Object)GridDataUtil.createHorizontalFill());
        int n = 0;
        while (n < this.types.length) {
            this.type.add(this.types[n]);
            ++n;
        }
        this.type.setEditable(false);
        this.typeComposite = this.getWidgetFactory().createComposite(composite2);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        gridData.heightHint = 100;
        gridData.grabExcessHorizontalSpace = true;
        this.typeComposite.setLayoutData((Object)gridData);
        this.type.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Control[] controlArray = TestObjectiveSection.this.typeComposite.getChildren();
                int n = 0;
                while (n < controlArray.length) {
                    controlArray[n].dispose();
                    ++n;
                }
                TestObjectiveSection.this.createObjectiveControl(TestObjectiveSection.this.typeComposite, TestObjectiveSection.this.type.getSelectionIndex(), "");
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
        this.getWidgetFactory().paintBordersFor(composite2);
        return composite2;
    }

    protected void createObjectiveControl(Composite composite, int n, String string) {
        this.setTestObjectiveReference(string);
        Control[] controlArray = composite.getChildren();
        int n2 = 0;
        while (n2 < controlArray.length) {
            controlArray[n2].dispose();
            ++n2;
        }
        switch (n) {
            case 0: {
                this.createStringObjective(composite);
                break;
            }
            case 1: {
                this.createFileObjective(composite);
            }
        }
        if (this.testObjectiveDescription != null) {
            this.testObjectiveDescription.addModifyListener((ModifyListener)this);
        }
    }

    protected void createStringObjective(Composite composite) {
        composite.setLayout((Layout)new GridLayout());
        this.testObjectiveDescription = this.getWidgetFactory().createStyledText(composite, 66114);
        GridData gridData = GridDataUtil.createHorizontalFill();
        gridData.heightHint = 4 * this.testObjectiveDescription.getLineHeight();
        this.testObjectiveDescription.setLayoutData((Object)gridData);
        this.testObjectiveDescription.setEditable(true);
        this.testObjectiveDescription.setText(this.getTestObjectiveReference());
        composite.redraw();
        composite.layout();
        this.getWidgetFactory().paintBordersFor(composite);
    }

    protected void createFileObjective(Composite composite) {
        composite.setLayout((Layout)new GridLayout());
        this.testObjectiveDescription = this.getWidgetFactory().createStyledText(composite, 65540);
        this.testObjectiveDescription.setLayoutData((Object)GridDataUtil.createHorizontalFill());
        this.testObjectiveDescription.setEditable(true);
        this.testObjectiveDescription.setText(this.getTestObjectiveReference());
        Button button = this.getWidgetFactory().createButton(composite, TestUIPlugin.getString("BROWSE"), 8);
        button.setLayoutData((Object)new GridData(128));
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                FileDialog fileDialog = new FileDialog(new Shell());
                fileDialog.open();
                Path path = new Path(fileDialog.getFilterPath());
                TestObjectiveSection.this.testObjectiveDescription.setText(path.addTrailingSeparator().toOSString() + fileDialog.getFileName());
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
        composite.redraw();
        composite.layout();
        this.getWidgetFactory().paintBordersFor(composite);
    }

    public void setInput(Object object) {
        if (this.testObjectiveDescription != null) {
            this.testObjectiveDescription.removeModifyListener((ModifyListener)this);
        }
        if (object instanceof TPFTestSuite) {
            TPFTestObjective tPFTestObjective;
            this.setTestSuite((TPFTestSuite)object);
            EList eList = this.getTestSuite().getTestObjectives();
            if (eList != null && eList.size() > 0 && eList.get(0) instanceof TPFTestObjective && (tPFTestObjective = (TPFTestObjective)eList.get(0)) != null) {
                int n = this.getIndexFromType(tPFTestObjective.getType());
                String string = tPFTestObjective.getReference();
                if (n > -1 && string != null) {
                    this.setTestObjectiveReference(string);
                    this.createObjectiveControl(this.typeComposite, n, this.getTestObjectiveReference());
                    this.type.select(n);
                }
            }
        }
        if (this.testObjectiveDescription != null) {
            this.testObjectiveDescription.addModifyListener((ModifyListener)this);
        }
    }

    protected int getIndexFromType(String string) {
        int n = 0;
        while (n < this.types.length) {
            if (this.types[n].equals(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    protected WidgetFactory getWidgetFactory() {
        return this.widgetFactory;
    }

    private void setWidgetFactory(WidgetFactory widgetFactory) {
        this.widgetFactory = widgetFactory;
    }

    public BaseEditorExtension getBaseEditorExtension() {
        return this.baseEditorExtension;
    }

    private void setBaseEditorExtension(BaseEditorExtension baseEditorExtension) {
        this.baseEditorExtension = baseEditorExtension;
    }

    public String getTestObjectiveReference() {
        return this.testObjectiveReference;
    }

    public void setTestObjectiveReference(String string) {
        this.testObjectiveReference = string;
    }

    public void modifyText(ModifyEvent modifyEvent) {
        if (modifyEvent.widget == this.testObjectiveDescription) {
            EList eList = this.getTestSuite().getTestObjectives();
            TPFTestObjective tPFTestObjective = null;
            if (eList != null && eList.size() == 1 && eList.get(0) instanceof TPFTestObjective) {
                tPFTestObjective = (TPFTestObjective)eList.get(0);
            }
            if (tPFTestObjective != null) {
                tPFTestObjective.setType(this.type.getText());
                tPFTestObjective.setReference(this.testObjectiveDescription.getText());
            } else {
                tPFTestObjective = Common_TestprofileFactory.eINSTANCE.createTPFTestObjective();
                tPFTestObjective.setType(this.type.getText());
                tPFTestObjective.setReference(this.testObjectiveDescription.getText());
                this.getTestSuite().getTestObjectives().add((Object)tPFTestObjective);
            }
            this.getBaseEditorExtension().markDirty();
        }
    }

    public TPFTestSuite getTestSuite() {
        return this.testSuite;
    }

    public void setTestSuite(TPFTestSuite tPFTestSuite) {
        this.testSuite = tPFTestSuite;
    }
}

