/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.editor.form.util;

import org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.form.base.SelectableFormLabel;
import org.eclipse.hyades.ui.util.IDisposable;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;

public class WidgetFactory
extends FormWidgetFactory
implements IDisposable {
    private VisibilityHandler visibilityHandler = new VisibilityHandler();
    private BorderPainter borderPainter = new BorderPainter();

    public WidgetFactory() {
        this(Display.getCurrent());
    }

    public WidgetFactory(Display display) {
        super(display);
    }

    public void dispose() {
        this.visibilityHandler = null;
        this.borderPainter = null;
        super.dispose();
    }

    protected VisibilityHandler getVisibilityHandler() {
        return this.visibilityHandler;
    }

    protected BorderPainter getBorderPainter() {
        return this.borderPainter;
    }

    public StyledText createStyledText(Composite composite, int n) {
        StyledText styledText = new StyledText(composite, n);
        styledText.setBackground(this.getBackgroundColor());
        styledText.setForeground(this.getForegroundColor());
        styledText.addFocusListener((FocusListener)this.getVisibilityHandler());
        return styledText;
    }

    public CCombo createCCombo(Composite composite, int n) {
        CCombo cCombo = new CCombo(composite, n);
        cCombo.setBackground(this.getBackgroundColor());
        cCombo.setForeground(this.getForegroundColor());
        cCombo.addFocusListener((FocusListener)this.getVisibilityHandler());
        return cCombo;
    }

    public void paintBordersFor(Composite composite) {
        composite.addPaintListener((PaintListener)this.getBorderPainter());
    }

    protected static class VisibilityHandler
    extends FocusAdapter {
        protected VisibilityHandler() {
        }

        public void focusGained(FocusEvent focusEvent) {
            Widget widget = focusEvent.widget;
            if (widget instanceof Control) {
                FormWidgetFactory.ensureVisible((Control)widget);
            }
        }
    }

    protected class BorderPainter
    implements PaintListener {
        protected BorderPainter() {
        }

        public void paintControl(PaintEvent paintEvent) {
            Composite composite = (Composite)paintEvent.widget;
            Control[] controlArray = composite.getChildren();
            int n = 0;
            while (n < controlArray.length) {
                block12: {
                    GC gC;
                    Rectangle rectangle;
                    boolean bl;
                    Control control;
                    block13: {
                        control = controlArray[n];
                        bl = false;
                        if (!control.getEnabled() && !(control instanceof CCombo) || control instanceof SelectableFormLabel) break block12;
                        Object object = control.getData("FormWidgetFactory.drawBorder");
                        if (object == null) break block13;
                        if (object.equals(Boolean.FALSE)) break block12;
                        if (object.equals("treeBorder")) {
                            bl = true;
                        }
                    }
                    if (!bl && (control instanceof Text || control instanceof Canvas || control instanceof CCombo)) {
                        rectangle = control.getBounds();
                        gC = paintEvent.gc;
                        gC.setForeground(control.getBackground());
                        gC.drawRectangle(rectangle.x - 1, rectangle.y - 1, rectangle.width + 1, rectangle.height + 1);
                        gC.setForeground(WidgetFactory.this.getForegroundColor());
                        if (control instanceof CCombo) {
                            gC.drawRectangle(rectangle.x - 1, rectangle.y - 1, rectangle.width + 1, rectangle.height + 1);
                        } else if (control instanceof StyledText) {
                            gC.drawRectangle(rectangle.x - 2, rectangle.y - 2, rectangle.width + 2, rectangle.height + 3);
                        } else {
                            gC.drawRectangle(rectangle.x - 1, rectangle.y - 2, rectangle.width + 1, rectangle.height + 3);
                        }
                    } else if (bl || control instanceof Table || control instanceof Tree || control instanceof TableTree) {
                        rectangle = control.getBounds();
                        gC = paintEvent.gc;
                        gC.setForeground(WidgetFactory.this.getBorderColor());
                        gC.drawRectangle(rectangle.x - 1, rectangle.y - 1, rectangle.width + 2, rectangle.height + 2);
                    }
                }
                ++n;
            }
        }
    }
}

