/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.action;

import java.io.File;
import org.eclipse.core.runtime.Path;
import org.eclipse.hyades.models.common.datapool.DPLDatapool;
import org.eclipse.hyades.models.common.datapool.impl.Common_DatapoolFactoryImpl;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.editor.form.util.ExtensibleEObjectTableSection;
import org.eclipse.hyades.test.ui.internal.action.AddTestSuiteChildAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class AddDatapoolAction
extends AddTestSuiteChildAction {
    private TPFTestSuite testSuite;
    private ExtensibleEObjectTableSection table;

    public AddDatapoolAction() {
        super(TestUIPlugin.getString("label.Add"));
    }

    protected boolean updateSelection(IStructuredSelection iStructuredSelection) {
        if (iStructuredSelection == null) {
            return false;
        }
        TPFTestSuite tPFTestSuite = this.getTestSuite(iStructuredSelection);
        if (tPFTestSuite != null) {
            this.testSuite = tPFTestSuite;
        }
        return this.testSuite != null;
    }

    public void run() {
        if (this.testSuite == null) {
            return;
        }
        Shell shell = Display.getCurrent().getActiveShell();
        FileDialog fileDialog = new FileDialog(shell);
        fileDialog.setFilterExtensions(new String[]{"*.datapool", "*.*"});
        fileDialog.open();
        Path path = new Path(fileDialog.getFilterPath() + '/' + fileDialog.getFileName());
        File file = path.toFile();
        if (file == null || !file.exists()) {
            return;
        }
        Common_DatapoolFactoryImpl common_DatapoolFactoryImpl = new Common_DatapoolFactoryImpl();
        DPLDatapool dPLDatapool = (DPLDatapool)common_DatapoolFactoryImpl.loadForEdit(file, false);
        if (this.testSuite.getDatapools() == null) {
            return;
        }
        if (!this.testSuite.getDatapools().contains((Object)dPLDatapool)) {
            this.testSuite.getDatapools().add((Object)dPLDatapool);
        }
        this.table.initialize(this.testSuite);
    }

    public void setTable(ExtensibleEObjectTableSection extensibleEObjectTableSection) {
        this.table = extensibleEObjectTableSection;
    }
}

