/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.dialog;

import java.util.Vector;
import org.eclipse.hyades.models.common.configuration.CFGComparableProperty;
import org.eclipse.hyades.models.common.configuration.Common_ConfigurationFactory;
import org.eclipse.hyades.models.common.configuration.util.Common_ConfigurationCategoryUtil;
import org.eclipse.hyades.models.common.configuration.util.ICategory;
import org.eclipse.hyades.models.common.configuration.util.ICategoryEnumeration;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ComparablePropertyInputDialog
extends Dialog
implements SelectionListener,
ModifyListener {
    private String title;
    private CCombo[] comboBoxes = new CCombo[3];
    private Button okButton;
    private CFGComparableProperty property;
    private ICategory[] categories;
    private String[] categoryDisplayNames;
    private String[] operators;

    public ComparablePropertyInputDialog(Shell shell, String string) {
        super(shell);
        this.title = string;
    }

    private ICategory[] getAllCategories() {
        if (this.categories == null) {
            this.categories = Common_ConfigurationCategoryUtil.getInstance().getCategories();
        }
        return this.categories;
    }

    private String[] getCategoryDisplayNames() {
        if (this.categoryDisplayNames == null) {
            ICategory[] iCategoryArray = this.getAllCategories();
            this.categoryDisplayNames = new String[iCategoryArray.length];
            int n = 0;
            while (n < iCategoryArray.length) {
                this.categoryDisplayNames[n] = iCategoryArray[n].getDisplayName();
                ++n;
            }
        }
        return this.categoryDisplayNames;
    }

    private String[] getOperators() {
        if (this.operators == null) {
            this.operators = new String[]{"=", "!=", ">", "<", ">=", "<="};
        }
        return this.operators;
    }

    private String[] getEnumerationDisplayNames(ICategory iCategory) {
        int n;
        Object object;
        ICategoryEnumeration[] iCategoryEnumerationArray = Common_ConfigurationCategoryUtil.getInstance().getCategoryEnumeration(iCategory);
        if (iCategoryEnumerationArray == null) {
            return new String[0];
        }
        Vector<String> vector = new Vector<String>(200);
        int n2 = 0;
        while (n2 < iCategoryEnumerationArray.length) {
            object = iCategoryEnumerationArray[n2].getIEnumerationValues();
            n = 0;
            while (n < object.size()) {
                vector.add((String)object.get(n));
                ++n;
            }
            ++n2;
        }
        object = new String[vector.size()];
        n = 0;
        while (n < vector.size()) {
            object[n] = (String)vector.get(n);
            ++n;
        }
        return object;
    }

    protected Control createDialogArea(Composite composite) {
        GridData gridData;
        Composite composite2 = (Composite)super.createDialogArea(composite);
        GridLayout gridLayout = new GridLayout(3, false);
        composite2.setLayout((Layout)gridLayout);
        Label[] labelArray = new Label[3];
        int n = 0;
        while (n < 3) {
            labelArray[n] = new Label(composite2, 64);
            switch (n) {
                case 0: {
                    labelArray[n].setText(TestUIPlugin.getString("DLG_PROPERTY_NAME"));
                    break;
                }
                case 1: {
                    labelArray[n].setText(TestUIPlugin.getString("DLG_OPERATOR"));
                    break;
                }
                case 2: {
                    labelArray[n].setText(TestUIPlugin.getString("DLG_PROPERTY_VALUE"));
                    break;
                }
            }
            gridData = new GridData(36);
            labelArray[n].setLayoutData((Object)gridData);
            labelArray[n].setFont(composite.getFont());
            ++n;
        }
        this.comboBoxes[0] = new CCombo(composite2, 2048);
        this.comboBoxes[0].setItems(this.getCategoryDisplayNames());
        if (this.property != null && this.property.getName() != null) {
            this.comboBoxes[0].setText(this.property.getName());
        }
        gridData = new GridData(256);
        gridData.widthHint = 150;
        this.comboBoxes[0].setLayoutData((Object)gridData);
        this.comboBoxes[0].setSize(100, this.comboBoxes[0].getSize().y);
        this.comboBoxes[0].addSelectionListener((SelectionListener)this);
        this.comboBoxes[0].addModifyListener((ModifyListener)this);
        this.comboBoxes[1] = new CCombo(composite2, 2056);
        this.comboBoxes[1].setItems(this.getOperators());
        if (this.property != null && this.property.getOperator() != null) {
            this.comboBoxes[1].setText(this.property.getOperator());
        } else {
            this.comboBoxes[1].select(0);
        }
        gridData = new GridData();
        gridData.widthHint = 50;
        this.comboBoxes[1].setLayoutData((Object)gridData);
        this.comboBoxes[1].addModifyListener((ModifyListener)this);
        this.comboBoxes[2] = new CCombo(composite2, 2048);
        if (this.property != null && this.property.getValue() != null) {
            this.comboBoxes[2].setText(this.property.getValue());
        }
        gridData = new GridData(256);
        gridData.widthHint = 150;
        this.comboBoxes[2].setLayoutData((Object)gridData);
        this.comboBoxes[2].setSize(100, this.comboBoxes[2].getSize().y);
        this.comboBoxes[2].addModifyListener((ModifyListener)this);
        return composite2;
    }

    protected void buttonPressed(int n) {
        if (n == 0) {
            String string = this.comboBoxes[0].getText();
            int n2 = this.comboBoxes[0].indexOf(string);
            if (n2 > -1) {
                string = this.getAllCategories()[n2].getName();
            }
            String string2 = this.comboBoxes[1].getText();
            String string3 = this.comboBoxes[2].getText();
            if (this.property == null) {
                this.property = Common_ConfigurationFactory.eINSTANCE.createCFGComparableProperty();
            }
            this.property.setName(string);
            if (string2 != null && string2.length() > 0) {
                this.property.setOperator(string2);
            }
            if (string3 != null && string3.length() > 0) {
                this.property.setValue(string3);
            }
        } else {
            this.property = null;
        }
        super.buttonPressed(n);
    }

    protected void createButtonsForButtonBar(Composite composite) {
        this.okButton = this.createButton(composite, 0, IDialogConstants.OK_LABEL, true);
        this.okButton.setEnabled(false);
        this.createButton(composite, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    protected void validateInput() {
        String string = this.comboBoxes[0].getText();
        String string2 = this.comboBoxes[1].getText();
        String string3 = this.comboBoxes[2].getText();
        if (string == null || string.length() < 1 || string2 == null || string2.length() < 1 || string3 == null || string3.length() < 1) {
            this.okButton.setEnabled(false);
        } else {
            this.okButton.setEnabled(true);
        }
    }

    public CFGComparableProperty getProperty() {
        return this.property;
    }

    public void setProperty(CFGComparableProperty cFGComparableProperty) {
        this.property = cFGComparableProperty;
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        if (selectionEvent.widget == this.comboBoxes[0]) {
            int n = this.comboBoxes[0].getSelectionIndex();
            if (n < 0) {
                return;
            }
            ICategory iCategory = this.getAllCategories()[n];
            String[] stringArray = this.getEnumerationDisplayNames(iCategory);
            this.comboBoxes[2].setItems(stringArray);
        }
    }

    public void modifyText(ModifyEvent modifyEvent) {
        this.validateInput();
    }
}

