/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.editor;

import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.hyades.test.ui.util.RCPFileEditorInput;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.extension.IAssociationDescriptor;
import org.eclipse.hyades.ui.internal.editor.HyadesEditorPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PartInitException;

public abstract class BaseEditorPart
extends HyadesEditorPart {
    private ResourceSet resourceSet;
    private Class editoObjectClass;

    public BaseEditorPart(Class clazz) {
        this.editoObjectClass = clazz;
    }

    public void dispose() {
        if (this.resourceSet != null) {
            EMFUtil.removeAdapters((Iterator)this.resourceSet.getAllContents());
            this.resourceSet.eAdapters().clear();
            this.resourceSet.getResources().clear();
            this.resourceSet = null;
        }
        super.dispose();
    }

    protected ResourceSet getResourceSet() {
        return this.resourceSet;
    }

    protected IAssociationDescriptor identifyEditorDescriptor(IEditorInput iEditorInput) throws PartInitException {
        if (!(iEditorInput instanceof IFileEditorInput)) {
            throw new PartInitException(HyadesUIPlugin.getString((String)"_ERROR_EDT_INPUT"));
        }
        IAssociationDescriptor iAssociationDescriptor = null;
        if (iEditorInput instanceof IFileEditorInput) {
            EObject eObject = null;
            eObject = iEditorInput instanceof RCPFileEditorInput ? this.getFileContent(((RCPFileEditorInput)iEditorInput).getIOFile()) : this.getFileContent(((IFileEditorInput)iEditorInput).getFile());
            if (eObject == null) {
                throw new PartInitException(HyadesUIPlugin.getString((String)"_ERROR_EDT_INPUT"));
            }
            this.setEditorObject(eObject);
            iAssociationDescriptor = this.identifyEditorDescriptor(eObject);
        }
        return iAssociationDescriptor;
    }

    protected abstract IAssociationDescriptor identifyEditorDescriptor(EObject var1);

    protected EObject getFileContent(IFile iFile) {
        this.resourceSet = new ResourceSetImpl();
        AdapterImpl adapterImpl = new AdapterImpl(){

            public void notifyChanged(Notification notification) {
                switch (notification.getEventType()) {
                    case 3: {
                        if (!(notification.getNewValue() instanceof Resource)) break;
                        ((Resource)notification.getNewValue()).setTrackingModification(true);
                        break;
                    }
                    case 5: {
                        Collection collection = (Collection)notification.getNewValue();
                        Iterator iterator = collection.iterator();
                        while (iterator.hasNext()) {
                            Object e = iterator.next();
                            if (!(e instanceof Resource)) continue;
                            ((Resource)e).setTrackingModification(true);
                        }
                        break;
                    }
                }
            }
        };
        this.resourceSet.eAdapters().add((Object)adapterImpl);
        EObject[] eObjectArray = EMFUtil.load(this.resourceSet, iFile);
        if (eObjectArray.length == 1 && this.editoObjectClass.isInstance(eObjectArray[0])) {
            return eObjectArray[0];
        }
        return null;
    }

    protected EObject getFileContent(File file) {
        this.resourceSet = new ResourceSetImpl();
        AdapterImpl adapterImpl = new AdapterImpl(){

            public void notifyChanged(Notification notification) {
                switch (notification.getEventType()) {
                    case 3: {
                        if (!(notification.getNewValue() instanceof Resource)) break;
                        ((Resource)notification.getNewValue()).setTrackingModification(true);
                        break;
                    }
                    case 5: {
                        Collection collection = (Collection)notification.getNewValue();
                        Iterator iterator = collection.iterator();
                        while (iterator.hasNext()) {
                            Object e = iterator.next();
                            if (!(e instanceof Resource)) continue;
                            ((Resource)e).setTrackingModification(true);
                        }
                        break;
                    }
                }
            }
        };
        this.resourceSet.eAdapters().add((Object)adapterImpl);
        EObject[] eObjectArray = EMFUtil.load(this.resourceSet, URI.createFileURI((String)file.getAbsolutePath()));
        if (eObjectArray.length == 1 && this.editoObjectClass.isInstance(eObjectArray[0])) {
            return eObjectArray[0];
        }
        return null;
    }

    public void setSelection(ISelection iSelection) {
        if (!(iSelection = this.adjustSelection(iSelection)).isEmpty()) {
            super.setSelection(iSelection);
        }
    }

    public ISelection adjustSelection(ISelection iSelection) {
        if (iSelection instanceof IStructuredSelection) {
            Object[] objectArray = ((IStructuredSelection)iSelection).toArray();
            int n = 0;
            int n2 = objectArray.length;
            while (n < n2) {
                EObject eObject = null;
                if (objectArray[n] instanceof EObject) {
                    eObject = EMFUtil.getEObject(this.getResourceSet(), (EObject)objectArray[n], false);
                } else if (objectArray[n] instanceof Resource) {
                    eObject = this.getResourceSet().getResource(((Resource)objectArray[n]).getURI(), false);
                }
                if (eObject == null) {
                    return StructuredSelection.EMPTY;
                }
                objectArray[n] = eObject;
                ++n;
            }
            iSelection = new StructuredSelection(objectArray);
        }
        return iSelection;
    }
}

