/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.editor.extension;

import java.util.Vector;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.hyades.models.common.configuration.CFGArtifact;
import org.eclipse.hyades.models.common.configuration.CFGLocation;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.editor.form.util.WidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.extension.ConfigurableObjectEditorExtension;
import org.eclipse.hyades.test.ui.internal.editor.form.ArtifactLocationMapForm;
import org.eclipse.hyades.test.ui.internal.editor.form.ConfigurableObjectOverviewForm;
import org.eclipse.hyades.test.ui.internal.editor.form.DeploymentForm;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;

public class DeploymentEditorExtension
extends ConfigurableObjectEditorExtension {
    public static final String EXTENSION_ID = "org.eclipse.hyades.test.ui.editor.extension.Deployment";
    public static final String EDITOR_OBJECT_TYPE = "org.eclipse.hyades.models.common.testprofile.TPFDeployment";
    private static final int PAGE_PAIRS = 1;
    private ArtifactLocationMapForm mapForm;

    public void dispose() {
        if (this.mapForm != null) {
            this.mapForm.dispose();
            this.mapForm = null;
        }
        super.dispose();
    }

    protected IConfigurationElement[] collectRegisteredExtensionElements() {
        IConfigurationElement[] iConfigurationElementArray = super.collectRegisteredExtensionElements();
        Vector<IConfigurationElement> vector = new Vector<IConfigurationElement>();
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            if (iConfigurationElementArray[n].getAttribute("appliesTo").equals(EDITOR_OBJECT_TYPE)) {
                vector.add(iConfigurationElementArray[n]);
            }
            ++n;
        }
        if (iConfigurationElementArray.length == vector.size()) {
            return iConfigurationElementArray;
        }
        IConfigurationElement[] iConfigurationElementArray2 = new IConfigurationElement[vector.size()];
        int n2 = 0;
        while (n2 < vector.size()) {
            iConfigurationElementArray2[n2] = (IConfigurationElement)vector.get(n2);
            ++n2;
        }
        return iConfigurationElementArray2;
    }

    protected ConfigurableObjectOverviewForm createOverviewPage(WidgetFactory widgetFactory) {
        DeploymentForm deploymentForm = new DeploymentForm(this, widgetFactory);
        deploymentForm.setLocationPageIndex(1);
        return deploymentForm;
    }

    protected void createOtherStaticPages(WidgetFactory widgetFactory) {
        this.mapForm = new ArtifactLocationMapForm(this, widgetFactory);
        this.getHyadesEditorPart().addPage(this.mapForm.createControl());
        this.getHyadesEditorPart().setPageText(1, TestUIPlugin.getString("W_PAIRS"));
    }

    public int addExtensionPage(IConfigurationElement iConfigurationElement) {
        if (!iConfigurationElement.getAttribute("appliesTo").equals(EDITOR_OBJECT_TYPE)) {
            return -1;
        }
        return super.addExtensionPage(iConfigurationElement);
    }

    public void refreshContent(Object object) {
        super.refreshContent(object);
        this.mapForm.load();
        this.mapForm.updateTitle();
    }

    public IStructuredSelection getSelection() {
        if (1 == this.getHyadesEditorPart().getActivePage()) {
            return (IStructuredSelection)this.mapForm.getSelection();
        }
        return super.getSelection();
    }

    public boolean pageActivated(int n) {
        if (n == 1) {
            return this.mapForm.activated();
        }
        return super.pageActivated(n);
    }

    public void setSelection(IStructuredSelection iStructuredSelection) {
        super.setSelection(iStructuredSelection);
        if (iStructuredSelection.size() == 1) {
            Object object = iStructuredSelection.getFirstElement();
            if (object instanceof TPFDeployment) {
                this.getHyadesEditorPart().setActivePage(0);
                this.getOverviewForm().selectReveal((ISelection)iStructuredSelection);
            } else if (object instanceof CFGLocation) {
                this.getHyadesEditorPart().setActivePage(1);
                this.mapForm.selectReveal((ISelection)iStructuredSelection);
            } else if (object instanceof CFGArtifact) {
                this.getHyadesEditorPart().setActivePage(1);
                this.mapForm.selectReveal((ISelection)iStructuredSelection);
            }
        }
    }
}

