/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.editor.form;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.hyades.models.common.configuration.CFGComparableProperty;
import org.eclipse.hyades.models.common.configuration.CFGPropertyGroup;
import org.eclipse.hyades.models.common.configuration.Common_ConfigurationPackage;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.action.model.MoveFeatureChildrenDownAction;
import org.eclipse.hyades.test.ui.action.model.MoveFeatureChildrenUpAction;
import org.eclipse.hyades.test.ui.action.model.RemoveFeatureChildrenAction;
import org.eclipse.hyades.test.ui.editor.extension.BaseEditorExtension;
import org.eclipse.hyades.test.ui.editor.form.util.EObjectTableContentProvider;
import org.eclipse.hyades.test.ui.editor.form.util.EditorForm;
import org.eclipse.hyades.test.ui.editor.form.util.EditorSection;
import org.eclipse.hyades.test.ui.editor.form.util.ExtensibleEObjectTableSection;
import org.eclipse.hyades.test.ui.editor.form.util.ExtensibleEObjectTreeSection;
import org.eclipse.hyades.test.ui.editor.form.util.WidgetFactory;
import org.eclipse.hyades.test.ui.internal.action.AddConfigPropertyAction;
import org.eclipse.hyades.test.ui.internal.dialog.ComparablePropertyInputDialog;
import org.eclipse.hyades.test.ui.internal.editor.extension.ConfigurableObjectEditorExtension;
import org.eclipse.hyades.test.ui.internal.editor.form.IPropertyGroupForm;
import org.eclipse.hyades.test.ui.internal.editor.form.util.EObjectTreeSection;
import org.eclipse.hyades.test.ui.internal.model.ui.ChildrenSelectionAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.actions.ActionFactory;

public class PropertyGroupForm
extends EditorForm
implements IPropertyGroupForm {
    private IConfigurationElement extensionInstance;
    private String name;
    private String description;
    private CFGPropertyGroup propertyGroup;
    private EditorSection mainSection;
    private String editorType = "";
    public static final String CONTROL_TYPE_CUSTOM = "custom";
    public static final String CONTROL_TYPE_TABLE = "table";
    public static final String CONTROL_TYPE_TREE = "tree";
    public static final String CONTROL_TYPE_FIELDS = "fields";
    private String controlType = "table";
    private AddConfigPropertyAction addAction;
    private RemoveFeatureChildrenAction removeAction;

    public void init(CFGPropertyGroup cFGPropertyGroup, BaseEditorExtension baseEditorExtension, WidgetFactory widgetFactory) {
        super.init(baseEditorExtension, widgetFactory);
        this.propertyGroup = cFGPropertyGroup;
        if (cFGPropertyGroup.eContainer() != null) {
            this.editorType = cFGPropertyGroup.eContainer().eClass().getInstanceClassName();
        }
    }

    public void setExtension(IConfigurationElement iConfigurationElement) {
        block2: {
            this.extensionInstance = iConfigurationElement;
            this.name = iConfigurationElement.getAttribute("name");
            this.description = iConfigurationElement.getAttribute("description");
            this.controlType = iConfigurationElement.getAttribute("controlType");
            this.editorType = iConfigurationElement.getAttribute("appliesTo");
            if (iConfigurationElement.getAttribute("addAction") == null) break block2;
            try {
                this.addAction = (AddConfigPropertyAction)((Object)iConfigurationElement.createExecutableExtension("addAction"));
                this.addAction.setPropertyGroup(this.propertyGroup);
            }
            catch (CoreException coreException) {}
        }
    }

    public String getName() {
        if (this.name == null) {
            this.name = "";
        }
        return this.name;
    }

    public String getDescription() {
        if (this.description == null) {
            this.description = "";
        }
        return this.description;
    }

    public CFGPropertyGroup getPropertyGroup() {
        return this.propertyGroup;
    }

    public String getControlType() {
        return this.controlType;
    }

    public String getAppliesTo() {
        return this.editorType;
    }

    public void dispose() {
        if (this.mainSection != null) {
            this.mainSection.dispose();
            this.mainSection = null;
        }
        this.extensionInstance = null;
        super.dispose();
    }

    protected EObject getEditorObject() {
        return ((ConfigurableObjectEditorExtension)this.getBaseEditorExtension()).getEditorObject();
    }

    protected void createEditorFormContents(Composite composite) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.makeColumnsEqualWidth = true;
        gridLayout.marginWidth = 10;
        gridLayout.horizontalSpacing = 15;
        composite.setLayout((Layout)gridLayout);
        Composite composite2 = this.createColumn(composite);
        Composite composite3 = this.createColumn(composite);
        if (this.controlType.equals(CONTROL_TYPE_TREE)) {
            this.mainSection = this.createTreeSection(composite2);
        } else if (this.controlType.equals(CONTROL_TYPE_TABLE)) {
            this.mainSection = this.createTableSection(composite2);
        } else if (this.controlType.equals(CONTROL_TYPE_FIELDS)) {
            // empty if block
        }
        if (this.mainSection != null) {
            this.registerSection(this.mainSection);
            this.mainSection.setHeaderText(this.getName());
            this.mainSection.setCollapsable(true);
            Control control = this.mainSection.createControl(composite2, this.getWidgetFactory());
            control.setLayoutData((Object)new GridData(1810));
        }
    }

    protected EditorSection createTreeSection(Composite composite) {
        IAction[] iActionArray = this.createButtonActions();
        ExtensibleEObjectTreeSection extensibleEObjectTreeSection = new ExtensibleEObjectTreeSection(this, (EStructuralFeature)Common_ConfigurationPackage.eINSTANCE.getCFGPropertyGroup_Properties(), iActionArray);
        int n = 0;
        while (n < iActionArray.length) {
            IAction iAction = iActionArray[n];
            if (iAction != null && iAction instanceof ChildrenSelectionAction) {
                ((ChildrenSelectionAction)iAction).setStructuredViewer((StructuredViewer)extensibleEObjectTreeSection.getTreeViewer());
            }
            ++n;
        }
        return extensibleEObjectTreeSection;
    }

    protected EditorSection createTableSection(Composite composite) {
        IAction[] iActionArray = this.createButtonActions();
        PropertyGroupTableSection propertyGroupTableSection = new PropertyGroupTableSection(this, (EStructuralFeature)Common_ConfigurationPackage.eINSTANCE.getCFGPropertyGroup_Properties(), 3, iActionArray);
        propertyGroupTableSection.setContentProvider((IContentProvider)new EObjectTableContentProvider(this, (EStructuralFeature)Common_ConfigurationPackage.eINSTANCE.getCFGPropertyGroup_Properties()));
        propertyGroupTableSection.setLabelProvider(new PropertyGroupTableLabelProvider());
        int n = 0;
        while (n < iActionArray.length) {
            IAction iAction = iActionArray[n];
            if (iAction != null && iAction instanceof ChildrenSelectionAction) {
                ((ChildrenSelectionAction)iAction).setStructuredViewer((StructuredViewer)propertyGroupTableSection.getTableViewer());
            }
            ++n;
        }
        return propertyGroupTableSection;
    }

    protected IAction[] createButtonActions() {
        IAction[] iActionArray;
        if (this.addAction == null) {
            iActionArray = new IAction[3];
            this.removeAction = new RemoveFeatureChildrenAction((EObject)this.getPropertyGroup(), (EStructuralFeature)Common_ConfigurationPackage.eINSTANCE.getCFGPropertyGroup_Properties(), false);
            iActionArray[0] = this.removeAction;
            iActionArray[1] = new MoveFeatureChildrenUpAction((EObject)this.getPropertyGroup(), (EStructuralFeature)Common_ConfigurationPackage.eINSTANCE.getCFGPropertyGroup_Properties());
            iActionArray[2] = new MoveFeatureChildrenDownAction((EObject)this.getPropertyGroup(), (EStructuralFeature)Common_ConfigurationPackage.eINSTANCE.getCFGPropertyGroup_Properties());
        } else {
            iActionArray = new IAction[4];
            iActionArray[0] = this.addAction;
            this.removeAction = new RemoveFeatureChildrenAction((EObject)this.getPropertyGroup(), (EStructuralFeature)Common_ConfigurationPackage.eINSTANCE.getCFGPropertyGroup_Properties(), false);
            iActionArray[1] = this.removeAction;
            iActionArray[2] = new MoveFeatureChildrenUpAction((EObject)this.getPropertyGroup(), (EStructuralFeature)Common_ConfigurationPackage.eINSTANCE.getCFGPropertyGroup_Properties());
            iActionArray[3] = new MoveFeatureChildrenDownAction((EObject)this.getPropertyGroup(), (EStructuralFeature)Common_ConfigurationPackage.eINSTANCE.getCFGPropertyGroup_Properties());
        }
        return iActionArray;
    }

    public void load() {
        if (this.controlType.equals(CONTROL_TYPE_TREE)) {
            EObjectTreeSection eObjectTreeSection = (EObjectTreeSection)this.mainSection;
            eObjectTreeSection.setInput(this.propertyGroup);
        } else if (this.controlType.equals(CONTROL_TYPE_TABLE)) {
            ExtensibleEObjectTableSection extensibleEObjectTableSection = (ExtensibleEObjectTableSection)this.mainSection;
            extensibleEObjectTableSection.getTableViewer().removeSelectionChangedListener((ISelectionChangedListener)extensibleEObjectTableSection);
            extensibleEObjectTableSection.setInput(this.propertyGroup);
            extensibleEObjectTableSection.getTableViewer().addSelectionChangedListener((ISelectionChangedListener)extensibleEObjectTableSection);
        } else if (this.controlType.equals(CONTROL_TYPE_FIELDS)) {
            // empty if block
        }
    }

    public IStructuredSelection getSelection() {
        return new StructuredSelection((Object)this.getEditorObject());
    }

    public void selectReveal(ISelection iSelection) {
        this.mainSection.selectReveal(iSelection);
    }

    public boolean doGlobalAction(String string) {
        if (string.equals(ActionFactory.DELETE.getId())) {
            if (this.removeAction != null) {
                this.removeAction.run();
            }
            return true;
        }
        return false;
    }

    public class PropertyGroupTableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        public Image getColumnImage(Object object, int n) {
            return null;
        }

        public String getColumnText(Object object, int n) {
            if (object instanceof CFGComparableProperty) {
                CFGComparableProperty cFGComparableProperty = (CFGComparableProperty)object;
                switch (n) {
                    case 0: {
                        return cFGComparableProperty.getName();
                    }
                    case 1: {
                        if (cFGComparableProperty.getOperator() == null) {
                            cFGComparableProperty.setOperator("=");
                        }
                        return cFGComparableProperty.getOperator();
                    }
                    case 2: {
                        return cFGComparableProperty.getValue();
                    }
                }
            }
            return null;
        }
    }

    protected class PropertyGroupTableSection
    extends ExtensibleEObjectTableSection {
        public PropertyGroupTableSection(EditorForm editorForm, EStructuralFeature eStructuralFeature, int n, IAction[] iActionArray) {
            super(editorForm, eStructuralFeature, n, iActionArray);
        }

        protected void handleDoubleClick(IStructuredSelection iStructuredSelection) {
            if (iStructuredSelection.getFirstElement() instanceof CFGComparableProperty) {
                ComparablePropertyInputDialog comparablePropertyInputDialog = new ComparablePropertyInputDialog(Display.getCurrent().getActiveShell(), TestUIPlugin.getString("DLG_EDIT_PROPERTY"));
                comparablePropertyInputDialog.setProperty((CFGComparableProperty)iStructuredSelection.getFirstElement());
                comparablePropertyInputDialog.open();
            }
        }
    }
}

