/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.editor.form.util;

import org.eclipse.hyades.test.ui.editor.form.util.EditorForm;
import org.eclipse.hyades.test.ui.editor.form.util.EditorSection;
import org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.form.base.StructuredViewerPart;
import org.eclipse.hyades.test.ui.internal.model.ui.LocalTransfer;
import org.eclipse.hyades.ui.internal.util.UIUtil;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;

public abstract class StructuredViewerSection
extends EditorSection {
    private StructuredViewerPart viewerPart;
    private boolean handleDefaultButton;

    protected StructuredViewerSection(EditorForm editorForm, String[] stringArray) {
        super(editorForm);
        this.setButtonLabels(stringArray);
    }

    protected StructuredViewerSection(EditorForm editorForm) {
        super(editorForm);
    }

    protected void setButtonLabels(String[] stringArray) {
        if (this.viewerPart != null) {
            return;
        }
        this.viewerPart = this.createViewerPart(stringArray);
        this.viewerPart.setMinimumSize(50, 50);
    }

    public void dispose() {
        this.viewerPart = null;
        super.dispose();
    }

    protected void setHandleDefaultButton(boolean bl) {
        this.handleDefaultButton = bl;
    }

    protected boolean isHandlingDefaultButton() {
        return this.handleDefaultButton;
    }

    protected abstract StructuredViewerPart createViewerPart(String[] var1);

    protected StructuredViewerPart getViewerPart() {
        return this.viewerPart;
    }

    public void setFocus() {
        this.getViewerPart().getViewer().getControl().setFocus();
    }

    protected Composite createClientContainer(Composite composite, int n, FormWidgetFactory formWidgetFactory) {
        Composite composite2 = formWidgetFactory.createComposite(composite);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 2;
        gridLayout.marginWidth = 2;
        gridLayout.numColumns = n;
        composite2.setLayout((Layout)gridLayout);
        return composite2;
    }

    protected void createViewerPartControl(Composite composite, int n, int n2, FormWidgetFactory formWidgetFactory) {
        this.viewerPart.createControl(composite, n, n2, formWidgetFactory);
        this.createActions();
        MenuManager menuManager = new MenuManager();
        IMenuListener iMenuListener = new IMenuListener(){

            public void menuAboutToShow(IMenuManager iMenuManager) {
                StructuredViewerSection.this.fillContextMenu(iMenuManager);
            }
        };
        menuManager.addMenuListener(iMenuListener);
        menuManager.setRemoveAllWhenShown(true);
        Control control = this.viewerPart.getControl();
        Menu menu = menuManager.createContextMenu(control);
        control.setMenu(menu);
    }

    protected void createActions() {
    }

    public void setInput(Object object) {
        this.getViewerPart().getViewer().setInput(object);
        if (object != null) {
            this.updateActionsAndButtons((IStructuredSelection)new StructuredSelection(object));
        } else {
            this.updateActionsAndButtons((IStructuredSelection)StructuredSelection.EMPTY);
        }
    }

    public Object getInput() {
        return this.getViewerPart().getViewer().getInput();
    }

    public IStructuredSelection getStructuredSelection() {
        return (IStructuredSelection)this.getViewerPart().getViewer().getSelection();
    }

    public void selectReveal(ISelection iSelection) {
        if (UIUtil.areEquals((ISelection)this.getStructuredSelection(), (ISelection)iSelection)) {
            return;
        }
        this.getViewerPart().getViewer().setSelection(iSelection, true);
    }

    protected void fillContextMenu(IMenuManager iMenuManager) {
    }

    protected void entryModified(Object object, String string) {
    }

    protected void selectionChanged(IStructuredSelection iStructuredSelection) {
        this.fireSelectionNotification(iStructuredSelection);
        this.getHyadesEditorPart().setSelection((ISelection)iStructuredSelection);
        this.updateActionsAndButtons(iStructuredSelection);
    }

    protected void handleDoubleClick(IStructuredSelection iStructuredSelection) {
    }

    protected void buttonSelected(int n) {
    }

    protected void updateActionsAndButtons(IStructuredSelection iStructuredSelection) {
    }

    protected void doPaste() {
        LocalTransfer localTransfer;
        IStructuredSelection iStructuredSelection = this.getStructuredSelection();
        if (iStructuredSelection.size() > 1) {
            return;
        }
        Object object = iStructuredSelection.getFirstElement();
        Clipboard clipboard = this.getClipboard();
        Object[] objectArray = (Object[])clipboard.getContents((Transfer)(localTransfer = LocalTransfer.getInstance()));
        if (objectArray != null && objectArray.length > 0) {
            this.doPaste(object, objectArray);
        }
    }

    protected void doPaste(Object object, Object[] objectArray) {
    }

    public boolean canPaste(Clipboard clipboard) {
        IStructuredSelection iStructuredSelection = this.getStructuredSelection();
        if (iStructuredSelection.size() > 1) {
            return false;
        }
        Object object = iStructuredSelection.getFirstElement();
        LocalTransfer localTransfer = LocalTransfer.getInstance();
        Object[] objectArray = (Object[])clipboard.getContents((Transfer)localTransfer);
        if (objectArray != null && objectArray.length > 0) {
            return this.canPaste(object, objectArray);
        }
        return false;
    }

    protected boolean canPaste(Object object, Object[] objectArray) {
        return false;
    }
}

